<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class booking_helper
{
        /**
	* Get latitude logitude according to the address
	*
	* @access	public
	* @since	1.5
	*/
        public static function getLatLong($address)
	{
		$elsettings = booking_helper::config();
		
		if($address == "")
		{
			return array();
		}
		
		// Desired address
		$address	= rawurlencode($address);	
		
		if($elsettings->ssl_enabled==1 && $elsettings->api_key!=""){
			$q = "https://maps.googleapis.com/maps/api/geocode/json?address=$address&sensor=false";
		}
		else {
			$q = "http://maps.googleapis.com/maps/api/geocode/json?address=$address&sensor=false";
		}
		
		if($elsettings->api_client_id!=""){
			$q .= '&client='.$elsettings->api_client_id;
		}
		if($elsettings->api_client_signature!=""){
			$q .= '&signature='.$elsettings->api_client_signature;
		}
		if($elsettings->api_key!=""){
			$q .= '&key='.$elsettings->api_key;
		}
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $q);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$json = curl_exec($ch);
		$curl_errno = curl_errno($ch);
		$curl_error = curl_error($ch);
		if ($curl_errno > 0) {
			return array();
		} 
		curl_close($ch);

		$response = json_decode($json, TRUE);

		// Parse the coordinate string
		if($response['status']=="OK"){
			$latitude_longitude = array ();

		       // Output the coordinates
			$latitude_longitude[]=$response['results'][0]['geometry']['location']['lat'];
			$latitude_longitude[]=$response['results'][0]['geometry']['location']['lng'];

			return $latitude_longitude;	
		}
		else{
			return array();
		}
	}
        
        public static function isJSON($string){
		return is_string($string) && is_object(json_decode($string)) ? true : false;
	}
        /**
	* Logic to Calculate distance between two address
	*
	* @access	public
	* @since	1.5
	*/
        public static function calculateDistance($lat1, $lon1, $lat2, $lon2, $unit, $waypoint_coords = array()) 
        {
		$elsettings = booking_helper::config();
		$unit_system = ($unit=='mile') ? 'imperial' : 'metric';
		
		$distance_meters = 0;  // distance in meter
		$duration_seconds = 0;  // duration in second
		
		if($elsettings->ssl_enabled==1 && $elsettings->api_key!=""){
			$q = "https://maps.googleapis.com/maps/api/directions/json?";
		}
		else {
			$q = "http://maps.googleapis.com/maps/api/directions/json?";
		}
		
		$q .= "origin={$lat1},{$lon1}&destination={$lat2},{$lon2}&mode=driving&sensor=false&units=$unit_system";
		
		if(!empty($waypoint_coords)){
			$q .= ((int)$elsettings->optimize_stops==1) ? "&waypoints=optimize:true|" : "&waypoints=optimize:false|";
			
			$temp_waypts = array();
			for($i=0;$i<count($waypoint_coords);$i++){
				$temp_waypts[] = implode(',',$waypoint_coords[$i]);
			}
			$q .= implode('|', $temp_waypts);
		}
		
		if($elsettings->api_client_id!=""){
			$q .= '&client='.$elsettings->api_client_id;
		}
		if($elsettings->api_client_signature!=""){
			$q .= '&signature='.$elsettings->api_client_signature;
		}
		if($elsettings->api_key!=""){
			$q .= '&key='.$elsettings->api_key;
		}
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $q);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$json = curl_exec($ch);
		$curl_errno = curl_errno($ch);
		$curl_error = curl_error($ch);
		
		if ($curl_errno > 0) {
			return array(0, 0, "cURL Error","cURL Error ($curl_errno): $curl_error");
		} 
		curl_close($ch);
	
		if(!booking_helper::isJSON($json)){
			return array(0, 0, "Google Maps API Error",$json);
		}
		else {
			$response = json_decode($json, TRUE);
		
			$gapi_msg = '';
			if($response['status']=="OK")
			{
				foreach($response['routes'][0]['legs'] as $leg)
				{
					$distance_meters += $leg['distance']['value'];
					$duration_seconds += $leg['duration']['value'];
				}
			}
			if(!empty($response['error_message'])){
				$gapi_msg = $response['error_message'];
			}
			
			$distance_km = $distance_meters / 1000;
			
			if ($unit == "kM") {
				return array($distance_km, $duration_seconds, $response['status'], $gapi_msg);
			} else {
				return array(($distance_km / 1.609344), $duration_seconds, $response['status'], $gapi_msg); 
			}
		}
        }
	
	/**
	* Convert number of seconds into hours, minutes and seconds
	* and return an array containing those values
	*
	* @param integer $seconds Number of seconds to parse
	* @return array
	*/
	public static function secondsToTime($seconds)
	{
		$duration_str = '';
		// extract hours
		$hours = floor($seconds / (60 * 60));
	     
		// extract minutes
		$divisor_for_minutes = $seconds % (60 * 60);
		$minutes = floor($divisor_for_minutes / 60);
	     
		// extract the remaining seconds
		$divisor_for_seconds = $divisor_for_minutes % 60;
		$seconds = ceil($divisor_for_seconds);
	     
		// return the final array
		$obj = array(
		    "h" => (int) $hours,
		    "m" => (int) $minutes,
		    "s" => (int) $seconds,
		);
		
		$duration_str .= ((int) $hours > 0) ? JText::sprintf("CAR_LIST_ESTIMATED_TIME_HR", $hours) : '';
		$duration_str .= ((int) $minutes > 0) ? JText::sprintf("CAR_LIST_ESTIMATED_TIME_MIN", $minutes) : '';
		//$duration_str .= ((int) $seconds > 0) ? ' '.$seconds.' sec' : '';
		//$duration_str .= ((int) $seconds > 1) ? 's' : '';
		
		return $duration_str;
	}
	
	/**
	* Logic to Calculate distance Base and Pickup
	*
	* @access	public
	* @since	1.5
	*/
        public static function considerBase($elsettings, $booking_data)
	{
		$session =  JFactory::getSession();
		$base_pickup_distance = 0;
		$base_pickup_duration = 0;
		$base_pickup_price = 0;
		$base_pickup_price_calc = booking_helper::price_display(0,$elsettings);
		$dropoff_base_distance = 0;
		$dropoff_base_duration = 0;
		$dropoff_base_price = 0;
		$dropoff_base_price_calc = booking_helper::price_display(0,$elsettings);
		$booking_type = $booking_data['booking_type'];
		
		if($booking_type=='hourly'){
			$session->set('lat_long_from', array());
			$session->set('lat_long_to', array());
			return array($base_pickup_distance,
				$base_pickup_duration,
				$base_pickup_price,
				$base_pickup_price_calc,
				$dropoff_base_distance,
				$dropoff_base_duration,
				$dropoff_base_price,
				$dropoff_base_price_calc
				);
		}
		
		if($elsettings->base_lat!="" && $elsettings->base_long!="")
		{
			if($elsettings->calculate_base_pickup==1)
			{
				$pickup_coords = $booking_data['lat_long_from'];
				
				if(!empty($pickup_coords))
				{
					list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($elsettings->base_lat,$elsettings->base_long,$pickup_coords[0],$pickup_coords[1],$elsettings->distance_unit);
					
					if($gapi_status=="OK")
					{
						$base_pickup_distance = $distance;
						$base_pickup_duration = $duration_seconds;
						$base_pickup_price_calc = '';
						
						if($elsettings->base_pickup_price_type=='flat'){
							$base_pickup_price += (float)$elsettings->base_pickup_price;
							$base_pickup_price_calc .= booking_helper::price_display($elsettings->base_pickup_price,$elsettings);
						}
						else {
							$base_pickup_price += ($base_pickup_distance*$elsettings->base_pickup_price);
							$base_pickup_price_calc .= booking_helper::distance_display($base_pickup_distance,$elsettings).' X '.booking_helper::price_display($elsettings->base_pickup_price,$elsettings);
						}
					}
				}
			}
			
			if($elsettings->calculate_dropoff_base==1)
			{
				$dropoff_coords = $booking_data['lat_long_to'];
				
				if(!empty($dropoff_coords))
				{
					list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($dropoff_coords[0],$dropoff_coords[1],$elsettings->base_lat,$elsettings->base_long,$elsettings->distance_unit);
					
					if($gapi_status=="OK")
					{
						$dropoff_base_distance = $distance;
						$dropoff_base_duration = $duration_seconds;
						$dropoff_base_price_calc = '';
						
						if($elsettings->dropoff_base_price_type=='flat'){
							$dropoff_base_price += (float)$elsettings->dropoff_base_price;
							$dropoff_base_price_calc .= booking_helper::price_display($elsettings->dropoff_base_price,$elsettings);
						}
						else {
							$dropoff_base_price += ($dropoff_base_distance*$elsettings->dropoff_base_price);
							$dropoff_base_price_calc .= booking_helper::distance_display($dropoff_base_distance,$elsettings).' X '.booking_helper::price_display($elsettings->dropoff_base_price,$elsettings);
						}
					}
				}
			}
		}
		
		return array($base_pickup_distance,
				$base_pickup_duration,
				$base_pickup_price,
				$base_pickup_price_calc,
				$dropoff_base_distance,
				$dropoff_base_duration,
				$dropoff_base_price,
				$dropoff_base_price_calc
				);
	}
        
	public static function clear_booking_data()
	{
		$session =  JFactory::getSession();
		$booking_type = $session->get('booking_type', '');
		
		if($booking_type!='address'){
			$session->clear('address_from');
			$session->clear('address_from_lat');
			$session->clear('address_from_lng');
			$session->clear('address_to');
			$session->clear('address_to_lat');
			$session->clear('address_to_lng');
			
			$session->clear('waypoints');
			$session->clear('waypoints_lat');
			$session->clear('waypoints_lng');
			$session->clear('waypoints_stop_duration');
			$session->clear('total_waypoint_duration');   
		}
		elseif($booking_type!='offers'){
			$session->clear('route_category_fld');
			$session->clear('route_category');
			$session->clear('route_category_dropoff_fld');
			$session->clear('route_category_dropoff');
			$session->clear('route_from');
			$session->clear('route_to');
			$session->clear('route_from_fld');
			$session->clear('route_to_fld');
		}
		elseif($booking_type!='hourly'){
			$session->clear('hourly_hr');
			$session->clear('hourly_min');
		}
		elseif($booking_type!='shuttle'){
			$session->clear('shuttle_pickup');
			$session->clear('shuttle_pickup_poi');
			$session->clear('shuttle_dropoff');
			$session->clear('shuttle_dropoff_poi');
			$session->clear('shuttletime');
			$session->clear('shuttle_route_id');
		}
	}
	
        /**
         * Check all the input values
         *
         * @access	public
         * @since	1.0
         */
        function check_input($data) {
            $data = trim($data);
            $data = stripslashes($data);
            $data = htmlspecialchars($data, ENT_QUOTES);
            //no	$data = htmlentities($data);
            return $data;
        }
        
        function DateTime($date, $time)
        {//01-NOV-2008 04:40

            if ((strlen($date)!=11)||(strlen($time)!=5)||($date[2]!="-")||($date[6]!="-")||($time[2]!=":")) return false;

            $temp = substr ($date, 7, 4);	//year
            switch(substr ($date, 3, 3))
            {
                    case "JAN": $temp .= "01"; break;
                    case "FEB": $temp .= "02"; break;
                    case "MAR": $temp .= "03"; break;
                    case "APR": $temp .= "04"; break;
                    case "MAY": $temp .= "05"; break;
                    case "JUN": $temp .= "06"; break;
                    case "JUL": $temp .= "07"; break;
                    case "AUG": $temp .= "08"; break;
                    case "SEP": $temp .= "09"; break;
                    case "OCT": $temp .= "10"; break;
                    case "NOV": $temp .= "11"; break;
                    case "DEC": $temp .= "12"; break;
            }
            $temp.= substr ($date, 0, 2);	//day
            $temp.= substr ($time, 0, 2);	//time
            $temp.= substr ($time, 3, 2);

            if ( is_numeric($temp) )	return $temp;
            else return false;
        }
        
        public static function DateTime2($date, $time)
        {//	"31/10/2008", "08:45"	echo $date." ".$time."<br>";

            if ((strlen($date)!=10)||(strlen($time)!=5)||($time[2]!=":")) return false;

            $temp = substr ($date, 6, 4);	//year
            $temp.= substr ($date, 3, 2);	//month
            $temp.= substr ($date, 0, 2);	//day
            $temp.= substr ($time, 0, 2);	//hour
            $temp.= substr ($time, 3, 2);	//minutes

            if ( is_numeric($temp) )	return $temp;
            else return false;
        }
        
	public static function DateTimeHuman($datetime)
        {//	"200809230845"
            if ( (strlen($datetime)==12) && is_numeric($datetime) )
            {
                    $temp = substr ($datetime, 6, 2);	//day date
                    $temp.= "-";
                    $temp.= substr ($datetime, 4, 2);	//month
                    $temp.= "-";
                    $temp.= substr ($datetime, 0, 4);	//year
                    $temp.= " ";

                    $temp.= substr ($datetime, 8, 2);	//hours time
                    $temp.= ":";
                    $temp.= substr ($datetime, 10, 2);	//minutes
                    return $temp;
            }
            else return false;
        }
        
        public static function DateHuman($datetime)
        {//	"200809230845"
            if ( (strlen($datetime)==12) && is_numeric($datetime) )
            {
                    $temp = substr ($datetime, 6, 2);	//day	date
                    $temp.= "/";

                    $temp.= substr ($datetime, 4, 2);	//month
                    $temp.= "/";

                    $temp.= substr ($datetime, 0, 4);	//year
                    return $temp;
            }
            else return false;
        }
        
        public static function TimeHuman($datetime)
        {//	"200809230845"
            if ( (strlen($datetime)==12) && is_numeric($datetime) )
            {
                    $temp = substr ($datetime, 8, 2);	//time
                    $temp.= ":";
                    $temp.= substr ($datetime, 10, 2);
                    return $temp;
            }
            else return false;
        }
        
        public static function AddressType($from_dest, $part)
        {
                switch ($from_dest)
                {
                        case 0:
                                switch ($part)
                                {
                                        case 1:	$temp = JText::_('FLIGHT');	break;
                                        case 2:	$temp = "From";		break;
                                        case 3:	$temp = "Terminal";	break;
                                }
                                break;
                        case 1:
                                switch ($part)
                                {
                                        /*case 1:	$temp = "Door №";	break;
                                        case 2:	$temp = "Flat №";	break;
                                        case 3:	$temp = "Address";	break;*/
					case 1:	$temp = JText::_('STREET');	break;
                                        case 2:	$temp = "Town/City";	break;
                                        case 3:	$temp = "Country";	break;
                                }
                                break;
                        case 2:
                                switch ($part)
                                {
                                        case 1:	$temp = "Vessel"; break;
                                        case 2:	$temp = "To";	break;
                                        case 3:	$temp = "Dock";	break;
                                }
                                break;
                }
                return $temp;
        }
        
        public static function is_valid_email($email) {
		return ( ! preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,}$/ix", $email)) ? FALSE : TRUE;
        }
        
        public static function is_valid_phone($string) {
		if(preg_match('/^(NA|[0-9+-]+)$/',$string)) {
                        return true;
                } else {
                        return false;
                }
        }

	public static function get_points($output_format = 'json', $filter = array())
	{
		$db = JFactory::getDBO();
		$query = 'SELECT * '
			. ' FROM #__taxibooking_points'
			. ' WHERE published = 1'
			. ' ORDER BY title ASC'
		;
	
		$db->setQuery($query);
		$items = $db->loadObjectList();
		
		if($output_format == 'json')
		{
			$poi_data = array();
			if(!empty($items))
			{
				$i = 0;
				foreach ($items as $item)
				{
					$poi_data[$i]['label'] = $item->title;
					$poi_data[$i]['value'] = $item->title;
					$poi_data[$i]['id'] = $item->id;
					$i++;
				}
			}
	    
			return json_encode($poi_data);	
		}
	}
	
	public static function get_routes($output_format = 'json', $filter = array())
	{
		$elsettings = booking_helper::config();
		$db = JFactory::getDBO();
		$query = 'SELECT *'
			. ' FROM #__taxibooking_routes'
			. ' WHERE published = 1'
			. ' ORDER BY title ASC'
		;
    
		$db->setQuery($query);
		$items = $db->loadObjectList();
			
		if($output_format == 'json')
		{
			$route_data = array();
			if(!empty($items))
			{
				$i = 0;
				foreach ($items as $item)
				{
					$route_data[$i]['label'] = $item->title. ' - ' . $elsettings->currency_symbol . $item->price;
					$route_data[$i]['value'] = $item->title. ' - ' . $elsettings->currency_symbol . $item->price;
					$route_data[$i]['id'] = $item->id;
					$i++;
				}
			}
	    
			return json_encode($route_data);	
		}
	}
    
        public static function get_place_field($address = '', $field = 'title'){
                
                $result = '';
                if($address != ''){
                    $db = JFactory::getDBO();
            
                    $query = 'SELECT `'.$field.'`'
                            . ' FROM #__taxibooking_points'
                            . ' WHERE alias = '.$db->quote($address)
                            ;
                    $db->setQuery($query);
                    $db->query();
                    $result = $db->loadResult(); 
                    
                }
                return $result;
        }
	
	public static function get_specific_place_details($where = array()){
                
		$db = JFactory::getDBO();
		
                $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
		$query = 'SELECT p.* '
			. ' FROM #__taxibooking_points AS p'
			. $where
		;
		$db->setQuery($query);
		$db->query();
		$row = $db->loadObject();
		
                return $row;
        }
	
	public static function get_place_field_by_id($id = '', $field = 'title'){
                
                $result = '';
                if($id != ''){
                    $db = JFactory::getDBO();
            
                    $query = 'SELECT `'.$field.'`'
                            . ' FROM #__taxibooking_points'
                            . ' WHERE id = '.$db->quote($id)
                            ;
                    $db->setQuery($query);
                    $db->query();
                    $result = $db->loadResult(); 
                    
                }
                return $result;
        }
        
        public static function get_route_field($filter = '', $field = 'title'){
                
                $result = '';
                if($filter != ''){
                    $db = JFactory::getDBO();
            
                    $query = 'SELECT `'.$field.'`'
                            . ' FROM #__taxibooking_routes'
                            . ' WHERE alias = '.$db->quote($filter)
                            ;
                    $db->setQuery($query);
                    $db->query();
                    $result = $db->loadResult(); 
                    
                }
                return $result;
        }
	public static function get_available_cars()
	{
		$db = JFactory::getDBO();
	
		$query = 'SELECT * '
			. ' FROM #__taxibooking_cars'
			. ' WHERE published = 1'
			. ' ORDER BY title'
			;
		$db->setQuery($query);
		$db->query();
		$result = $db->loadObjectList(); 
                return $result;
        }
        public static function get_car_details($id = 0)
	{
                $result = array();
                if($id != 0)
		{
			$db = JFactory::getDBO();
		
			$query = 'SELECT * '
				. ' FROM #__taxibooking_cars'
				. ' WHERE id = '.$db->quote($id)
				;
			$db->setQuery($query);
			$db->query();
			$result = $db->loadObject(); 
                }
                return $result;
        }
	
	public static function get_order_by_id($id = 0)
	{
                $result = array();
                if($id != 0)
		{
			$db = JFactory::getDBO();
			
			$query = $db->getQuery(true);
 
			// Select the required fields from the table.
			$query->select('a.*');
			$query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
			
			 // Join over the driver 
			$query->select('u.name AS drivername')
				->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
				
			// Join over the payment methods 
			$query->select('pm.title AS payment_method')
				->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
				
			$query->where('a.id = ' . (int)$id);
			
			$db->setQuery($query);
			$db->query();
			$result = $db->loadObject(); 
                }
                return $result;
        }
	public static function get_order_by_order_number($order_number = "")
	{
                $result = array();
                if($order_number != "")
		{
			$db = JFactory::getDBO();
			
			$query = $db->getQuery(true);
 
			// Select the required fields from the table.
			$query->select('a.*');
			$query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
			
			 // Join over the driver 
			$query->select('u.name AS drivername')
				->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
				
			// Join over the payment methods 
			$query->select('pm.title AS payment_method')
				->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
				
			$query->where('a.order_number = ' . $db->quote($order_number));
			
			$db->setQuery($query);
			$db->query();
			$result = $db->loadObject(); 
                }
                return $result;
        }
	public static function update_order_status($order_id = 0, $data = array(), $notify_admins = false)
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
                
		if($order_id > 0 && !empty($data))
		{
			$old_row_queue = booking_helper::get_order_by_id($order_id);
			
			$order = new stdClass();
			$order->id = $order_id;
			$order->state = $data['order_status'];
			
			if (!$db->updateObject('#__taxibooking_orders', $order, 'id')) {
				exit($db->stderr());
			}
			
			$elsettings = booking_helper::config();
			$row_queue = booking_helper::get_order_by_id($order_id);
			
			if($row_queue)
			{
				// Rejected orders will be archived only, but review email will not be sent
				if((int)$row_queue->state == -1 && $old_row_queue->state!=0) // Archived email
				{
					booking_helper::sendOrderArchiveEmail($row_queue, $elsettings);
				}
				else {
					$SiteName = $app->getCfg('sitename');
					$MailFrom = $app->getCfg('mailfrom');
					$FromName = $app->getCfg('fromname');
					$FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $FromName);
					
					if ($row_queue->state == 1) {
						$row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_ACCEPTED').'</span>';
					} elseif ($row_queue->state == 0) {
						$row_queue->order_status .= '<span style="color:red;">'.JText::_('NEW_ORDER_STATUS_REJECTED').'</span>';
					} elseif ($row_queue->state == -1) {
						$row_queue->order_status .= '<span style="color:yellow;">'.JText::_('NEW_ORDER_STATUS_ARCHIVED').'</span>';
					} elseif ($row_queue->state == -2) {
						$row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_WAITING').'</span>';
					}
					
					$payment_data = '';
					JPluginHelper::importPlugin('tbpayment');
					$_dispatcher = JDispatcher::getInstance();
					$_returnValues = $_dispatcher->trigger('plgTbOnShowOrderEmailsInvoice',array( $row_queue->id,$row_queue->payment));
					foreach ($_returnValues as $_returnValue) {
						if ($_returnValue !== null) {
							$payment_data .= $_returnValue;
						}
					}
					
					$converted_currency_label = '';
					$returnValues = $_dispatcher->trigger('plgTbonShowConvertedPriceLabel', array(&$row_queue->payment, $row_queue->cprice, &$converted_currency_label));
					    
					// glean language specific header and footer info
					$header_info = $elsettings->header_info;
					$header_info = isset($header_info[$lang_tag]) ? changeEditorImageUrl($header_info[$lang_tag]) : '';
					
					$contact_info = $elsettings->contact_info;
					$contact_info = isset($contact_info[$lang_tag]) ? changeEditorImageUrl($contact_info[$lang_tag]) : '';
					
					if($row_queue->driver_id > 0){
						$driverObj = booking_helper::getDriverInfo($row_queue->driver_id);
					}
					
					// now get the email template
					ob_start();
					if ($app->isAdmin()){
						include( JPATH_COMPONENT_SITE.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
					}
					else {
						include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
					}
					$mailbody = ob_get_contents();
					ob_end_clean();
					
					// Creating a pdf invoice if status is changed to Accepted
					$pdf_file = '';
					if ($row_queue->state == 1)
					{
						$header_info = $elsettings->header_info;
						$header_info_pdf = isset($header_info[$lang_tag]) ? changeEditorImagePath($header_info[$lang_tag]) : '';
						
						$contact_info = $elsettings->contact_info;
						$contact_info_pdf = isset($contact_info[$lang_tag]) ? changeEditorImagePath($contact_info[$lang_tag]) : '';
						
						ob_start();
						if ($app->isAdmin()){
							include( JPATH_COMPONENT_SITE.DS .'templates'.DS.'order_invoice.tpl.php' );
						}
						else {
							include( JPATH_COMPONENT.DS .'templates'.DS.'order_invoice.tpl.php' );
						}
						
						$invoice_template = ob_get_contents();
						ob_end_clean();
						
						if ($app->isAdmin()){
							require_once(JPATH_COMPONENT."/classes/dompdf_lib.php");
						}
						else {
							require_once(JPATH_COMPONENT_ADMINISTRATOR."/classes/dompdf_lib.php");
						}
						$dompdf_lib = new Dompdf_lib;
						$dompdf_lib->set_custom_paper('A4');
						$pdfoutput = $dompdf_lib->convert_html_to_pdf($invoice_template, '', false);
						
						$invoice_title = ($elsettings->invoice_title!="") ? $elsettings->invoice_title."_".$order_id.".pdf" : "taxi_reservation_$order_id.pdf";
						
						if ($app->isAdmin()){
							$pdf_file = JPATH_COMPONENT . DS . "documents".DS.$invoice_title;
						}
						else {
							$pdf_file = JPATH_COMPONENT_ADMINISTRATOR . DS . "documents".DS.$invoice_title;
						}
						file_put_contents($pdf_file, $pdfoutput);
						
						// update order invoice title
						$query = 'UPDATE #__taxibooking_orders SET'
							.' invoice_title =' . $db->Quote($invoice_title)
							.' WHERE id = ' . (int)$order_id;
						$db->setQuery($query);
						$db->execute();
						
						// confirm booked seats if this is shuttle booking
						if($row_queue->booking_type=='shuttle'){
							booking_helper::confirm_shuttle_booking($row_queue);
						}
					}
					
					// Remove car booking data if order status is changed to rejected
					if ($row_queue->state == 0){
						booking_helper::cancel_car_bookings($order_id);
						// order is rejected so, remove shuttle booking
						if($row_queue->booking_type=='shuttle'){
						    booking_helper::remove_shuttle_booking($order_id);
						}
					}
					
					$mail =  JFactory::getMailer();
					$mail->setSender(array($MailFrom, $FromName));
					$mail->setSubject(JText::sprintf('BOOKING_STATUS_CHANGED_ORDER', $row_queue->order_number));
					$mail->setBody($mailbody);
					if($pdf_file!=""&&$elsettings->show_price==1)
					{
					    $mail->addAttachment($pdf_file);    
					}            
					$mail->IsHTML(true);
					$mail->addRecipient($row_queue->email);
					$sent = $mail->Send();
					
					// Sending mail to driver if driver is selected 
					if($row_queue->driver_id > 0)
					{
						$driver_name = $driver_obj->name;
						$driver_email = $driver_obj->email;
					    
						$mail->ClearAllRecipients();
						$mail->ClearAttachments();
						$mail->setSender(array($MailFrom, $FromName));
						$mail->setSubject(JText::sprintf('DRIVER_BOOKING_NOTIFICATION', $driver_email) .' '.JText::sprintf('BOOKING_STATUS_CHANGED_ORDER', $row_queue->order_number));
						$mail->setBody($mailbody);
						if($pdf_file!=""&&$elsettings->show_price==1)
						{
						    $mail->addAttachment($pdf_file);    
						}
						$mail->IsHTML(true);
						$mail->addRecipient($driver_email);
						$sent = $mail->Send();
					}
					
					// send emails to all admin
					if($notify_admins)
					{
						$query = 'SELECT u.id, u.email, u.name' .
							' FROM #__users AS u' .
							' LEFT JOIN #__user_usergroup_map AS gu ON gu.user_id = u.id' .
							' WHERE (gu.group_id = 8 OR gu.group_id = 7) ' .
							' AND u.sendEmail = 1 AND u.block = 0';
						$db->setQuery($query);
						$adminRows = $db->loadObjectList();
						
						// order submitter IP in only admin email
						$mailbody .= 'Order submitted from IP: '.$row_queue->ip_address.' - <a href="http://ip-lookup.net/index.php?ip='.$row_queue->ip_address.'" target="blank">Look it up</a>';
						
						$admin_emails = array();
						// send email notification to admins
						foreach ($adminRows as $adminRow)
						{
							$admin_emails[] = $adminRow->email;
					
							$mail =  JFactory::getMailer();
							$mail->setSender(array($MailFrom, $FromName));
							$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->order_number));
							$mail->setBody($mailbody);
							$mail->IsHTML(true);
							$mail->addRecipient($adminRow->email);
							$mail->addReplyTo($row_queue->email, $row_queue->names);
					    
							$sent = $mail->Send();
						}
					}
				}
				
				// changed order status is not Accpeted so, remove shuttle booking
				if($row_queue->booking_type=='shuttle' && $row_queue->state!=1){
					booking_helper::remove_shuttle_booking($order_id);
				}
			}
                }
		
		return true;
        }
	
	public static function shuttle_booking_count($data = array())
	{
		$total_seats_booked = 0;
		
		if(!empty($data))
		{
			$db = JFactory::getDBO();
			$query = $db->getQuery(true);
			$query->select('SUM(booked_seats) as total_seats_booked');
			$query->from('#__taxibooking_shuttle_bookings');
			$query->where('order_date = '.$db->Quote($data['order_date']));
			$query->where('route_id = '.(int)$data['route_id']);
			
			$db->setQuery((string)$query);
			$total_seats_booked = $db->loadResult();
		}
		
		return $total_seats_booked;
	}
	public static function confirm_shuttle_booking($order = array())
	{
		if(!empty($order))
		{
			$date = JFactory::getDate();
			$db = JFactory::getDBO();
			
			$config   = JFactory::getConfig();
			$siteOffset = $config->get('offset');
			$dtnow = JFactory::getDate('now', $siteOffset);
			
			// first check if this booking is already confirmed
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_shuttle_bookings');
			$query->where('order_id = '.(int)$order->id);
			
			$db->setQuery((string)$query);
			$result = $db->loadObject();
			
			if($result) // update shuttle order
			{
				$booking = new stdClass();
				$booking->id = $result->id;
				$booking->order_id = $order->id;
				$booking->route_id = $order->shuttle_route_id;
				$booking->order_date = date('Y-m-d', (int)$order->datetime1);
				$booking->booked_seats = $order->selpassengers;
				
				$db->updateObject('#__taxibooking_shuttle_bookings', $booking, 'id');
			}
			else { // insert 
				$booking = new stdClass();
				$booking->order_id = $order->id;
				$booking->route_id = $order->shuttle_route_id;
				$booking->order_date = date('Y-m-d', (int)$order->datetime1);
				$booking->booked_seats = $order->selpassengers;
				$booking->created_date = $date->toSQL();
				
				$db->insertObject('#__taxibooking_shuttle_bookings', $booking);
			}
		}
	}
	public static function remove_shuttle_booking($order_id = 0)
	{
		if($order_id > 0)
		{
			$db = JFactory::getDBO();
			$query = 'DELETE FROM `#__taxibooking_shuttle_bookings` WHERE `order_id` = '.$db->quote($order_id);
			$db->setQuery($query);
			$db->execute();
		}
	}
	
	public static function get_poi_category($id)
	{
                $db = JFactory::getDBO();
		
		// now list cars
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_poicats');
		$query->where('id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		return $row;
	}
	public static function get_fixed_route_car_set($fixed_car_prices, $booking_data = array())
	{
		$car_price_arr = unserialize($fixed_car_prices);
                
		// Sort by price and maintain index association
		asort($car_price_arr);
		
		$adultseats = empty($booking_data['adultseats']) ? 0 : $booking_data['adultseats'];
		$suitcases = empty($booking_data['suitcases']) ? 0 : $booking_data['suitcases'];
		$infantseats = empty($booking_data['infantseats']) ? 0 : $booking_data['infantseats'];
		$chseats = empty($booking_data['chseats']) ? 0 : $booking_data['chseats'];
		$boosterseats = empty($booking_data['boosterseats']) ? 0 : $booking_data['boosterseats'];
		
		// adult + booster + child + infant must be less than the maximum passenger seats for a car
		$total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;
	
		$result = array();
                if(!empty($car_price_arr))
                {
			foreach($car_price_arr as $car_id => $fixed_price)
			{
				if($fixed_price != "" && $fixed_price != 0)
				{
					$car_obj = booking_helper::get_car_details($car_id);
					
					if((int)$car_obj->published==0){
						continue;
					}
					
					// check seats limitations
					if($adultseats > 0 && $adultseats > $car_obj->passenger_no){
						continue;
					}
					if($suitcases > 0 && $suitcases > $car_obj->suitcase_no) {
						continue;
					}
					if($boosterseats > 0 && $boosterseats > $car_obj->booster_seat_no) {
						continue;
					}
					if($infantseats > 0 && $infantseats > $car_obj->infant_seat_no) {
						continue;
					}
					if($chseats > 0 && $chseats > $car_obj->child_seat_no) {
						continue;
					}
					if($total_passengers > 0 && $total_passengers < $car_obj->min_passenger_no) {
						continue;
					}
					if($total_passengers > 0 && $total_passengers > $car_obj->passenger_no) {
						continue;
					}
					
					$car_obj->price = $fixed_price;  // here car price will be reset for this route only
					$result[] = $car_obj;
				}
			}
                }
                return $result;
	}
	
	/**
	 * Method to check pickup date is a blocked date or not for this car.
	 *
	 * @param   object	
	 * @param   pickup date set from mobile app
	 */
	public static function check_car_block_dates($car, $pickup_time_str="")
	{
		if(!is_object($car)){
			$car = booking_helper::get_car_details($car);
		}
		
		$session =  JFactory::getSession();
		if($pickup_time_str!=""){
			$order_date_time_str = $pickup_time_str;
		}
		else {
			$order_date_time_str = $session->get('timestr1', '');
		}
		
		if($order_date_time_str!='')
		{
			$order_date = date("Y-m-d", $order_date_time_str);
			$blocked_dates_arr = unserialize($car->blocked_dates);
			
			if(!empty($blocked_dates_arr) && in_array($order_date, $blocked_dates_arr)){
				return FALSE;
			}
		}
		return TRUE;
	}
	/**
	 * Method to check if car is available on pickup date
	 *
	 * @param   object	
	 * @param   pickup date set from mobile app
	 */
	public static function check_todays_availability($car, $pickup_time_str="")
	{
		if(!is_object($car)){
			$car = booking_helper::get_car_details($car);
		}
		
		$session =  JFactory::getSession();
		
		if($pickup_time_str!=""){
			$order_date_time_str = $pickup_time_str;
		}
		else {
			$order_date_time_str = $session->get('timestr1', '');
		}
		
		if($order_date_time_str==""){
			return FALSE;
		}
		
		$order_date = date("Y-m-d", $order_date_time_str);
		$order_date_time_hr = date("H", $order_date_time_str);
		$order_date_time_min = date("i", $order_date_time_str);
		$order_date_week_day = date("N", $order_date_time_str);  //1 (for Monday) through 7 (for Sunday)
		//echo 'current - '.$order_date_time_hr.' - '.$order_date_time_min;
		
		$weekdays = array(0 => JText::_('MON'),
				1 => JText::_('TUE'),
				2 => JText::_('WED'),
				3 => JText::_('THU'),
				4 => JText::_('FRI'),
				5 => JText::_('SAT'),
				6 => JText::_('SUN')
				);
		
		$registry = new JRegistry;
		$registry->loadString($car->days_availability);
		$car_availability_arr = $registry->toArray();
		
		$car_data = array('opening_hr'=>0,
				'opening_min'=>0,
				'closing_hr'=>0,
				'closing_min'=>0,
				'is_available' => 0
				);
		
		$todays_availabilty = !empty($car_availability_arr[$order_date_week_day-1]) ? $car_availability_arr[$order_date_week_day-1] : array();
		
		if(empty($car_availability_arr))  // if availability is not set yet, car is not available
		{
			$car_data['is_available']=0;
		}
		elseif(empty($todays_availabilty) || empty($todays_availabilty['is_available']) || $todays_availabilty['is_available']==0 ) // if today's availability is not set, car is not available today
		{
			$car_data['is_available']=0;
		}
		elseif($todays_availabilty['is_available']==1&&$todays_availabilty['opening_hrs']==-1&&$todays_availabilty['opening_mins']==-1&&$todays_availabilty['closing_hrs']==-1&&$todays_availabilty['closing_mins']==-1 )
		{
			$car_data['is_available']=1;
		}
		else
		{
			$car_data['opening_hr']	=	(int)$todays_availabilty['opening_hrs'];
			$car_data['opening_min']	=	(int)$todays_availabilty['opening_mins'];
			$car_data['closing_hr']	=	(int)$todays_availabilty['closing_hrs'];
			$car_data['closing_min']	=	(int)$todays_availabilty['closing_mins'];
			
			// now check the availability based on opening/closing time
			if($car_data['opening_hr']>-1 && $car_data['closing_hr']>-1)
			{
				if($car_data['opening_hr'] > $order_date_time_hr && $car_data['closing_hr'] > $order_date_time_hr) { // out of hour range
					$car_data['is_available'] = 0;
				}
				elseif($car_data['opening_hr'] < $order_date_time_hr && $car_data['closing_hr'] < $order_date_time_hr) { // out of hour range
					$car_data['is_available'] = 0;
				}
				else {
				    
					if($car_data['opening_hr'] < $order_date_time_hr && $order_date_time_hr < $car_data['closing_hr']){ // inside of hour range
						$car_data['is_available'] = 1;
					}
					else { // opening OR closing hour == current hour, so minutes will be considered now
					    
						if($car_data['opening_hr'] == $order_date_time_hr)
						{
							if($car_data['opening_min'] <= $order_date_time_min){
								$car_data['is_available'] = 1;
							}
							else {
								$car_data['is_available'] = 0;
							}
						}
						elseif($car_data['closing_hr'] == $order_date_time_hr)
						{
							if($order_date_time_min <= $car_data['closing_min'] ){
								$car_data['is_available'] = 1;
							}
							else {
								$car_data['is_available'] = 0;
							}
						}
					}
				}
			}
		}
		
		if($car_data['is_available']==1){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	/**
	 * Method to check previous booking of this car
	 *
	 * @param   object	
	 * @param   pickup date set from mobile app
	 */
	public static function check_car_previous_bookings($car, $pickup_time_str="", $editing_order_id = 0, $duration_seconds = 0)
	{
		if(!is_object($car)){
			$car = booking_helper::get_car_details($car);
		}
		
		$session =  JFactory::getSession();
		if($pickup_time_str!=""){
			$order_date_time_str = $pickup_time_str;
		}
		else {
			$order_date_time_str = $session->get('timestr1', '');
		}

		if($order_date_time_str!='')
		{
			// if car tracking is set NO, no need to check previous booking
			if((int)$car->track_availability==0){
				return TRUE;
			}
			
			// here we have 2 time ranges
			// one is pickup to pickup_plus_duration
			// another is database booking_start to booking_end
			// availability check -- 4 OVERLAPPED cases
			
			$pickup = $order_date_time_str;
			$pickup_plus_duration = $order_date_time_str+(float)$duration_seconds;
			
			// 1) (pickup in between booking_start and booking_end) AND (pickup_plus_duration in between booking_start and booking_end) -- OVERLAPPED
			// 2) (pickup less than booking_start)  AND (pickup_plus_duration greater than booking_end) -- OVERLAPPED
			// 3) (pickup in between booking_start and booking_end) AND (pickup_plus_duration not in between booking_start and booking_end) -- OVERLAPPED
			// 4) (pickup not in between booking_start and booking_end) AND (pickup_plus_duration in between booking_start and booking_end) -- OVERLAPPED
			
			$db = JFactory::getDBO();
            
			$query = 'SELECT COUNT(id)'
				. ' FROM #__taxibooking_order_car_rel'
				. ' WHERE vehicle_id = '.$db->quote($car->id)
				. ' AND ( ('.$db->quote($pickup).' BETWEEN `booking_time_start` AND `booking_time_end` ) AND ('.$db->quote($pickup_plus_duration).' BETWEEN `booking_time_start` AND `booking_time_end` )'
				. '  	OR ('.$db->quote($pickup).' <= `booking_time_start` AND `booking_time_end` <= '.$db->quote($pickup_plus_duration).' )  '
				. '  	OR ('.$db->quote($pickup).' BETWEEN `booking_time_start` AND `booking_time_end` ) AND ('.$db->quote($pickup_plus_duration).' NOT BETWEEN `booking_time_start` AND `booking_time_end` )'
				. '  	OR ('.$db->quote($pickup).' NOT BETWEEN `booking_time_start` AND `booking_time_end` ) AND ('.$db->quote($pickup_plus_duration).' BETWEEN `booking_time_start` AND `booking_time_end` )'
				. ' )'
				;
			if($editing_order_id > 0){
				$query .= ' AND order_id <> '.$db->Quote($editing_order_id);
			}
			$db->setQuery($query);
			$db->query();
			$previous_booking = $db->loadResult();
			
			if($previous_booking>0){
				return FALSE;
			}
		}
		return TRUE;
	}
	
	/**
	 * Method to check if a car is aready assigned to any shuttle route on the order time
	 *
	 * @param   object	
	 * @param   pickup date set from mobile app
	 */
	public static function check_car_shuttle_route($car, $pickup_time="", $elsettings)
	{
		if(!is_object($car)){
			$car = booking_helper::get_car_details($car);
		}
		
		if($car->use_as_shuttle==2){ // car used only as shuttle will not be listed in other booking
			return FALSE;
		}
		
		$session =  JFactory::getSession();
		if($pickup_time==""){
			$pickup_time = $session->get('time1', '');
		}

		if($pickup_time!='')
		{
			$time_arr = explode(':', $pickup_time);
			$pickup_hr = (int)$time_arr[0];
			
			if($elsettings->time_format=='12hr') {
				$pickup_min = substr($time_arr[1],0,2);
				$pickup_meridian = substr($time_arr[1],2);
				
				if($pickup_meridian=='PM'){
					$pickup_hr += 12;
				}
			}
			else {
				$pickup_min = $time_arr[1];
			}
			
			$pickup_time = str_pad($pickup_hr, 2, '0', STR_PAD_LEFT).':'.$pickup_min;
			
			$db = JFactory::getDBO();
			
			$query = 'SELECT r.*'
				. ' FROM #__taxibooking_shuttle_routes AS r'
				. ' WHERE r.car_id = '.(int)$car->id
				;
			//echo str_replace('#__', 'nfgwj_', $query);
			$db->setQuery($query);
			$db->query();
			$routes = $db->loadObjectList();
			
			if(!empty($routes)){
				$result = TRUE;
				foreach($routes as $route){
					$query = 'SELECT DATE_FORMAT(rs.arrival_time, "%H:%i") AS arrival_time'
						. ' FROM #__taxibooking_shuttle_route_stops AS rs'
						. ' WHERE rs.route_id = '.(int)$route->id
						. ' ORDER BY rs.arrival_time'
						;
					//echo str_replace('#__', 'nfgwj_', $query);
					$db->setQuery($query);
					$db->query();
					$stops = $db->loadObjectList();
					
					if(!empty($stops)){
						$count = count($stops);
						$start = $stops[0]->arrival_time;
						$end = $stops[$count-1]->arrival_time;
						//print $start.'--'.$pickup_time.'--'.$end;
						if($start <= $pickup_time && $pickup_time <= $end){ // this car assigned to a shuttle route
							$result = FALSE;
							break;
						}
					}
				}
				
				return $result;
			}
			else {
				return TRUE;
			}
		}
		return TRUE;
	}
	
	// Clears car booking for an order
	public static function cancel_car_bookings($order_id = 0)
	{
		$app = JFactory::getApplication();
		$elsettings 	= booking_helper::config();
		
		if($order_id > 0)
		{
			// first collect car availability records for this order
			// if any found with appropriate google event ID, remove that event from google calendar
			$db = JFactory::getDBO();
			
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_order_car_rel');
			$query->where('order_id = '.$db->quote($order_id));
			$db->setQuery((string)$query);
			$db->query();
			if($db->getNumRows()>0)
			{
				$rows = $db->loadObjectList();
				$outbound_order = $rows[0];
				
				// collect google user information from order car
				$order_car = booking_helper::get_car_details($outbound_order->vehicle_id);
				
				if($order_car->google_calendar_enabled==1 && $order_car->use_as_shuttle!=2)
				{
					// stop if p12 file is not uploaded
					if($elsettings->google_app_email_address==""
					   ||$elsettings->google_client_id==""
					   ||$elsettings->google_p12_key_filename=="")
					{
						// do nothing
					}
					else {
						if ($app->isAdmin()){
							include_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_calendar.php');
						}
						else{
							include_once (JPATH_COMPONENT.DS.'classes'.DS.'google_calendar.php');
						}
						
						$gcal = new GoogleCalendar;
						// login
						$result = $gcal->login($elsettings);
						if( $result == "ok")
						{
							$client = $gcal->getClient();	
							if($client != null)
							{
								foreach($rows as $row)
								{
									if($row->google_event_id!="")
									{
										if($row->google_calendar_id == ""){
											$gcal->deleteEventById($client, $row->google_event_id);
										}
										else {
											$result2 = $gcal->deleteEvent($client, $row->google_event_id, $row->google_calendar_id);
											if($result2 != "ok"){
												tberror_log("Removing Event, $row->google_event_id".$result2); 
											}
										}
									}
								}
							}
							else {
								tberror_log("Removing Event,"."$client == null error"); 
							}
						}
						else {
							tberror_log("Authentication - Removing Event,".$result); 
						}
					}
				}
			}
			
			// now delete availability records
			$query = $db->getQuery(true);
			$query = 'DELETE FROM `#__taxibooking_order_car_rel` WHERE `order_id` = '.$db->quote($order_id);
			$db->setQuery($query);
			$db->execute();
			
			// trigger remove order method for payment plugin
			JPluginHelper::importPlugin('tbpayment');
			$_dispatcher = JDispatcher::getInstance();
			$_dispatcher->trigger('plgTbOnRemoveOrder',array( $order_id));
		}
		return TRUE;
	}
	
        public static function get_car_field($filter = '', $field = 'title'){
                
                $result = '';
                if($filter != ''){
                    $db =  JFactory::getDBO();
            
                    $query = 'SELECT `'.$field.'`'
                            . ' FROM #__taxibooking_cars'
                            . ' WHERE id = '.$db->quote($filter)
                            ;
                    $db->setQuery($query);
                    $db->query();
                    $result = $db->loadResult(); 
                    
                }
                return $result;
        }
	
	public static function get_order_car($order)
	{
                if(!empty($order)){
			
			if($order->custom_car!=""){
				return $order->custom_car;
			}
			else {
				$db = JFactory::getDBO();
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_cars');
				$query->where('id = '.(int)$order->vehicletype);
				$db->setQuery((string)$query);
				$row = $db->loadObject();
				
				if($row){
					return $row->title;
				}
				else {
					return 'NOT FOUND';
				}
			}
		}
		else {
			return 'NOT FOUND';
		}
        }
	public static function get_order_pickup_date($order, $elsettings = false)
	{
                if(!empty($order)){
			
			if($order->source=="backend"){
				return booking_helper::date_format($order->datetime1, 'Y-m-d H:i:s', $elsettings);
			}
			else {
				if(is_numeric($order->payment)){
					return booking_helper::date_format($order->datetime1, 'Y-m-d H:i:s', $elsettings);
				}
				else {
					return booking_helper::DateTimeHuman($order->datetime1);
				}
			}
		}
		else {
			return 'NOT FOUND';
		}
        }
	public static function get_order_return_date($order, $elsettings = false)
	{
                if(!empty($order)){
			
			if($order->source=="backend"){
				return booking_helper::date_format($order->datetime2, 'Y-m-d H:i:s', $elsettings);
			}
			else {
				if(is_numeric($order->payment)){
					return booking_helper::date_format($order->datetime2, 'Y-m-d H:i:s', $elsettings);
				}
				else {
					return booking_helper::DateTimeHuman($order->datetime2);
				}
			}
		}
		else {
			return 'NOT FOUND';
		}
        }
	public static function get_order_payment($order)
	{
                if(!empty($order)){
			
			if($order->custom_payment!=""){
				return $order->custom_payment;
			}
			else {
				if(is_numeric($order->payment)){
					return $order->payment_method;
				}
				else {
					return $order->payment;
				}
			}
		}
		else {
			return 'NOT FOUND';
		}
        }
	
	public static function get_car_unit_price($car, $distance, $available_tariffs = array())
	{
		$elsettings = booking_helper::config();
		$unit_price = $elsettings->price_per_unit_distance;
		$applied_tariff = null;
		
                if($car->unit_price_override==1) // if this car has unit price override
		{
			$unit_price = $car->unit_price;
			$distance_price_arr = unserialize($car->distance_prices);
		}
		else
		{
			$unit_price = $elsettings->price_per_unit_distance;
			$distance_price_arr = $elsettings->distance_prices; // this is alerady unserialized
		}
		
		if(!empty($distance_price_arr))
		{
			for($i = 0; $i < count($distance_price_arr); $i++)
			{
				$distance_min = $distance_price_arr[$i][0];
				$distance_max = $distance_price_arr[$i][1];
				$price_value = isset($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
				$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
				
				if($distance_min <= $distance && $distance <= $distance_max )
				{
					if($car->use_tariff==1 && !empty($available_tariffs)){
						// loop through all available tariffs and pick the appropriate one
						for($tarcounter=0;$tarcounter<count($available_tariffs);$tarcounter++){
							$tariff = $available_tariffs[$tarcounter];
							if(booking_helper::checkCarTariff($car, $tariff)){
								$applied_tariff = $tariff;
								$unit_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
								break;
							}
						}
					}
					else {
						$unit_price = $price_value;
					}
					break;
				}
			}
		}
		else { // no distance sector block 
			if($car->use_tariff==1 && !empty($available_tariffs)){
				// loop through all available tariffs and pick the appropriate one
				for($tarcounter=0;$tarcounter<count($available_tariffs);$tarcounter++){
					$tariff = $available_tariffs[$tarcounter];
					if(booking_helper::checkCarTariff($car, $tariff)){
						$applied_tariff = $tariff;
						$unit_price = $tariff->unit_price;
						break;
					}
				}
			}
		}
		
		return array($unit_price, $applied_tariff);
        }
	
	// check if this tariff is assigned to this car or not
	public static function checkCarTariff($car, $tariff){
		$assigned_cars = $tariff->assigned_cars;
		if(explode(',', $assigned_cars)){
			$assigned_cars_arr = explode(',', $assigned_cars);
			
			if(in_array($car->id, $assigned_cars_arr)){
				return TRUE;
			}
		}
		
		return FALSE;
	}
	
	public static function get_car_cumulative_price($car, $distance, $available_tariffs = array())
	{
		$elsettings = booking_helper::config();
		
		$applied_tariff = null;
		$car_price = 0;
		$unit_price = 0;
		$price_calculation_debug_str = '';
                if($car->unit_price_override==1) // if this car has unit price override
		{
			$unit_price = $car->unit_price;
			$cumulative_distance_prices = unserialize($car->cumulative_distance_prices);
		}
		else
		{
			$unit_price = $elsettings->price_per_unit_distance;
			$cumulative_distance_prices = $elsettings->cumulative_distance_prices; // this is alerady unserialized
		}
		
		if(!empty($cumulative_distance_prices))
		{
			$temp = $distance;
			foreach($cumulative_distance_prices as $cumulative_distance_price)
			{
				$price_value = isset($cumulative_distance_price[2]) ? $cumulative_distance_price[2] : 0;
				$tariff_prices = !empty($cumulative_distance_price[5]) ? $cumulative_distance_price[5] : array();
				
				$block_unit_price = $unit_price;
				if($car->use_tariff==1 && !empty($available_tariffs)){
					// loop through all available tariffs and pick the appropriate one
					for($tarcounter=0;$tarcounter<count($available_tariffs);$tarcounter++){
						$tariff = $available_tariffs[$tarcounter];
						if(booking_helper::checkCarTariff($car, $tariff)){
							$applied_tariff = $tariff;
							$block_unit_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
							break;
						}
					}
				}
				else {
					$block_unit_price = $price_value;
				}
					
				if($cumulative_distance_price[1]<=$distance){
				    $diff = $cumulative_distance_price[1]-$cumulative_distance_price[0];
				    $car_price += $block_unit_price*$diff;
				    $temp -= $diff;
				    $price_calculation_debug_str .= booking_helper::distance_display($diff,$elsettings).' X '.booking_helper::price_display($block_unit_price,$elsettings).' + ';
				}
				else {
				    $car_price += $block_unit_price*$temp;
				    $price_calculation_debug_str .= booking_helper::distance_display($temp,$elsettings).' X '.booking_helper::price_display($block_unit_price,$elsettings).' + ';
				    $temp = 0;
				}
				
				if($temp<=0){
				    break;
				}
			}
			if($temp>0){
				$car_price += $unit_price*$temp;
				$price_calculation_debug_str .= booking_helper::distance_display($temp,$elsettings).' X '.booking_helper::price_display($unit_price,$elsettings).' + ';
			}
		}
		else {
			// if tariff YES, unit price will come from tariff
			if($car->use_tariff==1 && !empty($available_tariffs)){
				// loop through all available tariffs and pick the appropriate one
				for($tarcounter=0;$tarcounter<count($available_tariffs);$tarcounter++){
					$tariff = $available_tariffs[$tarcounter];
					if(booking_helper::checkCarTariff($car, $tariff)){
						$applied_tariff = $tariff;
						$unit_price = $tariff->unit_price;
						break;
					}
				}
			}
			
			$car_price += $unit_price*$distance;
			$price_calculation_debug_str .= booking_helper::distance_display($distance,$elsettings).' X '.booking_helper::price_display($unit_price,$elsettings).' + ';
		}
		
		// remove last +
		$price_calculation_debug_str = substr( $price_calculation_debug_str, 0, -3 );
		
		if($applied_tariff){
			$car_price += (float)$applied_tariff->initial_price;
			$price_calculation_debug_str .= ' + '.booking_helper::price_display((float)$applied_tariff->initial_price,$elsettings);
		}
		    
		$price_calculation_debug_str .= ' = '.booking_helper::price_display($car_price,$elsettings);
		
		return array($car_price,$unit_price, $price_calculation_debug_str, $applied_tariff);
        }
	
	public static function get_distance_sector_discounts($car, $elsettings, $distance = 0){
		
		$distance_sector_outbound_discount = 0;
		$distance_sector_return_discount = 0;
		
		if(!is_object($car)){
			$car = booking_helper::get_car_details($car);
		}
		
		$price_calculation_type = 'non-cumulative';
		$distance_price_arr = array();
                if($car->unit_price_override==1) // if this car has unit price override
		{
			if($car->price_calculation_cumulative==1){
				$price_calculation_type = 'cumulative';
				$distance_price_arr = unserialize($car->cumulative_distance_prices);
			}
			else {
				$price_calculation_type = 'non-cumulative';
				$distance_price_arr = unserialize($car->distance_prices);
			}
		}
		else
		{
			if($elsettings->price_calculation_cumulative==1){
				$price_calculation_type = 'cumulative';
				$distance_price_arr = $elsettings->cumulative_distance_prices; // this is alerady unserialized
			}
			else {
				$price_calculation_type = 'non-cumulative';
				$distance_price_arr = $elsettings->distance_prices; // this is alerady unserialized
			}
		}
		
		if(!empty($distance_price_arr))
		{
			if($price_calculation_type == 'non-cumulative'){
				for($i = 0; $i < count($distance_price_arr); $i++)
				{
					$distance_min = $distance_price_arr[$i][0];
					$distance_max = $distance_price_arr[$i][1];
					
					if($distance_min <= $distance && $distance <= $distance_max )
					{
						$distance_sector_outbound_discount = isset($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
						$distance_sector_return_discount = isset($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
						break;
					}
				}
			}
			else {
				$temp = $distance;
				foreach($distance_price_arr as $cumulative_distance_price)
				{
					if((int)$cumulative_distance_price[1]<=$distance){
						$diff = (int)$cumulative_distance_price[1]-(int)$cumulative_distance_price[0];
						$distance_sector_outbound_discount += (int)$cumulative_distance_price[3];
						$distance_sector_return_discount += (int)$cumulative_distance_price[4];
						$temp -= $diff;
					}
					else {
						$distance_sector_outbound_discount += (int)$cumulative_distance_price[3];
						$distance_sector_return_discount += (int)$cumulative_distance_price[4];
						$temp = 0;
					}
					
					if($temp<=0){
						break;
					}
				}
			}
		}
		
		return array($distance_sector_outbound_discount, $distance_sector_return_discount);
	}
	
	public static function get_country_field($id = '', $field = 'country_name'){
                
                $db =  JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select($db->quoteName($field));
		$query->from('#__taxibooking_countries');
		$query->where('country_id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadResult();
		
		if($row)
		{
			return $row;
		}
		
		return false;
        }
        
        /**
	 * Checks a currency symbol wether it is a HTML entity.
	 * When not and $convertToEntity is true, it converts the symbol
	 *
	 * @param string $symbol
	 */
	public static function checkCurrencySymbol( $symbol, $convertToEntity=true ) {
		
		$symbol = str_replace('&amp;', '&', $symbol );
		
		if( substr( $symbol, 0, 1) == '&' && substr( $symbol, strlen($symbol)-1, 1 ) == ';') {
			return $symbol;
		}
		else {
			if( $convertToEntity ) {
				$symbol = htmlentities( $symbol, ENT_QUOTES, 'utf-8' );
				
				if( substr( $symbol, 0, 1) == '&' && substr( $symbol, strlen($symbol)-1, 1 ) == ';') {
					return $symbol;
				}		
				// Sometimes htmlentities() doesn't return a valid HTML Entity
				switch( ord( $symbol ) ) {
					case 128:
					case 63:
						$symbol = '&euro;';
						break;
				}
						
			}
		}
		
		return $symbol;
	}
        
        /**
	 * Pulls settings from database and stores in an static object
	 *
	 * @return object
	 * @since 0.9
	 */
	public static function config()
	{
		$db 	=  JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_configs');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		$config = new stdClass;
		if(count($rows) > 0)
		{
			foreach($rows as $row)
			{
				$params = unserialize($row->text);
				foreach ($params as $key => $value)
				{
					$config->$key = $value;
				}
			}
		}

		return $config;
	}
	
	/**
	 * Pulls old settings from old table and stores in new settings table in new format
	 */
	public static function restoreSettings()
	{
		$db 	=  JFactory::getDBO();
		$sql 	= "SHOW TABLES LIKE '#__taxibooking_settings_old'";
		$db->setQuery($sql);
		$db->query();
		if($db->getNumRows()>0)
		{
			$sql 	= 'SELECT * FROM #__taxibooking_settings_old WHERE id= 1';
			$db->setQuery($sql);
			$db->query();
			$row = $db->loadObject();
			if($row)  // old settings table exists
			{
				$row->distance_prices = unserialize($row->distance_prices);
				$row = (array) $row;
				$params = serialize($row);
				
				$sql 	= 'UPDATE #__taxibooking_settings
					SET params  = '.$db->Quote($params).' WHERE id = 1';
				$db->setQuery($sql);
				if($db->query())
				{
					$sql 	= 'DROP TABLE #__taxibooking_settings_old';
					$db->setQuery($sql);
					$db->query();
				}
			}
		}
	}
	
	public static function calculate_time_difference($date1, $date2, $output = 'hr')
	{
		$date_obj1 = new DateTime($date1); //'2000-01-20'
		$date_obj2 = new DateTime($date2);
		//$hrs = round(($date_obj2->format('U') - $date_obj1->format('U')) / (60*60));
		
		if($output=='day'){
			$difference = ($date_obj2->format('U') - $date_obj1->format('U')) / (24*60*60);
		}
		else {
			$difference = ($date_obj2->format('U') - $date_obj1->format('U')) / (60*60);
		}
		
		return $difference;
	
		// This works only in php 5.3, not work on 5.2
		/*$date_obj1 = new DateTime($date1);
		$date_obj2 = new DateTime($date2);
		$interval = $date_obj1->diff($date_obj2);
		//print_r($interval);
		//echo "difference " . $interval->y . " years, " . $interval->m." months, ".$interval->d." days ".$interval->h." hrs ".$interval->i." mins <br>";
		if($interval->invert==0){
			if($output=='hr')
			{
				return ($interval->d*24)+$interval->h;
			}
		}
		else {
			return 0;
		}*/
	}
	
	public static function date_format($timestamp='', $format = 'Y-m-d H:i:s', $elsettings = false, $set_timezone = false)
	{
		if($timestamp==''){
			return '';
		}
		
		if($elsettings===false){
			$elsettings =  booking_helper::config();
		}
		
		// we had to set timezone for this website http://airport-london-transfers.co.uk/
		// somehow timezone was not set in Config timezone and time was showing in wrong timezone
		// another place is backend/models/order.php
		if(JURI::root()=='http://airport-london-transfers.co.uk/'){
			$config   = JFactory::getConfig();
			$siteOffset = $config->get('offset');
			date_default_timezone_set($siteOffset);
		}
		else {
			if($set_timezone){
				$config   = JFactory::getConfig();
				$siteOffset = $config->get('offset');
				date_default_timezone_set($siteOffset);
			}
		}
		
		//$dtnow = JFactory::getDate('now', $siteOffset);
		
		if($format=='Y-m-d'){
			if($elsettings->date_format=='mm-dd-yy') {
				$format = 'm-d-Y';
			}
			else {
				$format = 'd-m-Y';
			}
		}
		
		if($format=='Y-m-d H:i:s'){
			if($elsettings->date_format=='mm-dd-yy') {
				$format = 'm-d-Y';
			}
			else {
				$format = 'd-m-Y';
			}
			if($elsettings->time_format=='12hr') {
				$format .= ' h:i A';
			}
			else {
				$format .= ' H:i';
			}
		}
		
		return date($format, (int)$timestamp);
	}
	/**
	 * Generate captch code
	 */
	public static function generateCode($characters) 
	{
		/* list all possible characters, similar looking characters and vowels have been removed */
		$possible = '23456789bcdfghjkmnpqrstvwxyz';
		$code = '';
		$i = 0;
		while ($i < $characters) { 
			$code .= substr($possible, mt_rand(0, strlen($possible)-1), 1);
			$i++;
		}
		return $code;
	}
	public static function get_payment_details($id = 0)
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_paymentmethods');
		$query->where('id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		// process params
		if($row)
		{
			$params = explode('|', $row->payment_params);
			foreach($params as $item){
	
				$item = explode('=',$item);
				$key = $item[0];
				unset($item[0]);
	
				$item = implode('=',$item);
	
				if(!empty($item)){
					$row->$key = json_decode($item);
				}
			}
		}
		
		return $row;
	}
	public static function custom_field_details($id = 0)
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_fields');
		$query->where('id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		return $row;
	}
	public static function point_details($id = 0)
	{
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_points');
		$query->where('id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		return $row;
	}
	public static function has_any_coupon()
	{
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons');
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		return $rows;
	}
	public static function coupon_details($id = 0)
	{
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons');
		$query->where('id = '.(int)$id);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		return $row;
	}
	public static function process_extras($extras = array(), $booking_type = '')
	{
		if($booking_type=="")
		{
			$session = JFactory::getSession();
			$booking_type = $session->get('booking_type', 'address');
		}
		
		$result = array('pickup' => array(),
				'dropoff' => array(),
				'hourly_hire' => array(),
				'return_pickup' => array(),
				'return_dropoff' => array(),
				'shuttle_pickup' => array(),
				'shuttle_dropoff' => array()
				);
		$total_extra_price = 0;
		if(!empty($extras))
		{
			$pickup_extras = array();
			$dropoff_extras = array();
			
			if($booking_type=='address'){
				$pickup_extras = !empty($extras['pickup']) ? $extras['pickup'] : array();
				$dropoff_extras = !empty($extras['dropoff']) ? $extras['dropoff'] : array();
			}
			if($booking_type=='offers'){
				$pickup_extras = !empty($extras['route_pickup']) ? $extras['route_pickup'] : array();
				$dropoff_extras = !empty($extras['route_dropoff']) ? $extras['route_dropoff'] : array();
			}
			if($booking_type=='shuttle'){
				$pickup_extras = !empty($extras['shuttle_pickup']) ? $extras['shuttle_pickup'] : array();
				$dropoff_extras = !empty($extras['shuttle_dropoff']) ? $extras['shuttle_dropoff'] : array();
			}
			
			$hourly_extras = !empty($extras['hourly_hire']) ? $extras['hourly_hire'] : array();
			$return_pickup_extras = !empty($extras['return_pickup']) ? $extras['return_pickup'] : array();
			$return_dropoff_extras = !empty($extras['return_dropoff']) ? $extras['return_dropoff'] : array();
			
			if(!empty($pickup_extras))
			{
				foreach($pickup_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['pickup'][$id]['id'] = $row->id;
						$result['pickup'][$id]['type'] = $row->field_type;
						$result['pickup'][$id]['name'] = $row->title;
						
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['pickup'][$id]['value'] = $val;
							$result['pickup'][$id]['price'] = $row->price;
							$total_extra_price += $row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['pickup'][$id]['value'] = $val;
							$result['pickup'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['pickup'][$id]['value'] = $val;
							$result['pickup'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
			
			if(!empty($dropoff_extras))
			{
				foreach($dropoff_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['dropoff'][$id]['id'] = $row->id;
						$result['dropoff'][$id]['type'] = $row->field_type;
						$result['dropoff'][$id]['name'] = $row->title;
						
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['dropoff'][$id]['value'] = $val;
							$result['dropoff'][$id]['price'] = $row->price;
							$total_extra_price += $row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['dropoff'][$id]['value'] = $val;
							$result['dropoff'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['dropoff'][$id]['value'] = $val;
							$result['dropoff'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
			
			if(!empty($hourly_extras))
			{
				foreach($hourly_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['hourly_hire'][$id]['id'] = $row->id;
						$result['hourly_hire'][$id]['type'] = $row->field_type;
						$result['hourly_hire'][$id]['name'] = $row->title;
						
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['hourly_hire'][$id]['value'] = $val;
							$result['hourly_hire'][$id]['price'] = $row->price;
							$total_extra_price += $row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['hourly_hire'][$id]['value'] = $val;
							$result['hourly_hire'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['hourly_hire'][$id]['value'] = $val;
							$result['hourly_hire'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
			
			if(!empty($return_pickup_extras))
			{
				foreach($return_pickup_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['return_pickup'][$id]['id'] = $row->id;
						$result['return_pickup'][$id]['type'] = $row->field_type;
						$result['return_pickup'][$id]['name'] = $row->title;
						
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['return_pickup'][$id]['value'] = $val;
							$result['return_pickup'][$id]['price'] = $row->price;
							$total_extra_price += $row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['return_pickup'][$id]['value'] = $val;
							$result['return_pickup'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['return_pickup'][$id]['value'] = $val;
							$result['return_pickup'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
			
			if(!empty($return_dropoff_extras))
			{
				foreach($return_dropoff_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['return_dropoff'][$id]['id'] = $row->id;
						$result['return_dropoff'][$id]['type'] = $row->field_type;
						$result['return_dropoff'][$id]['name'] = $row->title;
						
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['return_dropoff'][$id]['value'] = $val;
							$result['return_dropoff'][$id]['price'] = $row->price;
							$total_extra_price += $row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['return_dropoff'][$id]['value'] = $val;
							$result['return_dropoff'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['return_dropoff'][$id]['value'] = $val;
							$result['return_dropoff'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
		}
		
		return array($result, $total_extra_price);
	}
	
	public static function process_user_details_extras($extras = array(), $booking_type = '')
	{
		if($booking_type=="")
		{
			$session = JFactory::getSession();
			$booking_type = $session->get('booking_type', 'address');
		}
		
		$result = array('user_details' => array());
		$total_extra_price = 0;
		if(!empty($extras))
		{
			$user_details_extras = !empty($extras['user_details']) ? $extras['user_details'] : array();
			
			if(!empty($user_details_extras))
			{
				foreach($user_details_extras as $id => $val)
				{
					$row = booking_helper::custom_field_details($id);
					if($row)
					{
						$result['user_details'][$id]['id'] = $row->id;
						$result['user_details'][$id]['type'] = $row->field_type;
						$result['user_details'][$id]['name'] = $row->title;
					
						if($row->field_type=='input' || $row->field_type=='textarea')
						{
							$result['user_details'][$id]['value'] = $val;
							$result['user_details'][$id]['price'] = $row->price;
							$total_extra_price += (float)$row->price;
						}
						elseif($row->field_type=='extra')
						{
							$result['user_details'][$id]['value'] = $val;
							$result['user_details'][$id]['price'] = number_format($val*$row->price, 2);
							$total_extra_price += number_format($val*$row->price, 2);
						}
						elseif($row->field_type=='optionlist')
						{
							$result['user_details'][$id]['value'] = $val;
							$result['user_details'][$id]['price'] = 0;
							$total_extra_price += 0;
						}
					}
				}
			}
		}
		
		return array($result, $total_extra_price);
	}
	
	public static function extra_html_preview($selected_extras = array(), $section = 'pickup')
	{
		$elsettings = booking_helper::config();
		$html = '';
		
		if(!empty($selected_extras[$section]))
		{
			$extras = $selected_extras[$section];
			
			$counter = 0;
			foreach($extras as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
				if( ($extra['type']=='input'||$extra['type']=='textarea')&& $extra['value']==""){
					continue;
				}
				elseif($extra['type']=='extra' && $extra['value']==0){
					continue;
				}
				else {
					$html .= '
			<div class="check_box_wrap clearfix">
				<div class="check_name">'.$extra['name'].':</div>
				<div class="check_desc">'.$extra['value'];
			
			if($extra['price']>0 && $elsettings->show_price==1){
				$html .= '('.booking_helper::price_display('+'.$extra['price'],$elsettings).')';
			}
				$html .= '</div>
			</div>';
				}
				$counter++;
			}
		}
		
		return $html;
	}
	
	public static function price_display($price, $elsettings = false)
	{
		if($elsettings===false){
			$elsettings = booking_helper::config();
		}
		
		if(substr($price, 0, 1)=='+'||substr($price, 0, 1)=='-'){
			$sign = substr($price, 0, 1);
			$price = (float)substr($price, 1);
			return $sign.$elsettings->currency_symbol.number_format($price, 2, '.', ',');
		}
		else {
			$price = (float)$price;
			return $elsettings->currency_symbol.number_format($price, 2, '.', ',');
		}	
	}
	public static function distance_display($distance, $elsettings = false)
	{
		if($elsettings===false){
			$elsettings = booking_helper::config();
		}
		
		if($distance>1){
			return number_format($distance,0).' '.$elsettings->distance_unit.'s';
		}
		else {
			return number_format($distance,0).' '.$elsettings->distance_unit;
		}
	}
	
	public static function custom_field_type($type = 'input')
	{
		if($type=='input'){
			return JText::_('INPUT_TYPE');
		}
		elseif($type=='textarea') {
			return JText::_('CUSTOM_FIELD_EDIT_TYPE_TEXTAREA');
		}
		elseif($type=='extra') {
			return JText::_('EXTRA_TYPE');
		}
		elseif($type=='optionlist') {
			return JText::_('OPTION_LIST_TYPE');
		}
		else {
			return '';
		}
	}
	public static function get_selected_extras($type = 'pickup')
	{
		$session =  JFactory::getSession();
		$route_from = $session->get('route_from', 0);
                $route_to = $session->get('route_to', 0);
		$airports1 = $session->get('address_from', '');
		$airports2 = $session->get('address_to', '');
		
		$shuttle_pickup_poi = $session->get('shuttle_pickup_poi', 0);
		$shuttle_dropoff_poi = $session->get('shuttle_dropoff_poi', 0);
		
		$extras = $session->get('selected_extras', array());
		
		switch($type){
			
			case 'route_pickup':
				if($route_from==0){
					return null;
				}
				else {
					$poi_obj = booking_helper::point_details($route_from);
					$rows = !empty($extras['pickup']) ? $extras['pickup'] : array();
				}
				break;
			
			case 'route_dropoff':
				if($route_to==0){
					return null;
				}
				else {
					$poi_obj = booking_helper::point_details($route_to);
					$rows = !empty($extras['dropoff']) ? $extras['dropoff'] : array();
				}
				break;
			
			case 'dropoff':
				if($airports2==''){
					return null;
				}
				else {
					$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports2), 'id');
					$poi_obj = booking_helper::point_details($poi_id);
					$rows = !empty($extras['dropoff']) ? $extras['dropoff'] : array();
				}
				break;
			
			case 'pickup':
			default:
				if($airports1==''){
					return null;
				}
				else {
					$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports1), 'id');
					$poi_obj = booking_helper::point_details($poi_id);
					$rows = !empty($extras['pickup']) ? $extras['pickup'] : array();
				}
				break;
			
			case 'hourly_hire':

				$rows = !empty($extras['hourly_hire']) ? $extras['hourly_hire'] : array();
				break;
			
			case 'shuttle_pickup':
				if($shuttle_pickup_poi==0){
					return null;
				}
				else {
					$poi_obj = booking_helper::point_details($shuttle_pickup_poi);
					$rows = !empty($extras['pickup']) ? $extras['pickup'] : array();
				}
				break;
			
			case 'shuttle_dropoff':
				if($shuttle_dropoff_poi==0){
					return null;
				}
				else {
					$poi_obj = booking_helper::point_details($shuttle_dropoff_poi);
					$rows = !empty($extras['dropoff']) ? $extras['dropoff'] : array();
				}
				break;
		}
		
		$html = '';
		
		if(!empty($poi_obj->text)){
		    $html .='<div class="ver_input_wrap clearfix"><label>'.$poi_obj->text.'</label></div>';
		}
		
		if(!empty($rows))
		{
			foreach($rows as $key => $val)
			{
				$row = booking_helper::custom_field_details($key);
				
				if($row->text!=""){
					$field_title = '<a href="javascript:void(0);" class="field_desc" title="'.$row->text.'">'.$row->title.'</a>';
				}
				else {
					$field_title = $row->title;
				}
				    
				$html .= '<div class="ver_input_wrap clearfix">
					    <label>'.$field_title.'</label>';
				
				if($row->field_type=='input'){
					$additional_class = ($row->is_mandatory==1) ? ' required' : '';
					$html .=    '<input class="ver_inputbox extra '.$additional_class.'" type="text" value="'.$val['value'].'" name="extras['.$type.']['.$key.']">';
				}
				elseif($row->field_type=='textarea'){
				    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
				    $html .=    '<textarea class="ver_inputbox extra'.$additional_class.'" name="extras['.$type.']['.$key.']">'.$val['value'].'</textarea>';
				}
				elseif($row->field_type=='extra'){
				    $html .=    '<select class="seat_options select extra" tabindex="1" name="extras['.$type.']['.$key.']">';
				    
				    for($i = 0; $i <= $row->quantity; $i++){
					$selected = ($i==$val['value']) ? ' selected="selected"' : '';
					$html .= '<option value="'.$i.'"'.$selected.'>'.$i.'</option>';
				    }
				    
				    $html .=    '</select>';
				}
				elseif($row->field_type=='optionlist'){
					$html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
					
					$field_options = unserialize($row->field_options);
					for($i = 0; $i < count($field_options); $i++){
						$selected = ($field_options[$i]==$val['value']) ? ' selected="selected"' : '';
					    $html .= '<option value="'.htmlspecialchars($field_options[$i]).'"'.$selected.'>'.$field_options[$i].'</option>';
					}
					
					$html .=    '</select>';
				}
				$html .=    '</div>';
			}
		}
		return $html;
	}
	
	public static function get_selected_return_extras($template_dir = '')
	{
		$db = JFactory::getDBO();
		$session =  JFactory::getSession();
		
		$route_from_fld = $session->get('route_from_fld', '');
		$route_from = $session->get('route_from', 0);
		
		$route_to_fld = $session->get('route_to_fld', '');
                $route_to = $session->get('route_to', 0);
		
		$airports1 = $session->get('address_from', '');
		$airports2 = $session->get('address_to', '');
		$booking_type = $session->get('booking_type', 'address');
		
		$extras = $session->get('selected_extras', array());
		$return_pickup_extras = !empty($extras['return_pickup']) ? $extras['return_pickup'] : array();
		$return_dropoff_extras = !empty($extras['return_dropoff']) ? $extras['return_dropoff'] : array();
		
		$pickup_extras = array();
		$dropoff_extras = array();
		
		if($booking_type=='address')
		{
			$return_pickup = $airports2;
			$return_dropoff = $airports1;
			
			if($airports2!='')
			{
				$where = array();
				$where[] = 'f.published = 1';
				
				$pickup_poicat = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports2), 'catid');
				$where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
				$where[] = '(f.show_on_pickup = 1 OR f.show_on_address = 1)';
				$where[] = 'f.show_on_return = 1';
				
				$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
				$query = 'SELECT f.* '
					. ' FROM #__taxibooking_fields AS f'
					. $where
					. ' ORDER BY f.ordering ASC'
				;
				$db->setQuery($query);
				$db->query();
				$pickup_extras = $db->loadObjectList();
			}
			if($airports1!='')
			{
				$where = array();
				$where[] = 'f.published = 1';
				
				$dropoff_poicat = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports1), 'catid');
				$where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
				$where[] = '(f.show_on_dropoff = 1 OR f.show_on_address = 1)';
				$where[] = 'f.show_on_return = 1';
				
				$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
				$query = 'SELECT f.* '
					. ' FROM #__taxibooking_fields AS f'
					. $where
					. ' ORDER BY f.ordering ASC'
				;
				
				$db->setQuery($query);
				$db->query();
				$dropoff_extras = $db->loadObjectList();
			}
		}
		elseif($booking_type=='offers')
		{
			$return_pickup = $route_to_fld;
			$return_dropoff = $route_from_fld;
			
			if($route_to > 0) 
			{
				$where = array();
				$where[] = 'f.published = 1';
				
				$pickup_poicat = booking_helper::get_place_field_by_id($route_to, 'catid');
				$where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
				$where[] = 'f.show_on_pickup = 1';
				$where[] = 'f.show_on_return = 1';
				
				$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
				$query = 'SELECT f.* '
					. ' FROM #__taxibooking_fields AS f'
					. $where
					. ' ORDER BY f.ordering ASC'
				;
				$db->setQuery($query);
				$db->query();
				$pickup_extras = $db->loadObjectList();
			}
			
			if($route_from > 0)
			{
				$where = array();
				$where[] = 'f.published = 1';
				
				$dropoff_poicat = booking_helper::get_place_field_by_id($route_from, 'catid');
				$where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
				$where[] = 'f.show_on_dropoff = 1';
				$where[] = 'f.show_on_return = 1';
				
				$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
				$query = 'SELECT f.* '
					. ' FROM #__taxibooking_fields AS f'
					. $where
					. ' ORDER BY f.ordering ASC'
				;
				
				$db->setQuery($query);
				$db->query();
				$dropoff_extras = $db->loadObjectList();
			}
		}
		
		$html = '';
		if($booking_type=='address' || $booking_type=='offers')
		{
		    ob_start();
		    if($template_dir==""){
			$template_dir = JPATH_COMPONENT.DS .'templates'.DS.'return_extras.tpl.php';
		    }
		    include( $template_dir );
		    $html = ob_get_contents();
		    ob_end_clean();
		}
		
		return $html;
	}
	
	public static function get_poi_additional_charge($booking_data = array())
	{
		$booking_type = $booking_data['booking_type'];
		
		$result = array('total_additional_price'=>0,'pickup'=>array(),'dropoff'=>array());
		$additional_price = 0;
		
		$poi_id = 0;
		if($booking_type=='address'){
			$poi_id = $booking_data['pickup_poi'];
		}
		elseif($booking_type=='offers'){
			$poi_id = $booking_data['route_from'];
		}
		
		if($poi_id > 0){
			$point_info = booking_helper::point_details($poi_id);
		
			if($point_info->additional_fld_label!="" && $point_info->additional_charge>0)
			{
				$additional_price += $point_info->additional_charge;
				$result['pickup'] = array('fld_label' => $point_info->additional_fld_label,
							  'charge' => $point_info->additional_charge
							 );
			}
		}
		
		$poi_id = 0;
		if($booking_type=='address'){
			$poi_id = $booking_data['dropoff_poi'];
		}
		elseif($booking_type=='offers'){
			$poi_id = $booking_data['route_to'];
		}
		
		if($poi_id > 0){
			$point_info = booking_helper::point_details($poi_id);
		
			if($point_info->additional_fld_label!="" && $point_info->additional_charge>0){
				$additional_price += $point_info->additional_charge;
				$result['dropoff'] = array('fld_label' => $point_info->additional_fld_label,
							  'charge' => $point_info->additional_charge
							 );
			}
		}
		
		$result['total_additional_price'] = $additional_price;
		
		return $result;
	}
	
	public static function is_hourly_rate_enabled()
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from('#__taxibooking_cars');
		$query->where('hourly_hire_enabled = 1');
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$result = $db->loadResult();
		
		if($result>0){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	public static function has_any_address()
	{
		$db = JFactory::getDBO();
		$user = JFactory::getUser();
		
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from('#__taxibooking_user_addresses');
		$query->where('user_id = '.(int)$user->get('id'));
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$result = $db->loadResult();
		
		if($result>0){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	public static function is_shuttles_enabled()
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from('#__taxibooking_shuttle_routes');
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$result = $db->loadResult();
		
		if($result>0){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	/**
	* Outputs PDF file stored on disk with proper headers.
	* @param string $filename 	Name of file on disk
	*/
	static function outputStoredPDF($filename)
	{
		ob_end_clean();
		header('Content-Type: application/pdf');
		header('Cache-Control: public, must-revalidate, max-age=0'); // HTTP/1.1
		header('Pragma: public');
		header('Expires: Sat, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Content-Length: '.filesize($filename));
		header('Content-Disposition: inline; filename="'.basename($filename).'";');
		readfile($filename);      
	}
	
	public static function calculate_wait_time_discount($return_discount_wait_hr='')
	{
		$elsettings =  booking_helper::config();
		$discount = 0;
		
		if($elsettings->wait_time_return_discount=="1" && (int)$return_discount_wait_hr>0 && $return_discount_wait_hr!="-1")
		{
			$return_discounts_arr = $elsettings->return_discounts;
			if(!empty($return_discounts_arr))
			{
				foreach($return_discounts_arr as $key => $val)
				{
					if((int)$return_discount_wait_hr == (int)$val[0]){
						$discount = (float)$val[1];
						break;
					}
				}
			}
		}
		
		return $discount;
	}
	
	public static function calculate_return_price($car_price = 0, $elsettings, $discounts = array()){
		$return_discounts = 0;
		$return_discounts_calc = '';
		
		if(!empty($discounts))
		{
			if($discounts['return_wait_discount']>0){
				$return_discounts += ($discounts['return_wait_discount']/100)*$car_price;
				$return_discounts_calc .= '('.$discounts['return_wait_discount'].' X '.$car_price.'/100)';
			}
			else {
				$elsettings->discount = (float)$elsettings->discount;
				$return_discounts += ($elsettings->discount/100)*$car_price;
				$return_discounts_calc .= '('.$elsettings->discount.' X '.$car_price.'/100)';
			}
			
			// apply distance sector discounts
			$return_discounts += $discounts['distance_sector_return_discount'];
			$return_discounts_calc .= ' + ('.$discounts['distance_sector_return_discount'].')';
		}
		
		$return_discounts_calc .= ' = '.$return_discounts;
		$return_price = $car_price - $return_discounts;
		
		return array($return_price, $return_discounts, $return_discounts_calc);
	}
	
	public static function round_price($price = 0, $elsettings){
		
		if($elsettings->roundup_price=='nearest5'){
/*
1. Round to the next multiple of 5, exclude the current number

Behaviour: 50 outputs 55, 52 outputs 55

function roundUpToAny($n,$x=5) {
    return round(($n+$x/2)/$x)*$x;
}

2. Round to the nearest multiple of 5, include the current number

Behaviour: 50 outputs 50, 52 outputs 55, 50.25 outputs 50

function roundUpToAny($n,$x=5) {
    return (round($n)%$x === 0) ? round($n) : round(($n+$x/2)/$x)*$x;
}

3. Round up to an integer, then to the nearest multiple of 5

Behaviour: 50 outputs 50, 52 outputs 55, 50.25 outputs 55

function roundUpToAny($n,$x=5) {
    return (ceil($n)%$x === 0) ? round($n) : round(($n+$x/2)/$x)*$x;
}
*/
			$rounded_price = booking_helper::roundUpToAny($price);
		}
		elseif($elsettings->roundup_price=='whole') {
			$rounded_price = round($price);
		}
		else {
			$rounded_price = (float)number_format($price,2,'.','');
		}
		
		return $rounded_price;
	}
	
	public static function roundUpToAny($n,$x=5) {
		return (ceil($n)%$x === 0) ? ceil($n) : round(($n+$x/2)/$x)*$x;
	}
	
	public static function send_order_sms($order, $elsettings)
	{
		require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'sms_helper.php');
		$options = array();
		$options['username'] = $elsettings->clickatell_api_username;
		$options['password'] = $elsettings->clickatell_api_password;
		$options['api_id'] = $elsettings->clickatell_api_id;
		$options['sender_id'] = $elsettings->clickatell_sender_id;
		$options['to'] = $elsettings->country_calling_code.$order->phone;
		
		$sms_helper = new sms_helper($options);
		$sms_helper->prepare_text($order, $elsettings);
		$response = $sms_helper->call();
		
		return $response;
	}
	
	public static function track_user_coupon($order, $elsettings)
	{
		$db = JFactory::getDBO();
		
		// increase coupon hits by one
		$sql	 = $db->getQuery(true)
			->update($db->qn('#__taxibooking_coupons'))
			->set('`hits` = `hits` + 1')
			->where('id = '.$db->Quote($order->coupon_used));

		$db->setQuery($sql);
		$db->execute();
		
		// keep user coupon record
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons_user_record');
		$query->where('coupon_id = '.$db->Quote($order->coupon_used));
		$query->where('user_email = '.$db->Quote($order->email));
		$db->setQuery((string)$query);
		$result = $db->loadObject();
		
		if($result){ // this email has record already
			$sql	 = $db->getQuery(true)
				->update($db->qn('#__taxibooking_coupons_user_record'))
				->set('`hits` = `hits` + 1')
				->where('coupon_id = '.$db->Quote($order->coupon_used))
				->where('user_email = '.$db->Quote($order->email));
	
			$db->setQuery($sql);
			$db->execute();
		}
		else {  // this email has no record, so insert one
			$coupon = new stdClass();
			$coupon->coupon_id = $order->coupon_used;
			$coupon->user_email = $order->email;
			$coupon->hits = 1;
	       
			if (!$db->insertObject('#__taxibooking_coupons_user_record', $coupon)) {
			    exit($db->stderr());
			}
		}
		
		return true;
	}
	
	public static function set_tbtimezone(){
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		date_default_timezone_set($siteOffset);
		
		return $siteOffset;
	}
	
	public static function get_order_status_text($order){
		if(!is_object($order)){
			$order = booking_helper::get_order_by_id($order);
		}
		if ($order->state == 1) {
			$text = JText::_('NEW_ORDER_STATUS_ACCEPTED');
		}
		elseif ($order->state == 0) {
			$text = JText::_('NEW_ORDER_STATUS_REJECTED');
		}
		elseif ($order->state == -1) {
			$text = JText::_('NEW_ORDER_STATUS_ARCHIVED');
		}
		elseif ($order->state == -2) {
			$text = JText::_('NEW_ORDER_STATUS_WAITING');
		}
		
		return $text;
	}
	public static function calculate_charge_per_min($duration = 0, $car, $elsettings, $applied_tariff = null)
	{
		$charge = $unit_charge = 0;
		if($elsettings->enable_charge_per_min==1 && $duration > 0)
		{
			if($car->unit_price_override==1) {
				// if use tariff YES and a tariff is found, tariff charge/min will be used
				if($car->use_tariff==1 && $applied_tariff){
					$unit_charge = (float)$applied_tariff->charge_per_min;
				}
				else {
					$unit_charge = (float)$car->charge_per_min;
				}
			}
			else {
				$unit_charge = (float)$elsettings->charge_per_min;
			}
			
			$charge = ceil($duration/60) * $unit_charge; // duration will be in seconds
		}
		return array($charge, $unit_charge);
	}
	public static function getTBVersion()
	{
		$manifest_file = JPATH_COMPONENT_ADMINISTRATOR.DS.'taxibooking.xml';
		$xml = JFactory::getXML($manifest_file);
		$version = (string)$xml->version;
		return $version;
	}
	public static function getBookingMapsState($elsettings)
	{
		$booking_maps = array('address' => (int)$elsettings->show_map_address,
                              'offers' => (int)$elsettings->show_map_offers,
                              'hourly' => 0,
                              'shuttle' => (int)$elsettings->show_map_shuttles
                              );
		
		return $booking_maps;
	}
	
	public static function getCurrentTariffs($datetime = 'now')
	{
		$db = JFactory::getDBO();
		$tariffs = array();
		
		$pickup_datetime = date("Y-m-d H:i:s", $datetime);
		$order_date = date("Y-m-d", $datetime);
		$order_time = date("Hi", $datetime);
		$order_date_week_day = date("N", $datetime); //1 (for Monday) through 7 (for Sunday)
		//echo $order_date.'-'.$order_time.'-'.$order_date_week_day;
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_tariffs');
		$query->where('published = 1');
		$query->order('`special_date_enabled` DESC');
		$db->setQuery((string)$query);
		$db->query();
		if($db->getNumRows()>0)
		{
			$rows = $db->loadObjectList();
			
			foreach($rows as $row)
			{
				if($row->special_date_enabled==1){ // if special tariffs, only available for selected dates
					$special_dates_arr = unserialize($row->special_dates);
					if(in_array($order_date, $special_dates_arr)){
						$tariffs[] = $row;
					}
				}
				else {
					$days_availability_arr = unserialize($row->days_availability);
					
					$tariff_data = array('opening'=>'',
							'closing'=>'',
							'is_available' => 0
							);
					
					$todays_availabilty = !empty($days_availability_arr[$order_date_week_day-1]) ? $days_availability_arr[$order_date_week_day-1] : array();
					
					if(empty($days_availability_arr))  // if availability is not set yet, car is not available
					{
						$tariff_data['is_available']=0;
					}
					elseif(empty($todays_availabilty) || empty($todays_availabilty['is_available']) || $todays_availabilty['is_available']==0 ) // if today's availability is not set, car is not available today
					{
						$tariff_data['is_available']=0;
					}
					elseif($todays_availabilty['opening_hrs']==-1&&$todays_availabilty['opening_mins']==-1&&$todays_availabilty['closing_hrs']==-1&&$todays_availabilty['closing_mins']==-1 ) // if today's availability is not set, car is not available today
					{
						$tariff_data['is_available']=1;
					}
					else
					{
						$opening_hrs = str_pad($todays_availabilty['opening_hrs'], 2,'0', STR_PAD_LEFT);
						$opening_mins = str_pad($todays_availabilty['opening_mins'], 2,'0', STR_PAD_LEFT);
						$closing_hrs = str_pad($todays_availabilty['closing_hrs'], 2,'0', STR_PAD_LEFT);
						$closing_mins = str_pad($todays_availabilty['closing_mins'], 2,'0', STR_PAD_LEFT);
						
						$tariff_data['opening']=$opening_hrs.$opening_mins;
						$tariff_data['closing']=$closing_hrs.$closing_mins;
						
						$time_ranges = array();
						
						// if opening and closing is on same day like opening 06:00 and closing 20:00
						if($tariff_data['opening'] < $tariff_data['closing'])
						{ 
							$time_ranges[]=array($tariff_data['opening'],$tariff_data['closing']);
						}
						else {
							if($tariff_data['opening']>=1200){
								if($tariff_data['closing']<1200){
									$time_ranges[]=array($tariff_data['opening'],'2400');
									$time_ranges[]=array('0000',$tariff_data['closing']);
								}		
							}
						}
						
						foreach($time_ranges as $time_range)
						{
							if($time_range[0]<=$order_time AND $time_range[1]>=$order_time){
								$tariff_data['is_available'] = 1;
								break;
							}
						}
					}
					
					if($tariff_data['is_available']==1){
						$tariffs[] = $row;
					}
				}
			}
		}
		
		return $tariffs;
	}
    
	public static function createCalendarEvent($order, $car, $order_car_rel_id, $booking_start, $booking_end)
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$config   = JFactory::getConfig();
		$offset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $offset);
		
		// stop if p12 file is not uploaded
		if($elsettings->google_app_email_address==""
		   ||$elsettings->google_client_id==""
		   ||$elsettings->google_p12_key_filename=="")
		{
			// do nothing
		}
		else {
			if ($app->isAdmin()){
				include_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_calendar.php');
			}
			else{
				include_once (JPATH_COMPONENT.DS.'classes'.DS.'google_calendar.php');
			}
			
			$startdate = date('Y-m-d', $booking_start);
			$starttime = date('H:i:s', $booking_start);
			$enddate = date('Y-m-d', $booking_end);
			$endtime = date('H:i:s', $booking_end);
			
			$TimeZonebyCity = new DateTimeZone($offset);
			$localTimebyCity = new DateTime($startdate, $TimeZonebyCity);
			$timeOffset = $TimeZonebyCity->getOffset($localTimebyCity);
			$offset = $timeOffset/3600;
			$offset = local_tz_offset_to_string($offset);
			
			$gcal = new GoogleCalendar;
			// login
			$result = $gcal->login($elsettings);
			if( $result != "ok"){
				tberror_log("Authentication,".$result); 
				return false;
			}		
			$gcal->setTZOffset($offset);
			
			// set calendar
			if($car->google_calendar_id != "")
			{
				try{
					$gcal->setCalID($car->google_calendar_id);
				}catch (Exception $e) { 
					tberror_log("SetCalendar,".$e->getMessage()); 
					return false;
				}			
			}
			
			// In future, this should recirect user to Iframe booking form in My Orders tab instead of Order list view
			//$order_url = JURI::root().TaxibookingHelperRoute::getBookingFormRoute().'&booking_type=orders&oid='.$order->order_number;
			
			$order_url = JURI::root().'index.php?option=com_taxibooking&view=order&cid='.$order->id.'&Itemid='.TaxibookingHelperRoute::getOrdersItemid();
			
			$title_text = JText::_('TAXI_FROM').': '.$order->begin;
			
			$body_text = JText::_('PASSENGERS').': '.$order->selpassengers;
			
			if($order->selluggage > 0){
				$body_text .= '<br>'.JText::_('CHECK_IN_LAGUAGE').': '.$order->selluggage;
			}
			if($order->selinfantseats > 0){
				$body_text .= '<br>'.JText::_('INFANT_SEATS').': '.$order->selinfantseats;
			}
			if($order->selchildseats > 0){
				$body_text .= '<br>'.JText::_('CHILD_SEATS').': '.$order->selchildseats;
			}
			if($order->selboosterseats > 0){
				$body_text .= '<br>'.JText::_('BOOSTER_SEATS').': '.$order->selboosterseats;
			}
			
			$body_text .= '<br>'.JText::_('VEHICLE_TYPE').': '.booking_helper::get_order_car($order);
			$body_text .= '<br>'.JText::_('PAYMENT_METHOD').': '.booking_helper::get_order_payment($order);
			$body_text .= '<br><a href="'.JRoute::_($order_url, false).'" target="blank">'.JText::_('DETAILS').'</a>';
			
			stripslashes($body_text);
			stripslashes($title_text);
			$body_text = str_replace("'", "`", $body_text);
			$title_text = str_replace("'", "`", $title_text);
			
			//create event
			try{
				$event_id_full = $gcal->createEvent( 
				$title_text,
				$body_text, 
				'',
				trim($startdate),
				trim($starttime),
				trim($enddate),
				trim($endtime));
			}catch (Exception $e) { 
				tberror_log("createEvent,".$e->getMessage());
				return false;					
			}
			
			$event_id = substr($event_id_full, strrpos($event_id_full, "/")+1);
			
			$temp = new stdClass();
			$temp->id = $order_car_rel_id;
			$temp->google_event_id = $event_id;
			$temp->google_calendar_id = $car->google_calendar_id;
			$db->updateObject('#__taxibooking_order_car_rel', $temp, 'id');
			
			return $event_id;
		}
		return false;
	}
	public static function getURLDynamicParams()
	{
		$dynamic_params = array();
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_searchurls');
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		if(!empty($rows))
		{
			foreach($rows as $row)
			{
				$temp = unserialize($row->dynamic_params);
				if(!empty($temp))
				{
					foreach($temp as $arr)
					{
						$key = $arr[0];
						$dynamic_params[$key] = $arr[1];
					}
				}
			}
		}
		
		return $dynamic_params;
	}
	public static function userIsInAdminGroups($uid = 0)
	{
		$in_admin_group = false;
		$usergroups = JAccess::getGroupsByUser($uid);
		$admin_groups_ids = array(7,8); // 7- it default id of Adminis group, 8 - dafault id of Super Admins group
		foreach ($admin_groups_ids as $agid)
		{
			if (in_array($agid,$usergroups)) $in_admin_group = true;
		}	  
		return $in_admin_group;	
	}
	public static function getTBUserInfo($uid = 0)
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_users');
		$query->where('user_id = '.(int)$uid);
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row)
		{
			return $row;
		}
		
		return false;
	}
	public static function getDrivers()
	{
		$db = JFactory::getDBO();
		
		// if user is added as Driver in Taxi Booking user manager,
		// he/she may not be assigned in Driver Joomla user group
		// but will still be in Driver list at Orders
		$query = 'SELECT DISTINCT u.user_id, u.name,u.email
			FROM #__taxibooking_users AS u 
			LEFT JOIN #__user_usergroup_map AS um ON um.user_id = u.user_id 
			LEFT JOIN #__usergroups AS ug ON um.group_id = ug.id
			WHERE ( ug.title = "Driver") OR (u.is_driver = 1)
			ORDER BY u.name';
		//echo nl2br(str_replace('#__','nfgwj_',$query));
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		return $rows;
	}
	public static function getDriverInfo($uid = 0)
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_users');
		$query->where('user_id = '.(int)$uid);
		$query->where('is_driver = 1');
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row)
		{
			return $row;
		}
		
		return false;
	}
	public static function getOrderPaymentData($order = 0)
	{
		$db = JFactory::getDBO();
		
		if(!is_object($order)){
			$order = booking_helper::get_order_by_id($order);
		}
		
		$paymentObj = booking_helper::get_payment_details($order->payment);
		if($paymentObj){
			
			$payment_tablename = '#__taxibooking_payment_plg_' . $paymentObj->payment_element;
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from($payment_tablename);
			$query->where('order_id = '.(int)$order->id);
			$db->setQuery((string)$query);
			$row = $db->loadObject();
			
			if($row){
				return $row;
			}
		}
		
		return false;
	}
	
	public static function sendOrderArchiveEmail($row_queue, $elsettings)
	{
		$app = JFactory::getApplication();
	
		//Get mailinformation
		$SiteName = $app->getCfg('sitename');
		$MailFrom = $app->getCfg('mailfrom');
		$FromName = $app->getCfg('fromname');
		$tzoffset = $app->getCfg('offset');
		$FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $FromName);
		
		require_once JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'security.php';
		$security = new TaxibookingSecurity();
            
		$emailSubject = JText::sprintf(
			'TBSCHEDULES_ARCHIVE_ORDER_EMAIL_SUBJECT',
			$SiteName
		);
		
		// convert distance to mile if it is in KM
		if($elsettings->distance_unit=="kM"){
		    $distance_miles = (float)$row_queue->distance * 0.621371;
		}
		else {
		    $distance_miles = (float)$row_queue->distance;
		}
		
		$duration_seconds = (int)$row_queue->duration;
		$tb_order_id = (int)$row_queue->id;
		
		$string = rtrim(JURI::root(), '/')."||".$row_queue->names."||".$row_queue->email."||".$distance_miles."||".$duration_seconds."||".$tb_order_id."||".$row_queue->language;
		
		$publicKey = $security->genRandString(32);
		$encryptedData = $security->encrypt($string, $publicKey);
		$encodedData = rawurlencode($encryptedData);
		
		$review_url = 'https://kabsky.co.uk/reviews';
		//$review_url = 'http://qucksite.com/share/index.php?option=com_appregulator&view=review&layout=form&';
		//$review_url .= "public={$publicKey}&data={$encodedData}";
		
		ob_start();
		if ($app->isAdmin()){
			include( JPATH_COMPONENT_SITE.DS .'templates'.DS.'order_emails'.DS.'archive_email.tpl.php' );
		}
		else{
			include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'archive_email.tpl.php' );
		}
		$emailBody = ob_get_contents();
		ob_end_clean();
		
		$mail = JFactory::getMailer();
		$mail->setSender(array($MailFrom, $FromName));
		$mail->setSubject($emailSubject);
		$mail->setBody($emailBody);
		$mail->IsHTML(true);
		$mail->addRecipient($row_queue->email);
		$sent = $mail->Send();
		
		return;
	}
	
	public static function getParentClient($user_email='')
	{
		$parentClient = false;
		
		$db = JFactory::getDBO();
		
		if($user_email != ""){
			$query = $db->getQuery(true);
			$query->select('uc.parent_user_id');
			$query->from('#__taxibooking_user_childs AS uc');
			$query->select('u.*')
				->join('LEFT', $db->quoteName('#__taxibooking_users') . ' AS u ON u.user_id = uc.child_user_id');
			$query->where('u.email = '.$db->quote($user_email));
			$db->setQuery((string)$query);
			$parentClient = $db->loadObject();
			
			if($parentClient){
				$parentClient = booking_helper::getTBUserInfo($parentClient->parent_user_id);
			}
		}
		
		return $parentClient;
	}
	
	public static function createOrderCopyUser($order_copy_users = array(), $elsettings)
	{
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$config = JFactory::getConfig();
		$date = JFactory::getDate();
		$user_params	= JComponentHelper::getParams('com_users');
		
		$jUserIds = array();
		if(!empty($order_copy_users))
		{
			// get all admin users
			$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE sendEmail=1';
			$db->setQuery( $query );
			$admins = $db->loadObjectList();
			
			foreach($order_copy_users as $key => $order_copy_user)
			{
				// first check in Joomla user database
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__users');
				$query->where('email = '.$db->Quote($order_copy_user['email']));
				$db->setQuery((string)$query);
				$jUserObj = $db->loadObject();
				
				if($jUserObj){
					//$jUserId = $jUserObj->id;
				}
				else {
					// Initialise the table with JUser.
					$user = new JUser;
					
					// Prepare the data for the user object.
					$data = array();
					$data['name']	        = $order_copy_user['name'];
					$data['username']	= $order_copy_user['email'];
					$data['email']		= $order_copy_user['email'];
					$data['password']	= JUserHelper::genRandomPassword();
					$data['activation'] = '';
					$data['block'] = 0;
					
					// Get the groups the user should be added to after registration.
					$data['groups'] = array();
				
					// Get the default new user group, Registered if not specified.
					$data['groups'][] = $user_params->get('new_usertype', 2);
					
					// Bind the data.
					if (!$user->bind($data)) {
					    continue;
					}
					
					// Store the data.
					if (!$user->save()) {
					    continue;
					}
					
					// Compile the notification mail values.
					$data['fromname']	= $config->get('fromname');
					$data['mailfrom']	= $config->get('mailfrom');
					$data['sitename']	= $config->get('sitename');
					$data['siteurl']	= JUri::root();
					$data['password_clear']	= $user->password_clear;
				
					$emailSubject	= JText::sprintf(
						'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
						$data['name'],
						$data['sitename']
					);
				
					$emailBody = JText::sprintf(
						'COM_TAXIBOOKING_EMAIL_REGISTERED_BODY',
						$data['name'],
						$data['sitename'],
						$data['siteurl'],
						$data['username'],
						$data['password_clear']
					);
					
					// Send the registration email.
					$return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody);
				
					//Send Notification mail to administrators
					$emailSubject = JText::sprintf(
						'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
						$data['name'],
						$data['sitename']
					);
				
					$emailBodyAdmin = JText::sprintf(
						'COM_TAXIBOOKING_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY',
						$data['name'],
						$data['username'],
						$data['siteurl']
					);
					
					// Send mail to all superadministrators id
					foreach( $admins as $admin )
					{
					    $return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $admin->email, $emailSubject, $emailBodyAdmin);
					}
					$jUserObj = $user;
				}
				
				$jUserIds[] = $jUserObj->id;
				
				// create TB user profile
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_users');
				$query->where('email = '.$db->Quote($order_copy_user['email']));
				$db->setQuery((string)$query);
				$tbUser = $db->loadObject();
				
				if($tbUser){
					$tbUserId = $tbUser->id;
				}
				else {
					if($jUserObj){
						$temp = new stdClass();
						$temp->user_id = $jUserObj->id;
						$temp->name = $order_copy_user['name'];
						$temp->email = $order_copy_user['email'];
						$temp->created = $date->toSql();
						$temp->published = 1;
						
						$db->insertObject('#__taxibooking_users', $temp);
						$tbUserId = $db->insertid();
					}
				}
			}
		}
		
		return $jUserIds;
	}
	
	public static function getUserOrders()
	{
		$db =  JFactory::getDBO();
		$user =  JFactory::getUser();
		$user_email = $user->get('email');
		$userId = $user->get('id');
		
		$user_order_ids = array();
		
		$copy_orders_sql = '';
		$query = $db->getQuery(true);
		$query->select('DISTINCT order_id');
		$query->from('#__taxibooking_order_copyusers');
		$query->where('user_id = '.(int)$user->get('id'));
		$db->setQuery((string)$query);
		$copy_order_ids = $db->loadColumn();
		if(!empty($copy_order_ids)){
		    $copy_orders_sql = ' OR a.id IN ('.implode(',',$copy_order_ids).')';
		}
		
		$query = $db->getQuery(true);
		$query->select('a.*');
		$query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
		$query->where('(a.email = ' . $db->Quote($user_email). $copy_orders_sql.')');
		$db->setQuery((string)$query);
		$user_order_ids = $db->loadColumn(0);
		return $user_order_ids;
	}
}