<?php

defined ('_JEXEC') or die('Restricted access');

if(!class_exists('tbPaymentPlugin')) {
	require(JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'tbpayment_plugin_helper.php');
}

class plgTbPaymentRealex extends tbPaymentPlugin {

	var $_name = 'realex';

	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);

		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
	}

	/**
	 * Create the table for this plugin if it does not yet exist.
	 */
	public function getTbPluginCreateTableSQL () {

		return $this->createTableSQL ('Payment Realex Table');
	}

	/**
	 * Fields to create the payment table
	 *
	 * @return string SQL Fileds
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                          => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'order_id'         		=> 'int(1) UNSIGNED',
			'order_number'                => 'char(64)',
			'paymentmethod_id' 		=> 'mediumint(1) UNSIGNED',
			'payment_name'                => 'varchar(5000)',
			'payment_order_total'         => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'            => 'char(3)',
			'cost_per_transaction'        => 'decimal(10,2)',
			'cost_percent_total'          => 'decimal(10,2)'
		);

		return $SQLfields;
	}

	/**
	 * plgTbDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 */
	public function plgTbDisplayListFEPayment ($selected = 0, &$htmlIn) {
		return $this->displayListFE ($selected, $htmlIn);
	}

	/**
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts ($method, $cart_price) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_price * $cost_percent_total * 0.01));
	}
	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 */
	protected function checkConditions ($method, $cart_price) {

		$this->convert ($method);

		$amount = $cart_price;

		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));

		if (!$amount_cond) {
			return FALSE;
		}

		return TRUE;
	}

	function convert ($method) {

		$method->min_amount = (float)$method->min_amount;
		$method->max_amount = (float)$method->max_amount;
	}

	/**
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgTbonSelectedCalculatePricePayment($method_id, $cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice($method_id, $cart_prices, $cart_prices_name);
	}

	/**
	 * This event triggers after order submit
	 */
	public function plgTbOrderSubmit ($order) {

		if (!($method = $this->getPluginMethod ($order->payment))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}

		// Get the page/component configuration
		$elsettings = booking_helper::config();

		$dbValues['payment_name'] = $this->renderPluginName ($method);
		$dbValues['order_id'] = $order->id;
		$dbValues['order_number'] = $order->order_number;
		$dbValues['paymentmethod_id'] = $order->payment;
		$dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		$dbValues['cost_percent_total'] = $method->cost_percent_total;
		$dbValues['payment_currency'] = $elsettings->currency;
		$dbValues['payment_order_total'] = $order->cprice;

		$this->storePluginInternalData ($dbValues);

		return TRUE;
	}


	public function getpaymentparams($id) {
		$GLOBALS['db'] = JFactory::getDbo();
		$db = $GLOBALS['db'];
    $db->setQuery("SELECT `payment_params` FROM `#__taxibooking_paymentmethods` WHERE `id` = \"".$id."\"" );
    $db->execute();
    return($db->loadResult());
	}

	/**
	 * This event triggers after order submit, redrects user to payment gateway
	 */

	public function plgTbProcessPayment($order){

		if (!($method = $this->getPluginMethod ($order->payment))) {
			return NULL; // Another method was selected, do nothing
		}

		$session =  JFactory::getSession();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		//test some vars
		$amoun = $order->cprice * 100;
		$ordid = $order->id;
		$curre = 'GBP';
		$langg = 'en';
		$dcc = 0;
		$merchresponse = 'our url for getting the info from realex';
		$timesta = date('YmdHis');
		//echo $sha1hash = '';

		$payid = $order->payment;
		//$paras = getpaymentparams($payid);
		$db = JFactory::getDbo();
    $db->setQuery("SELECT `payment_params` FROM `#__taxibooking_paymentmethods` WHERE `id` = \"".$payid."\"" );
    $db->execute();
    $paras = $db->loadResult();

		echo "<pre>";
		//print_r($paras);
		$paras = explode('|', $paras);
		//print_r($paras);
		$paras2 = array();
		foreach ($paras as $key => $value) {
			$key2 = strtok($value, '=');

			$valtemp = str_replace($key2, '', $value);
			$valtemp2 = str_replace('=', '', $valtemp);
			$value2 = str_replace('"', '', $valtemp2);

			$paras2[$key2] = $value2;
		}
		//print_r($paras2); //this is the params of the realex plugin.
		//die();

		$merchid = $paras2['realex_merchid'];
		$ssecret = $paras2['realex_shared_secret'];
		$liveornot = $paras2['sandbxo_live'];
		//die('here');
		$rurl = '';
		if($liveornot == 1):
			$rurl = 'https://hpp.realexpayments.com/pay';
		else:
			$rurl = 'https://hpp.sandbox.realexpayments.com/pay';
		endif;
		$rurl;
		function getSha1Hash ($secret, $args = null) {
			$args = func_get_args();
			array_shift($args);
			$hash = sha1(implode('.', $args));
			//$hash =$hash.$secret;
			$hash = sha1($hash . '.' . $secret);
			return $hash;
		}
		$hashed = getSha1Hash($ssecret, $timesta, $merchid, $ordid, $amoun, $curre);

		$returnUrl = JROUTE::_ (JURI::root () . 'index.php?option=com_taxibooking&controller=pluginresponse&task=pluginresponsereceived&on=' . $order->order_number . '&tmpl=component&pm=' . $order->payment . '&Itemid=' . JRequest::getInt ('Itemid'));

		// Keep this line, needed when testing
		$returnTest = JROUTE::_(JURI::root() . 'index.php?option=com_taxibooking&view=pluginresponse&task=pluginnotification&tmpl=component');

		$notifURL = JROUTE::_ (JURI::root () . 'index.php?option=com_taxibooking&controller=pluginresponse&task=pluginnotification&tmpl=component');

		$cancelUrl = JROUTE::_ (JURI::root () . 'index.php?option=com_taxibooking&controller=pluginresponse&task=pluginuserpaymentcancel&on=' . $order->order_number . '&pm=' . $order->payment . '&Itemid=' . JRequest::getInt ('Itemid'));

		echo "</pre>";
 		?>
		<div style="text-align:center; clear:both; padding-top:100px; width:100%;">
			<p style="font-family: Sans-serif;">Transferring to Realex Payments...</p>
		</div>
		<form name="frmPaymentRedirect" class="class" action="<?php echo $rurl; ?>" method="post">
			<input type="hidden" name="MERCHANT_ID" value="<?php echo $merchid; ?>">
			<input type="hidden" name="ORDER_ID" value="<?php echo $ordid; ?>">
			<input type="hidden" name="AMOUNT" value="<?php echo $amoun; ?>">
			<input type="hidden" name="CURRENCY" value="<?php echo $curre; ?>">
			<input type="hidden" name="LANG" value="<?php echo $langg; ?>">
			<input type="hidden" name="TIMESTAMP" value="<?php echo $timesta; ?>">
			<input type="hidden" name="DCC_ENABLE" value="<?php echo $dcc; ?>">
			<input type="hidden" name="COMMENT1" value="Payment for taxi fare from: <?php echo $order->begin; ?> to: <?php echo $order->end; ?>">
			<input type="hidden" name="MERCHANT_RESPONSE_URL" value="<?php echo $returnUrl; ?>">
			<input type="hidden" name="SHA1HASH" value="<?php echo $hashed; ?>">
			<input type="hidden" name="AUTO_SETTLE_FLAG" value="1">
			<button type="submit" name="button"></button>

		</form>

		<script type="text/javascript" language="javascript">
			window.setTimeout(document.frmPaymentRedirect.submit(), 5);
		</script>
		<?php
		// ini_set('display_errors', 1);
		// ini_set('display_startup_errors', 1);
		// error_reporting(E_ALL);

		die();




		$redirect_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
		//if($session->get('tmpl','')=='component'){
		    $redirect_url .= '&tmpl=component';
		//}


		$html = JText::_('RECEIVE_CONFIRMATION_MAIL');
		JRequest::setVar ('html', $html);

		return TRUE;
	}

	function plgTbOnPaymentResponseReceived (&$html) {

		// ini_set('display_errors', 1);
		// ini_set('display_startup_errors', 1);
		// error_reporting(E_ALL);
        
		$paymentmethod_id = JRequest::getInt ('pm', 0);
		$order_number = JRequest::getString ('on', 0);
		$goodurl = JROUTE::_ (JURI::root () . 'index.php?option=com_taxibooking&controller=pluginresponse&task=pluginresponsereceived&on=' . $order_number . '&pm=' . $paymentmethod_id . '&Itemid=' . JRequest::getInt ('Itemid'));

		/*if(isset($_GET['guid'])):
			echo '<meta http-equiv="refresh" content="0; url=' . $goodurl . '">';
		endif;*/

		if (!($method = $this->getPluginMethod ($paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return NULL;
		}
		if (!($order = booking_helper::get_order_by_order_number($order_number))) {
			return NULL;
		}
		if (!($paymentTable = $this->getDataByOrderId ($order->id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}
		$payment_name = $this->renderPluginName ($method);

		// update order status
		// $temp = new stdClass();
		// $temp->id = $order->id;
		// $temp->state = 1;
		// $this->_db->updateObject('#__taxibooking_orders', $temp, 'id');

		$order_data['order_status'] = 1;
		booking_helper::update_order_status($order->id, $order_data, true);
		// $mail = JFactory::getMailer();
		//
		// $states = array(1 => JText::_('ACCEPTED'),
		// 		0 => JText::_('REJECTED'),
		// 		-1 => JText::_('ARCHIVED'),
		// 		-2 => JText::_('WAITING'));
		//
		// $order_id = $row_queue->id;
        
        file_put_contents("log_get.log",print_r($_GET,true));
        file_put_contents("log_post.log",print_r($_POST,true));
		return TRUE;
	}


	/**
	 * Display stored payment data in confirmation emails and invoice
	 */
	function plgTbOnShowOrderEmailsInvoice ($order_id, $payment_id) {

		if (!$this->selectedThisByMethodId ($payment_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($payment = $this->getDataByOrderId ($order_id))) {
			return NULL;
		}

		$html = '';

		$html .= '<tr>
<td width="35%">' . JText::_ ('TBPAYMENT_CASH_PAYMENT_NAME') . ':</td>
<td width="35%">'.$payment->payment_name.'</td>
</tr>';

		return $html;
	}
}
