<?php
defined('_JEXEC') or die('Restricted access');
?><?php

class UsersController extends acymController
{
    public function __construct()
    {
        parent::__construct();
        $this->breadcrumb[acym_translation('ACYM_USERS')] = acym_completeLink('users');
        $this->currentClass = acym_get('class.user');
        $this->loadScripts = [
            'edit' => ['datepicker'],
            'all' => ['vue-applications' => ['entity_select']],
        ];
    }

    public function listing()
    {
        acym_setVar('layout', 'listing');

        $data = [];
        $data['search'] = acym_getVar('string', 'users_search', '');
        $data['ordering'] = acym_getVar('string', 'users_ordering', 'id');
        $data['orderingSortOrder'] = acym_getVar('string', 'users_ordering_sort_order', 'desc');
        $data['status'] = acym_getVar('string', 'users_status', '');
        $data['pagination'] = acym_get('helper.pagination');

        $this->prepareUsersListing($data);
        $this->prepareUsersSubscriptions($data);
        $this->prepareUsersFields($data);

        parent::display($data);
    }

    protected function prepareUsersListing(&$data)
    {
        $usersPerPage = $data['pagination']->getListLimit();
        $page = acym_getVar('int', 'users_pagination_page', 1);

        $matchingUsers = $this->getMatchingElementsFromData(
            [
                'search' => $data['search'],
                'elementsPerPage' => $usersPerPage,
                'offset' => ($page - 1) * $usersPerPage,
                'status' => $data['status'],
                'ordering' => $data['ordering'],
                'ordering_sort_order' => $data['orderingSortOrder'],
            ],
            $data['status'],
            $page
        );

        $data['pagination']->setStatus($matchingUsers['total'], $page, $usersPerPage);

        $data['allUsers'] = $matchingUsers['elements'];
        $data['userNumberPerStatus'] = $matchingUsers['status'];
    }

    protected function prepareUsersSubscriptions(&$data)
    {
        $usersId = [];
        foreach ($data['allUsers'] as $oneUser) {
            $usersId[] = $oneUser->id;
        }

        $subscriptions = [];

        if (!empty($usersId)) {
            $subscriptionsArray = $this->currentClass->getUsersSubscriptionsByIds($usersId);

            foreach ($subscriptionsArray as $oneSubscription) {
                $subscriptions[$oneSubscription->user_id][$oneSubscription->id] = $oneSubscription;
            }
        }

        $data['usersSubscriptions'] = $subscriptions;
    }

    protected function prepareUsersFields(&$data)
    {
        $data['fields'] = [];

        if (empty($data['allUsers'])) return;

        $fieldClass = acym_get('class.field');
        $fieldsToDisplay = $fieldClass->getAllFieldsBackendListing();
        if (empty($fieldsToDisplay['ids'])) return;

        $userIds = [];
        foreach ($data['allUsers'] as $user) {
            $userIds[] = $user->id;
        }

        $fieldValue = $fieldClass->getAllFieldsListingByUserIds($userIds, $fieldsToDisplay['ids'], 'field.backend_listing = 1');
        foreach ($data['allUsers'] as &$user) {
            $user->fields = [];
            foreach ($fieldsToDisplay['ids'] as $fieldId) {
                $user->fields[$fieldId] = !isset($fieldValue[$fieldId.'-'.$user->id]) ? '' : $fieldValue[$fieldId.'-'.$user->id];
            }
        }

        $data['fields'] = $fieldsToDisplay['names'];
    }

    public function edit()
    {
        acym_setVar('layout', 'edit');

        $data = [];
        $data['tab'] = acym_get('helper.tab');

        $userId = acym_getVar('int', 'id', 0);

        if (!$this->prepareUserEdit($data, $userId)) return;
        $this->prepareEntitySelectEdit($data, $userId);
        $this->prepareUserFieldsEdit($data, $userId);
        $this->prepareSubscriptionsEdit($data, $userId);
        $this->prepareStatsEdit($data, $userId);
        $this->prepareHistoryEdit($data, $userId);
        $this->prepareFieldsEdit($data);

        parent::display($data);
    }

    private function prepareUserEdit(&$data, $userId)
    {
        if (empty($userId)) {
            $data['user-information'] = new stdClass();
            $data['user-information']->name = '';
            $data['user-information']->email = '';
            $data['user-information']->active = '1';
            $data['user-information']->confirmed = '1';
            $data['user-information']->cms_id = null;

            $this->breadcrumb[acym_escape(acym_translation('ACYM_NEW_USER'))] = acym_completeLink('users&task=edit');
        } else {
            $data['user-information'] = $this->currentClass->getOneById($userId);

            if (empty($data['user-information'])) {
                acym_enqueueMessage(acym_translation('ACYM_USER_NOT_FOUND'), 'error');
                $this->listing();

                return false;
            }

            $this->breadcrumb[acym_escape($data['user-information']->email)] = acym_completeLink('users&task=edit&id='.$userId);
        }

        return true;
    }

    private function prepareEntitySelectEdit(&$data, $userId)
    {
        if (empty($userId)) return;

        $entityHelper = acym_get('helper.entitySelect');

        $columnsToDisplay = [0 => 'name', 1 => 'id'];
        $columnsToDisplay['join'] = 'userlist.list_id';

        $data['entityselect'] = acym_modal(
            acym_translation('ACYM_ADD_SUBSCRIPTION'),
            $entityHelper->entitySelect(
                'list',
                ['join' => 'join_user-'.$userId],
                $columnsToDisplay,
                ['text' => acym_translation('ACYM_CONFIRM'), 'action' => 'apply'],
                false
            ),
            null,
            '',
            'class="cell medium-6 large-shrink button button-secondary"'
        );
    }

    private function prepareUserFieldsEdit(&$data, $userId)
    {
        $data['fieldsValues'] = [];

        if (empty($userId)) return;

        $fieldClass = acym_get('class.field');
        $fieldsValues = $fieldClass->getFieldsValueByUserId($userId);
        foreach ($fieldsValues as $one) {
            $data['fieldsValues'][$one->field_id] = $one->value;
        }
    }

    private function prepareSubscriptionsEdit(&$data, $userId)
    {
        $data['subscriptionsIds'] = [];
        $data['subscriptions'] = [];
        $data['unsubscribe'] = [];

        if (empty($userId)) return;

        $data['allSubscriptions'] = $this->currentClass->getUserSubscriptionById($userId);

        $data['subscriptions'] = [];
        $data['unsubscribe'] = [];

        foreach ($data['allSubscriptions'] as $sub) {
            if ($sub->status == 1) {
                $data['subscriptions'][] = $sub;
            } else {
                $data['unsubscribe'][] = $sub;
            }
        }

        $data['subscriptionsIds'] = [];

        if (!empty($data['subscriptions'])) {
            $data['subscriptionsIds'] = [];
            foreach ($data['subscriptions'] as $list) {
                $data['subscriptionsIds'][] = $list->id;
            }

            acym_arrayToInteger($data['subscriptionsIds']);
        }
    }

    private function prepareStatsEdit(&$data, $userId)
    {
        $data['pourcentageOpen'] = 0;
        $data['pourcentageClick'] = 0;

        if (empty($userId)) return;

        $userStatClass = acym_get('class.userstat');
        $userStatFromDB = $userStatClass->getAllUserStatByUserId($userId);

        if (empty($userStatFromDB)) return;

        $userStat = new stdClass();
        $userStat->totalSent = 0;
        $userStat->open = 0;

        foreach ($userStatFromDB as $oneStat) {
            if ($oneStat->sent > 0) $userStat->totalSent++;
            if ($oneStat->open > 0) $userStat->open++;
        }

        $userStat->pourcentageOpen = empty($userStat->open) ? 0 : intval(($userStat->open * 100) / $userStat->totalSent);

        $data['pourcentageOpen'] = $userStat->pourcentageOpen;
        $data['pourcentageClick'] = $userStat->pourcentageOpen;
    }

    private function prepareHistoryEdit(&$data, $userId)
    {
        if (empty($userId)) return;

        $historyClass = acym_get('class.history');
        $data['userHistory'] = $historyClass->getHistoryOfOneById($userId);
        foreach ($data['userHistory'] as &$oneHistory) {
            if (!empty($oneHistory->data)) {
                $historyData = explode("\n", $oneHistory->data);
                $details = '<div><h5>'.acym_translation('ACYM_DETAILS').'</h5><br />';
                if (!empty($oneHistory->mail_id)) {
                    $details .= '<b>'.acym_translation('NEWSLETTER').' : </b>';
                    $details .= acym_escape($oneHistory->subject).' ( '.acym_translation('ACYM_ID').' : '.$oneHistory->mail_id.' )<br />';
                }

                foreach ($historyData as $value) {
                    if (!strpos($value, '::')) {
                        $details .= $value.'<br />';
                        continue;
                    }
                    list($part1, $part2) = explode('::', $value);
                    if (preg_match('#^[A-Z_]*$#', $part2)) $part2 = acym_translation($part2);
                    $details .= '<b>'.acym_escape(acym_translation($part1)).' : </b>'.acym_escape($part2).'<br />';
                }
                $details .= '</div>';

                $oneHistory->data = acym_modal(
                    acym_translation('ACYM_VIEW_DETAILS'),
                    $details,
                    null,
                    'style="word-break: break-word;"',
                    'class="history_details"',
                    true,
                    false
                );
            }

            if (!empty($oneHistory->source)) {
                $source = explode("\n", $oneHistory->source);
                $details = '<div><h5>'.acym_translation('ACYM_SOURCE').'</h5><br />';
                foreach ($source as $value) {
                    if (!strpos($value, '::')) continue;
                    list($part1, $part2) = explode('::', $value);
                    $details .= '<b>'.acym_escape($part1).' : </b>'.acym_escape($part2).'<br />';
                }
                $details .= '</div>';

                $oneHistory->source = acym_modal(
                    acym_translation('ACYM_VIEW_SOURCE'),
                    $details,
                    null,
                    'style="word-break: break-word;"',
                    'class="history_details"'
                );
            }
        }
    }

    protected function prepareFieldsEdit(&$data, $fieldVisibility = 'backend_edition')
    {
        $data['allFields'] = [];

        $fieldClass = acym_get('class.field');
        $fieldsElements = $fieldClass->getMatchingElements();
        $allFields = $fieldsElements['elements'];

        foreach ($allFields as $one) {
            $one->option = json_decode($one->option);
            $one->value = empty($one->value) ? '' : json_decode($one->value);
            $fieldDB = empty($one->option->fieldDB) ? '' : json_decode($one->option->fieldDB);


            $valuesArray = [];
            if (!empty($one->value)) {
                foreach ($one->value as $value) {
                    $valueTmp = new stdClass();
                    $valueTmp->text = $value->title;
                    $valueTmp->value = $value->value;
                    if ($value->disabled == 'y') $valueTmp->disable = true;
                    $valuesArray[$value->value] = $valueTmp;
                }
            }
            if (!empty($fieldDB) && !empty($fieldDB->value)) {
                $fromDB = $fieldClass->getValueFromDB($fieldDB);
                foreach ($fromDB as $value) {
                    $valuesArray[$value->value] = $value->title;
                }
            }

            $one->display = empty($one->option->display) ? '' : json_decode($one->option->display);
            $data['allFields'][$one->id] = $one;
            if ($one->id == 1) {
                $defaultValue = acym_escape(empty($data['user-information']->id) ? '' : $data['user-information']->name);
            } elseif ($one->id == 2) {
                $defaultValue = acym_escape(empty($data['user-information']->id) ? '' : $data['user-information']->email);
            } elseif (isset($data['fieldsValues'][$one->id]) && ((is_countable($data['fieldsValues'][$one->id]) && count($data['fieldsValues'][$one->id]) > 0) || (is_string($data['fieldsValues'][$one->id]) && strlen($data['fieldsValues'][$one->id]) > 0))) {
                $decoded = json_decode($data['fieldsValues'][$one->id]);
                $defaultValue = is_null($decoded) ? $data['fieldsValues'][$one->id] : $decoded;
            } else {
                $defaultValue = $one->default_value;
            }
            $size = empty($one->option->size) ? '' : 'width:'.$one->option->size.'px';

            $data['allFields'][$one->id]->html = $fieldClass->displayField($one, $defaultValue, $size, $valuesArray, true, !acym_isAdmin(), null, $one->$fieldVisibility);
        }
    }

    public function import()
    {
        acym_setVar('layout', 'import');

        $tab = acym_get('helper.tab');

        $nbUsersAcymailing = $this->currentClass->getCountTotalUsers();
        $nbUsersCMS = acym_loadResult('SELECT count('.$this->cmsUserVars->id.') FROM '.$this->cmsUserVars->table);

        $tables = acym_getTables();
        $arrayTables = [];
        foreach ($tables as $key => $tableName) {
            $arrayTables[$tableName] = $tableName;
        }

        $data = [
            'tab' => $tab,
            'nbUsersAcymailing' => $nbUsersAcymailing,
            'nbUsersCMS' => $nbUsersCMS,
            'tables' => $arrayTables,
        ];

        $this->breadcrumb[acym_translation('ACYM_IMPORT')] = acym_completeLink('users&task=import');


        parent::display($data);
    }

    public function ajaxEncoding()
    {
        acym_setVar('layout', 'ajaxencoding');
        parent::display();
        exit;
    }

    public function doImport()
    {
        acym_checkToken();

        $function = acym_getVar('cmd', 'import_from');
        $importHelper = acym_get('helper.import');

        if (empty($function) || !$importHelper->$function()) {
            $this->import();

            return;
        }

        if ($function == 'textarea' || $function == 'file') {
            $importFile = ACYM_MEDIA.'import'.DS.acym_getVar('cmd', 'filename');
            if (file_exists($importFile)) {
                $importContent = file_get_contents($importFile);
            }
            if (empty($importContent)) {
                acym_enqueueMessage(acym_translation('ACYM_EMPTY_TEXTAREA'), 'error');
                $this->import();
            } else {
                acym_setVar('layout', 'genericimport');
                $this->breadcrumb[acym_translation('ACYM_IMPORT')] = acym_completeLink('users&task=import');
                parent::display();

                return;
            }
        } else {
            $this->listing();
        }
    }

    public function finalizeImport()
    {
        $importHelper = acym_get('helper.import');
        $importHelper->finalizeImport();

        $this->listing();
    }

    public function downloadImport()
    {
        $filename = acym_getVar('cmd', 'filename');
        if (!file_exists(ACYM_MEDIA.'import'.DS.$filename.'.csv')) {
            return;
        }
        acym_noTemplate();
        $exportHelper = acym_get('helper.export');
        $exportHelper->setDownloadHeaders($filename);
        echo file_get_contents(ACYM_MEDIA.'import'.DS.$filename.'.csv');
        exit;
    }

    public function getAll()
    {
        return $this->currentClass->getAll();
    }

    public function export()
    {
        acym_setVar('layout', 'export');
        $this->breadcrumb[acym_translation('ACYM_EXPORT_USERS')] = acym_completeLink('users&task=export');

        $listClass = acym_get('class.list');
        $lists = $listClass->getAll();

        $checkedUsers = acym_getVar('array', 'elements_checked', []);

        $fields = acym_getColumns('user');

        $fieldClass = acym_get('class.field');
        $customFields = $fieldClass->getAllfields();

        $data = [
            'lists' => $lists,
            'checkedUsers' => $checkedUsers,
            'fields' => $fields,
            'customfields' => $customFields,
        ];

        parent::display($data);
    }

    public function doexport()
    {
        acym_checkToken();
        acym_increasePerf();

        $usersToExport = acym_getVar('string', 'export_users-to-export', 'all');
        $listsToExport = json_decode(acym_getVar('string', 'acym__entity_select__selected'));
        if ($usersToExport == 'list' && empty($listsToExport)) {
            acym_enqueueMessage(acym_translation('ACYM_EXPORT_SELECT_LIST'), 'error');

            return $this->exportError(acym_translation('ACYM_EXPORT_SELECT_LIST'));
        }
        acym_arrayToInteger($listsToExport);

        $exportUsersType = 'all';
        if ($usersToExport == 'list') {
            $exportUsersType = acym_getVar('string', 'export_list', 'all');
        }

        $selectedUsers = acym_getVar('string', 'selected_users', null);

        if (!empty($selectedUsers)) {
            $selectedUsersArray = explode(',', $selectedUsers);
            acym_arrayToInteger($selectedUsersArray);
        }

        $fieldsToExport = acym_getVar('array', 'export_fields', []);
        if (empty($fieldsToExport)) {
            if (!empty($selectedUsersArray)) {
                acym_setVar('elements_checked', $selectedUsersArray);
            } else {
                acym_setVar('elements_checked', []);
            }

            return $this->exportError(acym_translation('ACYM_EXPORT_SELECT_FIELD'));
        }

        $tableFields = acym_getColumns('user');
        $fieldClass = acym_get('class.field');
        $customFields = $fieldClass->getAllfields();

        $customFieldsToExport = [];

        foreach ($fieldsToExport as $i => $oneField) {
            if (empty($customFields[$oneField])) continue;
            $customFieldsToExport[$oneField] = acym_translation($customFields[$oneField]->name, true);
            unset($fieldsToExport[$i]);
        }

        $notAllowedFields = array_diff($fieldsToExport, $tableFields);
        if (in_array('id', $fieldsToExport)) $notAllowedFields[] = 'id';
        if (!empty($notAllowedFields)) {
            return $this->exportError(acym_translation_sprintf('ACYM_NOT_ALLOWED_FIELDS', implode(', ', $notAllowedFields), implode(', ', $tableFields)));
        }

        $charset = acym_getVar('string', 'export_charset', 'UTF-8');
        $excelsecurity = acym_getVar('string', 'export_excelsecurity', 0);
        $separator = acym_getVar('string', 'export_separator', 'comma');
        $realSeparators = ['comma' => ',', 'semicol' => ';'];
        if (!in_array($separator, ['comma', 'semicol'])) {
            $separator = 'comma';
        }


        $newConfig = new stdClass();
        $newConfig->export_separator = $separator;
        $newConfig->export_charset = $charset;
        $newConfig->export_excelsecurity = $excelsecurity;
        $newConfig->export_fields = implode(',', array_merge($fieldsToExport, array_keys($customFieldsToExport)));
        if (empty($selectedUsers)) {
            $newConfig->export_lists = implode(',', $listsToExport);
        }
        $this->config->save($newConfig);

        foreach ($fieldsToExport as $oneField) {
            acym_secureDBColumn($oneField);
        }
        $query = 'SELECT DISTINCT user.`id`, user.`'.implode('`, user.`', $fieldsToExport).'` FROM #__acym_user AS user';

        $where = [];

        if (!empty($selectedUsersArray)) {
            acym_arrayToInteger($selectedUsersArray);
            $where[] = 'user.id IN ('.implode(',', $selectedUsersArray).')';
        } elseif ($usersToExport == 'list' && !empty($listsToExport)) {
            $query .= ' JOIN #__acym_user_has_list AS userlist ON userlist.user_id = user.id';
            acym_arrayToInteger($listsToExport);
            $where[] = 'userlist.list_id IN ('.implode(',', $listsToExport).')';

            if ($exportUsersType == 'sub') $where[] = 'userlist.status = 1';
            if ($exportUsersType == 'unsub') $where[] = 'userlist.status = 0';
        }

        if (!empty($where)) $query .= ' WHERE ('.implode(') AND (', $where).')';

        $exportHelper = acym_get('helper.export');
        $exportHelper->exportCSV($query, $fieldsToExport, $customFieldsToExport, $realSeparators[$separator], $charset);

        exit;
    }

    private function exportError($message)
    {
        acym_enqueueMessage($message, 'error', 0);
        acym_setNoTemplate(false);

        return acym_redirect(acym_completeLink('users&task=export', false, true));
    }

    public function unsubscribeUser()
    {
        $userId = acym_getVar('int', 'id');

        if (empty($userId)) {
            $this->listing();

            return;
        }

        $lists = json_decode(acym_getVar('string', 'acym__entity_select__selected'));
        if (!is_array($lists)) {
            $lists = (array)$lists;
        }

        $this->currentClass->unsubscribe($userId, $lists);

        $this->edit();
    }

    public function subscribeUser($listing = false)
    {
        $userId = acym_getVar('int', 'id');
        $lists = json_decode(acym_getVar('string', 'acym__entity_select__selected'));

        if (empty($userId)) {
            $userId = $this->currentClass->save();
        }

        if (!is_array($lists)) {
            $lists = (array)$lists;
        }

        $this->currentClass->subscribe($userId, $lists);

        if (!$listing) {
            $this->edit();
        } else {
            $this->listing();
        }
    }

    public function save()
    {
        $this->apply(true);
    }

    public function apply($listing = false)
    {
        $userInformation = acym_getVar('array', 'user');
        $userId = acym_getVar('int', 'id');
        $listsToAdd = json_decode(acym_getVar('string', 'acym__entity_select__selected'));
        $user = new stdClass();
        $user->name = $userInformation['name'];
        $user->email = $userInformation['email'];
        $user->active = $userInformation['active'];
        $user->confirmed = $userInformation['confirmed'];
        $customFields = acym_getVar('array', 'customField');

        preg_match('/'.acym_getEmailRegex().'/i', $user->email, $matches);

        if (empty($matches)) {
            $this->edit();
            acym_enqueueMessage(acym_translation_sprintf('ACYM_VALID_EMAIL', $user->email), 'error');

            return;
        }

        if (empty($userId)) {
            $existingUser = $this->currentClass->getOneByEmail($user->email);
            if (!empty($existingUser) && acym_isAdmin()) {
                acym_enqueueMessage(acym_translation_sprintf('ACYM_X_ALREADY_EXIST', $user->email), 'error');

                $this->edit();

                return;
            } elseif (!empty($existingUser)) {
                $userId = $existingUser->id;
            } else {
                $user->creation_date = acym_date('now', 'Y-m-d H:i:s', false);
                $userId = $this->currentClass->save($user, $customFields);
            }
            acym_setVar('id', $userId);
        } else {
            $user->id = $userId;
            $this->currentClass->save($user, $customFields);
        }

        if (!empty($listsToAdd)) {
            $this->subscribeUser($listing);

            return;
        }


        if ($listing) {
            $this->listing();
        } else {
            $this->edit();
        }
    }

    public function getColumnsFromTable()
    {
        $tableName = acym_secureDBColumn(acym_getVar('string', 'tablename', ''));
        if (empty($tableName)) {
            exit;
        }
        $columns = acym_getColumns($tableName, false, false);
        $allColumnsSelect = '<option value=""></option>';
        foreach ($columns as $oneColumn) {
            $allColumnsSelect .= '<option value="'.acym_escape($oneColumn).'">'.$oneColumn.'</option>';
        }

        echo $allColumnsSelect;
        exit;
    }

    public function addToList()
    {
        $listsSelected = json_decode(acym_getVar('string', 'acym__entity_select__selected', ''));
        $userSelected = acym_getVar('array', 'elements_checked');
        foreach ($userSelected as $user) {
            $this->currentClass->subscribe($user, $listsSelected);
        }
        $this->listing();
    }

    public function setAjaxListing()
    {
        $showSelected = acym_getVar('string', 'showSelected');
        $matchingUsersData = new stdClass();
        $matchingUsersData->ordering = 'name';
        $matchingUsersData->searchFilter = acym_getVar('string', 'searchUsers');
        $matchingUsersData->usersPerPage = acym_getVar('string', 'usersPerPage');
        $matchingUsersData->idsSelected = json_decode(acym_getVar('string', 'selectedUsers'));
        $matchingUsersData->idsHidden = json_decode(acym_getVar('string', 'hiddenUsers'));
        $matchingUsersData->page = acym_getVar('int', 'pagination_page_ajax');
        if (empty($matchingUsersData->page)) {
            $matchingUsersData->page = 1;
        }

        $options = [
            'ordering' => $matchingUsersData->ordering,
            'search' => $matchingUsersData->searchFilter,
            'elementsPerPage' => $matchingUsersData->usersPerPage,
            'offset' => ($matchingUsersData->page - 1) * $matchingUsersData->usersPerPage,
            'hiddenElements' => $matchingUsersData->idsHidden,
        ];

        if ($showSelected == 'true') {
            $options['selectedUsers'] = $matchingUsersData->idsSelected;
            $options['showOnlySelected'] = true;
        }

        $users = $this->currentClass->getMatchingElements($options);

        $return = '';

        if (empty($users['elements'])) {
            $return .= '<h1 class="cell acym__listing__empty__search__modal text-center">'.acym_translation('ACYM_NO_RESULTS_FOUND').'</h1>';
        }

        foreach ($users['elements'] as $user) {
            $return .= '<div class="grid-x modal__pagination__users__listing__in-form__user cell">';

            $return .= '<div class="cell shrink"><input type="checkbox" id="modal__pagination__users__listing__user'.$user->id.'" value="'.intval($user->id).'" class="modal__pagination__users__listing__user--checkbox" name="users_checked[]"';

            if (!empty($matchingUsersData->idsSelected) && in_array($user->id, $matchingUsersData->idsSelected)) {
                $return .= 'checked';
            }

            $return .= '></div><label class="cell auto" for="modal__pagination__users__listing__user'.$user->id.'"';

            $return .= '> <span class="modal__pagination__users__listing__user-name ">'.$user->email.'</span></label></div>';
        }

        $pagination = acym_get('helper.pagination');
        $pagination->setStatus($users['total'], $matchingUsersData->page, $matchingUsersData->usersPerPage);

        $return .= $pagination->displayAjax();

        echo $return;
        exit;
    }
}

