<?php
/**
 * @package	AcySMS for Joomla!
 * @version	3.5.1
 * @author	acyba.com
 * @copyright	(C) 2009-2018 ACYBA S.A.R.L. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php

class ACYSMSGateway_suresms_gateway extends ACYSMSGateway_default_gateway{

	public $login;
	public $password;
	public $from;
	public $waittosend = 0;

	public $sendMessage = true;
	public $deliveryReport = true;
	public $answerManagement = true;

	public $domain = "ssl://api.suresms.com";
	public $port = 443;

	public $name = 'SureSMS';
	public $creditsUrl = 'https://www.suresms.com/';

	public function openSend($message, $phone){

		$params = array();
		$config = ACYSMS::config();

		$params['to'] = $this->checkNum($phone);
		$params['text'] = $message;
		$params['login'] = $this->login;
		$params['password'] = $this->password;
		$params['from'] = $this->from;
		$params['url'] = ACYSMS_LIVE.'index.php?option=com_acysms&ctrl=deliveryreport&gateway=suresms&pass='.$config->get('pass').'&smsid='.$this->fullMessage->smsid.'&';

		$stringToPost = '';
		foreach($params as $oneParam => $value){
			$value = urlencode(($value));
			$stringToPost .= '&'.$oneParam.'='.$value;
		}
		$stringToPost = ltrim($stringToPost, '&');

		$fsockParameter = "POST /Script/SendSMS.aspx HTTP/1.1\r\n";
		$fsockParameter .= "Host: api.suresms.com\r\n";
		$fsockParameter .= "Content-type: application/x-www-form-urlencoded\r\n";
		$fsockParameter .= "Content-length: ".strlen($stringToPost)."\r\n\r\n";
		$fsockParameter .= $stringToPost;

		$result = $this->sendRequest($fsockParameter);
		if(!$result && strpos(implode(',', $this->errors), 'Connection timed out') !== false && $this->port != '80'){
			$this->errors[] = 'It seems that the port you choose is blocked on you server. You should try to select the port 80';
		}
		return $result;
	}

	public function displayConfig(){
		$config = ACYSMS::config(); ?>
		<table>
			<tr>
				<td>
					<label for="senderprofile_from"><?php echo JText::_('SMS_FROM'); ?></label>
				</td>
				<td>
					<input type="text" name="data[senderprofile][senderprofile_params][from]" id="senderprofile_from" class="inputbox" maxlength="11" style="width:200px;" value="<?php echo htmlspecialchars(@$this->from, ENT_COMPAT, 'UTF-8'); ?>"/>
				</td>
			</tr>
			<tr>
				<td>
					<label for="senderprofile_login"><?php echo 'Login'; ?></label>
				</td>
				<td>
					<input type="text" name="data[senderprofile][senderprofile_params][login]"
						   id="senderprofile_login" class="inputbox" style="width:200px;"
						   value="<?php echo htmlspecialchars(@$this->login, ENT_COMPAT, 'UTF-8'); ?>"/>
				</td>
			</tr>
			<tr>
				<td>
					<label for="senderprofile_password"><?php echo JText::_('SMS_PASSWORD') ?></label>
				</td>
				<td>
					<input name="data[senderprofile][senderprofile_params][password]" id="senderprofile_password"
						   class="inputbox" type="password" style="width:200px;"
						   value="<?php echo htmlspecialchars(@$this->password, ENT_COMPAT, 'UTF-8'); ?>"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<label
						for="senderprofile_waittosend"><?php echo JText::sprintf('SMS_WAIT_TO_SEND', '<input type="text" style="width:20px;" name="data[senderprofile][senderprofile_params][waittosend]" id="senderprofile_waittosend" class="inputbox" value="'.intval($this->waittosend).'" />'); ?></label>
				</td>
			</tr>
		</table>
		<?php
		if(strpos(ACYSMS_LIVE, 'localhost') !== false){
			echo JText::_('SMS_LOCALHOST_PROBLEM');
		}else{
			echo '<ul id="gateway_addresses">';
			echo '<li>'.JText::sprintf('SMS_ANSWER_ADDRESS', 'SureSMS').'<br />'.ACYSMS_LIVE.'index.php?option=com_acysms&ctrl=answer&gateway=suresms&pass='.$config->get('pass').'</li>';
			echo '</ul>';
		}
	}

	protected function interpretSendResult($result){

		if(!strpos($result, '200 OK')){
			$this->errors[] = 'Error 200 KO => '.$result;
			return false;
		}else $res = trim(substr($result, strpos($result, "\r\n\r\n")));

		if($res == 'Message sent.'){
			$this->smsid = $this->fullMessage->smsid;
			return true;
		}else{
			$this->errors[] = $res;
			return false;
		}
	}

	public function deliveryReport(){

		$status = array();
		$apiAnswer = new stdClass();
		$apiAnswer->statsdetails_error = array();



		$status[1] = array(5, "Delivered to mobile");
		$status[2] = array(-1, "Delivery Failed");
		$status[4] = array(-1, "Buffered");
		$status[8] = array(-1, "Delivery Failed");


		$completed_time = JRequest::getVar("StatusUTCDateTime", '');

		$messageStatus = JRequest::getVar("status", '');
		if(empty($messageStatus)) $apiAnswer->statsdetails_error[] = 'Empty status received';
		if($messageStatus == 11){
			if(empty($completed_time)){
				$apiAnswer->statsdetails_received_date = time();
			}else $apiAnswer->statsdetails_received_date = $completed_time;
		}

		if(!isset($status[$messageStatus])){
			$apiAnswer->statsdetails_error[] = 'Unknow status : '.$messageStatus;
			$apiAnswer->statsdetails_status = -99;
		}else{
			$apiAnswer->statsdetails_status = $status[$messageStatus][0];
			$apiAnswer->statsdetails_error[] = $status[$messageStatus][1];
		}

		$apiAnswer->statsdetails_sms_id = JRequest::getVar("smsid", '');

		return $apiAnswer;
	}

	public function answer(){

		$apiAnswer = new stdClass();
		$apiAnswer->answer_date = JRequest::getString("receivedutcdatetime", time());

		$apiAnswer->answer_body = JRequest::getString("body", '');

		$sender = JRequest::getString("receivedfromphonenumber", '');
		$msisdn = JRequest::getString("receivedbyphonenumber", '');

		if(!empty($sender)) $apiAnswer->answer_from = '+'.$sender;
		if(!empty($msisdn)) $apiAnswer->answer_to = '+'.$msisdn;

		return $apiAnswer;
	}
}
