<?php
/**
* @title				Minitek FAQ Book
* @copyright   	Copyright (C) 2011-2020 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   https://www.minitek.gr/
* @developers   Minitek.gr
*/

defined('_JEXEC') or die;

JHtml::_('behavior.formvalidation');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', 'select');

$app = JFactory::getApplication();
$input = $app->input;

JFactory::getDocument()->addScriptDeclaration('
	Joomla.submitbutton = function(task)
	{
		if (task == "emailtemplate.cancel" || document.formvalidator.isValid(document.id("item-form")))
		{
			Joomla.submitform(task, document.getElementById("item-form"));
		}
	};
');
?>

<form action="<?php echo JRoute::_('index.php?option=com_faqbookpro&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-validate">

	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="form-horizontal">

		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

			<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_FAQBOOKPRO_FIELDSET_GENERAL', true)); ?>
				<div class="row-fluid">
					<div class="span9">
						<fieldset class="adminform">
							<div class="control-group form-inline">
								<div class="control-label">
									<?php echo $this->form->getLabel('subject'); ?>
								</div>
								<div class="controls">
									<?php echo $this->form->getInput('subject'); ?>
								</div>
							</div>

							<div class="alert alert-info">
								<span class="icon icon-book"></span>&nbsp;<a href="https://www.minitek.gr/support/documentation/joomla-extensions/components/minitek-faq-book#email-templates" target="_blank">
									<u>See the documentation</u>
								</a> for a list of available email body placeholders.
							</div>
							<?php echo $this->form->getLabel('content'); ?>
							<?php echo $this->form->getInput('content'); ?>
						</fieldset>
					</div>
					<div class="span3">
						<fieldset class="form-vertical">
							<div class="control-group">
								<div class="control-label">
									<?php echo $this->form->getLabel('template_key'); ?>
								</div>
								<div class="controls">
									<?php echo $this->form->getInput('template_key'); ?>
								</div>
							</div>
							<div class="control-group">
								<div class="control-label">
									<?php echo $this->form->getLabel('state'); ?>
								</div>
								<div class="controls">
									<?php echo $this->form->getInput('state'); ?>
								</div>
							</div>
							<div class="control-group">
								<div class="control-label">
									<?php echo $this->form->getLabel('language'); ?>
								</div>
								<div class="controls">
									<?php echo $this->form->getInput('language'); ?>
								</div>
							</div>
						</div>
					</fieldset>
				</div>
			<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value="" />
		<input type="hidden" name="return" value="<?php echo $input->getCmd('return');?>" />
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>
