<?php
/**
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

class TbColor
{
	protected $type = 'Color';
	protected $name = 'color';
	protected $id = 'color';
	protected $value = '';
	
	protected $onchange = '';
	protected $classes = '';
	protected $size = '';
	protected $readonly = false;
	protected $disabled = false;

	/**
	 * The initialised state of the document object.
	 *
	 * @var    boolean
	 * @since  11.1
	 */
	protected static $initialised = false;

	/**
	 * Method to instantiate the form field object.
	 *
	 * @param   object  $form  The form to attach to the form field object.
	 *
	 * @since   11.1
	 */
	public function __construct($config = array())
	{
		$this->name = isset($config['name']) ? $config['name'] : 'image';
		$this->id = isset($config['id']) ? $config['id'] : 'image';
		$this->value = isset($config['value']) ? $config['value'] : '';
		$this->classes = isset($config['class']) ? $config['class'] : '';
		$this->size = isset($config['size']) ? $config['size'] : '';
		$this->readonly = isset($config['readonly']) ? $config['readonly'] : false;
		$this->disabled = isset($config['disabled']) ? $config['disabled'] : false;
		$this->onchange = isset($config['onchange']) ? $config['onchange'] : '';
	}
	
	/**
	 * Method to get the field input markup for a media selector.
	 * Use attributes to identify specific created_by and asset_id fields
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	public function getInput()
	{
		// Initialize some field attributes.
		if (!$this->disabled)
		{
			JHtml::_('behavior.colorpicker');
			
			if(version_compare(JVERSION,'3.1.5','ge')) {
				$this->classes .= ' minicolors';
			}
			else {
				$this->classes .= ' input-colorpicker';
			}
		}

		if (empty($this->value))
		{
			// A color field can't be empty, we default to black. This is the same as the HTML5 spec.
			$this->value = '#000000';
		}

		$class = $this->classes ? ' class="' . trim($this->classes) . '"' : '';

		return '<input type="text" name="' . $this->name . '" id="' . $this->id . '"' . ' value="'
			. htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"' . $class . $this->size . $this->disabled . $this->onchange . '/>';
	}
}
