<?php
/**
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

class TbUser
{
	protected $type = 'User';
	protected $name = 'user';
	protected $id = 'user';
	protected $value = '';
	
	protected $onchange = '';
	protected $classes = '';
	protected $size = '';
	protected $readonly = false;
	protected $disabled = false;

	/**
	 * The initialised state of the document object.
	 *
	 * @var    boolean
	 * @since  11.1
	 */
	protected static $initialised = false;

	/**
	 * Method to instantiate the form field object.
	 *
	 * @param   object  $form  The form to attach to the form field object.
	 *
	 * @since   11.1
	 */
	public function __construct($config = array())
	{
		$this->name = isset($config['name']) ? $config['name'] : 'image';
		$this->id = isset($config['id']) ? $config['id'] : 'image';
		$this->value = isset($config['value']) ? $config['value'] : '';
		$this->classes = isset($config['class']) ? $config['class'] : '';
		$this->size = isset($config['size']) ? $config['size'] : '';
		$this->readonly = isset($config['readonly']) ? $config['readonly'] : false;
		$this->disabled = isset($config['disabled']) ? $config['disabled'] : false;
		$this->onchange = isset($config['onchange']) ? $config['onchange'] : '';
		$this->scope = isset($config['scope']) ? $config['scope'] : '';
	}
	
	/**
	 * Method to get the user field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.6
	 */
	public function getInput()
	{
		$html = array();
		$groups = $this->getGroups();
		$excluded = $this->getExcluded();
		$link = 'index.php?option=com_taxibooking&amp;view=tbusers&amp;layout=modal&amp;tmpl=component&amp;field=' . $this->id
			. (isset($groups) ? ('&amp;groups=' . base64_encode(json_encode($groups))) : '')
			. (($this->scope!="") ? '&amp;scope=' . $this->scope : '')
			. (isset($excluded) ? ('&amp;excluded=' . base64_encode(json_encode($excluded))) : '');

		// Initialize some field attributes.
		$attr = !empty($this->classes) ? ' class="' . $this->classes . '"' : '';
		$attr .= !empty($this->size) ? ' size="' . $this->size . '"' : '';
		$attr .= !empty($this->readonly) ? ' readonly="readonly"' : '';

		// Load the modal behavior script.
		JHtml::_('behavior.modal', 'a.modal_' . $this->id);

		// Build the script.
		$script = array();
		$script[] = '	function jSelectUser_' . $this->id . '(tbuser_id, juser_id, title) {';
		$script[] = '		var old_id = document.getElementById("' . $this->id . '_id").value;';
		$script[] = '		if (old_id != juser_id) {';
		$script[] = '			document.getElementById("' . $this->id . '_id").value = juser_id;';
		$script[] = '			document.getElementById("' . $this->id . '").value = title;';
		$script[] = '			document.getElementById("' . $this->id . '").className = document.getElementById("' . $this->id . '").className.replace(" invalid" , "");';
		$script[] = '			' . $this->onchange;
		$script[] = '		}';
		$script[] = '		SqueezeBox.close();';
		$script[] = '	}';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		// Load the current username if available.
		$table = JTable::getInstance('user');
		
		if (is_numeric($this->value))
		{
			$table->load($this->value);
		}
		// Handle the special case for "current".
		elseif (strtoupper($this->value) == 'CURRENT')
		{
			$table->load(JFactory::getUser()->id);
		}
		else
		{
			$table->username = JText::_('JLIB_FORM_SELECT_USER');
		}

		// Create a dummy text field with the user name.
		$html[] = '<div class="input-append">';
		if(is_string($this->value)){
			$value = htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8');
		}
		else {
			$value = htmlspecialchars($table->name, ENT_COMPAT, 'UTF-8');
		}
		$html[] = '	<input type="text" id="' . $this->id . '" value="' . $value . '"'. $attr . ' />';

		// Create the user select button.
		if ($this->readonly === false)
		{
			$html[] = '		<a class="btn btn-primary modal_' . $this->id . '" title="' . JText::_('JLIB_FORM_CHANGE_USER') . '" href="' . $link . '"'
				. ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}">';
			$html[] = '<i class="icon-user"></i></a>';
		}

		$html[] = '</div>';

		// Create the real field, hidden, that stored the user id.
		$html[] = '<input type="hidden" id="' . $this->id . '_id" name="' . $this->name . '" value="' . (int) $this->value . '" />';

		return implode("\n", $html);
	}

	/**
	 * Method to get the filtering groups (null means no filtering)
	 *
	 * @return  mixed  array of filtering groups or null.
	 *
	 * @since   1.6
	 */
	protected function getGroups()
	{
		return null;
	}

	/**
	 * Method to get the users to exclude from the list of users
	 *
	 * @return  mixed  Array of users to exclude or null to to not exclude them
	 *
	 * @since   1.6
	 */
	protected function getExcluded()
	{
		return null;
	}
}
