<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * taxibooking Component Controller
 *
 * @since 1.0
 */
class TaxiBookingController extends JControllerLegacy
{
    /**
     * Display the view
     */
    public function display($cachable = false, $urlparams = false)
    {
	$user 	= JFactory::getUser();
	$view   = JFactory::getApplication()->input->get('view', 'taxibooking');
	$layout = JFactory::getApplication()->input->get('layout', 'default');

	// Check for access.
	if ($view == 'taxibooking' && !$user->authorise('core.manage', 'com_taxibooking'))
	{
		$this->setError(JText::_('JERROR_ALERTNOAUTHOR'));
		$this->setMessage($this->getError(), 'error');
		$this->setRedirect(JRoute::_('index.php', false));
		return false;
	}

	if ( ($view == 'settings' && !$user->authorise('core.config', 'com_taxibooking'))
	    || (($view == 'paymentmethods' || $view == 'paymentmethod') && !$user->authorise('core.manage.payments', 'com_taxibooking'))
	    || (($view == 'poicats' || $view == 'poicat') && !$user->authorise('core.manage.poicats', 'com_taxibooking'))
	    || (($view == 'points' || $view == 'point') && !$user->authorise('core.manage.pois', 'com_taxibooking'))
	    || (($view == 'cars' || $view == 'car') && !$user->authorise('core.manage.cars', 'com_taxibooking'))
	    || (($view == 'tariffs' || $view == 'tariff') && !$user->authorise('core.manage.tariffs', 'com_taxibooking'))
	    || (($view == 'routes' || $view == 'route') && !$user->authorise('core.manage.specialroutes', 'com_taxibooking'))
	    || (($view == 'shuttles' || $view == 'shuttle') && !$user->authorise('core.manage.shuttles', 'com_taxibooking'))
	    || (($view == 'fields' || $view == 'field') && !$user->authorise('core.manage.customfields', 'com_taxibooking'))
	    || (($view == 'coupons' || $view == 'coupon') && !$user->authorise('core.manage.coupons', 'com_taxibooking'))
	    || ($view == 'calendar' && !$user->authorise('core.manage.calendar', 'com_taxibooking'))
	    || (($view == 'orders' || $view == 'order') && !$user->authorise('core.manage.orders', 'com_taxibooking'))
	    || (($view == 'tbusers' || $view == 'tbuser') && !$user->authorise('core.manage.users', 'com_taxibooking'))
	    || ($view == 'drivenot' && !$user->authorise('core.manage.drivenot', 'com_taxibooking'))
	    || (($view == 'searchurls' || $view == 'searchurl') && !$user->authorise('core.manage.searchurls', 'com_taxibooking'))
	    || ($view == 'translations' && !$user->authorise('core.manage.translations', 'com_taxibooking'))
	    )
	{
		$this->setError(JText::_('JERROR_ALERTNOAUTHOR'));
		$this->setMessage($this->getError(), 'error');
		$this->setRedirect(JRoute::_('index.php?option=com_taxibooking&view=taxibooking', false));
		return false;
	}

        parent::display();
	return $this;
    }

    /**
    * Gets the URL arguments to append to an item redirect.
    *
    * @param   integer  $recordId  The primary key id for the item.
    * @param   string   $urlVar    The name of the URL variable for the id.
    *
    * @return  string  The arguments to append to the redirect URL.
    *
    * @since   12.2
    */
    protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
    {
	    $tmpl   = JFactory::getApplication()->input->get('tmpl');
	    $layout = JFactory::getApplication()->input->get('layout', 'edit', 'string');
	    $append = '';

	    // Setup redirect info.
	    if ($tmpl)
	    {
		    $append .= '&tmpl=' . $tmpl;
	    }

	    if ($layout)
	    {
		    $append .= '&layout=' . $layout;
	    }

	    if ($recordId)
	    {
		    $append .= '&' . $urlVar . '=' . $recordId;
	    }

	    return $append;
    }

    /**
     * Gets the URL arguments to append to a list redirect.
     *
     * @return  string  The arguments to append to the redirect URL.
     *
     * @since   12.2
     */
    protected function getRedirectToListAppend()
    {
	    $tmpl = JFactory::getApplication()->input->get('tmpl');
	    $append = '';

	    // Setup redirect info.
	    if ($tmpl)
	    {
		    $append .= '&tmpl=' . $tmpl;
	    }

	    return $append;
    }

    public function getUserDetailsAjax()
    {
	$user_id = JRequest::getInt('user_id', 0);

	// Load the current username if available.
	$user = JTable::getInstance('user');
	$user->load($user_id);

	echo json_encode(array('name' => $user->get('name'),'email' => $user->get('email')));
	exit();
    }

    public function fixOrderAjax()
    {
	$json_result = array('error' => 0, 'msg' => '');

	$order_id = JRequest::getInt('order_id', 0);
	$db = JFactory::getDBO();

	$pickup_lat = $pickup_lng = $dropoff_lat = $dropoff_lng = 0;
	$extras = array();

	if($order_id>0)
	{
	    $order = booking_helper::get_order_by_id($order_id);

	    if($order)
	    {
		if($order->pickup_lat==0 || $order->pickup_lng==0 || $order->dropoff_lat==0 || $order->dropoff_lng==0)
		{
		    // first fix extras, add id for each extra
		    $extras = unserialize($order->extras);

		    if(!empty($extras))
		    {
			foreach($extras as $extra_type => $extra_arr)
			{
			    if(!empty($extra_arr))
			    {
				foreach($extra_arr as $id => $extra_row)
				{
				    $query = $db->getQuery(true);
				    $query->select('*');
				    $query->from('#__taxibooking_fields');
				    $query->where('title = '.$db->Quote($extra_row['name']));
				    $db->setQuery((string)$query);
				    $fieldObj = $db->loadObject();

				    if($fieldObj){
					$extra_arr[$id]['id'] = $fieldObj->id;
					$extra_arr[$id]['type'] = $fieldObj->field_type;
				    }
				    else {
					$extra_arr[$id]['id'] = 0;
					$extra_arr[$id]['type'] = '';
				    }
				}

				$extras[$extra_type] = $extra_arr;
			    }
			}
		    }
		    //print_r($extras);

		    // add pickup and dropoff lat-lng
		    $order->begin = trim($order->begin);
		    $order->end = trim($order->end);

		    if($order->booking_type=='address'){
			$poi_where = array('p.title = '.$db->Quote($order->begin));
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
			    $pickup_lat = $poiObj->lat;
			    $pickup_lng = $poiObj->long;
			}
			else {
			    $coords = booking_helper::getLatLong($order->begin);
			    if(!empty($coords)){
				$pickup_lat = $coords[0];
				$pickup_lng = $coords[1];
			    }
			}

			$poi_where = array('p.title = '.$db->Quote($order->end));
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
			    $dropoff_lat = $poiObj->lat;
			    $dropoff_lng = $poiObj->long;
			}
			else {
			    $coords = booking_helper::getLatLong($order->end);
			    if(!empty($coords)){
				$dropoff_lat = $coords[0];
				$dropoff_lng = $coords[1];
			    }
			}

		    }
		    elseif($order->booking_type=='offers' || $order->booking_type=='shuttle'){ // offers and shuttle are based on POI
			$poi_where = array('p.title = '.$db->Quote($order->begin));
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
			    $pickup_lat = $poiObj->lat;
			    $pickup_lng = $poiObj->long;
			}

			$poi_where = array('p.title = '.$db->Quote($order->end));
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
			    $dropoff_lat = $poiObj->lat;
			    $dropoff_lng = $poiObj->long;
			}
		    }
		    elseif($order->booking_type=='hourly'){
			// no coords
		    }
		    else {
			if($order->from_dest==0){ // POI
			    $poi_where = array('p.title = '.$db->Quote($order->begin));
			    $poiObj = booking_helper::get_specific_place_details($poi_where);
			    if($poiObj) // user chose POI
			    {
				$pickup_lat = $poiObj->lat;
				$pickup_lng = $poiObj->long;
			    }
			    else {
				$coords = booking_helper::getLatLong($order->begin);
				if(!empty($coords)){
				    $pickup_lat = $coords[0];
				    $pickup_lng = $coords[1];
				}
			    }
			}
			else{
			    $coords = booking_helper::getLatLong($order->begin);
			    if(!empty($coords)){
				$pickup_lat = $coords[0];
				$pickup_lng = $coords[1];
			    }
			}

			if($order->to_dest==0){ // POI
			    $poi_where = array('p.title = '.$db->Quote($order->end));
			    $poiObj = booking_helper::get_specific_place_details($poi_where);
			    if($poiObj) // user chose POI
			    {
				$dropoff_lat = $poiObj->lat;
				$dropoff_lng = $poiObj->long;
			    }
			    else {
				$coords = booking_helper::getLatLong($order->end);
				if(!empty($coords)){
				    $pickup_lat = $coords[0];
				    $pickup_lng = $coords[1];
				}
			    }
			}
			else{
			    $coords = booking_helper::getLatLong($order->end);
			    if(!empty($coords)){
				$dropoff_lat = $coords[0];
				$dropoff_lng = $coords[1];
			    }
			}
		    }

		    $data = new stdClass();
		    $data->id = $order_id;
		    $data->extras = serialize($extras);
		    $data->pickup_lat = $pickup_lat;
		    $data->pickup_lng = $pickup_lng;
		    $data->dropoff_lat = $dropoff_lat;
		    $data->dropoff_lng = $dropoff_lng;

		    $db->updateObject('#__taxibooking_orders', $data, 'id');

		    $json_result['msg'] = array($pickup_lat,
						$pickup_lng,
						$dropoff_lat,
						$dropoff_lng,
						$extras
						);
		}
		else {
		    $json_result['error'] = 0;
		    $json_result['msg'] = 'Order already fixed';
		}
	    }
	    else {
		$json_result['error'] = 1;
		$json_result['msg'] = 'Order not found';
	    }
	}
	echo json_encode($json_result);
	exit();
    }

    public function completeFixingOrderAjax()
    {
	$json_result = array('error' => 0, 'msg' => '');
	$db = JFactory::getDBO();

	$query = $db->getQuery(true);
	$query->select('*');
	$query->from('#__extensions');
	$query->where($db->quoteName('name') . ' = ' . $db->quote('taxibooking'));
	$db->setQuery((string)$query);
	$row = $db->loadObject();
	$params = json_decode($row->params);

	$params->order_fixing_used = 1;

	$query = $db->getQuery(true);
	$query->update($db->quoteName('#__extensions'));
	$query->set($db->quoteName('params') . ' = ' . $db->quote(json_encode($params)));
	$query->where($db->quoteName('name') . ' = ' . $db->quote('taxibooking'));
	$db->setQuery($query);
	$db->execute();

	echo json_encode($json_result);
	exit();
    }

    public function fixDatabaseAjax()
    {
	$json_result = array('error' => 0, 'msg' => '');

	$db = JFactory::getDBO();
	$tablename = '#__taxibooking_orders';

	$missing_fields = array(
	    'shuttle_route_id'  => 'INT NOT NULL DEFAULT \'0\' AFTER `coupon_used`',
	    'gratuity_amt'  => 'FLOAT( 10, 2 ) NOT NULL DEFAULT \'0\'',
	    'gratuity_amttype'  => 'CHAR( 10 ) NOT NULL DEFAULT \'flat\''
	);

	$current_fields = array();
	$db->setQuery('SHOW COLUMNS FROM '.$db->quoteName($tablename));
	$rows = $db->loadObjectList();
	if(!empty($rows))
	{
		foreach($rows as $row){
			$current_fields[] = $row->Field;
		}
	}

	foreach ($missing_fields as $fieldname => $fieldtype)
	{
	    if(!in_array($fieldname,$current_fields))
	    {
		$query = "ALTER TABLE " . $db->quoteName($tablename) . " ADD " . $db->quoteName($fieldname) . " $fieldtype";
		$db->setQuery($query);
		$db->execute();
	    }
	}

	echo json_encode($json_result);
	exit();
    }
}
