<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

/**
 * Component Settings Controller
 */
class TaxiBookingControllerCalendar extends TaxiBookingController
{
	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	function __construct()
	{
		parent::__construct();

		// Register Extra task
		$this->registerTask( 'apply', 		'save' );
	}

	/**
	 * logic for cancel an action
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	function cancel()
	{
		$model = $this->getModel('calendar');
		$this->setRedirect( 'index.php?option=com_taxibooking');
	}

	/**
	 * saves the venue in the database
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or die( 'Invalid Token' );

		// Sanitize
		$task	= JRequest::getVar('task');
		$post 	= JRequest::get( 'post' );
		$post['booking_calendar_url'] = JRequest::getVar( 'booking_calendar_url', '', 'post', 'string', JREQUEST_ALLOWRAW );
		
		//get model
		$model 	= $this->getModel('calendar');
                
		if ($model->store($post)) {
			$this->setMessage(JText::_('COM_TAXIBOOKING_SAVE_SUCCESS'));
		}
		else {
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');
		}
		
		$this->setRedirect(
			JRoute::_(
				'index.php?option=com_taxibooking&view=calendar', false
			)
		);
	}
}