<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * Component Item Controller
 */
class TaxiBookingControllerConfigs extends TaxiBookingController
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_TAXIBOOKING';
	/**
	 * The context for storing internal data, e.g. record.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $context;
	/**
	 * The URL option for the component.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $option;

	/**
	 * The URL view item variable.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $view_item;

	/**
	 * The URL view list variable.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $view_list;
	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	function __construct()
	{
		parent::__construct();

		$this->context = 'config';
		// Guess the option as com_NameOfController
		if (empty($this->option))
		{
			$this->option = 'com_taxibooking';
		}
		// Guess the item view as the context.
		if (empty($this->view_item))
		{
			$this->view_item = 'config';
		}
		// Guess the list view as the plural of the item view.
		if (empty($this->view_list))
		{
			$this->view_list = 'configs';
		}

		// Define standard task mappings.
		$this->registerTask( 'apply', 			'save' );
		$this->registerTask( 'save2copy', 		'save' );

		// Value = 0
		$this->registerTask('unpublish', 'publish');
		// Value = 2
		$this->registerTask('archive', 'publish');
		// Value = -2
		$this->registerTask('trash', 'publish');
		// Value = -3
		$this->registerTask('orderup', 'reorder');
		$this->registerTask('orderdown', 'reorder');
	}

	/**
	 * Method to add a new record.
	 *
	 * @return  mixed  True if the record can be added, a error object if not.
	 *
	 * @since   12.2
	 */
	public function add()
	{
		$app = JFactory::getApplication();
		$context = "$this->option.edit.$this->context";

		// Access check.
		if (!$this->allowAdd())
		{
			// Set the internal error and also the redirect error.
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Clear the record edit information from the session.
		$app->setUserState($context . '.data', null);

		// Redirect to the edit screen.
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_item
				. $this->getRedirectToItemAppend(), false
			)
		);

		return true;
	}

	/**
	 * Method to check if you can add a new record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowAdd($data = array())
	{
		return false;
	}

	/**
	 * Method to cancel an edit.
	 *
	 * @param   string  $key  The name of the primary key of the URL variable.
	 *
	 * @return  boolean  True if access level checks pass, false otherwise.
	 *
	 * @since   12.2
	 */
	public function cancel()
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app = JFactory::getApplication();
		$model = $this->getModel('config');
		$table = $model->getTable();
		$checkin = property_exists($table, 'checked_out');
		$context = "$this->option.edit.$this->context";

		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		$recordId = $app->input->getInt($key);

		// Attempt to check-in the current record.
		if ($recordId)
		{
			if ($checkin)
			{
				if ($model->checkin($recordId) === false)
				{
					// Check-in failed, go back to the record and display a notice.
					$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
					$this->setMessage($this->getError(), 'error');

					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend($recordId, $key), false
						)
					);

					return false;
				}
			}
		}

		// Clean the session data and redirect.
		$this->releaseEditId($context, $recordId);
		$app->setUserState($context . '.data', null);

		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list
				. $this->getRedirectToListAppend(), false
			)
		);

		return true;
	}
	/**
	 * Method to check if you can add a new record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		return JFactory::getUser()->authorise('core.config', 'com_taxibooking');
	}

	/**
	 * Logic to create the view for edit order
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function edit($key = null, $urlVar = null)
	{
		$app   = JFactory::getApplication();
		$model = $this->getModel('config');
		$table = $model->getTable();
		$cid	= JRequest::getVar( 'cid', array(0), 'get', 'array' );
		$context = "$this->option.edit.$this->context";

		// Determine the name of the primary key for the data.
		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		// To avoid data collisions the urlVar may be different from the primary key.
		if (empty($urlVar))
		{
			$urlVar = $key;
		}

		// Get the previous record id (if any) and the current record id.
		$recordId = (int) (count($cid) ? $cid[0] : $app->input->getInt($urlVar));
		$checkin = property_exists($table, 'checked_out');

		// Access check.
		if (!$this->allowEdit(array($key => $recordId), $key))
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Attempt to check-out the new record for editing and redirect.
		if ($checkin && !$model->checkout($recordId))
		{
			// Check-out failed, display a notice but allow the user to see the record.
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKOUT_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
		else
		{
			// Check-out succeeded, push the new record id into the session.
			$this->holdEditId($context, $recordId);
			$app->setUserState($context . '.data', null);

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return true;
		}
	}

        /**
	 * Logic to save an order
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function save($key = null, $urlVar = null)
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app   = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$date = JFactory::getDate();
		$model = $this->getModel('config');
		$table = $model->getTable();

		$post  = JRequest::getVar('jform', array(), 'array');

		$waiting_time = $post['wait_time_max'];
        $waiting_price = $post['return_time_price_hour'];
        
		$alias  = JRequest::getVar('alias', '');
		$post['text'] = JRequest::getVar( 'text', '', 'post', 'string', JREQUEST_ALLOWRAW );

		$checkin = property_exists($table, 'checked_out');
		$task = $this->getTask();
		$elsettings 	= booking_helper::config();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		// Determine the name of the primary key for the data.
		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		// To avoid data collisions the urlVar may be different from the primary key.
		if (empty($urlVar))
		{
			$urlVar = $key;
		}

		$recordId = JRequest::getInt($urlVar);

		if(isset($post['currency_symbol'])){
			$post['currency_symbol'] = booking_helper::checkCurrencySymbol( $post['currency_symbol'] );
		}

		// prepare distance prices only price configs
		if($alias=='general-settings')
		{
			if((int)$post['booking_cancellation_allowed']==0){
				$post['booking_cancellation_prior_hrs'] = 0;
			}
		}
		elseif($alias=='price-settings')
		{
			$distance_price_arr = array();
			if(!empty($post['distance_min']))
			{
				foreach($post['distance_min'] as $key => $distance_min)
				{
					if($distance_min!="")
					{
						$distance_max = !empty($post['distance_max'][$key]) ? trim($post['distance_max'][$key]) : 0;
						$price = !empty($post['price'][$key]) ? trim($post['price'][$key]) : 0;
						$outbound_discount = !empty($post['outbound_discount'][$key]) ? trim($post['outbound_discount'][$key]) : 0;
						$return_discount = !empty($post['return_discount'][$key]) ? trim($post['return_discount'][$key]) : 0;
						$tariff_prices = !empty($post['tariff_prices'][$key]) ? $post['tariff_prices'][$key] : array();
						$distance_price_arr[] = array(trim($distance_min), $distance_max, $price, $outbound_discount, $return_discount,$tariff_prices);
					}
				}
			}

			$cumulative_distance_price_arr = array();
			if(!empty($post['cumulative_distance_min']))
			{
				foreach($post['cumulative_distance_min'] as $key => $distance_min)
				{
					if($distance_min!="")
					{
						$distance_max = !empty($post['cumulative_distance_max'][$key]) ? trim($post['cumulative_distance_max'][$key]) : 0;
						$price = !empty($post['cumulative_price'][$key]) ? trim($post['cumulative_price'][$key]) : 0;
						$outbound_discount = !empty($post['cumulative_outbound_discount'][$key]) ? trim($post['cumulative_outbound_discount'][$key]) : 0;
						$return_discount = !empty($post['cumulative_return_discount'][$key]) ? trim($post['cumulative_return_discount'][$key]) : 0;
						$tariff_prices = !empty($post['tariff_cumulative_prices'][$key]) ? $post['tariff_cumulative_prices'][$key] : array();
						$cumulative_distance_price_arr[] = array(trim($distance_min), $distance_max, $price, $outbound_discount, $return_discount,$tariff_prices);
					}
				}
			}

			if($post['price_calculation_cumulative']==1){ // cumulative
				$distance_price_arr = array();
			}
			else {
				$cumulative_distance_price_arr = array();
			}

			$return_discount_arr = array();
			if($post['wait_time_return_discount']==1)
			{
				if(!empty($post['wait_time_hrs']))
				{
					foreach($post['wait_time_hrs'] as $key => $wait_time_hr)
					{
						if(!empty($wait_time_hr) && $wait_time_hr!=0)
						{
							$return_discount_percentage = !empty($post['return_discount_percentage'][$key]) ? trim($post['return_discount_percentage'][$key]) : 0;
							$return_discount_arr[] = array(trim($wait_time_hr), $return_discount_percentage);
						}
					}
				}
			}

			$gratuity_arr = array();
			if($post['enable_gratuity']==1)
			{
				if(!empty($post['gratuity_amount']))
				{
					foreach($post['gratuity_amount'] as $key => $gratuity_amount)
					{
						if(!empty($gratuity_amount) && $gratuity_amount!=0)
						{
							$gratuity_type = !empty($post['gratuity_type'][$key]) ? trim($post['gratuity_type'][$key]) : 'flat';
							$gratuity_arr[] = array(trim($gratuity_amount), $gratuity_type);
						}
					}
				}
			}

			$post['distance_prices'] = $distance_price_arr;
			$post['cumulative_distance_prices'] = $cumulative_distance_price_arr;
			$post['return_discounts'] = $return_discount_arr;
			$post['gratuities'] = $gratuity_arr;
		}
		elseif($alias=='orderemail-settings')
		{
			$post['header_info'] = JRequest::getVar( 'header_info', '', 'post', 'string', JREQUEST_ALLOWRAW );
			$post['contact_info'] = JRequest::getVar( 'contact_info', '', 'post', 'string', JREQUEST_ALLOWRAW );
		}
		elseif($alias=='terms-settings')
		{
			$post['terms_conditions'] = JRequest::getVar( 'terms_conditions', '', 'post', 'string', JREQUEST_ALLOWRAW );
		}
		elseif($alias=='gcal-settings')
		{
			// upload key file
			$files		= JRequest::getVar('google_p12_key_file', '', 'files', 'array');

			if(!empty($files['name'][0]))
			{
				list($result, $message, $file_name) = $this->_upload_files();
				if($result=='succeed')
				{
					$post['google_p12_key_filename'] = $file_name;
				}
			}
		}

		if ( $model->save($post) ) {

			// Save succeeded, so check-in the record.
			if ($checkin && $model->checkin($recordId) === false)
			{
				// Save the data in the session.
				$app->setUserState($this->context . '.data', $post);

				// Check-in failed, so go back to the record and display a notice.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
				$this->setMessage($this->getError(), 'error');

				$this->setRedirect(
					JRoute::_(
						'index.php?option=' . $this->option . '&view=' . $this->view_item
						. $this->getRedirectToItemAppend($recordId, $urlVar), false
					)
				);

				return false;
			}

			// send a cURL post to drivenot.com if admins save Base settings
			if($alias=='base-settings')
			{
				//set POST variables
				$post_url = APPREGULATOR_URL."/index.php?option=com_appregulator&task=updateDrivenotCompany&tmpl=component";

				$elsettings 	= booking_helper::config();
				$company_url = rtrim(JURI::root(), '/');
				$tbversion = booking_helper::getTBVersion();
				$operation_area_vertices = $elsettings->operation_area_vertices;

				$fields = array(
					'token'			=> urlencode('kanev'),
					'company_name'		=> urlencode($app->getCfg('sitename')),
					'company_url'		=> urlencode($company_url),
					'operation_area_vertices'=> urlencode($operation_area_vertices),
					'tbversion'		=> urlencode($tbversion),
					'contact_email'	=> urlencode($elsettings->booking_notification_email),
					'contact_city'	=> urlencode($elsettings->default_city),
					'contact_country'	=> urlencode($elsettings->default_country),
					'source'	=> urlencode('tbbase-settings'),
				);

				//url-ify the data for the POST
				$fields_string = '';
				foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				rtrim($fields_string, '&');

				//open connection
				$ch = curl_init();

				//set the url, number of POST vars, POST data
				curl_setopt($ch,CURLOPT_URL, $post_url);
				curl_setopt($ch,CURLOPT_POST, count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

				//execute post
				$result = curl_exec($ch);

				$curl_errno = curl_errno($ch);
				$curl_error = curl_error($ch);
				if ($curl_errno > 0) {
					$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', "cURL Error ($curl_errno): $curl_error"));
					$this->setMessage($this->getError(), 'error');
				}

				//close connection
				curl_close($ch);
			}

			$this->setMessage(JText::_('COM_TAXIBOOKING_SAVE_SUCCESS'));

			// Redirect the user and adjust session state based on the chosen task.
			switch ($task)
			{
				case 'apply':
					// Set the record data in the session.
					$recordId = $model->getState($this->context . '.id');
					$this->holdEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);
					$model->checkout($recordId);

					// Redirect back to the edit screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend($recordId, $urlVar), false
						)
					);
					break;

				case 'save2new':
					// Clear the record id and data from the session.
					$this->releaseEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);

					// Redirect back to the edit screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend(null, $urlVar), false
						)
					);
					break;

				default:
					// Clear the record id and data from the session.
					$this->releaseEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);

					// Redirect to the list screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_list
							. $this->getRedirectToListAppend(), false
						)
					);
					break;
			}

			return true;

		} else {
			// Redirect back to the edit screen.
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
	}

	private function _upload_files()
	{
		// Initialise variables.
		$app   = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_media');

		jimport( 'joomla.filesystem.file' );
		$files		= JRequest::getVar('google_p12_key_file', '', 'files', 'array');

		if (
			$_SERVER['CONTENT_LENGTH']>($params->get('upload_maxsize', 0) * 1024 * 1024) ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('upload_max_filesize'))* 1024 * 1024 ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('post_max_size'))* 1024 * 1024 ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('memory_limit'))* 1024 * 1024
		)
		{
			return array('failed', JText::_('COM_TAXIBOOKING_ERROR_WARNFILETOOLARGE'), '');
		}

		/*if (!file_exists(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'appregulator')))) {
			mkdir(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'appregulator')), 0777, true);
		}*/

		// Input is in the form of an associative array containing numerically indexed arrays
		// We want a numerically indexed array containing associative arrays
		// Cast each item as array in case the Filedata parameter was not sent as such
		$files = array_map( array($this, 'reformatFilesArray'),
			(array) $files['name'], (array) $files['type'], (array) $files['tmp_name'], (array) $files['error'], (array) $files['size']
		);

		// Perform basic checks on file info before attempting anything
		foreach ($files as &$file)
		{
			if (empty($file['name']))
			{
				// No filename (after the name was cleaned by JFile::makeSafe)
				return array('failed', JText::_('COM_TAXIBOOKING_ERROR_UPLOAD_INPUT'), '');
			}
			if ($file['error']==1)
			{
				return array('failed', JText::_('COM_TAXIBOOKING_ERROR_WARNFILETOOLARGE'), '');
			}

			$maxSize = (int) ($params->get('upload_maxsize', 0) * 1024 * 1024);
			if ($maxSize > 0 && (int) $file['size'] > $maxSize)
			{
				return array('failed', JText::_('COM_TAXIBOOKING_ERROR_WARNFILETOOLARGE'), '');
			}

			$format = strtolower(JFile::getExt($file['name']));
			$allowable = explode(',', $params->get('upload_extensions'));
			/*if (!in_array($format, $allowable))
			{
				return array('failed', JText::_('COM_TAXIBOOKING_ERROR_WARNFILETYPE'), '');
			}*/
		}

		foreach ($files as &$file)
		{
			//$file['name'] = JApplication::stringURLSafe($file['name']);

			if (!JFile::upload($file['tmp_name'], $file['filepath']))
			{
				// Error in upload
				return array('failed', JText::_('COM_TAXIBOOKING_ERROR_UNABLE_TO_UPLOAD_FILE'), '');
			}
			else {
				$result = 'succeed';
				$message = '';
				return array('succeed', '', $file['name']);
			}
		}

		return array('succeed', '', $file['name']);
	}

	/**
	 * Used as a callback for array_map, turns the multi-file input array into a sensible array of files
	 * Also, removes illegal characters from the 'name' and sets a 'filepath' as the final destination of the file
	 *
	 * @param	string	- file name			($files['name'])
	 * @param	string	- file type			($files['type'])
	 * @param	string	- temporary name	($files['tmp_name'])
	 * @param	string	- error info		($files['error'])
	 * @param	string	- file size			($files['size'])
	 *
	 * @return	array
	 * @access	protected
	 */
	protected function reformatFilesArray($name, $type, $tmp_name, $error, $size)
	{
		//$name = JFile::makeSafe($name);
		return array(
			'name'		=> $name,
			'type'		=> $type,
			'tmp_name'	=> $tmp_name,
			'error'		=> $error,
			'size'		=> $size,
			'filepath'	=> JPath::clean(implode(DIRECTORY_SEPARATOR, array(JPATH_COMPONENT_SITE, $name)))
		);
	}

	/**
	 * Method to publish a list of items
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	public function publish()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		return false;
	}

	/**
	 * Changes the order of one or more records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function reorder()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Reorder failed.
		$message = JText::sprintf('JLIB_APPLICATION_ERROR_REORDER_FAILED', 'Not Allowed');
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
		return false;
	}

	/**
	 * Method to save the submitted ordering values for records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function saveorder()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Reorder failed
		$message = JText::sprintf('JLIB_APPLICATION_ERROR_REORDER_FAILED', 'Not Allowed');
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
		return false;
	}

	/**
	 * Logic to delete items
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function remove()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		return false;
	}

	/**
	 * Check in of one or more records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function checkin()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$ids		= JRequest::getVar( 'cid', array(), 'post', 'array' );

		$model = $this->getModel('config');
		$return = $model->checkin($ids);
		if ($return === false)
		{
			// Checkin failed.
			$message = JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError());
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
			return false;
		}
		else
		{
			// Checkin succeeded.
			$message = JText::plural($this->text_prefix . '_N_ITEMS_CHECKED_IN', count($ids));
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message);
			return true;
		}
	}

	/**
	 * Method to clone an existing module.
	 * @since	1.6
	 */
	public function duplicate()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
		return false;
	}

	/**
        * Method to save the submitted ordering values for records via AJAX.
        *
        * @return  void
        *
        * @since   3.0
        */
	public function saveOrderAjax()
	{
		// Get the input
		if ($return)
		{
			echo "1";
		}

		// Close the application
		JFactory::getApplication()->close();
	}
}
