<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

/**
 * Drivenot Controller
 */
class TaxiBookingControllerDrivenot extends TaxiBookingController
{
	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * logic for cancel an action
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	function cancel()
	{
		$this->setRedirect( 'index.php?option=com_taxibooking');
	}

	/**
	 * saves the venue in the database
	 *
	 * @access public
	 * @return void
	 * @since 0.9
	 */
	public function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or die( 'Invalid Token' );

		// Sanitize
		$db =  JFactory::getDBO();
		$task	= JRequest::getVar('task');
		$post 	= JRequest::get( 'post' );
		
		$elsettings =  booking_helper::config();
		
		//set POST variables
		$post_url = APPREGULATOR_URL."/index.php?option=com_appregulator&task=updateDrivenotCompany&tmpl=component";
		
		$company_url = rtrim(JURI::root(), '/');
		$tbversion = booking_helper::getTBVersion();
		$operation_area_vertices = $elsettings->operation_area_vertices;
		
		$services_provided = array();
		$is_hourly_rate_enabled = booking_helper::is_hourly_rate_enabled();
		$is_shuttles_enabled = booking_helper::is_shuttles_enabled();

		if( (int)$elsettings->show_address_tab==1 &&
		   ($elsettings->show_from_poi==1 || $elsettings->show_from_address==1) &&
		   ($elsettings->show_to_poi==1 || $elsettings->show_to_address==1))
		{
			$services_provided[] = 'address';
		}
		
		// check if there is any special offers route
		$has_any_route = false;
		$query = 'SELECT poi.*, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
			. ' WHERE r.published = 1'
			. ' ORDER BY poi.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
		
		if (!empty($rows))
		{
			$has_any_route = true;
		}
		if((int)$elsettings->show_offers_tab==1 && $has_any_route){
			$services_provided[] = 'offers';
		}
		
		if((int)$elsettings->show_hourly_tab==1 && $is_hourly_rate_enabled){
			$services_provided[] = 'hourly';
		}
		
		if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){
			$services_provided[] = 'shuttles';
		}
		
		$fields = array(
			'token'			=> urlencode('kanev'),
			'company_name'		=> urlencode($post['company_name']),
			'company_url'		=> urlencode($company_url),
			'operation_area_vertices'=> urlencode($operation_area_vertices),
			'services_provided'	=> urlencode(implode(',',$services_provided)),
			'tbversion'		=> urlencode($tbversion),
			'contact_person'	=> urlencode($post['contact_person']),
			'contact_email'	=> urlencode($post['contact_email']),
			'contact_phone'	=> urlencode($post['contact_phone']),
			'contact_address'	=> urlencode($post['contact_address']),
			'contact_city'	=> urlencode($elsettings->default_city),
			'contact_state'	=> urlencode($post['contact_state']),
			'contact_country'	=> urlencode($elsettings->default_country),
			'contact_zip'	=> urlencode($post['contact_zip']),
			'source'	=> urlencode('tbdrivenot'),
		);
		
		if(!empty($post['company_registration_number'])){
			$fields['company_registration_number'] = urlencode($post['company_registration_number']);
		}
		if(!empty($post['transportation_license_number'])){
			$fields['transportation_license_number'] = urlencode($post['transportation_license_number']);
		}
		
		// upload image
		$cropped_data  = JRequest::getVar('cropped_data', array(), 'post', 'array');
		$file_name   = $post['logo'];
		$is_logo_changed   = JRequest::getInt('is_logo_changed',0);
		if($is_logo_changed==1 && $file_name!="")
		{
			require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'simpleimage.php');
			$targetFile = JPATH_COMPONENT_SITE.DS.'uploads'.DS.'medium'.DS.$file_name;
			$image = new SimpleImage();
			$image->load($targetFile);
			$image->crop($cropped_data['x1'], $cropped_data['y1'], $cropped_data['w'], $cropped_data['h']);
			$image->save($targetFile);
			
			//Import filesystem libraries. Perhaps not necessary, but does not hurt
			jimport('joomla.filesystem.file');
			
			$filename_without_ext = pathinfo($targetFile, PATHINFO_FILENAME);
			$extension = strtolower(JFile::getExt($file_name));
			
			$fields['logofileurl'] = urlencode(JURI::root().'images/'.$file_name);
			$fields['filename'] = urlencode($file_name);
			$fields['filename_without_ext'] = urlencode($filename_without_ext);
			$fields['extension'] = urlencode($extension);
			
			$new_filepath = JPath::clean(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', $file_name)));
			JFile::move($targetFile, $new_filepath);
			JFile::delete(JPATH_COMPONENT_SITE.DS.'uploads'.DS.$file_name);
		}
		
		/*list($result, $message, $file_name, $filename_without_ext,$extension) = $this->_upload_files();
		if($result=='succeed')
		{
			$fields['logofileurl'] = urlencode(JURI::root().'images/'.$file_name);
			$fields['filename'] = urlencode($file_name);
			$fields['filename_without_ext'] = urlencode($filename_without_ext);
			$fields['extension'] = urlencode($extension);
		}*/
		
		//url-ify the data for the POST
		$fields_string = '';
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');
		
		//open connection
		$ch = curl_init();
		
		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL, $post_url);
		curl_setopt($ch,CURLOPT_POST, count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		
		//execute post
		$result = curl_exec($ch);
		
		$curl_errno = curl_errno($ch);
		$curl_error = curl_error($ch);
		if ($curl_errno > 0) {
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', "cURL Error ($curl_errno): $curl_error"));
			$this->setMessage($this->getError(), 'error');
		}
		else {
			$this->setMessage(JText::_('COM_TAXIBOOKING_SAVE_SUCCESS'));
			
			// send notification email to mkanev@gmail.com
			$this->_changeNotification($post);
		}
		
		//close connection
		curl_close($ch);
		
		$this->setRedirect(
			JRoute::_(
				'index.php?option=com_taxibooking&view=drivenot&layout=edit', false
			)
		);
	}
	
	private function _upload_files()
	{
		// Initialise variables.
		$app   = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_media');
		
		jimport( 'joomla.filesystem.file' );
		$file		= JRequest::getVar('logo', null, 'files', 'array'); 
		
		if (
			$_SERVER['CONTENT_LENGTH']>($params->get('upload_maxsize', 0) * 1024 * 1024) ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('upload_max_filesize'))* 1024 * 1024 ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('post_max_size'))* 1024 * 1024 ||
			$_SERVER['CONTENT_LENGTH']>(int)(ini_get('memory_limit'))* 1024 * 1024
		)
		{
			return array('failed', JText::_('DRIVENOT_ERROR_WARNFILETOOLARGE'), '', '','');
		}
		
		$file_name = '';
		
		// Perform basic checks on file info before attempting anything
		if (empty($file['name']))
		{
			// No filename (after the name was cleaned by JFile::makeSafe)
			return array('failed', JText::_('DRIVENOT_ERROR_UPLOAD_INPUT'), '', '','');
		}
		if ($file['error']==1)
		{
			return array('failed', JText::_('DRIVENOT_ERROR_WARNFILETOOLARGE'), '', '','');
		}
		
		$maxSize = (int) ($params->get('upload_maxsize', 0) * 1024 * 1024);
		if ($maxSize > 0 && (int) $file['size'] > $maxSize)
		{
			return array('failed', JText::_('DRIVENOT_ERROR_WARNFILETOOLARGE'), '', '','');
		}
		
		$filename_without_ext = pathinfo($file['name'], PATHINFO_FILENAME);
		
		$format = strtolower(JFile::getExt($file['name']));
		$allowable = explode(',', $params->get('upload_extensions'));
		if (!in_array($format, $allowable))
		{
			return array('failed', JText::_('DRIVENOT_ERROR_WARNFILETYPE'), '', '','');
		}
		
		$file['name'] = JFile::makeSafe($file['name']);
		$newfilepath = JPath::clean(implode(DS, array(JPATH_ROOT, 'images', $file['name'])));
		
		if (!JFile::upload($file['tmp_name'], $newfilepath))
		{
			// Error in upload
			return array('failed', JText::_('DRIVENOT_ERROR_UNABLE_TO_UPLOAD_FILE'), '', '','');
		}
		else {
			$result = 'succeed';
			$message = '';
			$file_name = $file['name'];
			return array('succeed', '', $file_name, $filename_without_ext,$format);
		}
		
		$file_name = $file['name'];
		return array('succeed', '', $file_name, '','');
	}
	
	/**
	* Send Email to item submitter
	*
	* @access	public
	*/
	private function _changeNotification($post)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$config = JFactory::getConfig();
		$db =  JFactory::getDBO();
		$uri	= JURI::getInstance();
		$base	= $uri->toString(array('scheme', 'host', 'port'));
		
		// Compile the notification mail values.
		$data = array();
		$data['fromname']	= $config->get('fromname');
		$data['mailfrom']	= $config->get('mailfrom');
		$data['sitename']	= $config->get('sitename');
		$data['siteurl']	= JUri::root();
	
		$emailSubject	= JText::sprintf(
			'DRIVENOT_EMAIL_NEW_ITEM_SUBJECT',
			$data['sitename']
		);
		
		$admin_item_url = APPREGULATOR_URL.'/administrator/index.php?option=com_appregulator&task=item.edit&id='.$post['company_id'];
		
		$emailBody = JText::sprintf(
			'DRIVENOT_EMAIL_ADMIN_NEW_ITEM_BODY',
			$post['company_name'],
			$admin_item_url
		);
		
		// now send the email
		$mail =  JFactory::getMailer();
		$mail->setSender(array($data['mailfrom'], $data['fromname']));
		$mail->setSubject($emailSubject);
		$mail->setBody($emailBody);
		$mail->IsHTML(true);
		$mail->addRecipient('mkanev@gmail.com');
		//$mail->addBCC('unorina@gmail.com');
		$sent = $mail->Send();
	
		return true;
	}
}