<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

/**
 * Component Item Controller
 */
class TaxiBookingControllerTbusers extends TaxiBookingController
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_TAXIBOOKING';
	/**
	 * The context for storing internal data, e.g. record.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $context;
	/**
	 * The URL option for the component.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $option;

	/**
	 * The URL view item variable.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $view_item;

	/**
	 * The URL view list variable.
	 *
	 * @var    string
	 * @since  12.2
	 */
	protected $view_list;
	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	function __construct()
	{
		parent::__construct();
		
		$this->context = 'tbuser';
		// Guess the option as com_NameOfController
		if (empty($this->option))
		{
			$this->option = 'com_taxibooking';
		}
		// Guess the item view as the context.
		if (empty($this->view_item))
		{
			$this->view_item = 'tbuser';
		}
		// Guess the list view as the plural of the item view.
		if (empty($this->view_list))
		{
			$this->view_list = 'tbusers';
		}
		
		// Define standard task mappings.
		$this->registerTask( 'apply', 			'save' );
		$this->registerTask( 'save2copy', 		'save' );
		
		// Value = 0
		$this->registerTask('unpublish', 'publish');
		// Value = 2
		$this->registerTask('archive', 'publish');
		// Value = -2
		$this->registerTask('trash', 'publish');
		// Value = -3
		$this->registerTask('orderup', 'reorder');
		$this->registerTask('orderdown', 'reorder');
	}
	
	/**
	 * Method to add a new record.
	 *
	 * @return  mixed  True if the record can be added, a error object if not.
	 *
	 * @since   12.2
	 */
	public function add()
	{
		$app = JFactory::getApplication();
		$context = "$this->option.edit.$this->context";

		// Access check.
		if (!$this->allowAdd())
		{
			// Set the internal error and also the redirect error.
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Clear the record edit information from the session.
		$app->setUserState($context . '.data', null);

		// Redirect to the edit screen.
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_item
				. $this->getRedirectToItemAppend(), false
			)
		);

		return true;
	}

	/**
	 * Method to check if you can add a new record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return ($user->authorise('core.create', $this->option));
	}

	/**
	 * Method to cancel an edit.
	 *
	 * @param   string  $key  The name of the primary key of the URL variable.
	 *
	 * @return  boolean  True if access level checks pass, false otherwise.
	 *
	 * @since   12.2
	 */
	public function cancel()
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app = JFactory::getApplication();
		$model = $this->getModel('tbuser');
		$table = $model->getTable();
		$checkin = property_exists($table, 'checked_out');
		$context = "$this->option.edit.$this->context";

		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		$recordId = $app->input->getInt($key);

		// Attempt to check-in the current record.
		if ($recordId)
		{
			if ($checkin)
			{
				if ($model->checkin($recordId) === false)
				{
					// Check-in failed, go back to the record and display a notice.
					$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
					$this->setMessage($this->getError(), 'error');

					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend($recordId, $key), false
						)
					);

					return false;
				}
			}
		}

		// Clean the session data and redirect.
		$this->releaseEditId($context, $recordId);
		$app->setUserState($context . '.data', null);

		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list
				. $this->getRedirectToListAppend(), false
			)
		);

		return true;
	}
	/**
	 * Method to check if you can add a new record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		return JFactory::getUser()->authorise('core.edit', 'com_taxibooking');
	}
	
	/**
	 * Logic to create the view for edit order
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function edit($key = null, $urlVar = null)
	{
		$app   = JFactory::getApplication();
		$model = $this->getModel('tbuser');
		$table = $model->getTable();
		$cid	= JRequest::getVar( 'cid', array(0), 'get', 'array' );
		$context = "$this->option.edit.$this->context";
		
		// Determine the name of the primary key for the data.
		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		// To avoid data collisions the urlVar may be different from the primary key.
		if (empty($urlVar))
		{
			$urlVar = $key;
		}

		// Get the previous record id (if any) and the current record id.
		$recordId = (int) (count($cid) ? $cid[0] : $app->input->getInt($urlVar));
		$checkin = property_exists($table, 'checked_out');

		// Access check.
		if (!$this->allowEdit(array($key => $recordId), $key))
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Attempt to check-out the new record for editing and redirect.
		if ($checkin && !$model->checkout($recordId))
		{
			// Check-out failed, display a notice but allow the user to see the record.
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKOUT_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
		else
		{
			// Check-out succeeded, push the new record id into the session.
			$this->holdEditId($context, $recordId);
			$app->setUserState($context . '.data', null);

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return true;
		}
	}
	
        /**
	 * Logic to save an order
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function save($key = null, $urlVar = null)
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app   = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$date = JFactory::getDate();
		$model = $this->getModel('tbuser');
		$table = $model->getTable();
		$post = JRequest::get( 'post' );
		$post['text'] = JRequest::getVar( 'text', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$checkin = property_exists($table, 'checked_out');
		$task = $this->getTask();
		$elsettings 	= booking_helper::config();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		$isNew  = ($post['id'] == 0);

		// Determine the name of the primary key for the data.
		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		// To avoid data collisions the urlVar may be different from the primary key.
		if (empty($urlVar))
		{
			$urlVar = $key;
		}

		$recordId = JRequest::getInt($urlVar);
		
		$new_user_data = array('name' => $post['name'],
				       'email' => $post['email']
				       );
		list($juser_exist, $jUser) = $this->_createUserAccount($new_user_data);
		
		// if user already exists, warn admin
		/*if($juser_exist){
			// Save the data in the session.
			$app->setUserState($this->context . '.data', $post);
			
			$this->setError(JText::_('TBUSERS_NEW_USER_EXISTS_ERROR'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}*/
		
		if($jUser){
			$post['user_id'] = $jUser->id;
			
			// check if this email is already added in TB User
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_users');
			$query->where('email = '.$db->Quote($post['email']));
			$db->setQuery((string)$query);
			$tbUser = $db->loadObject();
			
			if($tbUser){
				$post['id'] = $tbUser->id;
			}
		}
		else {
			// Save the data in the session.
			$app->setUserState($this->context . '.data', $post);

			// Check-in failed, so go back to the record and display a notice.
			$this->setError(JText::_('TBUSERS_NEW_USER_CREATE_ERROR'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
		
		// upload image
		$cropped_data  = JRequest::getVar('cropped_data', array(), 'post', 'array');
		$file_name   = JRequest::getVar('new_photo','');
		$is_logo_changed   = JRequest::getInt('is_photo_changed',0);
		if($is_logo_changed==1 && $file_name!="")
		{
			require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'simpleimage.php');
			$targetFile = JPATH_COMPONENT_SITE.DS.'uploads'.DS.'medium'.DS.$file_name;
			$image = new SimpleImage();
			$image->load($targetFile);
			$image->crop($cropped_data['x1'], $cropped_data['y1'], $cropped_data['w'], $cropped_data['h']);
			$image->save($targetFile);
			
			jimport( 'joomla.filesystem.folder' );
			JFolder::create(JPATH_ROOT.DS."images".DS."taxibooking".DS."userphoto");
			
			//Import filesystem libraries. Perhaps not necessary, but does not hurt
			jimport('joomla.filesystem.file');
			
			$post['photo'] = 'images/taxibooking/userphoto/'.$file_name;
			
			$new_filepath = JPath::clean(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'taxibooking', 'userphoto', $file_name)));
			JFile::move($targetFile, $new_filepath);
			JFile::delete(JPATH_COMPONENT_SITE.DS.'uploads'.DS.$file_name);
		}
		
		if ( $model->save($post) ) {
			
			// Save succeeded, so check-in the record.
			if ($checkin && $model->checkin($recordId) === false)
			{
				// Save the data in the session.
				$app->setUserState($this->context . '.data', $post);
	
				// Check-in failed, so go back to the record and display a notice.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
				$this->setMessage($this->getError(), 'error');
	
				$this->setRedirect(
					JRoute::_(
						'index.php?option=' . $this->option . '&view=' . $this->view_item
						. $this->getRedirectToItemAppend($recordId, $urlVar), false
					)
				);
	
				return false;
			}
			
			// rename image uploaded and update image field in user database for this new user
			// as image uploaded name is user_.jpg, should be something like user_665.jpg
			$recordId = $model->getState($this->context . '.id');
			
			if($isNew){
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_users');
				$query->where('id = '.(int) $recordId);
				$db->setQuery((string)$query);
				$tbuser = $db->loadObject();
				
				$file_path_parts = pathinfo($new_filepath);
				$ext = $file_path_parts['extension'];

				rename($new_filepath, JPath::clean(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'taxibooking', 'userphoto', 'user_'.$tbuser->user_id.'.'.$ext))) );
				
				$temp = new stdClass();
				$temp->id = $recordId;
				$temp->photo = 'images/taxibooking/userphoto/user_'.$tbuser->user_id.'.'.$ext;
				$db->updateObject('#__taxibooking_users', $temp, 'id');
			}
			
			// check if this user is set as corporate client and is added in tbcorporate_clients database
			$path = JPATH_ROOT.DS."components".DS."com_tbcorporate";
			if(file_exists ( $path.DS.'tbcorporate.php' ))
			{
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_users');
				$query->where('id = '.(int) $recordId);
				$db->setQuery((string)$query);
				$tbuser = $db->loadObject();
				
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__tbcorporate_clients');
				$query->where('user_id = '.(int)$tbuser->user_id);
				$db->setQuery((string)$query);
				$tbclient = $db->loadObject();
				
				// always remove the old child users for this parent client
				$query = 'DELETE FROM `#__taxibooking_user_childs` WHERE `parent_user_id` = '.$db->quote($tbuser->user_id);
				$db->setQuery($query);
				$db->execute();
				
				if((int)$post['is_corporate_client']==1)
				{
					if($tbclient){
						
					}
					else {
						$temp = new stdClass();
						$temp->user_id = $tbuser->user_id;
						$temp->name = $tbuser->name;
						$temp->email = $tbuser->email;
						$temp->phone = $tbuser->phone;
						$temp->created = $date->toSQL();
						
						$db->insertObject('#__tbcorporate_clients', $temp);
					}
					
					// add child clients to database
					if(!empty($post['child_clients']))
					{
						$child_clients = array_unique($post['child_clients']);
						foreach($child_clients as $child_client_id)
						{
							$temp = new stdClass();
							$temp->parent_user_id = $tbuser->user_id;
							$temp->child_user_id = $child_client_id;
							$temp->created = $date->toSQL();
							
							$db->insertObject('#__taxibooking_user_childs', $temp);
						}
					}
				}
				else {
					if($tbclient){
						$query = 'DELETE FROM `#__tbcorporate_client_invoices` WHERE `client_id` = '.$db->quote($tbclient->id);
						$db->setQuery($query);
						$db->execute();
						
						$query = 'DELETE FROM `#__tbcorporate_clients` WHERE `id` = '.$db->quote($tbclient->id);
						$db->setQuery($query);
						$db->execute();
					}
					else {
						
					}
				}
			}
			
			$this->setMessage(JText::_('COM_TAXIBOOKING_SAVE_SUCCESS'));
			
			// Redirect the user and adjust session state based on the chosen task.
			switch ($task)
			{
				case 'apply':
					// Set the record data in the session.
					$recordId = $model->getState($this->context . '.id');
					$this->holdEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);
					$model->checkout($recordId);
	
					// Redirect back to the edit screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend($recordId, $urlVar), false
						)
					);
					break;
	
				case 'save2new':
					// Clear the record id and data from the session.
					$this->releaseEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);
	
					// Redirect back to the edit screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_item
							. $this->getRedirectToItemAppend(null, $urlVar), false
						)
					);
					break;
	
				default:
					// Clear the record id and data from the session.
					$this->releaseEditId($this->context, $recordId);
					$app->setUserState($this->context . '.data', null);
	
					// Redirect to the list screen.
					$this->setRedirect(
						JRoute::_(
							'index.php?option=' . $this->option . '&view=' . $this->view_list
							. $this->getRedirectToListAppend(), false
						)
					);
					break;
			}
			
			return true;

		} else {
			// Redirect back to the edit screen.
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
	}
	
	/**
	* Create user account silently
	*
	* @access	public
	* @since	1.0
	*/
	private function _createUserAccount($new_user_data = array())
	{
		//initialise variables
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$config = JFactory::getConfig();
		$user_params	= JComponentHelper::getParams('com_users');
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__users');
		$query->where('email = '.$db->Quote($new_user_data['email']));
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row){
			$temp = new stdClass();
			$temp->id = $row->id;
			$temp->name = $new_user_data['name'];
			$db->updateObject('#__users', $temp, 'id');
			
			return array(true,$row);
		}
		else {
			// Initialise the table with JUser.
			$user = new JUser;
			
			// Prepare the data for the user object.
			$data = array();
			$data['name']	        = $new_user_data['name'];
			$data['username']	= $new_user_data['email'];
			$data['email']		= $new_user_data['email'];
			$data['password']	= JUserHelper::genRandomPassword();
			$data['activation'] = '';
			$data['block'] = 0;
			
			// Get the groups the user should be added to after registration.
			$data['groups'] = array();
		
			// Get the default new user group, Registered if not specified.
			$data['groups'][] = $user_params->get('new_usertype', 2);
			
			// Bind the data.
			if (!$user->bind($data)) {
			    return false;
			}
			
			// Store the data.
			if (!$user->save()) {
			    return false;
			}
			
			// Compile the notification mail values.
			$data['fromname']	= $config->get('fromname');
			$data['mailfrom']	= $config->get('mailfrom');
			$data['sitename']	= $config->get('sitename');
			$data['siteurl']	= JUri::root();
			$data['password_clear']	= $user->password_clear;
		
			$emailSubject	= JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);
		
			$emailBody = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_BODY',
				$data['name'],
				$data['sitename'],
				$data['siteurl'],
				$data['username'],
				$data['password_clear']
			);
			
			// Send the registration email.
			$return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody);
		
			//Send Notification mail to administrators
			$emailSubject = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);
		
			$emailBodyAdmin = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY',
				$data['name'],
				$data['username'],
				$data['siteurl']
			);
		
			// get all admin users
			$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE sendEmail=1';
			$db->setQuery( $query );
			$rows = $db->loadObjectList();
			
			// Send mail to all superadministrators id
			foreach( $rows as $row )
			{
			    $return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $row->email, $emailSubject, $emailBodyAdmin);
			}
			return array(false,$user);
		}
	}
	
	/**
	 * Method to publish a list of items
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	public function publish()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		// Get items to publish from the request.
		$cid	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$data = array('publish' => 1, 'unpublish' => 0, 'archive' => 2, 'trash' => -2, 'report' => -3);
		$task = $this->getTask();
		$value = JArrayHelper::getValue($data, $task, 0, 'int');

		if (empty($cid))
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Get the model.
			$model = $this->getModel('tbuser');

			// Make sure the item ids are integers
			JArrayHelper::toInteger($cid);

			// Publish the items.
			try
			{
				$model->publish($cid, $value);

				if ($value == 1)
				{
					$ntext = $this->text_prefix . '_N_ITEMS_PUBLISHED';
				}
				elseif ($value == 0)
				{
					$ntext = $this->text_prefix . '_N_ITEMS_UNPUBLISHED';
				}
				elseif ($value == 2)
				{
					$ntext = $this->text_prefix . '_N_ITEMS_ARCHIVED';
				}
				else
				{
					$ntext = $this->text_prefix . '_N_ITEMS_TRASHED';
				}
				$this->setMessage(JText::plural($ntext, count($cid)));
			}
			catch (Exception $e)
			{
				$this->setMessage(JText::_('JLIB_DATABASE_ERROR_ANCESTOR_NODES_LOWER_STATE'), 'error');
			}
		}
		
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
	}
	
	/**
	 * Changes the order of one or more records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function reorder()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$ids	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$inc = ($this->getTask() == 'orderup') ? -1 : 1;

		$model = $this->getModel('tbuser');
		$return = $model->reorder($ids, $inc);
		if ($return === false)
		{
			// Reorder failed.
			$message = JText::sprintf('JLIB_APPLICATION_ERROR_REORDER_FAILED', $model->getError());
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
			return false;
		}
		else
		{
			// Reorder succeeded.
			$message = JText::_('JLIB_APPLICATION_SUCCESS_ITEM_REORDERED');
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message);
			return true;
		}
	}

	/**
	 * Method to save the submitted ordering values for records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function saveorder()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get the input
		$pks	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$order	= JRequest::getVar( 'order', array(), 'post', 'array' );

		// Sanitize the input
		JArrayHelper::toInteger($pks);
		JArrayHelper::toInteger($order);

		// Get the model
		$model = $this->getModel('tbuser');

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return === false)
		{
			// Reorder failed
			$message = JText::sprintf('JLIB_APPLICATION_ERROR_REORDER_FAILED', $model->getError());
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
			return false;
		}
		else
		{
			// Reorder succeeded.
			$this->setMessage(JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED'));
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
			return true;
		}
	}

	/**
	 * Logic to delete items
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	public function remove()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

		// Get items to remove from the request.
		$cid		= JRequest::getVar( 'cid', array(), 'post', 'array' );

		if (!is_array($cid) || count($cid) < 1)
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Get the model.
			$model = $this->getModel('tbuser');

			// Make sure the item ids are integers
			jimport('joomla.utilities.arrayhelper');
			JArrayHelper::toInteger($cid);
			
			// remove client invoices if necessary
			$path = JPATH_ROOT.DS."components".DS."com_tbcorporate";
			if(file_exists ( $path.DS.'tbcorporate.php' ))
			{
				$db =  JFactory::getDBO();
				foreach ($cid as $pk)
				{
					$query = $db->getQuery(true);
					$query->select('*');
					$query->from('#__taxibooking_users');
					$query->where('id = '.(int) $pk);
					$db->setQuery((string)$query);
					$tbuser = $db->loadObject();
					
					$query = $db->getQuery(true);
					$query->select('*');
					$query->from('#__tbcorporate_clients');
					$query->where('user_id = '.(int)$tbuser->user_id);
					$db->setQuery((string)$query);
					$tbclient = $db->loadObject();
					if((int)$tbuser->is_corporate_client==1 && $tbclient)
					{
						$query = 'DELETE FROM `#__tbcorporate_client_invoices` WHERE `client_id` = '.$db->quote($tbclient->id);
						$db->setQuery($query);
						$db->execute();
						
						$query = 'DELETE FROM `#__tbcorporate_clients` WHERE `id` = '.$db->quote($tbclient->id);
						$db->setQuery($query);
						$db->execute();
					}
				}
			}

			// Remove the items.
			if ($model->delete($cid))
			{
				$this->setMessage(JText::plural($this->text_prefix . '_N_ITEMS_DELETED', count($cid)));
			}
			else
			{
				$this->setMessage($model->getError());
			}
		}
		
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
	}
	
	/**
	 * Check in of one or more records.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   12.2
	 */
	public function checkin()
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$ids		= JRequest::getVar( 'cid', array(), 'post', 'array' );

		$model = $this->getModel('tbuser');
		$return = $model->checkin($ids);
		if ($return === false)
		{
			// Checkin failed.
			$message = JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError());
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
			return false;
		}
		else
		{
			// Checkin succeeded.
			$message = JText::plural($this->text_prefix . '_N_ITEMS_CHECKED_IN', count($ids));
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message);
			return true;
		}
	}
	
	/**
        * Method to save the submitted ordering values for records via AJAX.
        *
        * @return  void
        *
        * @since   3.0
        */
	public function saveOrderAjax()
	{
		// Get the input
		$pks = JFactory::getApplication()->input->post->get('cid', array(), 'array');
		$order = JFactory::getApplication()->input->post->get('order', array(), 'array');
    
		// Sanitize the input
		JArrayHelper::toInteger($pks);
		JArrayHelper::toInteger($order);
    
		// Get the model
		$model = $this->getModel('tbuser');
    
		// Save the ordering
		$return = $model->saveorder($pks, $order);
    
		if ($return)
		{
			echo "1";
		}
    
		// Close the application
		JFactory::getApplication()->close();
	}
	
	/**
	 * Method to clone an existing module.
	 * @since	1.6
	 */
	public function syncJoomlaUsers()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$app	= JFactory::getApplication();
		$db = JFactory::getDBO();
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__users');
		$db->setQuery((string)$query);
		$juserIds = $db->loadColumn();
		//print_r($juserIds);
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_users');
		$db->setQuery((string)$query);
		$tbuserIds = $db->loadColumn(1);
		//print_r($tbuserIds);
		
		$users_update = array_intersect($juserIds, $tbuserIds);
		
		$users_create = array_diff($juserIds, $tbuserIds);
		
		$users_delete = array_diff($tbuserIds, $juserIds);
		//die(print_r($users_create));
		
		if(!empty($users_create))
		{
			foreach($users_create as $user_create)
			{
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__users');
				$query->where('id = '.(int)$user_create);
				$db->setQuery((string)$query);
				$juserObj = $db->loadObject();
				
				$query = $db->getQuery(true);
				$temp = new stdClass();
				$temp->user_id = $juserObj->id;
				$temp->name = $juserObj->name;
				$temp->email = $juserObj->email;
				$temp->created = $date->toSql();
				$temp->created_by = $user->get('id');
				$db->insertObject('#__taxibooking_users', $temp);
			}
		}
		
		if(!empty($users_delete))
		{
			foreach($users_delete as $user_delete)
			{
				$query = 'DELETE FROM `#__taxibooking_users` WHERE `user_id` = '.$db->quote($user_delete);
				$db->setQuery($query);
				$db->execute();
				
				$query = 'DELETE FROM `#__taxibooking_user_addresses` WHERE `user_id` = '.$db->quote($user_delete);
				$db->setQuery($query);
				$db->execute();
				
				$query = 'DELETE FROM `#__taxibooking_user_childs` WHERE `parent_user_id` = '.$db->quote($user_delete);
				$db->setQuery($query);
				$db->execute();
			}
		}

		$this->setMessage(JText::_('TBUSERS_JOOMLA_USERS_SYNCHRONIZE_SUCCESS'));
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
		return true;
	}
	
	public function checkEmailAjax()
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		
		$email		= JRequest::getVar( 'email', '', 'post' );
		
		$json_result = array('error' => 0, 'msg' => '');
	
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__users');
		$query->where('email = '.$db->Quote($email));
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row){
			$json_result = array('error' => 1, 'msg' => JText::_('TBUSERS_NEW_USER_EXISTS_ERROR'));
		}
		
		echo json_encode($json_result);
		exit();
	}
	
	/**
	 * Gets the URL arguments to append to an item redirect.
	 *
	 * @param   integer  $recordId  The primary key id for the item.
	 * @param   string   $urlVar    The name of the URL variable for the id.
	 *
	 * @return  string  The arguments to append to the redirect URL.
	 *
	 * @since   12.2
	 */
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
		$tmpl   = JFactory::getApplication()->input->get('tmpl');
		$layout = JFactory::getApplication()->input->get('layout', 'edit', 'string');
		$append = '';

		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}

		if ($layout)
		{
			$append .= '&layout=' . $layout;
		}

		if ($recordId)
		{
			$append .= '&' . $urlVar . '=' . $recordId;
		}
		
		$field = JFactory::getApplication()->input->get('field', '');
		if ($field!="")
		{
			$append .= '&field=' . $field;
		}

		return $append;
	}
	
	/**
	* Gets the URL arguments to append to a list redirect.
	*
	* @return  string  The arguments to append to the redirect URL.
	*
	* @since   12.2
	*/
	protected function getRedirectToListAppend()
	{
		$tmpl = JFactory::getApplication()->input->get('tmpl');
		$append = '';
    
		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}
		
		$layout = JFactory::getApplication()->input->get('layout', '');
		if ($layout!="")
		{
			$append .= '&layout=' . $layout;
		}
		
		$field = JFactory::getApplication()->input->get('field', '');
		if ($field!="")
		{
			$append .= '&field=' . $field;
		}
   
	       return $append;
	}
}