<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

if(!class_exists('JElement')) require(JPATH_COMPONENT.DS.'helpers'.DS.'element.php' );

class JElementCurrencyList extends JElement {

	/**
	 * Element name
	 *
	 * @access    protected
	 * @var        string
	 */
	var $_name = 'CurrencyList';
	
	public function render(&$xmlElement, $value, $control_name = 'params')
	{
		$name = $xmlElement['name'];
		$label = $xmlElement['label'];
		$descr = $xmlElement['description'];

		//make sure we have a valid label
		$label = $label ? $label : $name;
		$result[0] = $this->fetchTooltip($label, $descr, $xmlElement, $control_name, $name);
		$result[1] = $this->fetchElement($name, $value, $xmlElement, $control_name);
		$result[2] = $descr;
		$result[3] = $label;
		$result[4] = $value;
		$result[5] = $name;

		return $result;
	}

	public function fetchElement($name, $value, &$node, $control_name)
	{
		$ctrl = $control_name . '[' . $name . ']';
		$attribs = ' ';
		
		if ($v = $node['size'])
		{
			$attribs .= 'size="' . $v . '"';
		}
		if ($v = $node['class'])
		{
			$attribs .= 'class="' . $v . '"';
		}
		else
		{
			$attribs .= 'class="inputbox"';
		}
		
		$db = JFactory::getDBO();
		$query = 'SELECT `currency_id`, `currency_code`, `currency_name`'
                        . ' FROM #__taxibooking_currency'
                        . ' ORDER BY `currency_name` ASC'
                        ;
                $db->setQuery($query);
                $rows = $db->loadObjectList();
                
		$currency_options = array();
                $currency_options[] = JHTML::_('select.option',  '', JText::_( 'SELECT CURRENCY' ) );
                if(!empty($rows)){
                    foreach ($rows as $row){
                        $currency_options[] = JHTML::_('select.option',  $row->currency_code, $row->currency_name );
                    }
                }
		
		return JHtml::_(
			'select.genericlist',
			$currency_options,
			$ctrl,
			array('id' => $control_name . $name, 'list.attr' => $attribs, 'list.select' => $value)
		);
	}
}