<?php
/**
 * @package     Joomla.Platform
 * @subpackage  HTML
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

if(!class_exists('JElement')) require(JPATH_COMPONENT.DS.'helpers'.DS.'element.php' );

/**
 * Renders a list element
 *
 * @package     Joomla.Platform
 * @subpackage  Parameter
 * @since       11.1
 * @deprecated  Use JFormFieldList instead
 */
class JElementList extends JElement
{
	/**
	 * Element type
	 *
	 * @var    string
	 */
	protected $_name = 'List';

	/**
	 * Get the options for the element
	 *
	 * @param   JXMLElement  &$node  JXMLElement node object containing the settings for the element
	 *
	 * @return  array
	 *
	 * @since   11.1
	 *
	 * @deprecated  12.1  Use JFormFieldList::getOptions Instead
	 */
	protected function _getOptions(&$node)
	{
		$options = array();
		
		foreach ($node->option as $option)
		{
			$val = $option['value'];
			$text = $option[0];
			$options[] = JHtml::_('select.option', $val, JText::_($text));
		}
		return $options;
	}
	
	public function render(&$xmlElement, $value, $control_name = 'params')
	{
		$name = $xmlElement['name'];
		$label = $xmlElement['label'];
		$descr = $xmlElement['description'];

		//make sure we have a valid label
		$label = $label ? $label : $name;
		$result[0] = $this->fetchTooltip($label, $descr, $xmlElement, $control_name, $name);
		$result[1] = $this->fetchElement($name, $value, $xmlElement, $control_name);
		$result[2] = $descr;
		$result[3] = $label;
		$result[4] = $value;
		$result[5] = $name;

		return $result;
	}

	/**
	 * Fetch the HTML code for the parameter element.
	 *
	 * @param   string             $name          The field name.
	 * @param   mixed              $value         The value of the field.
	 * @param   JSimpleXMLElement  &$node         The current JSimpleXMLElement node.
	 * @param   string             $control_name  The name of the HTML control.
	 *
	 * @return  string
	 *
	 * @deprecated    12.1
	 * @since   11.1
	 */
	public function fetchElement($name, $value, &$node, $control_name)
	{
		$ctrl = $control_name . '[' . $name . ']';
		$attribs = ' ';

		if ($v = $node['size'])
		{
			$attribs .= 'size="' . $v . '"';
		}
		if ($v = $node['class'])
		{
			$attribs .= 'class="' . $v . '"';
		}
		else
		{
			$attribs .= 'class="inputbox"';
		}
		if ($m = $node['multiple'])
		{
			$attribs .= 'multiple="multiple"';
			$ctrl .= '[]';
		}

		return JHtml::_(
			'select.genericlist',
			$this->_getOptions($node),
			$ctrl,
			array('id' => $control_name . $name, 'list.attr' => $attribs, 'list.select' => $value)
		);
	}
}
