<?php
/**
 * @package     Joomla.Platform
 * @subpackage  HTML
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

if(!class_exists('JElement')) require(JPATH_COMPONENT.DS.'helpers'.DS.'element.php' );

/**
 * Renders a textarea element
 *
 * @package     Joomla.Platform
 * @subpackage  Parameter
 * @since       11.1
 * @deprecated  12.1   Use JFormFieldTextArea instead
 */
class JElementTextarea extends JElement
{
	/**
	 * Element name
	 *
	 * @var    string
	 */
	protected $_name = 'Textarea';
	
	public function render(&$xmlElement, $value, $control_name = 'params')
	{
		$name = $xmlElement['name'];
		$label = $xmlElement['label'];
		$descr = $xmlElement['description'];

		//make sure we have a valid label
		$label = $label ? $label : $name;
		$result[0] = $this->fetchTooltip($label, $descr, $xmlElement, $control_name, $name);
		$result[1] = $this->fetchElement($name, $value, $xmlElement, $control_name);
		$result[2] = $descr;
		$result[3] = $label;
		$result[4] = $value;
		$result[5] = $name;

		return $result;
	}

	/**
	 * Fetch the element
	 *
	 * @param   string       $name          Element name
	 * @param   string       $value         Element value
	 * @param   JXMLElement  &$node         JXMLElement node object containing the settings for the element
	 * @param   string       $control_name  Control name
	 *
	 * @return  string
	 *
	 * @deprecated  12.1  Use JFormFieldTextArea::getInput
	 * @since   11.1
	 */
	public function fetchElement($name, $value, &$node, $control_name)
	{
		$rows = $node['rows'];
		$cols = $node['cols'];
		$class = ($node['class'] ? 'class="' . $node['class'] . '"' : 'class="text_area"');
		// Convert <br /> tags so they are not visible when editing
		$value = str_replace('<br />', "\n", $value);

		return '<textarea name="' . $control_name . '[' . $name . ']" cols="' . $cols . '" rows="' . $rows . '" ' . $class . ' id="' . $control_name
			. $name . '" >' . $value . '</textarea>';
	}
}
