<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

if(!class_exists('JElement')) require(JPATH_COMPONENT.DS.'helpers'.DS.'element.php' );

class JElementUsergroup extends JElement
{
	/**
	 * Element name
	 *
	 * @access    protected
	 * @var        string
	 */
	var $_name = 'Usergroup';
	
	public function render(&$xmlElement, $value, $control_name = 'params')
	{
		$name = $xmlElement['name'];
		$label = $xmlElement['label'];
		$descr = $xmlElement['description'];

		//make sure we have a valid label
		$label = $label ? $label : $name;
		$result[0] = $this->fetchTooltip($label, $descr, $xmlElement, $control_name, $name);
		$result[1] = $this->fetchElement($name, $value, $xmlElement, $control_name);
		$result[2] = $descr;
		$result[3] = $label;
		$result[4] = $value;
		$result[5] = $name;

		return $result;
	}

	public function fetchElement($name, $value, &$node, $control_name)
	{
		$ctrl = $control_name . '[' . $name . '][]';
		$attribs = ' ';
		
		if ($v = $node['size'])
		{
			$attribs .= 'size="' . $v . '"';
		}
		if ($v = $node['class'])
		{
			$attribs .= 'class="' . $v . '"';
		}
		else
		{
			$attribs .= 'class="inputbox"';
		}
		
		$attribs .= ' size="8"';
		$attribs .= ' multiple';
		
		return JHtml::_('access.usergroup', $ctrl, $value, $attribs, array(), $control_name . $name);
	}
}
