<?php

defined('_JEXEC') or die('Restricted access');

class TbParameters extends JRegistry {

	//	/** @var string Path to the xml setup file */
	var $_path = null;
	//	/** @var string The type of setup file */
	var $_type = null;
	var $_group = '_default';
	
	/**
	 * @var    string  The raw params string
	 * @since  11.1
	 */
	protected $_raw = null;
	/**
	 * @var    object  The XML params element
	 * @since  11.1
	 */
	protected $_xml = null;

	/**
	 * @var    array  Loaded elements
	 * @since  11.1
	 */
	protected $_elements = array();

	/**
	 * @var    array  Directories, where element types can be stored
	 * @since  11.1
	 */
	protected $_elementPath = array();

	/**
	 * Constructor
	 *
	 * @access	protected
	 * @param	string The raw parms text
	 * @param	string payment_element payment element name
	 * @since	1.5
	 */
	function __construct($data, $element = '', $type='component', $pluginfolder ) {
		
		$lang = JFactory::getLanguage();
		$lang->load('plg_'.$pluginfolder.'_' . $element,JPATH_ADMINISTRATOR);
		
		$path = JPATH_PLUGINS . DS . $pluginfolder . DS . basename($element). DS . basename($element) . '.xml';
		
		parent::__construct($data);
		
		// Set base path.
		$this->_elementPath[] = dirname(dirname(__FILE__)) . '/elements';
		if ($path)
		{
			$this->loadSetupFile($path);
		}
		$this->_raw = $data;
		
		$this->_type = $type;
		
		$this->bind($data);
	}
	
	/**
	 * Loads an XML setup file and parses it.
	 *
	 * @param   string  $path  A path to the XML setup file.
	 *
	 * @return  object
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function loadSetupFile($path)
	{
		$result = false;

		if ($path)
		{
			$xml = JFactory::getXML($path);
			$this->setXML($xml);
			$result = true;
		}

		return $result;
	}
	
	/**
	 * Sets the XML object from custom XML files.
	 *
	 * @param   JSimpleXMLElement  &$xml  An XML object.
	 *
	 * @return  void
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function setXML(&$xml)
	{
		if (is_object($xml))
		{
			if ($group = $xml->attributes()->group)
			{
				$group = (string)$group;
				$this->_xml[$group] = $xml;
			}
			else
			{
				$this->_xml['_default'] = $xml;
			}

			if ($dir = $xml->attributes()->addpath)
			{
				$this->addElementPath(JPATH_ROOT . str_replace('/', DS, $dir));
			}
		}
	}
	/**
	 * Add a directory where JParameter should search for element types.
	 *
	 * You may either pass a string or an array of directories.
	 *
	 * JParameter will be searching for a element type in the same
	 * order you added them. If the parameter type cannot be found in
	 * the custom folders, it will look in
	 * JParameter/types.
	 *
	 * @param   mixed  $path  Directory (string) or directories (array) to search.
	 *
	 * @return  void
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function addElementPath($path)
	{
		// Just force path to array.
		settype($path, 'array');

		// Loop through the path directories.
		foreach ($path as $dir)
		{
			// No surrounding spaces allowed!
			$dir = trim($dir);

			// Add trailing separators as needed.
			if (substr($dir, -1) != DIRECTORY_SEPARATOR)
			{
				// Directory
				$dir .= DIRECTORY_SEPARATOR;
			}

			// Add to the top of the search dirs.
			array_unshift($this->_elementPath, $dir);
		}
	}
	/**
	 * Bind data to the parameter.
	 *
	 * @param   mixed   $data   An array or object.
	 * @param   string  $group  An optional group that the data should bind to. The default group is used if not supplied.
	 *
	 * @return  boolean  True if the data was successfully bound, false otherwise.
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function bind($data, $group = '_default')
	{
		if (is_array($data))
		{
			return $this->loadArray($data);
		}
		elseif (is_object($data))
		{
			return $this->loadObject($data);
		}
		else
		{
			return $this->loadString($data);
		}
	}

	/**
	 * render
	 *
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	string	HTML
	 * @author      Valérie Cartan Isaksen
	 */
	function render($name = 'params', $group = '_default') {

		$parameters = $this->vmRender($name, $group);
		return $parameters;
	}

	/**
	 * Render all parameters copied from Joomla 1.5
	 *
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	array	Aarray of all parameters, each as array Any array of the label, the form element and the tooltip
	 * @since	1.5
	 */
	function getParam(&$node, $control_name = 'params', $group = '_default')
	{
		//get the type of the parameter
		$type = $node['type'];

		//remove any occurance of a mos_ prefix
		$type = str_replace('mos_', '', $type);

		$element = $this->loadElement($type);

		// error happened
		if ($element === false)
		{
			$result = array();
			$result[0] = $node['name'];
			$result[1] = JText::_('Element not defined for type').' = '.$type;
			$result[5] = $result[0];
			return $result;
		}

		//get value
		$value = $this->get($node['name'], $node['default'], $group);

		return $element->render($node, $value, $control_name);
	}
	
	/**
	 * Loads an element type.
	 *
	 * @param   string   $type  The element type.
	 * @param   boolean  $new   False (default) to reuse parameter elements; true to load the parameter element type again.
	 *
	 * @return  object
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function loadElement($type, $new = false)
	{
		$signature = md5($type);

		if ((isset($this->_elements[$signature]) && !($this->_elements[$signature] instanceof __PHP_Incomplete_Class)) && $new === false)
		{
			return $this->_elements[$signature];
		}

		$elementClass = 'JElement' . $type;
		
		if (!class_exists($elementClass))
		{
			if (isset($this->_elementPath))
			{
				$dirs = $this->_elementPath;
			}
			else
			{
				$dirs = array();
			}

			$file = JFilterInput::getInstance()->clean(str_replace('_', DS, $type) . '.php', 'path');

			jimport('joomla.filesystem.path');
			if ($elementFile = JPath::find($dirs, $file))
			{
				include_once $elementFile;
			}
			else
			{
				$false = false;
				return $false;
			}
		}

		if (!class_exists($elementClass))
		{
			$false = false;
			return $false;
		}

		$this->_elements[$signature] = new $elementClass($this);

		return $this->_elements[$signature];
	}
	
	function getParamByName($name){
		
		return $this->$name;
	}
	
	/**
	 * Render all parameters.
	 *
	 * @param   string  $name   An optional name of the HTML form control. The default is 'params' if not supplied.
	 * @param   string  $group  An optional group to render.  The default group is used if not supplied.
	 *
	 * @return  array  An array of all parameters, each as array of the label, the form element and the tooltip.
	 *
	 * @deprecated  12.1
	 * @since   11.1
	 */
	public function getParams($name = 'params', $group = '_default')
	{
		if (!isset($this->_xml[$group]))
		{
			return false;
		}

		$results = array();
		foreach ($this->_xml[$group]->params->param as $param)
		{
			$results[] = $this->getParam($param, $name, $group);
		}
		return $results;
	}
	
	/**
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	string	HTML
	 * @author	Joomla 1.5
	 */
	function vmRender($name = 'params', $group = '_default')
	{
		if (!isset($this->_xml[$group])) {
			return false;
		}

		$params = $this->getParams($name, $group);

		$html = array ();
		$html[] = '<div width="100%" cellspacing="1" class="paramlist admintable">';

		if ($description = $this->_xml[$group]['description']) {
			// add the params description to the display
			$desc	= JText::_($description);
			$html[]	= '<div><div class="paramlist_description" colspan="2">'.$desc.'</div></div>';
		}

		foreach ($params as $param)
		{
			$html[] = '<div class="param_inputWrap clearfix">';
			
			$param[1] = str_replace('%SITE_URL', JURI::root(), $param[1]);

			if ($param[0]) {
				$html[] = '<div width="30%" class="paramlist_key"><span class="editlinktip">'.$param[0].'</span></div>';
				$html[] = '<div class="paramlist_value">'.$param[1].'</div>';
			} else {
				$html[] = '<div class="paramlist_value">'.$param[1].'</div>';
			}

			$html[] = '</div>';
		}

		if (count($params) < 1) {
			$html[] = "<div><div><i>".JText::_('There are no Parameters for this item')."</i></div></div>";
		}

		$html[] = '</div>';

		return implode("\n", $html);
	}
	/**
	 *
	 * @param object A param tag node
	 * @param string The control name
	 * @return array Any array of the label, the form element and the tooltip
	 */

	function renderParam(&$param, $control_name='params') {

		$result = array();

		$name = $param->attributes('name');
		$type = $param->attributes('type');
		if ($param->attributes('label') != '') {
			$label = JText::_($param->attributes('label'));
		} else {
			$label = '';
		}

		if ($param->attributes('description')) {
			$description = JText::_($param->attributes('description'));
		} else {
		}

		$result[0] = $label ? $label : $name;

		if ($type == 'spacer' || $type == 'checkbox') {
			$result[0] = '&nbsp;';
		} else {
			//			$result[0] = JHTML::tooltip( addslashes( $description ), addslashes( $result[0] ), '', '', $result[0], '#', 0 );
			//$result[0] = $description;
		}

		if (in_array('_form_' . $type, $this->_methods)) {
			$control_name = '';
			$value = $this->get($name);
			//			$value = $this->get($param->attributes('name'), $param->attributes('default'));
			$result[1] = call_user_func(array($this, '_form_' . $type), $name, $value, $param, $control_name, $label);
		}
		else {
			$result[1] = _HANDLER . ' = ' . $type;
		}

		if ($description) {
			$result[2] = JHTML::tooltip($description, $result[0], '', $result[0]);
			//$result[2] = JHTML::tooltip( $description);
			//			$result[2] =  $description;
		} else {
			$result[2] = '';
		}

		return $result;
	}


	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_text($name, $value, &$node, $control_name) {
		$size = $node->attributes('size');
		if ((int) $size == 0) {
			$size = 25;
		}

		return '<input type="text" name="' . $control_name . '[' . $name . ']" value="' . htmlspecialchars($value) . '" class="text_area" size="' . $size . '" />';
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_password($name, $value, &$node, $control_name) {
		$size = $node->attributes('size');
		if ((int) $size == 0) {
			$size = 25;
		}

		return '<input type="password" name="' . $control_name . '[' . $name . ']" value="' . htmlspecialchars($value) . '" class="text_area" size="' . $size . '" />';
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_checkbox($name, $value, &$node, $control_name, $label='') {
		$default = $node->attributes('default');
		$checked = '';
		if ($value == $default) {
			$checked = ' checked="checked"';
		}

		$id = uniqid($name);
		return '<input type="checkbox" name="' . $control_name . '[' . $name . ']" value="' . htmlspecialchars($value) . '"' . $checked . ' class="text_area" id="' . $id . '" />
		<label for="' . $id . '">' . $label . '</label>';
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_list($name, $value, &$node, $control_name) {

		$size = $node->attributes('size');
		$multiselect = $node->attributes('multiselect');
		if ($multiselect) {
			$multiselect = 'multiple="multiple"';
			$size = 5;
			$name .= ']['; // well, if it's multi-select, this must be an array, right?
			if (strstr($value, ',')) {
				$value = explode(',', $value);
			}
		}
		if ($size == 0)
		$size = 1;
		$options = array();
		foreach ($node->_children as $option) {
			$val = $option->attributes('value');
			$text = trim($option->data());
			$options[$val] = JText::_($text);
		}


		return VmHTML::selectList($control_name . '[' . $name . ']', $value, $options, $size, $multiselect);
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_radio($name, $value, &$node, $control_name) {

		$options = array();
		foreach ($node->_children as $option) {
			$val = $option->attributes('value');
			$text = trim($option->data());
			$options[$val] = JText::_($text);
		}


		return VmHTML::radioList($control_name . '[' . $name . ']', $value, $options);
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_table_data_list($name, $value, &$node, $control_name) {

		$db = JFactory::getDBO();

		$table = $node->attributes('table');
		$condition = $node->attributes('sql_condition');
		$valuefield = $node->attributes('valuefield');
		$textfield = $node->attributes('textfield');
		$orderfield = $node->attributes('orderfield');
		$sorting = strtoupper($node->attributes('sorting')) == 'DESC' ? 'DESC' : 'ASC';
		$multiselect = $node->attributes('multiselect');

		$query = "SELECT `" . $db->getEscaped($valuefield) . '`, `' . $db->getEscaped($textfield) . "`"
		. "\n FROM `" . $db->getEscaped($table) . "`";
		if ($condition != '') {
			$query .= "\n WHERE " . $condition;
		}
		if ($orderfield) {
			$query .= "\n ORDER BY `" . $db->getEscaped($orderfield) . "` " . $sorting;
		}
		$db->setQuery($query);
		$array = $db->loadResultArray();

		if ($multiselect == '1') {
			$multiple = 'multiple="multiple"';
			$size = 5;
		} else {
			$multiple = '';
			$size = 1;
		}

		$name = $control_name . '[' . $name . ']';
		return VmHTML::selectList($name, $value, $array, $size, $multiple, 'class="inputbox"');
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	//	function _form_vm_category( $name, $value, &$node, $control_name ) {
	//		global $database;
	//
	//		$multiselect = $node->_attributes( 'multiselect' );
	//		if( $multiselect == '1' ) {
	//			$multiple = true;
	//			$size = 5;
	//		} else {
	//			$multiple = false;
	//			$size = 1;
	//		}
	//		require( CLASSPATH.'ps_product_category.php');
	//		$ps_product_category = new ps_product_category();
	//
	//		ob_start();
	//		$ps_product_category->list_all(''. $control_name .'['. $name .']', 0, array(), $size, true, $multiple );
	//		$category_dropdown = ob_get_clean();
	//		return $category_dropdown;
	//	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_filelist($name, $value, &$node, $control_name) {

		// path to images directory
		$path = JPATH_SITE . $node->attributes('directory');
		$filter = $node->attributes('filter');
		$files = vmReadDirectory($path, $filter);

		$options = array();
		foreach ($files as $file) {
			$options[$file] = $file;
		}
		if (!$node->attributes('hide_none')) {
			array_unshift($options, array('-1', '- ' . 'Do Not Use' . ' -'));
		}
		if (!$node->attributes('hide_default')) {
			array_unshift($options, array('', '- ' . 'Use Default' . ' -'));
		}

		return VmHTML::selectList('' . $control_name . '[' . $name . ']', $value, $options, 1, '', 'class="inputbox"');
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_imagelist($name, $value, &$node, $control_name) {
		$node->addAttribute('filter', '\.png$|\.gif$|\.jpg$|\.bmp$|\.ico$');

		return $this->_form_filelist($name, $value, $node, $control_name);
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_textarea($name, $value, &$node, $control_name) {
		$rows = $node->attributes('rows');
		$cols = $node->attributes('cols');
		// convert <br /> tags so they are not visible when editing
		$value = str_replace('<br />', "\n", $value);

		return '<textarea name="' . $control_name . '[' . $name . ']" cols="' . $cols . '" rows="' . $rows . '" class="text_area">' . htmlspecialchars($value) . '</textarea>';
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_hidden($name, $value, &$node, $control_name) {

		return '<input name="' . $control_name . '[' . $name . ']" value="' . htmlspecialchars($value) . '" type="hidden" />';
	}

	/**
	 * @param string The name of the form element
	 * @param string The value of the element
	 * @param object The xml element for the parameter
	 * @param string The control name
	 * @return string The html for the element
	 */
	function _form_spacer($name, $value, &$node, $control_name) {

		if ($value) {
			return '<h3>' . JText::_($value) . '</h3>';
		} else {
			return '<hr />';
		}
	}

	function _form_secret_key($name, $value, &$node, $control_name) {

		return '<a class="button" id="changekey" href="'
		. JRoute::_($_SERVER['SCRIPT_NAME'] . "?page=store.payment_method_keychange&element=$name") . '" >'
		. JText::_('COM_VIRTUEMART_CHANGE_TRANSACTION_KEY')
		. '<a/>';
	}

	/**
	 * special handling for textarea param
	 */
	function textareaHandling(&$txt) {
		$total = count($txt);
		for ($i = 0; $i < $total; $i++) {
			if (strstr($txt[$i], "\n")) {
				$txt[$i] = str_replace("\n", '<br />', $txt[$i]);
			}
		}
		$txt = implode("\n", $txt);

		return $txt;
	}

	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var $_name = 'SQL';

	function _form_sql($name, $value, &$node, $control_name) {
		$db = JFactory::getDBO();
		$db->setQuery($node->attributes('query'));
		$key = ($node->attributes('key_field') ? $node->attributes('key_field') : 'value');
		$val = ($node->attributes('value_field') ? $node->attributes('value_field') : $name);

		return JHTML::_('select.genericlist', $db->loadObjectList(), '' . $control_name . '[' . $name . ']', 'class="inputbox"', $key, $val, $value, $control_name . $name);
	}

}

/**
 * @param string
 * @return string
 */
function TbParseParams($txt) {
	return vmParameters::parse($txt);
}

// pure php no closing tag
