<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class TaxibookingHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string	The name of the active view.
	 *
	 * @return  void
	 * @since   1.6
	 */
	public static function addSubmenu($vName)
	{
		$user = JFactory::getUser();
		
		if ($user->authorise('core.manage', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'HOME' ), 'index.php?option=com_taxibooking', $vName == 'taxibooking');
		}
		if ($user->authorise('core.config', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'SETTINGS' ), 'index.php?option=com_taxibooking&view=configs', $vName == 'configs');
		}
		if ($user->authorise('core.manage.payments', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'PAYMENT_METHODS' ), 'index.php?option=com_taxibooking&view=paymentmethods', $vName == 'paymentmethods');
		}
		if ($user->authorise('core.manage.poicats', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'INTEREST_POINTS_CATEGORIES' ), 'index.php?option=com_taxibooking&view=poicats', $vName == 'poicats');
		}
		if ($user->authorise('core.manage.pois', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'INTEREST_POINTS' ), 'index.php?option=com_taxibooking&view=points', $vName == 'points');
		}
		if ($user->authorise('core.manage.cars', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'CARS' ), 'index.php?option=com_taxibooking&view=cars', $vName == 'cars');
		}
		if ($user->authorise('core.manage.tariffs', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'DASHBOARD_TARIFFS' ), 'index.php?option=com_taxibooking&view=tariffs', $vName == 'tariffs');
		}
		if ($user->authorise('core.manage.specialroutes', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'ROUTES' ), 'index.php?option=com_taxibooking&view=routes', $vName == 'routes');
		}
		if ($user->authorise('core.manage.shuttles', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'SHUTTLE_ROUTES' ), 'index.php?option=com_taxibooking&view=shuttles', $vName == 'shuttles');
		}
		if ($user->authorise('core.manage.customfields', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'CUSTOM_FIELDS' ), 'index.php?option=com_taxibooking&view=fields', $vName == 'fields');
		}
		if ($user->authorise('core.manage.coupons', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'COUPONS' ), 'index.php?option=com_taxibooking&view=coupons', $vName == 'coupons');
		}
		
		if ($user->authorise('core.manage.orders', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'ITEMS' ), 'index.php?option=com_taxibooking&view=orders', $vName == 'orders');
		}
		if ($user->authorise('core.manage.users', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'SUBMENU_BOOKING_USERS' ), 'index.php?option=com_taxibooking&view=tbusers', $vName == 'tbusers');
		}
		
		if ($user->authorise('core.manage.searchurls', 'com_taxibooking')){
			JSubMenuHelper::addEntry(JText::_( 'SUBMENU_BOOKING_SEARCHURLS' ), 'index.php?option=com_taxibooking&view=searchurls', $vName == 'searchurls');
		}

		if ($user->authorise('core.manage.searchurls', 'com_taxibooking')){
			JSubMenuHelper::addEntry('Upcoming trips', 'index.php?option=com_taxibooking&view=drivers', $vName == 'drivers');
		}
		
	}
	
	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @param	int		The category ID.
	 *
	 * @return	JObject
	 * @since	1.6
	 */
	public static function getActions()
	{
		$user	= JFactory::getUser();
		$result	= new JObject;

		$assetName = 'com_taxibooking';
		$level = 'component';

		$actions = JAccess::getActions('com_taxibooking', $level);

		foreach ($actions as $action) {
			$result->set($action->name,	$user->authorise($action->name, $assetName));
		}

		return $result;
	}
	
	/**
	 * Generate Booking calendar HTML.
	 */
	public static function generateBookingCalendarHtml()
	{
                $app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$config   = JFactory::getConfig();
		$offset = $config->get('offset');
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_cars');
		$query->where('published = 1');
		$query->where('google_calendar_enabled = 1');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		$colors = array('%23B1365F','%235C1158','%23691426','%23BE6D00','%2328754E','%2328754E','%230F4B38','%236E6E41','%2329527A','%232952A3','%237A367A','%235229A3','%238D6F47','%23333333','%23528800','%23754916','%23711616');
		if(!empty($rows))
		{
			$calendars = array();
			$i = 0;
			foreach($rows as $row)
			{
				$temp = 'src='.urlencode($row->google_calendar_id);
				if(isset($colors[$i])){
					$temp .= '&color='.$colors[$i];
				}
				$calendars[] = $temp;
				$i++;
			}
			
			$iframe_src = 'https://www.google.com/calendar/embed?title=Bookings&'.implode('&',$calendars).'&ctz='.urlencode($offset);
			
			$html = '<iframe src="'.$iframe_src.'" width="800" height="600" frameborder="0" scrolling="no"></iframe>';
			
			$temp = new stdClass();
			$temp->id = 1;
			$temp->booking_calendar_url  = $html;
			$db->updateObject('#__taxibooking_settings', $temp, 'id');
		}
		
		return;
        }
}