<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
/**
 * Component Settings Model 
 */
class TaxiBookingModelCalendar extends JModelList
{
	/**
	 * Settings data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * Constructor
	 *
	 * @since 0.9
	 */
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * Logic for the settings screen
	 *
	 */
	function getData()
	{
		$query = 'SELECT * FROM #__taxibooking_settings WHERE id = 1';

		$this->_db->setQuery($query);
		$this->_data = $this->_db->loadObject();

		return $this->_data;
	}

	/**
	 * Saves the settings
	 *
	 */
	function store($post)
	{
		$settings 	=  JTable::getInstance('taxibooking_settings', '');
		
		unset($post['option']);
		unset($post['controller']);
		unset($post['task']);
		unset($post['id']);
		
		$data = array();
		$data['id'] = 1;
		$data['booking_calendar_url'] = $post['booking_calendar_url'];

		// Bind the form fields to the table
		if (!$settings->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$settings->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return true;
	}
}