<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Component Category Model
 */
class TaxibookingModelCar extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Car', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($data)
	{
		$app = JFactory::getApplication();
		$date = JFactory::getDate();
		
		if($data['use_in_address']==1)
		{
			if($data['unit_price_override']==1)
			{
				if($data['use_tariff']==1){
					$data['unit_price'] = 0;
					$data['charge_per_min'] = 0;
				}
				
				// prepare distance prices
				$distance_price_arr = array();
				if(!empty($data['distance_min']))
				{
					foreach($data['distance_min'] as $key => $distance_min)
					{
						if($distance_min!="")
						{
							$distance_max = !empty($data['distance_max'][$key]) ? trim($data['distance_max'][$key]) : 0;
							$price = !empty($data['prices'][$key]) ? trim($data['prices'][$key]) : 0;
							$outbound_discount = !empty($data['outbound_discount'][$key]) ? trim($data['outbound_discount'][$key]) : 0;
							$return_discount = !empty($data['return_discount'][$key]) ? trim($data['return_discount'][$key]) : 0;
							$tariff_prices = !empty($data['tariff_prices'][$key]) ? $data['tariff_prices'][$key] : array();
							$distance_price_arr[] = array(trim($distance_min), $distance_max, $price, $outbound_discount, $return_discount,$tariff_prices);	
						}
					}
				}
				
				$cumulative_distance_price_arr = array();
				if(!empty($data['cumulative_distance_min']))
				{
					foreach($data['cumulative_distance_min'] as $key => $distance_min)
					{
						if($distance_min!="")
						{
							$distance_max = !empty($data['cumulative_distance_max'][$key]) ? trim($data['cumulative_distance_max'][$key]) : 0;
							$price = !empty($data['cumulative_prices'][$key]) ? trim($data['cumulative_prices'][$key]) : 0;
							$outbound_discount = !empty($data['cumulative_outbound_discount'][$key]) ? trim($data['cumulative_outbound_discount'][$key]) : 0;
							$return_discount = !empty($data['cumulative_return_discount'][$key]) ? trim($data['cumulative_return_discount'][$key]) : 0;
							$tariff_prices = !empty($data['tariff_cumulative_prices'][$key]) ? $data['tariff_cumulative_prices'][$key] : array();
							$cumulative_distance_price_arr[] = array(trim($distance_min), $distance_max, $price, $outbound_discount, $return_discount,$tariff_prices);	
						}
					}
				}
				
				if($data['price_calculation_cumulative']==1){ // cumulative
					$distance_price_arr = array();
				}
				else {
					$cumulative_distance_price_arr = array();
				}
			}
			else
			{
				$data['price_calculation_cumulative'] = 0;
				$distance_price_arr = $cumulative_distance_price_arr = array();
				$data['charge_per_min'] = $data['unit_price'] = $data['use_tariff'] = 0;
			}
		}
		else
		{
			$data['unit_price_override'] = $data['price_calculation_cumulative'] = 0;
			$distance_price_arr = $cumulative_distance_price_arr = array();
			$data['charge_per_min'] = $data['unit_price'] = $data['use_tariff'] = 0;
		}
		
		if($data['hourly_hire_enabled']==0){
			$data['hourly_hire_min_hr'] = $data['hourly_hire_max_hr'] = $data['hourly_rate'] = 0;
		}
		
		// prepare blocked dates
                $blocked_dates_arr = array();
		for($i = 0; $i < count($data['blocked_dates']); $i++)
		{
			if(isset($data['blocked_dates'][$i]) && $data['blocked_dates'][$i] != "")
			{
				$blocked_dates_arr[] = $data['blocked_dates'][$i];	
			}
		}
		
		$data['distance_prices'] = serialize($distance_price_arr);
		$data['cumulative_distance_prices'] = serialize($cumulative_distance_price_arr);
		$data['blocked_dates'] = serialize($blocked_dates_arr);
		
		// prepare car days-availability
		if (key_exists('days_availability', $data) && is_array($data['days_availability']))
		{
			$registry = new JRegistry();
			$registry->loadArray($data['days_availability']);
			$data['days_availability'] = $registry->toString();
		}
		
		if($data['google_calendar_enabled']==0){
			$data['google_user'] = '';
			$data['google_password'] = '';
			$data['google_calendar_id'] = '';
			$data['google_calendar_html_url'] = '';
		}
		else {
			$data['google_user'] = trim($data['google_user']);
			$data['google_password'] = encrypt_decrypt('encrypt', trim($data['google_password']));
			$data['google_calendar_id'] = trim($data['google_calendar_id']);
			$data['google_calendar_html_url'] = trim($data['google_calendar_html_url']);
		}
		
		if (parent::save($data))
		{
			$car_id = $this->getState('car.id');
			
			return true;
		}
	
		return false;
	}
	
	/**
	 * Method to load tariffs assigned to this car
	 *
	 * @access	private
	 * @return	boolean	True on success
	 * @since	1.0
	 */
	public function getTariffs()
	{
		$tariffs = array();
		$car_id = $this->getState($this->getName() . '.id', 0);
		
		if($car_id > 0)
		{
			$query = 'SELECT *'
				. ' FROM #__taxibooking_tariffs'
				. " WHERE (assigned_cars='$car_id' OR assigned_cars LIKE '$car_id,%' OR assigned_cars LIKE '%,$car_id' OR assigned_cars LIKE '%,$car_id,%')"
				. ' AND published = 1'
				;
			$this->_db->setQuery($query);
			$tariffs = $this->_db->loadObjectList();
		}
		
		return $tariffs;
	}
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
       }
	
	/**
	 * Method to duplicate items.
	 *
	 * @param   array  &$pks  An array of primary key IDs.
	 *
	 * @return  boolean  True if successful.
	 *
	 * @since   1.6
	 * @throws  Exception
	 */
	public function duplicate($pks)
	{
		// Initialise variables.
		$user	= JFactory::getUser();
		$db		= $this->getDbo();

		$table  = $this->getTable();

		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;

				// Alter the title.
				$m = null;
				if (preg_match('#\((\d+)\)$#', $table->title, $m))
				{
					$table->title = preg_replace('#\(\d+\)$#', '('.($m[1] + 1).')', $table->title);
				}
				else
				{
					$table->title .= ' (2)';
				}
				// Unpublish duplicate module
				$table->published = 0;

				if (!$table->check() || !$table->store())
				{
					throw new Exception($table->getError());
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
		}
		// Clear modules cache
		$this->cleanCache();

		return true;
	}
}