<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
/**
 * Component Items Model
 */
class TaxibookingModelCoupons extends JModelList
{
    /**
    * Constructor.
    *
    * @param   array  An optional associative array of configuration settings.
    * @see     JController
    * @since   1.6
    */
    public function __construct($config = array())
    {
            if (empty($config['filter_fields']))
            {
                    $config['filter_fields'] = array(
                            'id', 'a.id',
                            'title', 'a.title',
                            'language', 'a.language',
                            'alias', 'a.alias',
                            'valid_from', 'a.valid_from',
                            'valid_to', 'a.valid_to',
                            'published', 'a.published',
                            'ordering', 'a.ordering',
                    );
            }
 
            parent::__construct($config);
    }
    
    /**
    * Build an SQL query to load the list data.
    *
    * @return  JDatabaseQuery
    * @since   1.6
    */
    protected function getListQuery()
    {
            $db = $this->getDbo();
            $query = $db->getQuery(true);
 
            // Select the required fields from the table.
            $query->select(
                    $this->getState( 'list.select', 'a.*' )
            );
            $query->from($db->quoteName('#__taxibooking_coupons') . ' AS a');
            
            // Join over the language
            $query->select('l.title AS language_title')
                    ->join('LEFT', $db->quoteName('#__languages') . ' AS l ON l.lang_code = a.language');
 
            // Filter by published state
            $published = $this->getState('filter.state');
            if (is_numeric($published))
            {
                    $query->where('a.published = ' . (int) $published);
            }
            elseif ($published === '')
            {
                    $query->where('(a.published IN (0, 1))');
            }
 
            // Filter by search in title
            $search = $this->getState('filter.search');
            if (!empty($search))
            {
                    if (stripos($search, 'id:') === 0)
                    {
                            $query->where('a.id = ' . (int) substr($search, 3));
                    }
                    else
                    {
                            $search = $db->quote('%' . $db->escape($search, true) . '%');
                            $query->where('(a.title LIKE ' . $search . ' OR a.alias LIKE ' . $search . ')');
                    }
            }
            
            // Filter on the language.
            if ($language = $this->getState('filter.language'))
            {
                    $query->where('a.language = ' . $db->quote($language));
            }
 
            // Add the list ordering clause.
            $orderCol = $this->state->get('list.ordering', 'ordering');
            $orderDirn = $this->state->get('list.direction', 'ASC');
            if ($orderCol == 'ordering')
            {
                    $orderCol = 'a.ordering';
            }
            $query->order($db->escape($orderCol . ' ' . $orderDirn));
 
            //echo nl2br(str_replace('#__','jos_',$query));
            return $query;
    }
    
    /**
    * Method to auto-populate the model state.
    *
    * Note. Calling getState in this method will result in recursion.
    *
    * @since   1.6
    */
    protected function populateState($ordering = null, $direction = null)
    {
        // Load the filter state.
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
        $this->setState('filter.state', $state);

        // Load the parameters.
        $params = JComponentHelper::getParams('com_taxibooking');
        $this->setState('params', $params);

        // List state information.
        parent::populateState('a.title', 'asc');
    }
}