<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
/**
 * Drivenot Model 
 */
class TaxiBookingModelDrivenot extends JModelList
{
	/**
	 * Settings data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * Constructor
	 *
	 * @since 0.9
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * Logic for the settings screen
	 *
	 */
	public function getData()
	{
		$app = JFactory::getApplication();
		$config   = JFactory::getConfig();
		$sitename = $config->get('sitename');
		$company_url = rtrim(JURI::root(), '/');
		
		$q = APPREGULATOR_URL."/index.php?option=com_appregulator&task=getCompany&tmpl=component&token=kanev&company_url=".urlencode($company_url);
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $q);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		
		// to avoid error, CURLOPT_FOLLOWLOCATION cannot be activated when safe_mode is enabled or an open_basedir is set in 
		if(JURI::root()=="http://letsgotransfer.dns-systems.net/"){
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, FALSE);
		}
		else {
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		}
		
		$json = curl_exec($ch);
		$curl_errno = curl_errno($ch);
		$curl_error = curl_error($ch);
		
		if ($curl_errno > 0)
		{
			$this->_data = $this->_loadDefault();
			$app->enqueueMessage("cURL Error ($curl_errno): $curl_error", 'notice');
			return false;
		} 
		curl_close($ch);

		$response = json_decode($json, TRUE);
		
		$this->_data = new stdClass();
		
		if($response['error']==0)
		{
			$this->_data->company_id = $response['row']['id']; 
			$this->_data->company_name = $response['row']['name'];
			$this->_data->company_registration_number = $response['row']['company_registration_number'];
			$this->_data->transportation_license_number = $response['row']['transportation_license_number'];
			$this->_data->contact_person = $response['row']['contact_person'];
			$this->_data->contact_email = $response['row']['contact_email'];
			$this->_data->contact_phone = $response['row']['contact_phone'];
			$this->_data->contact_address = $response['row']['contact_address'];
			$this->_data->contact_state = $response['row']['contact_state'];
			$this->_data->contact_zip = $response['row']['contact_zip'];
			$this->_data->image = $response['row']['image'];
			$this->_data->app_sharing_coupon_code = $response['row']['app_sharing_coupon_code'];
			$this->_data->app_sharing_coupon_url = $response['row']['app_sharing_coupon_url'];
		}
		else {
			$this->_data = $this->_loadDefault();
		}
		
		return $this->_data;
	}
	
	private function _loadDefault()
	{
		$config   = JFactory::getConfig();
		$sitename = $config->get('sitename');
		
		$data = new stdClass();
		$data->company_id = 0;
		$data->company_name = $sitename;
		$data->company_registration_number = '';
		$data->transportation_license_number = '';
		$data->contact_person = '';
		$data->contact_email = '';
		$data->contact_phone = '';
		$data->contact_address = '';
		$data->contact_state = '';
		$data->contact_zip = '';
		$data->image = '';
		$data->app_sharing_coupon_code = '';
		$data->app_sharing_coupon_url = '';
		
		return $data;
	}
}