<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Order model.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxiBookingModelOrder extends JModelAdmin
{
    /**
    * Returns a JTable object, always creating it.
    *
    * @param   string  $type    The table type to instantiate. [optional]
    * @param   string  $prefix  A prefix for the table class name. [optional]
    * @param   array   $config  Configuration array for model. [optional]
    *
    * @return  JTable  A database object
    *
    * @since   1.6
    */
    public function getTable($type = 'Order', $prefix = 'TaxibookingTable', $config = array())
    {
            return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to get the record form.
     *
     * @param   array    $data      Data for the form. [optional]
     * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
     *
     * @return  mixed  A JForm object on success, false on failure
     *
     * @since   1.6
     */
    public function getForm($data = array(), $loadData = true)
    {
            return false;
    }

    /**
    * Prepare and sanitise the table prior to saving.
    *
    * @param   JTable  $table  A JTable object.
    *
    * @return  void
    *
    * @since   1.6
    */
    protected function prepareTable($table)
    {
        $date = JFactory::getDate();
        $user = JFactory::getUser();

        if (empty($table->id))
        {
            // Set the values
            $table->created = $date->toSql();
            $table->created_by	= $user->get('id');
        }
        else
        {
            // Set the values
            $table->modified	= $date->toSql();
            $table->modified_by	= $user->get('id');
        }

        $table->return_wait_hr	= -1;
        $table->return_wait_discount	= 0;
    }

    /**
     * Method to save the form data.
     *
     * @param   array  $data  The form data.
     *
     * @return  boolean  True on success.
     *
     * @since   1.6
     */

    // protected function translateDay($startdate)
    // {
    //     $date = new DateTime($startdate);
    //     $monday = $date->modify('next monday');
    //     // clone start date
    //     $endDate = clone $monday;
    //     // Add 7 days to start date
    //     $endDate->modify('+7 days');
    //     // Increase with an interval of one day
    //     $dateInterval = new DateInterval('P1D');
    //     $dateRange = new DatePeriod($monday, $dateInterval, $endDate);
    //     return $dateRange;
    // }
    public function save($data)
    {
        $app = JFactory::getApplication();
        $elsettings 	= booking_helper::config();
        $date = JFactory::getDate();

        // we had to set timezone for this website http://airport-london-transfers.co.uk/
        // somehow timezone was not set in Config timezone and time was showing in wrong timezone
        // another place is booking.helper.php
        if(JURI::root()=='http://airport-london-transfers.co.uk/'){
            $config   = JFactory::getConfig();
            $siteOffset = $config->get('offset');
            date_default_timezone_set($siteOffset);
        }

        $booking_type = $data['booking_type'];
        if($booking_type == 'schooldays') {

            unset($data['pickup_date']);
            unset($data['pickup_hr']);
            unset($data['pickup_min']);
            $data['booking_type'] = 'address';

            if ($data['returntrip'] == 1) {

            }

          // cleaning the arrays of hours and mins for schooldays from empty values
          foreach ($data as $key => $value) {
            if($key == 'school_hr') {
              $data[$key] = array_filter($value);
            }
            if($key == 'school_min') {
              $data[$key] = array_filter($value);
            }

                if ($data['returntrip'] == 1) {
                    if($key == 'school_hr_return') {
                      $data[$key] = array_filter($value);
                    }
                    if($key == 'school_min_return') {
                      $data[$key] = array_filter($value);
                    }
                }

          }

          // making the indexes of the school_hr and school_min consecutive
          foreach ($data as $key => $value) {
            if($key == 'school_hr') {
              $data[$key] = array_values($value);
            }
            if($key == 'school_min') {
              $data[$key] = array_values($value);
            }

                if ($data['returntrip'] == 1) {
                    if($key == 'school_hr_return') {
                      $data[$key] = array_values($value);
                    }
                    if($key == 'school_min_return') {
                      $data[$key] = array_values($value);
                    }
                }
          }

          $i = 0;
          // clones the data array to multiple orders, one for each day of the week selected.
          foreach ($data['schoolweek'] as $key => $value) {
            $data2[$i] = $data;
            $data2[$i]['pickup_date'] = $data['schoolweek'][$i];
            $data2[$i]['pickup_hr'] = $data['school_hr'][$i];
            if (empty($data['school_min'][$i])) {
                $data['school_min'][$i] = '00';
            }
            $data2[$i]['pickup_min'] = $data['school_min'][$i];
            $data2[$i]['booking_type'] = 'address';
                if ($data['returntrip'] == 1) {
                    $data2[$i]['return_date'] = $data['schoolweek_return'][$i];
                    $data2[$i]['return_hr'] = $data['school_hr_return'][$i];
                    if (empty($data['school_min_return'][$i])) {
                        $data['school_min_return'][$i] = '00';
                    }
                    $data2[$i]['return_min'] = $data['school_min_return'][$i];
                }
            $i++;
          }

          foreach ($data2 as $key => $value) {
            unset($data2[$key]['schoolweek']);
            unset($data2[$key]['school_hr']);
            unset($data2[$key]['school_min']);
            unset($data2[$key]['school_hr_return']);
            unset($data2[$key]['school_min_return']);
            unset($data2[$key]['schoolweek_return']);
            $data2[$key]['booking_type'] = 'address';
          }

          // TODO: check if return date is checked, if so, add it to the order.
          foreach ($data2 as $key2 => $value2) {
            $this->save($value2);
            // return;
          }
          return true;
      } // end if booking type schooldays

        elseif($booking_type!='address'){
                $data['pickup_poi'] = $data['dropoff_poi'] = 0;
                $data['pickup_lat'] = $data['pickup_lng'] = '';
                $data['dropoff_lat'] = $data['dropoff_lng'] = '';
        }
        elseif($booking_type!='offers'){
                $data['route_id'] = 0;
        }
        elseif($booking_type!='hourly'){
                $data['hourly_hr'] = $data['hourly_min'] = 0;
                $data['returntrip']=0;
                $data['return_date'] = '';
                $data['return_hr'] = $data['return_min'] = 0;
        }

        elseif($booking_type!='shuttle'){
                $data['shuttle_pickup_poi'] = $data['shuttle_dropoff_poi'] = 0;
                $data['shuttle_pickup_date'] = '';
                $data['shuttletime'] = '';
                $data['shuttle_passengers'] = 0;
                $data['returntrip']=0;
                $data['return_date'] = '';
                $data['return_hr'] = $data['return_min']=0;
        }
        $total_waypoint_duration = 0;
        if($booking_type=='address')
        {
            if($data['pickup_type']=='poi'){
                $poi_where = array('p.id = '.$this->_db->Quote($data['pickup_poi']));
                $poiObj = booking_helper::get_specific_place_details($poi_where);
                if($poiObj){
                    $data['begin'] = $poiObj->title;
                    $data['pickup_lat'] = $poiObj->lat;
                    $data['pickup_lng'] = $poiObj->long;
                }
            }
            else {
                $data['begin'] = $data['pickup_address'];
                $data['pickup_poi'] = 0;
            }

            if($data['dropoff_type']=='poi'){
                $poi_where = array('p.id = '.$this->_db->Quote($data['dropoff_poi']));
                $poiObj = booking_helper::get_specific_place_details($poi_where);
                if($poiObj){
                    $data['end'] = $poiObj->title;
                    $data['dropoff_lat'] = $poiObj->lat;
                    $data['dropoff_lng'] = $poiObj->long;
                }
            }
            else {
                $data['end'] = $data['dropoff_address'];
                $data['dropoff_poi'] = 0;
            }

            // process stops
            $stops = array();
            $waypoints = !empty($data['waypoints']) ? $data['waypoints'] : array();
            $waypoints_lat = !empty($data['waypoints_lat']) ? $data['waypoints_lat'] : array();
            $waypoints_lng = !empty($data['waypoints_lng']) ? $data['waypoints_lng'] : array();
            $waypoints_stop_duration = !empty($data['waypoints_stop_duration']) ? $data['waypoints_stop_duration'] : array();

            for($i = 0; $i < count($waypoints); $i++){
                $total_waypoint_duration += $waypoints_stop_duration[$i];
                $stops[$i] = array('stop' => $waypoints[$i],
                                   'stop_lat' => $waypoints_lat[$i],
                                   'stop_lng' => $waypoints_lng[$i],
                                   'stop_interval' => $waypoints_stop_duration[$i]
                                   );
            }
            $data['stops'] = serialize($stops);
        }
        elseif($data['booking_type']=='offers')
        {
            $query = $this->_db->getQuery(true);
            $query->select('route_from, route_to');
            $query->from('#__taxibooking_routes');
            $query->where('id = '.(int)$data['route_id']);
            $this->_db->setQuery((string)$query);
            $selected_route = $this->_db->loadObject();

            if($selected_route){
                $poi_where = array('p.id = '.$this->_db->Quote($selected_route->route_from));
                $poiObj = booking_helper::get_specific_place_details($poi_where);
                if($poiObj){
                    $data['begin'] = $poiObj->title;
                    $data['pickup_lat'] = $poiObj->lat;
                    $data['pickup_lng'] = $poiObj->long;
                    $data['pickup_poi'] = $poiObj->id;
                }

                $poi_where = array('p.id = '.$this->_db->Quote($selected_route->route_to));
                $poiObj = booking_helper::get_specific_place_details($poi_where);
                if($poiObj){
                    $data['end'] = $poiObj->title;
                    $data['dropoff_lat'] = $poiObj->lat;
                    $data['dropoff_lng'] = $poiObj->long;
                    $data['dropoff_poi'] = $poiObj->id;
                }
            }
        }
        elseif($data['booking_type']=='hourly')
        {
            $data['begin'] = $data['end'] = '';
        }
        elseif($data['booking_type']=='shuttle')
        {
            $poi_where = array('p.id = '.$this->_db->Quote($data['shuttle_pickup_poi']));
            $poiObj = booking_helper::get_specific_place_details($poi_where);
            if($poiObj){
                $data['begin'] = $poiObj->title;
                $data['pickup_lat'] = $poiObj->lat;
                $data['pickup_lng'] = $poiObj->long;
                $data['pickup_poi'] = $poiObj->id;
            }

            $poi_where = array('p.id = '.$this->_db->Quote($data['shuttle_dropoff_poi']));
            $poiObj = booking_helper::get_specific_place_details($poi_where);
            if($poiObj){
                $data['end'] = $poiObj->title;
                $data['dropoff_lat'] = $poiObj->lat;
                $data['dropoff_lng'] = $poiObj->long;
                $data['dropoff_poi'] = $poiObj->id;
            }

            $data['selpassengers'] = $data['shuttle_passengers'];
        }

        if(!empty($data['extras'])){
            list($selected_extras, $total_extra_price) = booking_helper::process_extras($data['extras'],$booking_type);

            list($selected_user_details_extras, $total_user_details_extra_price) = booking_helper::process_user_details_extras($data['extras']);
            $selected_extras = array_merge($selected_extras, $selected_user_details_extras);
            $total_extra_price += (float)$total_user_details_extra_price;
        }
        else {
            $selected_extras= array();
            $total_extra_price = 0;
        }

        if($data['booking_type']=='shuttle')
        {
            $order_date_time_str = strtotime($data['shuttle_pickup_date'].' '.$data['shuttletime']);
            $order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
        }
        else {
            if($data['pickup_date']!="")
            {
                $order_date_time_str = strtotime($data['pickup_date'].' '.$data['pickup_hr'].':'.$data['pickup_min']);
                $order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
            }
        }

        $orderreturn_date_time_str = '';
        $orderreturn_date_time = '';
        if(!empty($data['returntrip']) && $data['returntrip']==1 && $data['return_date']!="")
        {
            $orderreturn_date_time_str = strtotime($data['return_date'].' '.$data['return_hr'].':'.$data['return_min']);
            $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
        }

        $data['names'] = $data['user_name'];
        $data['extras'] = serialize($selected_extras);
        $data['datetime1'] = $order_date_time_str;
        $data['datetime2'] = $orderreturn_date_time_str;

        $duration_seconds = 0;
        if(!empty($data['duration_seconds'])){
            $duration_seconds = $data['duration_seconds'];
            $duration_seconds += $total_waypoint_duration*60;
            $duration_text = booking_helper::secondsToTime($duration_seconds);

            $data['duration'] = $duration_seconds;
            $data['duration_text'] = $duration_text;
        }

        // admin entered price override
        if(!empty($data['price_override']) && $data['price_override']!=0){
            $data['sub_total'] = 0;
            $data['flat_cost'] = 0;
            $data['percentage_cost'] = 0;
            $data['cprice'] = $data['price_override'];
        }
        else {
            //if($data['price'] > 0){
                //$data['sub_total'] = $data['price'] - $data['flat_cost'] - $data['percentage_cost'];
            //}
            $data['sub_total'] = $data['price'];

            $grand_total = $data['price'] + $data['flat_cost'] + $data['percentage_cost'];

            // apply coupon if coupon is associated with this order from frontend
            if($data['coupon_used'] > 0)
            {
                $booking_data = array('booking_type' => $booking_type,
                                        'email' => $data['email'],
                                        'route_from' => ($booking_type=='offers') ? $data['pickup_poi'] : 0,
                                        'route_to' => ($booking_type=='offers') ? $data['dropoff_poi'] : 0,
                                        'grand_total' => $grand_total,
                                        'pickup_date' => date("Y-m-d", $order_date_time_str)
                                      );
                require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'coupon_code.php');
                $cc = new CouponCode('',$data['coupon_used']);
                list($is_valid, $msg) = $cc->validate($booking_data);

                if($is_valid)
                {
                    $grand_total = $cc->apply($booking_data);
                }
            }

            if($data['gratuity_amttype']=='percent'){
                $data['gratuity_amt'] = ($grand_total * (float)$data['gratuity_percent_value']) / 100;
                $grand_total = $grand_total + $data['gratuity_amt'];
            }
            elseif($data['gratuity_amttype']=='flat'){
                $grand_total = $grand_total + (float)$data['gratuity_amt'];
            }

            $data['cprice'] = $grand_total;
        }

        // system car will get priority over custom car
        if(!empty($data['car_id']) && $data['car_id'] > 0){
            $data['vehicletype'] = $data['car_id'];
            $data['custom_car'] = '';
        }
        elseif($data['car_id']==0 && $data['custom_car']!=""){
            $data['vehicletype'] = 0;
        }

        // if frontend payment is set, admin cannot set custom payment until he cancel frontend payment
        if(is_numeric($data['payment']) && $data['payment'] > 0){
            $data['custom_payment'] = '';
        }

        $isNew		= ($data['id'] == 0 || $data['id'] == '');

        if($isNew){
            $data['order_number'] = uniqid();
        }

        if (parent::save($data))
        {
            $order_id = $this->getState('order.id');
            $order = booking_helper::get_order_by_id($order_id);

            // store order vehicle booking time data if track_availability is set YES for the booked car
            if($data['car_id']>0)
            {
                // for hourly frontend booking, duration should be considered after editing order
                if ($order->booking_type=='hourly' && !$isNew){
                    $duration_seconds = $order->duration;
                }

                $car = booking_helper::get_car_details($data['car_id']);
		$track_availability = $car->track_availability;

                if((int)$track_availability==1)
                {
                    $booking_time_start = $order_date_time_str;
                    $booking_time_end = $order_date_time_str+$duration_seconds;

                    $booking_time_end += (int) $elsettings->time_after_each_booking;

                    if((int)$elsettings->calculate_base_pickup==1)
                    {
                        $base_pickup_duration_seconds = $data['base_pickup_duration'];

                        $booking_time_start -= $base_pickup_duration_seconds;
                    }
                    if((int)$elsettings->calculate_dropoff_base==1)
                    {
                        $dropoff_base_duration_seconds = $data['dropoff_base_duration'];

                        $booking_time_end += $dropoff_base_duration_seconds;
                    }

                    if($isNew)
                    {
                        $order_car = new stdClass();
                        $order_car->order_id = $order_id;
                        $order_car->vehicle_id = $data['car_id'];
                        $order_car->journey_type = 'outbound';
                        $order_car->booking_time_start = $booking_time_start;
                        $order_car->booking_time_end = $booking_time_end;
                        $order_car->created_date = $date->toSql();

                        if (!$this->_db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
                            $app->enqueueMessage($this->_db->stderr(), 'warning');
                        }

                        $order_car_rel_id = $this->_db->insertid();
                        if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                        {
                            $event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
                        }

                        // enter another entry for return journey
                        if($data['returntrip']==1 && $orderreturn_date_time_str!="")
                        {
                            $booking_time_start = $orderreturn_date_time_str;
                            $booking_time_end = $orderreturn_date_time_str+$duration_seconds;

                            $order_car = new stdClass();
                            $order_car->order_id = $order_id;
                            $order_car->vehicle_id = $data['car_id'];
                            $order_car->journey_type = 'return';
                            $order_car->booking_time_start = $booking_time_start;
                            $order_car->booking_time_end = $booking_time_end;
                            $order_car->created_date = $date->toSql();

                            if (!$this->_db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
                                $app->enqueueMessage($this->_db->stderr(), 'warning');
                            }

                            $order_car_rel_id = $this->_db->insertid();

                            if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                            {
                                $event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
                            }
                        }
                    }
                    else {
                        // first check if this order has availability record already
                        $query = $this->_db->getQuery(true);
                        $query->select('*');
                        $query->from('#__taxibooking_order_car_rel');
                        $query->where('order_id = '.(int)$order_id);
                        $query->where('journey_type = "outbound"');
                        $this->_db->setQuery((string)$query);
                        $avail_record = $this->_db->loadObject();

                        if($avail_record){
                            $order_car = new stdClass();
                            $order_car->id = $avail_record->id;
                            $order_car->vehicle_id = $data['car_id'];
                            $order_car->booking_time_start = $booking_time_start;
                            $order_car->booking_time_end = $booking_time_end;
                            $order_car->modified_date = $date->toSql();

                            if (!$this->_db->updateObject('#__taxibooking_order_car_rel', $order_car, 'id')) {
                                $app->enqueueMessage($this->_db->stderr(), 'warning');
                            }

                            if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                            {
                                $this->_updateGoogleEvent($order, $car, $avail_record,$booking_time_start,$booking_time_end);
                            }
                        }
                        else {
                            $order_car = new stdClass();
                            $order_car->order_id = $order_id;
                            $order_car->vehicle_id = $data['car_id'];
                            $order_car->journey_type = 'outbound';
                            $order_car->booking_time_start = $booking_time_start;
                            $order_car->booking_time_end = $booking_time_end;
                            $order_car->created_date = $date->toSql();

                            if (!$this->_db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
                                $app->enqueueMessage($this->_db->stderr(), 'warning');
                            }

                            $order_car_rel_id = $this->_db->insertid();
                            if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                            {
                                $event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
                            }
                        }

                        // enter another entry for return journey if return trip is set YES
                        if($data['returntrip']==1 && $orderreturn_date_time_str!="")
                        {
                            $booking_time_start = $orderreturn_date_time_str;
                            $booking_time_end = $orderreturn_date_time_str+$duration_seconds;

                            // first check if this order has availability record already
                            $query = $this->_db->getQuery(true);
                            $query->select('*');
                            $query->from('#__taxibooking_order_car_rel');
                            $query->where('order_id = '.(int)$order_id);
                            $query->where('journey_type = "return"');
                            $this->_db->setQuery((string)$query);
                            $avail_record = $this->_db->loadObject();

                            if($avail_record){
                                $order_car = new stdClass();
                                $order_car->id = $avail_record->id;
                                $order_car->vehicle_id = $data['car_id'];
                                $order_car->booking_time_start = $booking_time_start;
                                $order_car->booking_time_end = $booking_time_end;
                                $order_car->modified_date = $date->toSql();

                                if (!$this->_db->updateObject('#__taxibooking_order_car_rel', $order_car, 'id')) {
                                    $app->enqueueMessage($this->_db->stderr(), 'warning');
                                }

                                if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                                {
                                    $this->_updateGoogleEvent($order, $car, $avail_record,$booking_time_start,$booking_time_end);
                                }
                            }
                            else {
                                $order_car = new stdClass();
                                $order_car->order_id = $order_id;
                                $order_car->vehicle_id = $data['car_id'];
                                $order_car->journey_type = 'return';
                                $order_car->booking_time_start = $booking_time_start;
                                $order_car->booking_time_end = $booking_time_end;
                                $order_car->created_date = $date->toSql();

                                if (!$this->_db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
                                    $app->enqueueMessage($this->_db->stderr(), 'warning');
                                }

                                $order_car_rel_id = $this->_db->insertid();

                                if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                                {
                                    $event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
                                }
                            }
                        }
                        else { // if return trip is NO, just check if there is previous return entry, if yes, remove that
                            $query = $this->_db->getQuery(true);
                            $query->select('*');
                            $query->from('#__taxibooking_order_car_rel');
                            $query->where('order_id = '.(int)$order_id);
                            $query->where('journey_type = "return"');
                            $this->_db->setQuery((string)$query);
                            $avail_record = $this->_db->loadObject();

                            if($avail_record)
                            {
                                // remove google event
                                if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
                                {
                                    if ($app->isAdmin()){
                                            include_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_calendar.php');
                                    }
                                    else{
                                            include_once (JPATH_COMPONENT.DS.'classes'.DS.'google_calendar.php');
                                    }

                                    $gcal = new GoogleCalendar;
                                    $result = $gcal->login($elsettings);
                                    if( $result == "ok")
                                    {
                                        $client = $gcal->getClient();
                                        if($client != null)
                                        {
                                            // if google event id is present, delete that event first
                                            if($avail_record->google_event_id!="")
                                            {
                                                if($avail_record->google_calendar_id == ""){
                                                    $gcal->deleteEventById($client, $avail_record->google_event_id);
                                                }
                                                else {
                                                    $result2 = $gcal->deleteEvent($client, $avail_record->google_event_id, $avail_record->google_calendar_id);
                                                    if($result2 != "ok"){
                                                        tberror_log("Removing Event, $avail_record->google_event_id".$result2);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                $query = $this->_db->getQuery(true);
                                $query = 'DELETE FROM `#__taxibooking_order_car_rel` WHERE `order_id` = '.$this->_db->quote($order_id).' AND journey_type = "return"';
                                $this->_db->setQuery($query);
                                $this->_db->execute();
                            }
                        }
                    }
                }
            }

            return true;
        }

        return false;
    }

    private function _updateGoogleEvent($order, $order_car, $availability_record,$booking_start,$booking_end)
    {
        $app = JFactory::getApplication();
        $db = JFactory::getDBO();
        $config   = JFactory::getConfig();
	$offset = $config->get('offset');
        $elsettings 	= booking_helper::config();

        if ($app->isAdmin()){
                include_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_calendar.php');
        }
        else{
                include_once (JPATH_COMPONENT.DS.'classes'.DS.'google_calendar.php');
        }

        $gcal = new GoogleCalendar;
        // login
        $result = $gcal->login($elsettings);
        if( $result == "ok")
        {
            $client = $gcal->getClient();
            if($client != null)
            {
                // if google event id is present, delete that event first
                if($availability_record->google_event_id!="")
                {
                    if($availability_record->google_calendar_id == ""){
                        $gcal->deleteEventById($client, $availability_record->google_event_id);
                    }
                    else {
                        $result2 = $gcal->deleteEvent($client, $availability_record->google_event_id, $availability_record->google_calendar_id);
                        if($result2 != "ok"){
                            tberror_log("Removing Event, $availability_record->google_event_id".$result2);
                        }
                    }
                }

                // create new event
                $startdate = date('Y-m-d', $booking_start);
		$starttime = date('H:i:s', $booking_start);
		$enddate = date('Y-m-d', $booking_end);
		$endtime = date('H:i:s', $booking_end);

		$TimeZonebyCity = new DateTimeZone($offset);
		$localTimebyCity = new DateTime($startdate, $TimeZonebyCity);
		$timeOffset = $TimeZonebyCity->getOffset($localTimebyCity);
		$offset = $timeOffset/3600;
		$offset = local_tz_offset_to_string($offset);

                $gcal->setTZOffset($offset);

		// set calendar
		if($order_car->google_calendar_id != "")
		{
                    try{
                            $gcal->setCalID($order_car->google_calendar_id);
                    }catch (Exception $e) {
                            tberror_log("SetCalendar,".$e->getMessage());
                            return false;
                    }
		}

		$order_url = JURI::root().'index.php?option=com_taxibooking&view=order&cid='.$order->id.'&Itemid='.TaxibookingHelperRoute::getOrdersItemid();

		$title_text = JText::_('TAXI_FROM').': '.$order->begin;

		$body_text = JText::_('PASSENGERS').': '.$order->selpassengers;

		if($order->selluggage > 0){
			$body_text .= '<br>'.JText::_('CHECK_IN_LAGUAGE').': '.$order->selluggage;
		}
		if($order->selinfantseats > 0){
			$body_text .= '<br>'.JText::_('INFANT_SEATS').': '.$order->selinfantseats;
		}
		if($order->selchildseats > 0){
			$body_text .= '<br>'.JText::_('CHILD_SEATS').': '.$order->selchildseats;
		}
		if($order->selboosterseats > 0){
			$body_text .= '<br>'.JText::_('BOOSTER_SEATS').': '.$order->selboosterseats;
		}

		$body_text .= '<br>'.JText::_('VEHICLE_TYPE').': '.booking_helper::get_order_car($order);
		$body_text .= '<br>'.JText::_('PAYMENT_METHOD').': '.booking_helper::get_order_payment($order);
		$body_text .= '<br><a href="'.JRoute::_($order_url, false).'" target="blank">'.JText::_('DETAILS').'</a>';

		stripslashes($body_text);
		stripslashes($title_text);
		$body_text = str_replace("'", "`", $body_text);
		$title_text = str_replace("'", "`", $title_text);

		//create event
		try{
                    $event_id_full = $gcal->createEvent(
                                                $title_text,
                                                $body_text,
                                                '',
                                                trim($startdate),
                                                trim($starttime),
                                                trim($enddate),
                                                trim($endtime)
                                            );
		}catch (Exception $e) {
			tberror_log("createEvent,".$e->getMessage());
			return false;
		}

		$event_id = substr($event_id_full, strrpos($event_id_full, "/")+1);

		$temp = new stdClass();
		$temp->id = $availability_record->id;
		$temp->google_event_id = $event_id;
		$temp->google_calendar_id = $car->google_calendar_id;
		$db->updateObject('#__taxibooking_order_car_rel', $temp, 'id');
            }
            else {
                tberror_log("Removing Event,"."$client == null error");
            }
        }
        else {
            tberror_log("Authentication - Removing Event,".$result);
        }
    }
}
