<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
/**
 * Component Items Model
 */
class TaxibookingModelOrders extends JModelList
{
    /**
    * Constructor.
    *
    * @param   array  An optional associative array of configuration settings.
    * @see     JController
    * @since   1.6
    */
    public function __construct($config = array())
    {
            if (empty($config['filter_fields']))
            {
                    $config['filter_fields'] = array(
                            'id', 'a.id',
                            'names', 'a.names',
                            'cprice', 'a.cprice',
                            'datetime1', 'a.datetime1',
                            'datetime2', 'a.datetime2',
                            'drivername', 'u.name',
                            'begin', 'a.begin',
                            'end', 'a.end',
                            'passengers', 'a.selpassengers',
                    );
            }

            parent::__construct($config);
    }

    /**
    * Method to get an array of data items.
    *
    * @return  mixed  An array of data items on success, false on failure.
    *
    * @since   12.2
    */
    public function getItems($csv = false)
    {
        // Get a storage key.
        $store = $this->getStoreId();

        // Try to load the data from internal storage.
        if (isset($this->cache[$store]))
        {
                return $this->cache[$store];
        }

        // Load the list items.
        $query = $this->_getListQuery();

        try
        {
            if($csv === false){
                $items = $this->_getList($query, $this->getStart(), $this->getState('list.limit'));
            }
            else {
                $items = $this->_getList($query);
            }
        }
        catch (RuntimeException $e)
        {
                $this->setError($e->getMessage());
                return false;
        }

        // Add the items to the internal cache.
        $this->cache[$store] = $items;

        return $this->cache[$store];
    }

    /**
     * Method to get CSV data
     *
     * @access public
     * @return object
     */
    function getCSVData() {

        return $this->getItems(true);
    }

    /**
    * Build an SQL query to load the list data.
    *
    * @return  JDatabaseQuery
    * @since   1.6
    */
    protected function getListQuery()
    {
            $db = $this->getDbo();
            $query = $db->getQuery(true);

            // Select the required fields from the table.
            $query->select(
                    $this->getState( 'list.select', 'a.*' )
            );
            $query->from($db->quoteName('#__taxibooking_orders') . ' AS a');

             // Join over the driver
            $query->select('u.name AS drivername')
                    ->join('LEFT', $db->quoteName('#__taxibooking_users') . ' AS u ON u.user_id = a.driver_id');

            // Join over the payment methods
            $query->select('pm.title AS payment_method')
                    ->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');

            // Filter by published state
            $state = $this->getState('filter.state');
            if ($state == 'P') {
                $query->where('a.state = 1');
            }
            else if ($state == 'U') {
                $query->where('a.state = 0');
            }
            else if ($state == 'A') {
                $query->where('a.state = -1');
            }
            else if ($state == 'W') {
                $query->where('a.state = -2');
            }

            $filter_car = $this->getState('filter.car');
            if ($filter_car) {
                $query->where('a.vehicletype = ' . $filter_car);
            }

            $filter_driver = $this->getState('filter.driver');
            if ($filter_driver) {
                $query->where('a.driver_id = ' . $filter_driver);
            }

            $filter_payment = $this->getState('filter.payment');
            if ($filter_payment>0) {
                $query->where('a.payment = ' . (int)$filter_payment);
            }

            // new
            $filter_operator = $this->getState('filter.operator');
            if ($filter_operator>0) {
                $query->where('a.created_by = ' . (int)$filter_operator);
            }
            // endnew

            // date filtering
            $fromdate = $this->getState('filter.from_date');
            $todate = $this->getState('filter.to_date');
            if($fromdate!='' && $todate != '')
            {
                $fromtime = $this->getState('filter.from_time', '00:00');
                $totime = $this->getState('filter.to_time', '23:59');

                $from_time_str = strtotime($fromdate.' '.$fromtime);
                $to_time_str = strtotime($todate.' '.$totime);

                $this->setState('filter.from_time_str', $from_time_str);
                $this->setState('filter.to_time_str', $to_time_str);

                $query->where('( (a.datetime1 BETWEEN "' . $from_time_str . '" AND "' . $to_time_str . '")
                            OR (a.datetime2 BETWEEN "' . $from_time_str . '" AND "' . $to_time_str . '") )');
            }

            // Filter by search in title
            $search = $this->getState('filter.search');
            if (!empty($search))
            {
                    if (stripos($search, 'id:') === 0)
                    {
                            $query->where('a.id = ' . (int) substr($search, 3));
                    }
                    else
                    {
                            $search = $db->quote('%' . $db->escape($search, true) . '%');
                            $query->where('(a.names LIKE ' . $search . ' OR a.begin LIKE ' . $search . ' OR a.end LIKE ' . $search . ')');
                    }
            }

            // Add the list ordering clause.
            $orderCol = $this->state->get('list.ordering', 'a.datetime1');
            $orderDirn = $this->state->get('list.direction', 'DESC');
            $query->order($db->escape($orderCol . ' ' . $orderDirn));

            //echo nl2br(str_replace('#__','jos_',$query));
            return $query;
    }

    /**
     * Return all the users of Group Driver
     * @return type
     */
    function getPaymentMethods() {

        $extPlgTable = '#__extensions';
        $extField1 = 'extension_id';
        $extField2 = 'element';

        $q = 'SELECT v.id AS value, v.title AS text FROM  `#__taxibooking_paymentmethods` as v ';
        $q .= ' LEFT JOIN `' . $extPlgTable . '` as j ON j.`' . $extField1 . '` =  v.`payment_plugin_id` ';
        $q .= ' WHERE v.`published` = "1" AND j.`folder` = "tbpayment"';
        $q .= ' ORDER BY v.`ordering`';

        $this->_db->setQuery ($q);

        $this->methods = $this->_db->loadObjectList();

        return $this->methods;
    }

    // New:
    function getOperators() {

        $extPlgTable = '#__users';
        $extField1 = 'extension_id';
        $extField2 = 'element';

        //$q = 'SELECT id, name FROM  `#__users`';
        //$q .= ' WHERE  = "1" AND j.`folder` = "tbpayment"';
        $q = 'SELECT name, #__users.id ';
        $q .= 'FROM #__taxibooking_orders LEFT JOIN #__users ';
        $q .= 'ON created_by = #__users.id ';
        $q .= 'WHERE #__users.id > 0';
        //$q .= ' ORDER BY id';

        $this->_db->setQuery ($q);

        $allids = $this->_db->loadObjectList();

        $operators = array_unique($allids, SORT_REGULAR);
        return $operators;
    }
    // endnew

    /**
     * Method to remove a faq item
     *
     * @access	public
     * @return	boolean	True on success
     * @since	1.0
     */
    function delete($cids)
    {
        if (count($cids))
        {
            foreach($cids as $cid)
            {
                // delete car availability record
                booking_helper::cancel_car_bookings($cid);

                // delete payment record
                $orderObj = booking_helper::get_order_by_id($cid);
                $paymentObj = booking_helper::get_payment_details($orderObj->payment);
                if($paymentObj){
                    $payment_tablename = '#__taxibooking_payment_plg_' . $paymentObj->payment_element;

                    $query = "DELETE FROM " . $this->_db->quoteName($payment_tablename) . " WHERE order_id = ".(int)$cid;
                    $this->_db->setQuery($query);
                    $this->_db->execute();
                }

                // now delete the order
                $query = 'DELETE FROM `#__taxibooking_orders` WHERE `id` = '.$this->_db->quote($cid);
                $this->_db->setQuery($query);
                $this->_db->execute();
            }
            return true;
        }
        return false;
    }

    /**
    * Method to auto-populate the model state.
    *
    * Note. Calling getState in this method will result in recursion.
    *
    * @since   1.6
    */
    protected function populateState($ordering = null, $direction = null)
    {
        // Load the filter state.
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $from_date = $this->getUserStateFromRequest($this->context . '.filter.from_date', 'fromdate');
        $this->setState('filter.from_date', $from_date);

        $to_date = $this->getUserStateFromRequest($this->context . '.filter.to_date', 'todate');
        $this->setState('filter.to_date', $to_date);

        $from_time = $this->getUserStateFromRequest($this->context . '.filter.from_time', 'fromtime');
        $this->setState('filter.from_time', $from_time);

        $to_time = $this->getUserStateFromRequest($this->context . '.filter.to_time', 'totime');
        $this->setState('filter.to_time', $to_time);

        $state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
        $this->setState('filter.state', $state);

        $driver = $this->getUserStateFromRequest($this->context . '.filter.driver', 'filter_driver', '', 'string');
        $this->setState('filter.driver', $driver);

        $payment = $this->getUserStateFromRequest($this->context . '.filter.payment', 'filter_payment', '', 'string');
        $this->setState('filter.payment', $payment);

        $operator = $this->getUserStateFromRequest($this->context . '.filter.operator', 'filter_operator', '', 'string');
        $this->setState('filter.operator', $operator);

        $car = $this->getUserStateFromRequest($this->context . '.filter.car', 'filter_car', '', 'string');
        $this->setState('filter.car', $car);

        // Load the parameters.
        $params = JComponentHelper::getParams('com_taxibooking');
        $this->setState('params', $params);

        // List state information.
        parent::populateState('a.datetime1', 'desc');
    }
}
