<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Component Category Model
 */
class TaxibookingModelPoint extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Point', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
		/**
	 * Method to get a single record.
	 *
	 * @param   integer    $pk    The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 * @since   1.6
	 */
	public function getItem($pk = null)
	{
		return parent::getItem($pk);
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($post)
	{
		$app = JFactory::getApplication();
		
		if (parent::save($post))
		{
			$point_id = $this->getState('point.id');
			
			return true;
		}
	
		return false;
	}
	
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
       }
	
	/**
	 * Method to duplicate items.
	 *
	 * @param   array  &$pks  An array of primary key IDs.
	 *
	 * @return  boolean  True if successful.
	 *
	 * @since   1.6
	 * @throws  Exception
	 */
	public function duplicate($pks)
	{
		// Initialise variables.
		$user	= JFactory::getUser();
		$db		= $this->getDbo();

		$table  = $this->getTable();

		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;

				// Alter the title.
				$m = null;
				if (preg_match('#\((\d+)\)$#', $table->title, $m))
				{
					$table->title = preg_replace('#\(\d+\)$#', '('.($m[1] + 1).')', $table->title);
				}
				else
				{
					$table->title .= ' (2)';
				}
				// Unpublish duplicate module
				$table->published = 0;

				if (!$table->check() || !$table->store())
				{
					throw new Exception($table->getError());
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
		}
		// Clear modules cache
		$this->cleanCache();

		return true;
	}
}