<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Searchurl model.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxiBookingModelSearchurl extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Searchurl', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
		/**
	 * Method to get a single record.
	 *
	 * @param   integer    $pk    The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 * @since   1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk))
		{
			$url_params = unserialize($item->url_params);
			if(!empty($url_params)){
				foreach($url_params as $key => $val)
				{
					$item->$key = $val;
				}
			}
		}
		return $item;
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($post)
	{
		$app = JFactory::getApplication();
		
		$booking_type = $post['booking_type'];
		
		$url_params = array();
		
		foreach($post as $key => $val){
			$url_params[$key] = $val;
		}
		
		if($booking_type!='address'){
			$url_params['pickup_type'] = $url_params['dropoff_type'] = 'poi';
			$url_params['pickup_poi'] = $url_params['dropoff_poi'] = 0;
			$url_params['pickup_address'] = $url_params['pickup_lat'] = $url_params['pickup_lng'] = '';
			$url_params['dropoff_address'] = $url_params['dropoff_lat'] = $url_params['dropoff_lng'] = '';
		}
		elseif($booking_type!='offers'){
			$url_params['route_pickup_category'] = $url_params['route_dropoff_category'] = 0;
			$url_params['route_pickup_poi'] = $url_params['route_dropoff_poi'] = 0;
		}
		elseif($booking_type!='hourly'){
			$url_params['hourly_hr'] = $url_params['hourly_min'] = 0;
			$url_params['returntrip']=0;
			$url_params['return_date'] = '';
			$url_params['return_hr'] = $url_params['return_min'] = 0;
		}
		elseif($booking_type!='shuttle'){
			$url_params['shuttle_pickup_poi'] = $url_params['shuttle_dropoff_poi'] = 0;
			$url_params['shuttle_pickup_date'] = '';
			$url_params['shuttletime'] = '';
			$url_params['shuttle_passengers'] = 0;
			$url_params['returntrip']=0;
			$url_params['return_date'] = '';
			$url_params['return_hr'] = $url_params['return_min']=0;
		}
		
		if($booking_type=='address'){
			if($post['pickup_type']=='poi'){
				$url_params['pickup_address'] = $url_params['pickup_lat'] = $url_params['pickup_lng'] = '';
			}
			else {
				$url_params['pickup_poi'] = 0;
			}
			if($post['dropoff_type']=='poi'){
				$url_params['dropoff_address'] = $url_params['dropoff_lat'] = $url_params['dropoff_lng'] = '';
			}
			else {
				$url_params['dropoff_poi'] = 0;
			}
		}
		
		if($post['returntrip']==0){
			$url_params['return_date'] = '';
			$url_params['return_hr'] = $url_params['return_min'] = 0;
		}
		
		$dynamic_param_arr = array();
		if(!empty($post['dynamic_param_key']))
		{
			foreach($post['dynamic_param_key'] as $key => $dynamic_param_key)
			{
				$dynamic_param_arr[] = array(trim($dynamic_param_key), trim($post['dynamic_param_value'][$key]));
			}
		}
		$url_params['dynamic_params'] = $dynamic_param_arr;
		
		unset($url_params['id']);
		unset($url_params['title']);
		unset($url_params['alias']);
		unset($url_params['generated_url']);
		unset($url_params['anchor_text']);
		unset($url_params['anchor_text_html']);
		unset($url_params['text']);
		unset($url_params['published']);
		unset($url_params['option']);
		unset($url_params['controller']);
		unset($url_params['view']);
		unset($url_params['task']);
		
		$post['url_params'] = serialize($url_params);
		$post['dynamic_params'] = serialize($dynamic_param_arr);
		
		if (parent::save($post))
		{
			$searchurl_id = $this->getState('searchurl.id');
			
			return true;
		}
	
		return false;
	}
	
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
       }
	
	/**
	 * Method to duplicate items.
	 *
	 * @param   array  &$pks  An array of primary key IDs.
	 *
	 * @return  boolean  True if successful.
	 *
	 * @since   1.6
	 * @throws  Exception
	 */
	public function duplicate($pks)
	{
		// Initialise variables.
		$user	= JFactory::getUser();
		$db		= $this->getDbo();

		$table  = $this->getTable();

		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;

				// Alter the title.
				$m = null;
				if (preg_match('#\((\d+)\)$#', $table->title, $m))
				{
					$table->title = preg_replace('#\(\d+\)$#', '('.($m[1] + 1).')', $table->title);
				}
				else
				{
					$table->title .= ' (2)';
				}
				// Unpublish duplicate module
				$table->published = 0;

				if (!$table->check() || !$table->store())
				{
					throw new Exception($table->getError());
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
		}
		// Clear modules cache
		$this->cleanCache();

		return true;
	}
}