<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Component Model
 */
class TaxibookingModelShuttle extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Shuttle', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
	/**
	 * Method to get a single record.
	 *
	 * @param   integer    $pk    The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 * @since   1.6
	 */
	public function getItem($pk = null)
	{
		return parent::getItem($pk);
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($data)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$date = JFactory::getDate();
		
		if (parent::save($data))
		{
			$shuttle_id = $this->getState('shuttle.id');
			
			// store route stops if something is changed in stops section
			if(isset($data['is_stops_changed']) && $data['is_stops_changed']==1)
			{
				// first delete previous entries
				$db = JFactory::getDbo();
				$query = $db->getQuery(true);
				$conditions = array(
				    $db->quoteName('route_id') . ' = '.$db->quote($shuttle_id)
				);
				 
				$query->delete($db->quoteName('#__taxibooking_shuttle_route_stops'));
				$query->where($conditions);
				$db->setQuery($query);
				$result = $db->query();
				
				// process post stops array to remove duplicate
				$post_stops = array('stop_poi' => array(),
						    'stop_price' => array(),
						    'stop_arrival_hr' => array(),
						    'stop_arrival_min' => array()
						    );
				if(!empty($data['stop_poi']))
				{
					$i = 0;
					foreach($data['stop_poi'] as $key => $stop_poi)
					{
						if($stop_poi > 0)
						{
							$post_stops['stop_poi'][$i] = $stop_poi;
							$post_stops['stop_price'][$i] = $data['stop_price'][$key];
							$post_stops['stop_arrival_hr'][$i] = $data['stop_arrival_hr'][$key];
							$post_stops['stop_arrival_min'][$i] = $data['stop_arrival_min'][$key];
							
							$i++;
						}
					}
				}
				
				for($i = 0; $i < count($post_stops['stop_poi']); $i++)
				{
					if($post_stops['stop_poi'][$i] > 0)
					{
						$object = new stdClass();
						$object->route_id = $shuttle_id;
						$object->poi_id = $post_stops['stop_poi'][$i];
						$object->price_per_passenger = !empty($post_stops['stop_price'][$i]) ? $post_stops['stop_price'][$i] : 0;
						$object->arrival_time = $post_stops['stop_arrival_hr'][$i].$post_stops['stop_arrival_min'][$i].'00';
						$object->is_start		= ($i==0) ? 1 : 0;
						$object->is_end			= ($i==(count($post_stops['stop_poi'])-1) ) ? 1 : 0;
						$object->created 		= $date->toSQL();
						$object->created_by		= $user->get('id');
						$object->published		= 1;
						$object->ordering		= $i+1;
						 
						// Update their details in the users table using id as the primary key.
						$result = $db->insertObject('#__taxibooking_shuttle_route_stops', $object);
					}
				}
			}
			
			return true;
		}
	
		return false;
	}
	
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
	}
	
	/**
	 * Method to duplicate items.
	 *
	 * @param   array  &$pks  An array of primary key IDs.
	 *
	 * @return  boolean  True if successful.
	 *
	 * @since   1.6
	 * @throws  Exception
	 */
	public function duplicate($pks)
	{
		// Initialise variables.
		$user	= JFactory::getUser();
		$db		= $this->getDbo();

		$table  = $this->getTable();

		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;

				// Alter the title.
				$m = null;
				if (preg_match('#\((\d+)\)$#', $table->title, $m))
				{
					$table->title = preg_replace('#\(\d+\)$#', '('.($m[1] + 1).')', $table->title);
				}
				else
				{
					$table->title .= ' (2)';
				}
				// Unpublish duplicate module
				$table->published = 0;

				if (!$table->check() || !$table->store())
				{
					throw new Exception($table->getError());
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
		}
		// Clear modules cache
		$this->cleanCache();

		return true;
	}
}