<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Tarrif model.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxiBookingModelTariff extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Tariff', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to load all cars
	 *
	 * @access	private
	 * @return	boolean	True on success
	 * @since	1.0
	 */
	public function getCars()
	{
		$query = 'SELECT *'
			. ' FROM #__taxibooking_cars'
			. ' WHERE published = 1'
			. ' AND use_as_shuttle != 2' // cars used only as shuttle will not be listed in other booking types
			. ' ORDER BY title'
			;
		$this->_db->setQuery($query);
		$cars = $this->_db->loadObjectList();
    
		return $cars;
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($data)
	{
		$app = JFactory::getApplication();
		$date = JFactory::getDate();
		
		$data['assigned_cars'] = implode(',', $data['car_ids']);

		// prepare days-availability
		if (key_exists('days_availability', $data) && is_array($data['days_availability'])){
			$data['days_availability'] = serialize($data['days_availability']);
		}
		
		// prepare special dates
                $special_dates_arr = array();
		for($i = 0; $i < count($data['special_dates']); $i++)
		{
			if(isset($data['special_dates'][$i]) && $data['special_dates'][$i] != "")
			{
				$special_dates_arr[] = $data['special_dates'][$i];	
			}
		}
		
		if($data['special_date_enabled']==1){
			$data['days_availability'] = 'a:7:{i:0;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:1;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:2;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:3;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:4;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:5;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:6;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}}';
		}
		else {
			$special_dates_arr = array();
		}
		
		$data['special_dates'] = serialize($special_dates_arr);
		
		if (parent::save($data))
		{
			$tariff_id = $this->getState('tariff.id');
			
			return true;
		}
	
		return false;
	}
	
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
       }
	
	/**
	 * Method to duplicate items.
	 *
	 * @param   array  &$pks  An array of primary key IDs.
	 *
	 * @return  boolean  True if successful.
	 *
	 * @since   1.6
	 * @throws  Exception
	 */
	public function duplicate($pks)
	{
		// Initialise variables.
		$user	= JFactory::getUser();
		$db		= $this->getDbo();

		$table  = $this->getTable();

		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;

				// Alter the title.
				$m = null;
				if (preg_match('#\((\d+)\)$#', $table->title, $m))
				{
					$table->title = preg_replace('#\(\d+\)$#', '('.($m[1] + 1).')', $table->title);
				}
				else
				{
					$table->title .= ' (2)';
				}
				// Unpublish duplicate module
				$table->published = 0;

				if (!$table->check() || !$table->store())
				{
					throw new Exception($table->getError());
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
		}
		// Clear modules cache
		$this->cleanCache();

		return true;
	}
}