<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modeladmin');

/**
 * Component Category Model
 */
class TaxibookingModelTbuser extends JModelAdmin
{
	/**
	* Returns a JTable object, always creating it.
	*
	* @param   string  $type    The table type to instantiate. [optional]
	* @param   string  $prefix  A prefix for the table class name. [optional]
	* @param   array   $config  Configuration array for model. [optional]
	*
	* @return  JTable  A database object
	*
	* @since   1.6
	*/
	public function getTable($type = 'Tbuser', $prefix = 'TaxibookingTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		return false;
	}
	
	/**
	 * Method to get a single record.
	 *
	 * @param   integer    $pk    The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 * @since   1.6
	 */
	public function getItem($pk = null)
	{
		return parent::getItem($pk);
	}
	
	/**
	* Prepare and sanitise the table prior to saving.
	*
	* @param   JTable  $table  A JTable object.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
	
		if (empty($table->id))
		{
		    // Set the values
		    $table->created = $date->toSql();
		    $table->created_by	= $user->get('id');
		}
		else
		{
		    // Set the values
		    $table->modified	= $date->toSql();
		    $table->modified_by	= $user->get('id');
		}
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($post)
	{
		$app = JFactory::getApplication();
		
		if($post['is_corporate_client']==0){
			$post['client_organization_name'] = '';
			$post['client_organization_address'] = '';
			$post['client_registration_number'] = '';
			$post['client_vat'] = '';
		}
		
		if($post['is_driver']==0){
			$post['driver_badge_number'] = '';
			$post['show_badge_number_email'] = 0;
			$post['show_phone_number_email'] = 0;
			$post['driver_address'] = '';
			$post['driver_date_employment_commenced'] = '';
			$post['driver_date_employment_terminated'] = '';
			$post['driver_date_insurance_end'] = '';
			$post['driver_rent_amount'] = 0;
			$post['driver_rent_payable_date'] = '';
		}
		else {
			$post['phone'] = $post['driver_phone_number'];
		}
		
		if (parent::save($post))
		{
			$tbuser_id = $this->getState('tbuser.id');
			
			return true;
		}
	
		return false;
	}
	
	/**
	* Method to order Items
	*
	* @access	public
	* @return	boolean	True on success
	* @since	1.0
	*/
	public function saveorder($pks = null, $order = null)
	{
		$table  = $this->getTable();
		
		$i = 0;
		foreach ($pks as $pk)
		{
			if ($table->load($pk, true))
			{
				if ($table->ordering != $order[$i])
				{
					$table->ordering = $order[$i];
					if (!$table->check() || !$table->store())
					{
						throw new Exception($table->getError());
					}
				}
			}
			else
			{
				throw new Exception($table->getError());
			}
			$i++;
		}
	
		return true;
	}
	
	/**
	 * Method to delete one or more records.
	 *
	 * @param   array  &$pks  An array of record primary keys.
	 *
	 * @return  boolean  True if successful, false if an error occurs.
	 *
	 * @since   12.2
	 */
	public function delete(&$pks)
	{
		$user  = JFactory::getUser();
		$pks = (array) $pks;
		$table = $this->getTable();
		
		
		// Check if I am a Super Admin
		$iAmSuperAdmin = $user->authorise('core.admin');
		
		// parameter pks contains tbUserId, but we need Joomla User ID here
		$jpks = array();
		foreach ($pks as $i => $pk)
		{
			$query = $this->_db->getQuery(true);
			$query->select('user_id');
			$query->from('#__taxibooking_users');
			$query->where('id = '.(int)$pk);
			$this->_db->setQuery((string)$query);
			$jUserId = $this->_db->loadResult();
			
			$jpks[$i] = $jUserId;
		}
		
		if (in_array($user->id, $jpks))
		{
			$this->setError(JText::_('TBUSERS_ERROR_CANNOT_DELETE_SELF'));

			return false;
		}

		// Iterate the items to delete each one.
		foreach ($pks as $i => $pk)
		{
			if ($table->load($pk))
			{
				if ($this->canDelete($table))
				{
					$jUsertable = JTable::getInstance('User', 'JTable');
					
					// Access checks.
					$allow = $user->authorise('core.delete', 'com_users');
	
					// Don't allow non-super-admin to delete a super admin
					$allow = (!$iAmSuperAdmin && JAccess::check($jpks[$i], 'core.admin')) ? false : $allow;
					
					if($allow)
					{
						// first remove this user from Joomla User database
						if ($jUsertable->load($jpks[$i]))
						{
							$jUsertable->delete($jpks[$i]);
							
							// delete record from child users database
							$query = 'DELETE FROM `#__taxibooking_user_childs` WHERE (`child_user_id` = '.(int) $jpks[$i].' OR `parent_user_id` = '.(int) $jpks[$i].')';
							$this->_db->setQuery($query);
							$this->_db->execute();
						}
						
						// now remove TB user
						$context = $this->option . '.' . $this->name;
						if (!$table->delete($pk))
						{
							$this->setError($table->getError());
							return false;
						}
					}
					else {
						// Prune items that you can't change.
						unset($pks[$i]);
						unset($jpks[$i]);
						$this->setError(JText::_('JERROR_CORE_DELETE_NOT_PERMITTED'));
						return false;
					}
				}
				else
				{
					// Prune items that you can't change.
					unset($pks[$i]);
					unset($jpks[$i]);
					$error = $this->getError();
					if ($error)
					{
						JLog::add($error, JLog::WARNING, 'jerror');
						return false;
					}
					else
					{
						JLog::add(JText::_('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED'), JLog::WARNING, 'jerror');
						return false;
					}
				}
			}
			else
			{
				$this->setError($table->getError());
				return false;
			}
		}

		// Clear the component's cache
		$this->cleanCache();

		return true;
	}
}