<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
/**
 * Script file of Taxibooking component
 */
class com_taxibookingInstallerScript
{
	/** @var string The component's name */
	protected $_adsmanager_extension = 'com_taxibooking';
	
	/** @var array The list of extra modules and plugins to install */
	private $installation_queue = array(
		// modules => { (folder) => { (module) => { (position), (published) } }* }*
		'modules' => array(
			'site' => array(
				'taxibooking' => array('left', 0)
			)
		),
		'plugins' => array(
			'tbpayment' => array(
				'cash'	=> 1,
				'paypal'=> 1
			),
			'system' => array(
				'tbapp' => 1,
				'tbschedules' => 1
			)
		)
	);
	
	/*
	 * method to run before an install/update/uninstall method
	 * preflight runs before anything else and while the extracted files are in the uploaded temp folder.
	 * If preflight returns false, Joomla will abort the update and undo everything already done.
	 */
        function preflight($type, $parent) 
        {
                // $parent is the class calling this method
                // $type is the type of change (install, update or discover_install)
		
		// Installing component manifest file version
		$this->release = $parent->get( "manifest" )->version;
		
                //echo '<p>' . JText::_('COM_TAXIBOOKING_PREFLIGHT_' . $type . '_TEXT') . '</p>';
        }
	
        /**
         * method to install the component
         *
         * @return void
         */
        function install($parent) 
        {
		//echo '<p>' . JText::sprintf('COM_TAXIBOOKING_INSTALL_TEXT', $this->release) . '</p>';
                // $parent is the class calling this method
                //$parent->getParent()->setRedirectURL('index.php?option=com_taxibooking&view=settings');
		
		$this->_generateNewConfigs('install');
        }
 
        /**
         * method to uninstall the component
         *
         * @return void
         */
        function uninstall($parent) 
        {
                // $parent is the class calling this method
                //echo '<p>' . JText::sprintf('COM_TAXIBOOKING_UNINSTALL_TEXT', $this->release) . '</p>';
        }
 
        /**
         * method to update the component
         *
         * @return void
         */
        function update($parent) 
        {
                // $parent is the class calling this method
                //echo '<p>' . JText::sprintf('COM_TAXIBOOKING_UPDATE_TEXT', $parent->get('manifest')->version) . '</p>';
		//$parent->getParent()->setRedirectURL('index.php?option=com_taxibooking&view=settings');
		
		//$this->displayFinished(true);
		
		$this->_generateNewConfigs('update');
		return true;
        }
 
        /**
         * method to run after an install/update/uninstall method
         *
         * @return void
         */
        function postflight($type, $parent) 
        {
                // $parent is the class calling this method
                // $type is the type of change (install, update or discover_install)
                //echo '<p>' . JText::_('COM_TAXIBOOKING_POSTFLIGHT_' . $type . '_TEXT') . '</p>';
		
		$this->release = $parent->get( "manifest" )->version;
		
		$app_token = time();
		
		// Install subextension
		$status = $this->_installSubextensions($parent, $type, $app_token);
		
		$this->displayFinished(false, $status, $parent);
		
		$this->_addAppCompany($this->release, $app_token);
		
		return true;
        }
	
	private function _generateNewConfigs($action)
	{
		$app	= JFactory::getApplication();
		$conf	= JFactory::getConfig();
		$db = JFactory::getDBO();
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		$lang 	= JFactory::getLanguage();
		
		$config_sections = array();
		$config_sections['general-settings'] = array(
			'title' => 'General Settings',
			'params' => array(
				'distance_unit' => 'mile',
				'restrict_time' => 3,
				'date_format' => 'dd-mm-yy',
				'datepicker_type' => 'jquery',
				'time_format' => '24hr',
				'load_current_date' => 1,
				'show_address_tab' => 1,
				'show_from_poi' => 1,
				'show_from_address' => 1,
				'show_to_poi' => 1,
				'show_to_address' => 1,
				'show_offers_tab' => 1,
				'enable_route_swap' => 1,
				'show_poi_categories' => 0,
				'show_hourly_tab' => 1,
				'show_shuttles_tab' => 1,
				'default_tab' => 'address',
				'default_adult_seat' => 0,
				'show_suitcase_select' => 1,
				'invoice_title' => 'taxi_booking',
				'enable_captcha' => 1,
				'combine_car_type' => 0,
				'display_car_types' => 0,
				'usergroups_allowed_import_orders' => array(),
				'booking_cancellation_allowed' => 0,
				'booking_cancellation_prior_hrs' => 0,
				//'timestamp_collect_disabled_dates' => 0,
				//'timestamp_archive_orders' => 0,
			)
		);
		
		$config_sections['price-settings'] = array(
			'title' => 'General Price Settings',
			'params' => array(
				'show_price' => 1,
				'auto_approve_free_order' => 1,
				'debug_price_calculation' => 1,
				'roundup_price' => 'no',
				'cost_per_call' => 0,
				'minmil' => 0,
				'minprice' => 0,
				'show_infant_select' => 1,
				'infant_seat_price' => 0,
				'show_child_select' => 1,
				'child_seat_price' => 0,
				'show_booster_select' => 1,
				'booster_seat_price' => 0,
				'currency' => '',
				'currency_symbol' => '',
				'price_per_unit_distance' => 0,
				'enable_charge_per_min' => 0,
				'charge_per_min' => 0,
				'show_return_option' => 1,
				'discount' => 0,
				'show_return_extras' => 0,
				'wait_time_return_discount' => 0,
				'return_discounts' => array(),
				'price_calculation_cumulative' => 0,
				'cumulative_distance_prices' => array(),
				'distance_prices' => array(),
				'enable_gratuity' => 0,
				'gratuities' => array(),
				'enable_gratuity_flat' => 1,
			)
		);
		
		$config_sections['map-settings'] = array(
			'title' => 'Map Settings',
			'params' => array(
				'show_map_address' => 1,
				'show_map_offers' => 1,
				'show_map_shuttles' => 1,
				'map_height' => '300',
				'map_zoom' => '10',
				'dir_height' => '200',
				'ssl_enabled' => 0,
				'api_key' => '',
				'api_client_id' => '',
				'api_client_signature' => '',
				'enable_stops' => 0,
				'show_stop_poi' => 0,
				'show_stop_address' => 0,
				'max_stop_time' => 0,
				'stop_duration_interval' => '15',
				'stops_charge_per_min' => 0,
				'optimize_stops' => 1,
			)
		);
		
		$super_user_email = $conf->get('mailfrom');
		$default_operation_area_vertices = '[[51.629949539313905,-0.5104715976563057],[51.36834810929568,-0.3786356601563057],[51.447157400846535,0.2695576992186943],[51.83916879427223,0.3189961757811943]]';
		$config_sections['base-settings'] = array(
			'title' => 'Base Settings',
			'params' => array(
				'default_country' => '222',
				'default_city' => 'London',
				'booking_company_name' => '',
				'booking_notification_email' => $super_user_email, 
				'operation_area_vertices' => $default_operation_area_vertices,
				'pickup_in_area' => 0,
				'dropoff_in_area' => 0,
				'pickup_dropoff_in_area' => 0,
				'base_lat' => '',
				'base_long' => '',
				'calculate_base_pickup' => 0,
				'base_pickup_special_routes' => 'price_time',
				'base_pickup_price_type' => 'flat',
				'base_pickup_price' => 0,
				'calculate_dropoff_base' => 0,
				'base_dropoff_special_routes' => 'price_time',
				'dropoff_base_price_type' => 'flat',
				'dropoff_base_price' => 0,
				'time_after_each_booking' => 0,
			)
		);
		
		$config_sections['gcal-settings'] = array(
			'title' => 'Google Calendar Settings',
			'params' => array(
				'google_client_id' => '',
				'google_app_name' => '',
				'google_app_email_address' => '',
				'google_p12_key_filename' => '',
			)
		);
		
		$config_sections['orderemail-settings'] = array(
			'title' => 'Order Email Settings',
			'params' => array(
				'additional_emails' => '',
				'send_order_copy' => 1,
				'header_logo' => ''
			)
		);
		
		$config_sections['terms-settings'] = array(
			'title' => 'Terms Settings',
			'params' => array(
				'use_terms' => 1,
			)
		);
		
		foreach($lang->getKnownLanguages() as $tag => $lang)
		{
			$header_info = 'header_info['.$tag.']';
			$contact_info = 'contact_info['.$tag.']';
			$terms_conditions = 'terms_conditions['.$tag.']';
			
			$config_sections['orderemail-settings']['params']['header_info'][$tag] = '';
			$config_sections['orderemail-settings']['params']['contact_info'][$tag] = '';
			$config_sections['terms-settings']['params']['terms_conditions'][$tag] = '';
		}
		
		$config_sections['design-settings'] = array(
			'title' => 'Design Settings',
			'params' => array(
				'booking_form_bgcolor' => '#006599',
				'booking_form_active_tab_color' => '#006599',
				'booking_form_inactive_tab_color' => '#1aa1bf',
				'booking_form_boxcolor' => '#2D2D2D',
				'booking_form_fontcolor' => '#FFFFFF',
				'booking_form_boxes_fontcolor' => '#FFFFFF',
				'booking_form_header_tabs_fontcolor' => '#FFFFFF',
				'other_steps_fontcolor' => '#999999',
				'booking_form_btncolor' => '#1aa1bf',
				'highlights_color' => '#1aa1bf',
			)
		);
		
		$config_sections['sms-settings'] = array(
			'title' => 'SMS Settings',
			'params' => array(
				'send_user_sms' => 0,
				'clickatell_api_id' => '',
				'clickatell_api_username' => '',
				'clickatell_api_password' => '',
				'country_calling_code' => '',
				'clickatell_sender_id' => '',
			)
		);
		//echo '<pre>';
		//print_r($config_sections);
		
		// If action is update, fetch old config params first
		if($action=='update')
		{
			// if user is updating from a very older version before 3.10.4
			// then configs will be fetched from old settings table
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_configs');
			$db->setQuery((string)$query);
			$rows = $db->loadObjectList();
			
			if(count($rows) > 0) // update is from version after 3.10.4 as there are rows in latest configs table
			{
				foreach($rows as $row)
				{
					$oldParams = unserialize($row->text);
					
					$section_arr = $config_sections[$row->alias];
					foreach($section_arr['params'] as $field_name => $value)
					{
						if(isset($oldParams[$field_name])){
							$section_arr['params'][$field_name] = $oldParams[$field_name];
						}
					}
					$config_sections[$row->alias]['params'] = $section_arr['params'];
				}
			}
			else {
				// update is from version before 3.10.4 as there are no row found in latest configs table
				// at 3.10.4, old settings table data are added in latest configs table on Settings view
				// but in recent release, that is happened in script.php
				// fetch old settings object first
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_settings');
				$query->where('id = 1');
				$db->setQuery((string)$query);
				$oldSettings = $db->loadObject();
				$oldParams = unserialize($oldSettings->params);
				//print_r($oldParams);
				
				// now move to creating config for each section
				foreach($config_sections as $section_key => $section_arr)
				{
					foreach($section_arr['params'] as $field_name => $value)
					{
						if(isset($oldParams[$field_name])){
							$section_arr['params'][$field_name] = $oldParams[$field_name];
						}
					}
					$config_sections[$section_key]['params'] = $section_arr['params'];
				}
			}
			
			// Add database column if it is added already by database sql 
			$tablename = '#__taxibooking_orders';
			$missing_fields = array(
				'gratuity_amt'  => 'FLOAT( 10, 2 ) NOT NULL DEFAULT \'0\'',
				'gratuity_amttype'  => 'CHAR( 10 ) NOT NULL',
				'gratuity_percent_value' => 'FLOAT( 10, 2 ) NOT NULL DEFAULT \'0\''
			);
			
			$current_fields = array();
			$db->setQuery('SHOW COLUMNS FROM '.$db->quoteName($tablename));
			$rows = $db->loadObjectList();
			if(!empty($rows))
			{
				foreach($rows as $row){
					$current_fields[] = $row->Field;
				}
			}
			
			foreach ($missing_fields as $fieldname => $fieldtype)
			{
				if(!in_array($fieldname,$current_fields))
				{
					$query = "ALTER TABLE " . $db->quoteName($tablename) . " ADD " . $db->quoteName($fieldname) . " $fieldtype";
					$db->setQuery($query);
					$db->execute();
				}
			}
		}
		
		foreach($config_sections as $section_key => $section_arr)
		{
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_configs');
			$query->where('alias = '.$db->Quote($section_key));
			$db->setQuery((string)$query);
			$row = $db->loadObject();
			
			if($row){ // update this config
				$temp = new stdClass();
				$temp->id = $row->id;
				$temp->title = $section_arr['title'];
				$temp->alias = $section_key;
				$temp->text = serialize($section_arr['params']);
				$temp->created = $date->toSql();
				$temp->created_by = $user->get('id');
		       
				$db->updateObject('#__taxibooking_configs', $temp, 'id');
			}
			else { // create this new config
				$temp = new stdClass();
				$temp->title = $section_arr['title'];
				$temp->alias = $section_key;
				$temp->text = serialize($section_arr['params']);
				$temp->created = $date->toSql();
				$temp->created_by = $user->get('id');
		       
				$db->insertObject('#__taxibooking_configs', $temp);
			}
		}
		
		return true;
	}
	
	private function _addAppCompany($tbversion, $app_token)
	{
		// first collect session token
		/*$q = "#";
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $q);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$token = curl_exec($ch);
		curl_close($ch);*/
		
		// post new company details with token
		$config   = JFactory::getConfig();
		$sitename = $config->get('sitename');
		$company_url = rtrim(JURI::root(), '/');
		
		//set POST variables
		$post_url = "https://kabsky.co.uk/reviews";
		
		$operation_area_vertices = '[[51.629949539313905,-0.5104715976563057],[51.36834810929568,-0.3786356601563057],[51.447157400846535,0.2695576992186943],[51.83916879427223,0.3189961757811943]]';
		
		$fields = array(
			'token'			=> urlencode('kanev'),
			'company_name'		=> urlencode($sitename),
			'company_url'		=> urlencode($company_url),
			'operation_area_vertices'=> urlencode($operation_area_vertices),
			'app_token'		=> urlencode($app_token),
			'tbversion'		=> urlencode($tbversion)
		);
		
		//url-ify the data for the POST
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');
		
		//open connection
		$ch = curl_init();
		
		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL, $post_url);
		curl_setopt($ch,CURLOPT_POST, count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		
		//execute post
		$result = curl_exec($ch);
		
		//close connection
		curl_close($ch);
	}
	
	/**
	 * Installs subextensions (modules, plugins) bundled with the main extension
	 * 
	 * @param JInstaller $parent 
	 * @return JObject The subextension installation status
	 */
	private function _installSubextensions($parent, $type, $app_token)
	{
		$src = $parent->getParent()->getPath('source');
		
		$db = JFactory::getDbo();
		
		$status = new JObject();
		$status->modules = array();
		$status->plugins = array();
		
		// Modules installation
		if(count($this->installation_queue['modules'])) {
			foreach($this->installation_queue['modules'] as $folder => $modules) {
				if(count($modules)) foreach($modules as $module => $modulePreferences) {
					// Install the module
					if(empty($folder)) $folder = 'site';
					$path = "$src/modules/$folder/$module";
					if(!is_dir($path)) {
						$path = "$src/modules/$folder/mod_$module";
					}
					if(!is_dir($path)) {
						$path = "$src/modules/$module";
					}
					if(!is_dir($path)) {
						$path = "$src/modules/mod_$module";
					}
					if(!is_dir($path)) continue;
					
					// Was the module already installed?
					$sql = $db->getQuery(true)
					->select('COUNT(*)')
					->from('#__modules')
					->where($db->qn('module').' = '.$db->q('mod_'.$module));
					$db->setQuery($sql);
					$count = $db->loadResult();
					
					$installer = new JInstaller;
					$result = $installer->install($path);
					$status->modules[] = array(
						'name'=>'mod_'.$module,
						'client'=>$folder,
						'result'=>$result
					);
					
					// Modify where it's published and its published state
					if(!$count) {
						// A. Position and state
						list($modulePosition, $modulePublished) = $modulePreferences;
						if($modulePosition == 'cpanel') {
							$modulePosition = 'icon';
						}
						if(version_compare(JVERSION, '3.0.0', 'ge')) {
							if ($modulePosition == "left") {
								$modulePosition = 'position-7';
							}
						}
						
						$sql = $db->getQuery(true)
							->update($db->qn('#__modules'))
							->set($db->qn('position').' = '.$db->q($modulePosition))
							->where($db->qn('module').' = '.$db->q('mod_'.$module));
						if($modulePublished) {
							$sql->set($db->qn('published').' = '.$db->q('1'));
						}
						$db->setQuery($sql);
						$db->query();
						
						// B. Change the ordering of back-end modules to 1 + max ordering
						if($folder == 'admin') {
							$query = $db->getQuery(true);
							$query->select('MAX('.$db->qn('ordering').')')
								->from($db->qn('#__modules'))
								->where($db->qn('position').'='.$db->q($modulePosition));
							$db->setQuery($query);
							$position = $db->loadResult();
							$position++;

							$query = $db->getQuery(true);
							$query->update($db->qn('#__modules'))
								->set($db->qn('ordering').' = '.$db->q($position))
								->where($db->qn('module').' = '.$db->q('mod_'.$module));
							$db->setQuery($query);
							$db->query();
						}
						
						// C. Link to all pages
						$query = $db->getQuery(true);
						$query->select('id')->from($db->qn('#__modules'))
							->where($db->qn('module').' = '.$db->q('mod_'.$module));
						$db->setQuery($query);
						$moduleid = $db->loadResult();

						$query = $db->getQuery(true);
						$query->select('*')->from($db->qn('#__modules_menu'))
							->where($db->qn('moduleid').' = '.$db->q($moduleid));
						$db->setQuery($query);
						$assignments = $db->loadObjectList();
						$isAssigned = !empty($assignments);
						if(!$isAssigned) {
							$o = (object)array(
								'moduleid'	=> $moduleid,
								'menuid'	=> 0
							);
							$db->insertObject('#__modules_menu', $o);
						}
					}
				}
			}
		}
		
		// Plugins installation
		if(count($this->installation_queue['plugins'])) {
			foreach($this->installation_queue['plugins'] as $folder => $plugins) {
				if(count($plugins)) foreach($plugins as $plugin => $published) {
					$path = "$src/plugins/$folder/$plugin";
					
					if(!is_dir($path)) {
						$path = "$src/plugins/$folder/plg_$plugin";
					}
					if(!is_dir($path)) {
						$path = "$src/plugins/$plugin";
					}
					if(!is_dir($path)) {
						$path = "$src/plugins/plg_$plugin";
					}
					if(!is_dir($path)) continue;

					// Was the plugin already installed?
					$query = $db->getQuery(true)
						->select('COUNT(*)')
						->from($db->qn('#__extensions'))
						->where($db->qn('element').' = '.$db->q($plugin))
						->where($db->qn('folder').' = '.$db->q($folder));
					$db->setQuery($query);
					$count = $db->loadResult();
					
					$installer = new JInstaller;
					$result = $installer->install($path);
					
					$status->plugins[] = array('name'=>'plg_tbpayment_'.$plugin,'group'=>$folder, 'result'=>$result);

					if($published && !$count) {
						$query = $db->getQuery(true)
							->update($db->qn('#__extensions'))
							->set($db->qn('enabled').' = '.$db->q('1'))
							->where($db->qn('element').' = '.$db->q($plugin))
							->where($db->qn('folder').' = '.$db->q($folder));
						$db->setQuery($query);
						$db->query();
					}
					
					// set params for tbapp plugin only for new installs
					// param is just a unique security token
					if($plugin=='tbapp' && $type=='install'){
						$query = $db->getQuery(true)
							->update($db->qn('#__extensions'))
							->set($db->qn('params').' = '.$db->q('{"security_token":"'.$app_token.'"}'))
							->set($db->qn('enabled').' = '.$db->q('1'))
							->where($db->qn('element').' = '.$db->q($plugin))
							->where($db->qn('folder').' = '.$db->q($folder));
						$db->setQuery($query);
						$db->query();
					}
					
					//  from 3.12.5, let's leave to whatever Admin sets it
					// no need to force resetting all params in Schedule plugin on TB update
					//if($plugin=='tbschedules' && $type=='update')
					//{
						//$params_arr = array();
						//$params_arr['disable_dates_collect_enabled'] = 1;
						//$params_arr['collect_disabled_dates_freq'] = 60;
						//$params_arr['archive_orders_enabled'] = 1;
						//$params_arr['archive_orders_freq'] = 1440;
						//$params_arr['send_tbcorporate_invoice_enabled'] = 1;
						//$params_arr['tbcorporate_invoice_sending_freq'] = 1440;
						//$params_arr['tbcorporate_invoice_send_days'] = 5;
						
						//$registry = new JRegistry;
						//$registry->loadArray($params_arr);
						//$params_arr = (string) $registry;
						
						//$query = $db->getQuery(true)
							//->update($db->qn('#__extensions'))
							//->set($db->qn('params').' = '.$db->q($params_arr))
							//->set($db->qn('enabled').' = '.$db->q('1'))
							//->where($db->qn('element').' = '.$db->q($plugin))
							//->where($db->qn('folder').' = '.$db->q($folder));
						//$db->setQuery($query);
						//$db->query();
					//}
				}
			}
		}

		return $status;
	}
	
	public function displayFinished($update, $status = false, $parent = false){

		$lang = JFactory::getLanguage();
		//Load first english files
		$lang->load('com_taxibooking.sys',JPATH_ADMINISTRATOR,'en_GB',true);
		$lang->load('com_taxibooking',JPATH_ADMINISTRATOR,'en_GB',true);

		//load specific language
		$lang->load('com_taxibooking.sys',JPATH_ADMINISTRATOR,null,true);
		$lang->load('com_taxibooking',JPATH_ADMINISTRATOR,null,true);
		?>
		
		<script type="text/javascript">
		setTimeout(function(){
			window.location = "<?php echo JURI::base().'index.php?option=com_taxibooking&controller=configs&task=edit&cid[]=4'; ?>";
		}, 2000);
		</script>

<div align="center">
	<table
		width="100%"
		border="0">
		<tr>
			<td
				valign="top"
				align="center">
				<h2><?php echo JText::_('COM_TAXIBOOKING_INSTALLATION_WELCOME') ?></h2>
			</td>
			<td>
				<h3>
				<?php
				if($update){
					echo JText::_('COM_TAXIBOOKING_UPGRADE_SUCCESSFUL');
				} else {
					echo JText::_('COM_TAXIBOOKING_INSTALLATION_SUCCESSFUL');
				}
				?>
				</h3>
				<a href="<?php echo JURI::base().'index.php?option=com_taxibooking&controller=configs&task=edit&cid[]=4'; ?>">
					<?php echo JText::_('COM_TAXIBOOKING_CONFIGURE'); ?>
				</a>
			</td>
		</tr>
	</table>
	
	
	<table class="adminlist table table-striped" width="100%">
		<thead>
			<tr>
				<th class="title" colspan="2">Extension</th>
				<th width="30%">Status</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="3"></td>
			</tr>
		</tfoot>
		<tbody>
			<tr class="row0">
				<td class="key" colspan="2">Taxibooking component</td>
				<td><strong style="color: green">Installed</strong></td>
			</tr>
			<?php if (count($status->modules)) : ?>
			<tr>
				<th>Module</th>
				<th>Client</th>
				<th></th>
			</tr>
			<?php foreach ($status->modules as $module) : ?>
			<tr class="row<?php echo ($rows++ % 2); ?>">
				<td class="key"><?php echo $module['name']; ?></td>
				<td class="key"><?php echo ucfirst($module['client']); ?></td>
				<td><strong style="color: <?php echo ($module['result'])? "green" : "red"?>"><?php echo ($module['result'])?'Installed':'Not installed'; ?></strong></td>
			</tr>
			<?php endforeach;?>
			<?php endif;?>
			<?php if (count($status->plugins)) : ?>
			<tr>
				<th>Plugin</th>
				<th>Group</th>
				<th></th>
			</tr>
			<?php foreach ($status->plugins as $plugin) : ?>
			<tr class="row<?php echo ($rows++ % 2); ?>">
				<td class="key"><?php echo $plugin['name']; ?></td>
				<td class="key"><?php echo $plugin['group']; ?></td>
				<td><strong style="color: <?php echo ($plugin['result'])? "green" : "red"?>"><?php echo ($plugin['result'])?'Installed':'Not installed'; ?></strong></td>
			</tr>
			<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
</div>

<?php
	}

}