--
-- Table structure for table `#__taxibooking_cars`
--
DROP TABLE IF EXISTS `#__taxibooking_cars`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_cars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `min_passenger_no` int(11) NOT NULL DEFAULT '0',
  `passenger_no` int(11) NOT NULL,
  `suitcase_no` int(11) NOT NULL,
  `booster_seat_no` int(11) NOT NULL,
  `infant_seat_no` int(11) NOT NULL,
  `child_seat_no` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `add_price_return` tinyint(4) NOT NULL DEFAULT '0',
  `price_calculation_cumulative` tinyint(4) NOT NULL DEFAULT '0',
  `distance_prices` text NOT NULL,
  `cumulative_distance_prices` text NOT NULL,
  `unit_price_override` tinyint(4) NOT NULL DEFAULT '0',
  `use_tariff` tinyint(4) NOT NULL DEFAULT '0',
  `unit_price` decimal(10,2) NOT NULL,
  `track_availability` tinyint(4) NOT NULL DEFAULT '1',
  `days_availability` text NOT NULL,
  `blocked_dates` text NOT NULL,
  `hourly_hire_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `hourly_hire_min_hr` int(11) NOT NULL,
  `hourly_hire_max_hr` int(11) NOT NULL,
  `hourly_rate` decimal(10,2) NOT NULL,
  `hourly_hire_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `use_as_shuttle` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 = No, 1 = Yes, 2 = Only Shuttle',
  `use_in_address` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Use as taxi in Address search',
  `use_in_offers` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Use as limo in Special routes',
  `charge_per_min` decimal(10,2) NOT NULL DEFAULT '0.00',
  `image` mediumtext NOT NULL,
  `text` text NOT NULL,
  `google_calendar_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `google_user` varchar(255) NOT NULL,
  `google_password` varchar(255) NOT NULL,
  `google_calendar_id` varchar(255) NOT NULL,
  `google_calendar_html_url` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4;


--
-- Dumping data for table `#__taxibooking_cars`
--
INSERT INTO `#__taxibooking_cars` (`id`, `title`, `alias`, `min_passenger_no`, `passenger_no`, `suitcase_no`, `booster_seat_no`, `infant_seat_no`, `child_seat_no`, `price`, `distance_prices`, `unit_price_override`, `unit_price`, `days_availability`, `blocked_dates`, `hourly_hire_enabled`, `hourly_hire_min_hr`, `hourly_hire_max_hr`, `hourly_rate`, `use_as_shuttle`, `charge_per_min`, `image`, `text`, `created`, `created_by`, `published`, `ordering`) VALUES
(1, 'Saloon', 'saloon', 0, 4, 4, 0, 0, 0, '10.00', 'a:0:{}', 0, '0.00', '{"0":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"1":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"2":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"3":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"4":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"5":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"6":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"}}', 'a:0:{}', 0,0,0,'0.00',0,'0.00','', '', '0000-00-00 00:00:00', 0, 1, 2),
(2, 'MPV', 'mpv', 0, 5, 5, 0, 0, 0, '20.00', 'a:0:{}', 0, '0.00',  '{"0":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"1":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"2":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"3":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"4":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"5":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"6":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"}}', 'a:0:{}', 0,0,0,'0.00',0,'0.00','', '', '0000-00-00 00:00:00', 0, 1, 1),
(3, '8 Seater', '8-seater', 0, 8, 8, 2, 2, 2, '30.00', 'a:0:{}', 0, '0.00',  '{"0":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"1":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"2":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"3":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"4":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"5":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"},"6":{"is_available":"1","opening_hrs":"-1","opening_mins":"-1","closing_hrs":"-1","closing_mins":"-1"}}', 'a:0:{}', 0,0,0,'0.00',0,'0.00','', '', '0000-00-00 00:00:00', 0, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_configs`
--

CREATE TABLE IF NOT EXISTS `#__taxibooking_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_countries`
--

DROP TABLE IF EXISTS `#__taxibooking_countries`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_countries` (
  `country_id` smallint(1) unsigned NOT NULL AUTO_INCREMENT,
  `country_name` char(64) DEFAULT NULL,
  `country_3_code` char(3) DEFAULT NULL,
  `country_2_code` char(2) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`country_id`),
  KEY `idx_country_3_code` (`country_3_code`),
  KEY `idx_country_2_code` (`country_2_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Country records' AUTO_INCREMENT=249 ;

--
-- Dumping data for table `#__taxibooking_countries`
--

INSERT INTO `#__taxibooking_countries` (`country_id`, `country_name`, `country_3_code`, `country_2_code`, `published`) VALUES
(1, 'Afghanistan', 'AFG', 'AF', 1),
(2, 'Albania', 'ALB', 'AL', 1),
(3, 'Algeria', 'DZA', 'DZ', 1),
(4, 'American Samoa', 'ASM', 'AS', 1),
(5, 'Andorra', 'AND', 'AD', 1),
(6, 'Angola', 'AGO', 'AO', 1),
(7, 'Anguilla', 'AIA', 'AI', 1),
(8, 'Antarctica', 'ATA', 'AQ', 1),
(9, 'Antigua and Barbuda', 'ATG', 'AG', 1),
(10, 'Argentina', 'ARG', 'AR', 1),
(11, 'Armenia', 'ARM', 'AM', 1),
(12, 'Aruba', 'ABW', 'AW', 1),
(13, 'Australia', 'AUS', 'AU', 1),
(14, 'Austria', 'AUT', 'AT', 1),
(15, 'Azerbaijan', 'AZE', 'AZ', 1),
(16, 'Bahamas', 'BHS', 'BS', 1),
(17, 'Bahrain', 'BHR', 'BH', 1),
(18, 'Bangladesh', 'BGD', 'BD', 1),
(19, 'Barbados', 'BRB', 'BB', 1),
(20, 'Belarus', 'BLR', 'BY', 1),
(21, 'Belgium', 'BEL', 'BE', 1),
(22, 'Belize', 'BLZ', 'BZ', 1),
(23, 'Benin', 'BEN', 'BJ', 1),
(24, 'Bermuda', 'BMU', 'BM', 1),
(25, 'Bhutan', 'BTN', 'BT', 1),
(26, 'Bolivia', 'BOL', 'BO', 1),
(27, 'Bosnia and Herzegowina', 'BIH', 'BA', 1),
(28, 'Botswana', 'BWA', 'BW', 1),
(29, 'Bouvet Island', 'BVT', 'BV', 1),
(30, 'Brazil', 'BRA', 'BR', 1),
(31, 'British Indian Ocean Territory', 'IOT', 'IO', 1),
(32, 'Brunei Darussalam', 'BRN', 'BN', 1),
(33, 'Bulgaria', 'BGR', 'BG', 1),
(34, 'Burkina Faso', 'BFA', 'BF', 1),
(35, 'Burundi', 'BDI', 'BI', 1),
(36, 'Cambodia', 'KHM', 'KH', 1),
(37, 'Cameroon', 'CMR', 'CM', 1),
(38, 'Canada', 'CAN', 'CA', 1),
(39, 'Cape Verde', 'CPV', 'CV', 1),
(40, 'Cayman Islands', 'CYM', 'KY', 1),
(41, 'Central African Republic', 'CAF', 'CF', 1),
(42, 'Chad', 'TCD', 'TD', 1),
(43, 'Chile', 'CHL', 'CL', 1),
(44, 'China', 'CHN', 'CN', 1),
(45, 'Christmas Island', 'CXR', 'CX', 1),
(46, 'Cocos (Keeling) Islands', 'CCK', 'CC', 1),
(47, 'Colombia', 'COL', 'CO', 1),
(48, 'Comoros', 'COM', 'KM', 1),
(49, 'Congo', 'COG', 'CG', 1),
(50, 'Cook Islands', 'COK', 'CK', 1),
(51, 'Costa Rica', 'CRI', 'CR', 1),
(52, 'Cote D''Ivoire', 'CIV', 'CI', 1),
(53, 'Croatia', 'HRV', 'HR', 1),
(54, 'Cuba', 'CUB', 'CU', 1),
(55, 'Cyprus', 'CYP', 'CY', 1),
(56, 'Czech Republic', 'CZE', 'CZ', 1),
(57, 'Denmark', 'DNK', 'DK', 1),
(58, 'Djibouti', 'DJI', 'DJ', 1),
(59, 'Dominica', 'DMA', 'DM', 1),
(60, 'Dominican Republic', 'DOM', 'DO', 1),
(61, 'East Timor', 'TMP', 'TP', 1),
(62, 'Ecuador', 'ECU', 'EC', 1),
(63, 'Egypt', 'EGY', 'EG', 1),
(64, 'El Salvador', 'SLV', 'SV', 1),
(65, 'Equatorial Guinea', 'GNQ', 'GQ', 1),
(66, 'Eritrea', 'ERI', 'ER', 1),
(67, 'Estonia', 'EST', 'EE', 1),
(68, 'Ethiopia', 'ETH', 'ET', 1),
(69, 'Falkland Islands (Malvinas)', 'FLK', 'FK', 1),
(70, 'Faroe Islands', 'FRO', 'FO', 1),
(71, 'Fiji', 'FJI', 'FJ', 1),
(72, 'Finland', 'FIN', 'FI', 1),
(73, 'France', 'FRA', 'FR', 1),
(75, 'French Guiana', 'GUF', 'GF', 1),
(76, 'French Polynesia', 'PYF', 'PF', 1),
(77, 'French Southern Territories', 'ATF', 'TF', 1),
(78, 'Gabon', 'GAB', 'GA', 1),
(79, 'Gambia', 'GMB', 'GM', 1),
(80, 'Georgia', 'GEO', 'GE', 1),
(81, 'Germany', 'DEU', 'DE', 1),
(82, 'Ghana', 'GHA', 'GH', 1),
(83, 'Gibraltar', 'GIB', 'GI', 1),
(84, 'Greece', 'GRC', 'GR', 1),
(85, 'Greenland', 'GRL', 'GL', 1),
(86, 'Grenada', 'GRD', 'GD', 1),
(87, 'Guadeloupe', 'GLP', 'GP', 1),
(88, 'Guam', 'GUM', 'GU', 1),
(89, 'Guatemala', 'GTM', 'GT', 1),
(90, 'Guinea', 'GIN', 'GN', 1),
(91, 'Guinea-bissau', 'GNB', 'GW', 1),
(92, 'Guyana', 'GUY', 'GY', 1),
(93, 'Haiti', 'HTI', 'HT', 1),
(94, 'Heard and Mc Donald Islands', 'HMD', 'HM', 1),
(95, 'Honduras', 'HND', 'HN', 1),
(96, 'Hong Kong', 'HKG', 'HK', 1),
(97, 'Hungary', 'HUN', 'HU', 1),
(98, 'Iceland', 'ISL', 'IS', 1),
(99, 'India', 'IND', 'IN', 1),
(100, 'Indonesia', 'IDN', 'ID', 1),
(101, 'Iran (Islamic Republic of)', 'IRN', 'IR', 1),
(102, 'Iraq', 'IRQ', 'IQ', 1),
(103, 'Ireland', 'IRL', 'IE', 1),
(104, 'Israel', 'ISR', 'IL', 1),
(105, 'Italy', 'ITA', 'IT', 1),
(106, 'Jamaica', 'JAM', 'JM', 1),
(107, 'Japan', 'JPN', 'JP', 1),
(108, 'Jordan', 'JOR', 'JO', 1),
(109, 'Kazakhstan', 'KAZ', 'KZ', 1),
(110, 'Kenya', 'KEN', 'KE', 1),
(111, 'Kiribati', 'KIR', 'KI', 1),
(112, 'Korea, Democratic People''s Republic of', 'PRK', 'KP', 1),
(113, 'Korea, Republic of', 'KOR', 'KR', 1),
(114, 'Kuwait', 'KWT', 'KW', 1),
(115, 'Kyrgyzstan', 'KGZ', 'KG', 1),
(116, 'Lao People''s Democratic Republic', 'LAO', 'LA', 1),
(117, 'Latvia', 'LVA', 'LV', 1),
(118, 'Lebanon', 'LBN', 'LB', 1),
(119, 'Lesotho', 'LSO', 'LS', 1),
(120, 'Liberia', 'LBR', 'LR', 1),
(121, 'Libyan Arab Jamahiriya', 'LBY', 'LY', 1),
(122, 'Liechtenstein', 'LIE', 'LI', 1),
(123, 'Lithuania', 'LTU', 'LT', 1),
(124, 'Luxembourg', 'LUX', 'LU', 1),
(125, 'Macau', 'MAC', 'MO', 1),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MKD', 'MK', 1),
(127, 'Madagascar', 'MDG', 'MG', 1),
(128, 'Malawi', 'MWI', 'MW', 1),
(129, 'Malaysia', 'MYS', 'MY', 1),
(130, 'Maldives', 'MDV', 'MV', 1),
(131, 'Mali', 'MLI', 'ML', 1),
(132, 'Malta', 'MLT', 'MT', 1),
(133, 'Marshall Islands', 'MHL', 'MH', 1),
(134, 'Martinique', 'MTQ', 'MQ', 1),
(135, 'Mauritania', 'MRT', 'MR', 1),
(136, 'Mauritius', 'MUS', 'MU', 1),
(137, 'Mayotte', 'MYT', 'YT', 1),
(138, 'Mexico', 'MEX', 'MX', 1),
(139, 'Micronesia, Federated States of', 'FSM', 'FM', 1),
(140, 'Moldova, Republic of', 'MDA', 'MD', 1),
(141, 'Monaco', 'MCO', 'MC', 1),
(142, 'Mongolia', 'MNG', 'MN', 1),
(143, 'Montserrat', 'MSR', 'MS', 1),
(144, 'Morocco', 'MAR', 'MA', 1),
(145, 'Mozambique', 'MOZ', 'MZ', 1),
(146, 'Myanmar', 'MMR', 'MM', 1),
(147, 'Namibia', 'NAM', 'NA', 1),
(148, 'Nauru', 'NRU', 'NR', 1),
(149, 'Nepal', 'NPL', 'NP', 1),
(150, 'Netherlands', 'NLD', 'NL', 1),
(151, 'Netherlands Antilles', 'ANT', 'AN', 1),
(152, 'New Caledonia', 'NCL', 'NC', 1),
(153, 'New Zealand', 'NZL', 'NZ', 1),
(154, 'Nicaragua', 'NIC', 'NI', 1),
(155, 'Niger', 'NER', 'NE', 1),
(156, 'Nigeria', 'NGA', 'NG', 1),
(157, 'Niue', 'NIU', 'NU', 1),
(158, 'Norfolk Island', 'NFK', 'NF', 1),
(159, 'Northern Mariana Islands', 'MNP', 'MP', 1),
(160, 'Norway', 'NOR', 'NO', 1),
(161, 'Oman', 'OMN', 'OM', 1),
(162, 'Pakistan', 'PAK', 'PK', 1),
(163, 'Palau', 'PLW', 'PW', 1),
(164, 'Panama', 'PAN', 'PA', 1),
(165, 'Papua New Guinea', 'PNG', 'PG', 1),
(166, 'Paraguay', 'PRY', 'PY', 1),
(167, 'Peru', 'PER', 'PE', 1),
(168, 'Philippines', 'PHL', 'PH', 1),
(169, 'Pitcairn', 'PCN', 'PN', 1),
(170, 'Poland', 'POL', 'PL', 1),
(171, 'Portugal', 'PRT', 'PT', 1),
(172, 'Puerto Rico', 'PRI', 'PR', 1),
(173, 'Qatar', 'QAT', 'QA', 1),
(174, 'Reunion', 'REU', 'RE', 1),
(175, 'Romania', 'ROM', 'RO', 1),
(176, 'Russian Federation', 'RUS', 'RU', 1),
(177, 'Rwanda', 'RWA', 'RW', 1),
(178, 'Saint Kitts and Nevis', 'KNA', 'KN', 1),
(179, 'Saint Lucia', 'LCA', 'LC', 1),
(180, 'Saint Vincent and the Grenadines', 'VCT', 'VC', 1),
(181, 'Samoa', 'WSM', 'WS', 1),
(182, 'San Marino', 'SMR', 'SM', 1),
(183, 'Sao Tome and Principe', 'STP', 'ST', 1),
(184, 'Saudi Arabia', 'SAU', 'SA', 1),
(185, 'Senegal', 'SEN', 'SN', 1),
(186, 'Seychelles', 'SYC', 'SC', 1),
(187, 'Sierra Leone', 'SLE', 'SL', 1),
(188, 'Singapore', 'SGP', 'SG', 1),
(189, 'Slovakia', 'SVK', 'SK', 1),
(190, 'Slovenia', 'SVN', 'SI', 1),
(191, 'Solomon Islands', 'SLB', 'SB', 1),
(192, 'Somalia', 'SOM', 'SO', 1),
(193, 'South Africa', 'ZAF', 'ZA', 1),
(194, 'South Georgia and the South Sandwich Islands', 'SGS', 'GS', 1),
(195, 'Spain', 'ESP', 'ES', 1),
(196, 'Sri Lanka', 'LKA', 'LK', 1),
(197, 'St. Helena', 'SHN', 'SH', 1),
(198, 'St. Pierre and Miquelon', 'SPM', 'PM', 1),
(199, 'Sudan', 'SDN', 'SD', 1),
(200, 'Suriname', 'SUR', 'SR', 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ', 1),
(202, 'Swaziland', 'SWZ', 'SZ', 1),
(203, 'Sweden', 'SWE', 'SE', 1),
(204, 'Switzerland', 'CHE', 'CH', 1),
(205, 'Syrian Arab Republic', 'SYR', 'SY', 1),
(206, 'Taiwan', 'TWN', 'TW', 1),
(207, 'Tajikistan', 'TJK', 'TJ', 1),
(208, 'Tanzania, United Republic of', 'TZA', 'TZ', 1),
(209, 'Thailand', 'THA', 'TH', 1),
(210, 'Togo', 'TGO', 'TG', 1),
(211, 'Tokelau', 'TKL', 'TK', 1),
(212, 'Tonga', 'TON', 'TO', 1),
(213, 'Trinidad and Tobago', 'TTO', 'TT', 1),
(214, 'Tunisia', 'TUN', 'TN', 1),
(215, 'Turkey', 'TUR', 'TR', 1),
(216, 'Turkmenistan', 'TKM', 'TM', 1),
(217, 'Turks and Caicos Islands', 'TCA', 'TC', 1),
(218, 'Tuvalu', 'TUV', 'TV', 1),
(219, 'Uganda', 'UGA', 'UG', 1),
(220, 'Ukraine', 'UKR', 'UA', 1),
(221, 'United Arab Emirates', 'ARE', 'AE', 1),
(222, 'United Kingdom', 'GBR', 'GB', 1),
(223, 'United States', 'USA', 'US', 1),
(224, 'United States Minor Outlying Islands', 'UMI', 'UM', 1),
(225, 'Uruguay', 'URY', 'UY', 1),
(226, 'Uzbekistan', 'UZB', 'UZ', 1),
(227, 'Vanuatu', 'VUT', 'VU', 1),
(228, 'Vatican City State (Holy See)', 'VAT', 'VA', 1),
(229, 'Venezuela', 'VEN', 'VE', 1),
(230, 'Viet Nam', 'VNM', 'VN', 1),
(231, 'Virgin Islands (British)', 'VGB', 'VG', 1),
(232, 'Virgin Islands (U.S.)', 'VIR', 'VI', 1),
(233, 'Wallis and Futuna Islands', 'WLF', 'WF', 1),
(234, 'Western Sahara', 'ESH', 'EH', 1),
(235, 'Yemen', 'YEM', 'YE', 1),
(237, 'The Democratic Republic of Congo', 'DRC', 'DC', 1),
(238, 'Zambia', 'ZMB', 'ZM', 1),
(239, 'Zimbabwe', 'ZWE', 'ZW', 1),
(240, 'East Timor', 'XET', 'XE', 1),
(241, 'Jersey', 'XJE', 'XJ', 1),
(242, 'St. Barthelemy', 'XSB', 'XB', 1),
(243, 'St. Eustatius', 'XSE', 'XU', 1),
(244, 'Canary Islands', 'XCA', 'XC', 1),
(245, 'Serbia', 'SRB', 'RS', 1),
(246, 'Sint Maarten (French Antilles)', 'MAF', 'MF', 1),
(247, 'Sint Maarten (Netherlands Antilles)', 'SXM', 'SX', 1),
(248, 'Palestinian Territory, occupied', 'PSE', 'PS', 1);


--
-- Table structure for table `#__taxibooking_coupons`
--

DROP TABLE IF EXISTS `#__taxibooking_coupons`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `discount_type` char(10) NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `hits` int(11) NOT NULL,
  `valid_from` datetime NOT NULL,
  `valid_to` datetime NOT NULL,
  `coupon_user` int(11) NOT NULL,
  `coupon_email` varchar(255) NOT NULL,
  `coupon_user_group` text NOT NULL,
  `booking_types` text NOT NULL,
  `special_routes` text NOT NULL,
  `hits_limit` int(11) NOT NULL,
  `max_hits_user` int(11) NOT NULL,
  `for_company_share` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'This will enable this coupon only for App Sharing',
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the coupons.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Unique Coupon Code` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


--
-- Table structure for table `#__taxibooking_coupons_user_record`
--

DROP TABLE IF EXISTS `#__taxibooking_coupons_user_record`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_coupons_user_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
 
--
-- Table structure for table `#__taxibooking_currency`
--

DROP TABLE IF EXISTS `#__taxibooking_currency`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_currency` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(64) DEFAULT NULL,
  `currency_code` char(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`),
  KEY `idx_currency_name` (`currency_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Used to store currencies' AUTO_INCREMENT=159 ;

--
-- Dumping data for table `#__taxibooking_currency`
--

INSERT INTO `#__taxibooking_currency` (`currency_id`, `currency_name`, `currency_code`) VALUES
(1, 'Andorran Peseta', 'ADP'),
(2, 'United Arab Emirates Dirham', 'AED'),
(3, 'Afghanistan Afghani', 'AFA'),
(4, 'Albanian Lek', 'ALL'),
(5, 'Netherlands Antillian Guilder', 'ANG'),
(6, 'Angolan Kwanza', 'AOK'),
(7, 'Argentine Peso', 'ARS'),
(9, 'Australian Dollar', 'AUD'),
(10, 'Aruban Florin', 'AWG'),
(11, 'Barbados Dollar', 'BBD'),
(12, 'Bangladeshi Taka', 'BDT'),
(14, 'Bulgarian Lev', 'BGL'),
(15, 'Bahraini Dinar', 'BHD'),
(16, 'Burundi Franc', 'BIF'),
(17, 'Bermudian Dollar', 'BMD'),
(18, 'Brunei Dollar', 'BND'),
(19, 'Bolivian Boliviano', 'BOB'),
(20, 'Brazilian Real', 'BRL'),
(21, 'Bahamian Dollar', 'BSD'),
(22, 'Bhutan Ngultrum', 'BTN'),
(23, 'Burma Kyat', 'BUK'),
(24, 'Botswanian Pula', 'BWP'),
(25, 'Belize Dollar', 'BZD'),
(26, 'Canadian Dollar', 'CAD'),
(27, 'Swiss Franc', 'CHF'),
(28, 'Chilean Unidades de Fomento', 'CLF'),
(29, 'Chilean Peso', 'CLP'),
(30, 'Yuan (Chinese) Renminbi', 'CNY'),
(31, 'Colombian Peso', 'COP'),
(32, 'Costa Rican Colon', 'CRC'),
(33, 'Czech Koruna', 'CZK'),
(34, 'Cuban Peso', 'CUP'),
(35, 'Cape Verde Escudo', 'CVE'),
(36, 'Cyprus Pound', 'CYP'),
(40, 'Danish Krone', 'DKK'),
(41, 'Dominican Peso', 'DOP'),
(42, 'Algerian Dinar', 'DZD'),
(43, 'Ecuador Sucre', 'ECS'),
(44, 'Egyptian Pound', 'EGP'),
(46, 'Ethiopian Birr', 'ETB'),
(47, 'Euro', 'EUR'),
(49, 'Fiji Dollar', 'FJD'),
(50, 'Falkland Islands Pound', 'FKP'),
(52, 'British Pound', 'GBP'),
(53, 'Ghanaian Cedi', 'GHC'),
(54, 'Gibraltar Pound', 'GIP'),
(55, 'Gambian Dalasi', 'GMD'),
(56, 'Guinea Franc', 'GNF'),
(58, 'Guatemalan Quetzal', 'GTQ'),
(59, 'Guinea-Bissau Peso', 'GWP'),
(60, 'Guyanan Dollar', 'GYD'),
(61, 'Hong Kong Dollar', 'HKD'),
(62, 'Honduran Lempira', 'HNL'),
(63, 'Haitian Gourde', 'HTG'),
(64, 'Hungarian Forint', 'HUF'),
(65, 'Indonesian Rupiah', 'IDR'),
(66, 'Irish Punt', 'IEP'),
(67, 'Israeli Shekel', 'ILS'),
(68, 'Indian Rupee', 'INR'),
(69, 'Iraqi Dinar', 'IQD'),
(70, 'Iranian Rial', 'IRR'),
(73, 'Jamaican Dollar', 'JMD'),
(74, 'Jordanian Dinar', 'JOD'),
(75, 'Japanese Yen', 'JPY'),
(76, 'Kenyan Shilling', 'KES'),
(77, 'Kampuchean (Cambodian) Riel', 'KHR'),
(78, 'Comoros Franc', 'KMF'),
(79, 'North Korean Won', 'KPW'),
(80, '(South) Korean Won', 'KRW'),
(81, 'Kuwaiti Dinar', 'KWD'),
(82, 'Cayman Islands Dollar', 'KYD'),
(83, 'Lao Kip', 'LAK'),
(84, 'Lebanese Pound', 'LBP'),
(85, 'Sri Lanka Rupee', 'LKR'),
(86, 'Liberian Dollar', 'LRD'),
(87, 'Lesotho Loti', 'LSL'),
(89, 'Libyan Dinar', 'LYD'),
(90, 'Moroccan Dirham', 'MAD'),
(91, 'Malagasy Franc', 'MGF'),
(92, 'Mongolian Tugrik', 'MNT'),
(93, 'Macau Pataca', 'MOP'),
(94, 'Mauritanian Ouguiya', 'MRO'),
(95, 'Maltese Lira', 'MTL'),
(96, 'Mauritius Rupee', 'MUR'),
(97, 'Maldive Rufiyaa', 'MVR'),
(98, 'Malawi Kwacha', 'MWK'),
(99, 'Mexican Peso', 'MXP'),
(100, 'Malaysian Ringgit', 'MYR'),
(101, 'Mozambique Metical', 'MZM'),
(102, 'Nigerian Naira', 'NGN'),
(103, 'Nicaraguan Cordoba', 'NIC'),
(105, 'Norwegian Kroner', 'NOK'),
(106, 'Nepalese Rupee', 'NPR'),
(107, 'New Zealand Dollar', 'NZD'),
(108, 'Omani Rial', 'OMR'),
(109, 'Panamanian Balboa', 'PAB'),
(110, 'Peruvian Nuevo Sol', 'PEN'),
(111, 'Papua New Guinea Kina', 'PGK'),
(112, 'Philippine Peso', 'PHP'),
(113, 'Pakistan Rupee', 'PKR'),
(114, 'Polish Zloty', 'PLN'),
(116, 'Paraguay Guarani', 'PYG'),
(117, 'Qatari Rial', 'QAR'),
(118, 'Romanian Leu', 'RON'),
(119, 'Rwanda Franc', 'RWF'),
(120, 'Saudi Arabian Riyal', 'SAR'),
(121, 'Solomon Islands Dollar', 'SBD'),
(122, 'Seychelles Rupee', 'SCR'),
(123, 'Sudanese Pound', 'SDP'),
(124, 'Swedish Krona', 'SEK'),
(125, 'Singapore Dollar', 'SGD'),
(126, 'St. Helena Pound', 'SHP'),
(127, 'Sierra Leone Leone', 'SLL'),
(128, 'Somali Shilling', 'SOS'),
(129, 'Suriname Guilder', 'SRG'),
(130, 'Sao Tome and Principe Dobra', 'STD'),
(131, 'Russian Ruble', 'RUB'),
(132, 'El Salvador Colon', 'SVC'),
(133, 'Syrian Potmd', 'SYP'),
(134, 'Swaziland Lilangeni', 'SZL'),
(135, 'Thai Bath', 'THB'),
(136, 'Tunisian Dinar', 'TND'),
(137, 'Tongan Pa''anga', 'TOP'),
(138, 'East Timor Escudo', 'TPE'),
(139, 'Turkish Lira', 'TRY'),
(140, 'Trinidad and Tobago Dollar', 'TTD'),
(141, 'Taiwan Dollar', 'TWD'),
(142, 'Tanzanian Shilling', 'TZS'),
(143, 'Uganda Shilling', 'UGS'),
(144, 'US Dollar', 'USD'),
(145, 'Uruguayan Peso', 'UYP'),
(146, 'Venezualan Bolivar', 'VEB'),
(147, 'Vietnamese Dong', 'VND'),
(148, 'Vanuatu Vatu', 'VUV'),
(149, 'Samoan Tala', 'WST'),
(150, 'Democratic Yemeni Dinar', 'YDD'),
(151, 'Yemeni Rial', 'YER'),
(152, 'Dinar', 'RSD'),
(153, 'South African Rand', 'ZAR'),
(154, 'Zambian Kwacha', 'ZMK'),
(155, 'Zaire Zaire', 'ZRZ'),
(156, 'Zimbabwe Dollar', 'ZWD'),
(157, 'Slovak Koruna', 'SKK'),
(158, 'Armenian Dram', 'AMD');

--
-- Table structure for table `#__taxibooking_errorlog`
--

DROP TABLE IF EXISTS `#__taxibooking_errorlog`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_errorlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `description` text,
  `sql_data` varchar(255) DEFAULT NULL,
  `err_object` varchar(252) DEFAULT NULL,
  `err_severity` varchar(25) DEFAULT NULL,
  `checked_out` smallint(5) DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` smallint(5) DEFAULT '0',
  `published` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_fields`
--

DROP TABLE IF EXISTS `#__taxibooking_fields`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catid` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `field_type` varchar(100) NOT NULL,
  `show_on_pickup` tinyint(4) NOT NULL DEFAULT '1',
  `show_on_dropoff` tinyint(4) NOT NULL DEFAULT '1',
  `show_on_address` TINYINT NOT NULL DEFAULT '0',
  `show_on_hourly` TINYINT NOT NULL DEFAULT '0',
  `show_on_shuttles` TINYINT NOT NULL DEFAULT '0',
  `show_on_return` TINYINT NOT NULL DEFAULT '0',
  `show_on_user_details` TINYINT NOT NULL DEFAULT '0',
  `is_mandatory` tinyint(4) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `allow_zero` tinyint(4) NOT NULL DEFAULT '1',
  `field_options` TEXT NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` CHAR( 7 ) NOT NULL DEFAULT '*' COMMENT 'The language code for the Custom Fields.',
  `checked_out` INT UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',  
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


--
-- Dumping data for table `#__taxibooking_fields`
--
INSERT INTO `#__taxibooking_fields` (`catid`, `title`, `alias`, `field_type`, `show_on_pickup`, `show_on_dropoff`, `show_on_address`, `show_on_hourly`, `show_on_return`, `show_on_user_details`, `is_mandatory`, `price`, `quantity`, `allow_zero`, `field_options`, `text`, `created`, `created_by`, `published`, `ordering`, `language`, `checked_out`, `checked_out_time`) VALUES
('', 'Gender', 'gender', 'optionlist', 0, 0, 0, 0, 0, 1, 0, '0.00', 0, 1, 'a:2:{i:0;s:4:"Male";i:1;s:6:"Female";}', '', '0000-00-00 00:00:00', 0, 1, 11, '*', 0, '0000-00-00 00:00:00'),
('', 'Message', 'message', 'textarea', 0, 0, 0, 0, 0, 1, 0, '0.00', 0, 1, '', '', '0000-00-00 00:00:00', 0, 1, 11, '*', 0, '0000-00-00 00:00:00');

--
-- Table structure for table `#__taxibooking_orders`
--
CREATE TABLE IF NOT EXISTS `#__taxibooking_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(100) NOT NULL,
  `names` varchar(40) NOT NULL DEFAULT '',
  `gender` varchar(10) NOT NULL,
  `email` varchar(40) NOT NULL DEFAULT '',
  `phone` varchar(40) NOT NULL DEFAULT '',
  `booking_type` varchar(30) NOT NULL,
  `returntrip` tinyint(1) NOT NULL DEFAULT '0',
  `return_wait_hr` int(11) NOT NULL,
  `return_wait_discount` int(11) NOT NULL,
  `sub_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `flat_cost` decimal(10,2) NOT NULL DEFAULT '0.00',
  `percentage_cost` decimal(10,2) NOT NULL DEFAULT '0.00',
  `poi_additional_charges` text NOT NULL,
  `cprice` decimal(10,2) NOT NULL DEFAULT '0.00',
  `prepay` float unsigned NOT NULL DEFAULT '100',
  `extras` text NOT NULL,
  `selpassengers` tinyint(2) NOT NULL DEFAULT '0',
  `selinfantseats` int(11) NOT NULL DEFAULT '0',
  `selchildseats` int(11) NOT NULL DEFAULT '0',
  `selboosterseats` int(11) NOT NULL DEFAULT '0',
  `selluggage` tinyint(2) NOT NULL DEFAULT '0',
  `selcarry` tinyint(2) NOT NULL DEFAULT '0',
  `hourly_hr` int(11) NOT NULL,
  `hourly_min` int(11) NOT NULL,
  `PickupAddr1` text NOT NULL,
  `PickupAddr4` text NOT NULL,
  `datetime1` varchar(20) NOT NULL DEFAULT '',
  `datetime2` varchar(20) NOT NULL DEFAULT '',
  `distance` decimal(10,5) NOT NULL DEFAULT '0.00000' COMMENT 'Disance is in KM or Mile based on unit distance settings',
  `duration` int(11) NOT NULL COMMENT '(seconds)',
  `duration_text` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `begin` varchar(255) NOT NULL DEFAULT '',
  `stops` text NOT NULL,
  `end` varchar(255) NOT NULL DEFAULT '',
  `from_dest` tinyint(1) NOT NULL DEFAULT '0',
  `to_dest` tinyint(1) NOT NULL DEFAULT '0',
  `state` tinyint(1) DEFAULT '0',
  `driver_id` int(11) NOT NULL DEFAULT '0',
  `payment` varchar(10) DEFAULT NULL,
  `vehicletype` tinyint(1) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `invoice_title` varchar(100) NOT NULL,
  `coupon_used` int(11) NOT NULL,
  `shuttle_route_id` int(11) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_car` varchar(255) NOT NULL,
  `price_override` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `custom_payment` varchar(255) NOT NULL,
  `payment_notes` text NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `source` enum('backend','frontend','drivenot') NOT NULL DEFAULT 'frontend',
  `pickup_poi` int(11) NOT NULL DEFAULT '0',
  `pickup_lat` decimal(10,8) NOT NULL,
  `pickup_lng` decimal(11,8) NOT NULL,
  `dropoff_poi` int(11) NOT NULL DEFAULT '0',
  `dropoff_lat` decimal(10,8) NOT NULL,
  `dropoff_lng` decimal(11,8) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `gratuity_amt` float(10,2) NOT NULL DEFAULT '0.00',
  `gratuity_amttype` char(10) NOT NULL,
  `gratuity_percent_value` float(10,2) NOT NULL DEFAULT '0.00',
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The site language code while submitting this order',
  `reminder_sent` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_order_car_rel`
--
CREATE TABLE IF NOT EXISTS `#__taxibooking_order_car_rel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `vehicle_id` int(11) NOT NULL,
  `journey_type` enum('outbound','return') NOT NULL DEFAULT 'outbound',
  `booking_time_start` int(11) NOT NULL COMMENT 'seconds',
  `booking_time_end` int(11) NOT NULL COMMENT 'seconds',
  `google_event_id` varchar(255) NOT NULL,
  `google_calendar_id` varchar(255) NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Table structure for table `#__taxibooking_order_copyusers`
--
CREATE TABLE IF NOT EXISTS `#__taxibooking_order_copyusers` (
  `order_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL COMMENT 'Users to whom this order copy email sent',
  `created` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Holds users ID to whom order copy email sent';

--
-- Table structure for table `#__taxibooking_order_notes`
-- 
CREATE TABLE IF NOT EXISTS `#__taxibooking_order_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_paymentmethods`
--
DROP TABLE IF EXISTS `#__taxibooking_paymentmethods`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_paymentmethods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `text` text NOT NULL,
  `payment_plugin_id` int(11) NOT NULL DEFAULT '0',
  `payment_element` char(50) NOT NULL DEFAULT '',
  `payment_params` varchar(19000) DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the method',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_poicats`
--

DROP TABLE IF EXISTS `#__taxibooking_poicats`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_poicats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `image` mediumtext NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` CHAR( 7 ) NOT NULL DEFAULT '*' COMMENT 'The language code for the POI Category.',
  `checked_out` INT UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `e7zbp_taxibooking_poicats`
--

INSERT INTO `#__taxibooking_poicats` (`id`, `title`, `alias`, `image`, `text`, `created`, `created_by`, `published`, `ordering`, `language`) VALUES
(1, 'Airports', 'airports', '', '', '2013-03-10 11:47:32', 42, 1, 1, '*'),
(2, 'Cruise Ports', 'cruise-ports', '', '', '2013-03-10 11:47:43', 42, 1, 2, '*'),
(3, 'Hotels', 'hotels', '', '', '2013-03-10 11:47:50', 42, 1, 3, '*'),
(4, 'Train Stations', 'train-stations', '', '', '2013-03-10 11:48:00', 42, 1, 4, '*'),
(5, 'Landmarks', 'landmarks', '', '', '0000-00-00 00:00:00', 0, 1, 5, '*'),
(6, 'Post Codes', 'post-codes', '', '', '2013-03-10 11:48:44', 42, 1, 6, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_paypal_table`
--

DROP TABLE IF EXISTS `#__taxibooking_paypal_table`;


--
-- Table structure for table `#__taxibooking_points`
--

DROP TABLE IF EXISTS `#__taxibooking_points`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `long` varchar(100) NOT NULL,
  `additional_fld_label` varchar( 255 ) NOT NULL,
  `additional_charge` decimal(10,2) NOT NULL,
  `show_on_pickup` tinyint(4) NOT NULL DEFAULT '1',
  `show_on_dropoff` tinyint(4) NOT NULL DEFAULT '1',
  `show_on_offers_pickup` tinyint(4) NOT NULL DEFAULT '1',
  `show_on_offers_dropoff` tinyint(4) NOT NULL DEFAULT '1',
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` CHAR( 7 ) NOT NULL DEFAULT '*' COMMENT 'The language code for the POI.',
  `checked_out` INT UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `#__taxibooking_points`
--
INSERT INTO `#__taxibooking_points` (`id`, `catid`, `title`, `alias`, `lat`, `long`, `text`, `created`, `created_by`, `published`, `ordering`, `language` ) VALUES
(1, 1, 'London Heathrow Airport', 'london-heathrow-airport', '51.4696040', '-0.4535660', '', '0000-00-00 00:00:00', 0, 1, 1,'*'),
(2, 1, 'London Gatwick airport', 'london-gatwick-airport', '51.1518301', '-0.1848285', '', '0000-00-00 00:00:00', 0, 1, 2,'*'),
(3, 2, 'Dover Port', 'dover-port', '51.121007', '1.313163', '', '2011-12-31 03:16:39', 62, 1, 4,'*'),
(4, 2, 'Harwich Curiseport', 'harwich-curiseport', '51.943471', '1.258485', '', '2011-12-31 03:17:02', 62, 1, 3,'*'),
(5, 2, 'Portsmouth Curiseport', 'portsmouth-curiseport', '50.812294', '-1.089474', '', '0000-00-00 00:00:00', 0, 1, 5,'*'),
(6, 2, 'Southampton Curiseport', 'southampton-curiseport', '50.888998', '-1.396276', '', '0000-00-00 00:00:00', 0, 1, 6,'*');

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_routes`
--
DROP TABLE IF EXISTS `#__taxibooking_routes`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `route_from` int(11) NOT NULL,
  `route_to` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `separate_car_price` tinyint(4) NOT NULL DEFAULT '0',
  `car_prices` text NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` INT UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_searchurls`
--

DROP TABLE IF EXISTS `#__taxibooking_searchurls`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_searchurls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `url_params` text NOT NULL,
  `dynamic_params` text NOT NULL,
  `generated_url` text NOT NULL,
  `short_url` mediumtext NOT NULL,
  `anchor_text` text NOT NULL,
  `anchor_text_html` text NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the searchurls.',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for new settings table 
--

DROP TABLE IF EXISTS `#__taxibooking_settings`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_settings` (
  `id` int(11) NOT NULL,
  `params` text NOT NULL,
  `booking_calendar_url` text NOT NULL,
  `checked_out` int(11) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__taxibooking_settings`
--

INSERT INTO `#__taxibooking_settings` (`id`, `params`, `checked_out`, `checked_out_time`) VALUES
(1, 'a:59:{s:12:"default_city";s:6:"London";s:15:"default_country";s:3:"222";s:13:"distance_unit";s:2:"kM";s:8:"discount";s:0:"";s:18:"surcharge_by_dates";s:0:"";s:13:"restrict_time";s:1:"5";s:11:"date_format";s:8:"dd-mm-yy";s:15:"datepicker_type";s:6:"jquery";s:11:"time_format";s:4:"24hr";s:13:"show_from_poi";s:1:"1";s:17:"show_from_address";s:1:"1";s:11:"show_to_poi";s:1:"1";s:15:"show_to_address";s:1:"1";s:17:"enable_route_swap";s:1:"1";s:11:"load_jquery";s:1:"1";s:13:"load_jqueryui";s:1:"1";s:11:"default_tab";s:1:"0";s:17:"load_current_date";s:1:"1";s:18:"default_adult_seat";s:0:"";s:13:"invoice_title";s:12:"taxi_booking";s:14:"enable_captcha";s:1:"1";s:10:"show_price";s:1:"1";s:23:"price_per_unit_distance";s:0:"";s:17:"infant_seat_price";s:0:"";s:16:"child_seat_price";s:0:"";s:18:"booster_seat_price";s:0:"";s:13:"cost_per_call";s:0:"";s:6:"minmil";s:1:"0";s:8:"minprice";s:4:"0.00";s:8:"currency";s:3:"GBP";s:15:"currency_symbol";s:7:"&pound;";s:10:"map_height";s:3:"300";s:8:"map_zoom";s:2:"10";s:10:"dir_height";s:3:"200";s:10:"map_active";s:1:"1";s:14:"map_route_calc";s:8:"shortest";s:11:"header_logo";s:0:"";s:11:"header_info";s:0:"";s:12:"contact_info";s:0:"";s:16:"terms_conditions";s:0:"";s:20:"booking_form_bgcolor";s:7:"#006599";s:29:"booking_form_active_tab_color";s:7:"#006599";s:31:"booking_form_inactive_tab_color";s:7:"#1aa1bf";s:21:"booking_form_boxcolor";s:7:"#2d2d2d";s:22:"booking_form_fontcolor";s:7:"#ffffff";s:21:"booking_form_btncolor";s:7:"#1aa1bf";s:9:"base_name";s:0:"";s:8:"base_lat";s:0:"";s:9:"base_long";s:0:"";s:21:"calculate_base_pickup";s:1:"0";s:22:"base_pickup_price_type";s:4:"flat";s:17:"base_pickup_price";s:0:"";s:22:"calculate_dropoff_base";s:1:"0";s:23:"dropoff_base_price_type";s:4:"flat";s:18:"dropoff_base_price";s:0:"";s:23:"time_after_each_booking";s:0:"";s:32:"1b400dc8da58b67e33a58d332ffc853c";s:1:"1";s:10:"lastupdate";s:0:"";s:15:"distance_prices";a:0:{}}', 0, '');

--
-- Table structure for table `#__taxibooking_shuttle_bookings`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_bookings`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `route_id` int(11) NOT NULL,
  `order_date` date NOT NULL,
  `booked_seats` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Table structure for table `#__taxibooking_shuttle_routes`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_routes`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `car_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the Route',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_shuttle_route_stops`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_route_stops`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_route_stops` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `route_id` int(11) NOT NULL,
  `poi_id` int(11) NOT NULL,
  `price_per_passenger` decimal(10,2) NOT NULL,
  `arrival_time` time NOT NULL,
  `is_start` tinyint(4) NOT NULL DEFAULT '0',
  `is_end` tinyint(4) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_tariffs`
--

DROP TABLE IF EXISTS `#__taxibooking_tariffs`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_tariffs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `initial_price` decimal(10,2) NOT NULL,
  `unit_price` decimal(10,2) NOT NULL,
  `charge_per_min` decimal(10,2) NOT NULL DEFAULT '0.00',
  `assigned_cars` text NOT NULL,
  `days_availability` text NOT NULL,
  `special_date_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `special_dates` text NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the tariffs.',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_users`
--

CREATE TABLE IF NOT EXISTS `#__taxibooking_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `is_corporate_client` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'If YES, this user can use Invoice Later payment method',
  `client_organization_name` text NOT NULL,
  `client_organization_address` text NOT NULL,
  `client_registration_number` text NOT NULL,
  `client_vat` text NOT NULL,
  `is_driver` tinyint(4) NOT NULL DEFAULT '0',
  `driver_badge_number` varchar(100) NOT NULL,
  `show_badge_number_email` tinyint(4) NOT NULL DEFAULT '1',
  `show_phone_number_email` tinyint(4) NOT NULL DEFAULT '1',
  `driver_address` text NOT NULL,
  `driver_date_employment_commenced` date NOT NULL,
  `driver_date_employment_terminated` date NOT NULL,
  `driver_date_insurance_end` date NOT NULL,
  `driver_rent_amount` decimal(10,2) NOT NULL,
  `driver_rent_payable_date` varchar(100) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `KEY id_userid` (`id`,`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_user_addresses`
--

CREATE TABLE IF NOT EXISTS `#__taxibooking_user_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `lng` varchar(100) NOT NULL,
  `organization` varchar(255) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__taxibooking_user_childs`
--

CREATE TABLE IF NOT EXISTS `#__taxibooking_user_childs` (
  `parent_user_id` int(11) NOT NULL,
  `child_user_id` int(11) NOT NULL COMMENT 'Users can use Invoice Later payment though they are not Client',
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Holds child users those can use Invoice Later';