--
-- Add 2 extra fields in car table
--
ALTER TABLE `#__taxibooking_cars` ADD `distance_prices` TEXT NOT NULL AFTER `price`;
ALTER TABLE `#__taxibooking_cars` ADD `unit_price_override` TINYINT NOT NULL DEFAULT '0' AFTER `distance_prices`; 
ALTER TABLE `#__taxibooking_cars` ADD `unit_price` DECIMAL( 10, 2 ) NOT NULL AFTER `unit_price_override`;

--
-- Table structure for table `#__taxibooking_poicats`
--

DROP TABLE IF EXISTS `#__taxibooking_poicats`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_poicats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `image` mediumtext NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `e7zbp_taxibooking_poicats`
--

INSERT INTO `#__taxibooking_poicats` (`id`, `title`, `alias`, `image`, `text`, `created`, `created_by`, `published`, `ordering`) VALUES
(1, 'Airports', 'airports', '', '', '2013-03-10 11:47:32', 42, 1, 1),
(2, 'Cruise Ports', 'cruise-ports', '', '', '2013-03-10 11:47:43', 42, 1, 2),
(3, 'Hotels', 'hotels', '', '', '2013-03-10 11:47:50', 42, 1, 3),
(4, 'Train Stations', 'train-stations', '', '', '2013-03-10 11:48:00', 42, 1, 4),
(5, 'Landmarks', 'landmarks', '', '', '0000-00-00 00:00:00', 0, 1, 5),
(6, 'Post Codes', 'post-codes', '', '', '2013-03-10 11:48:44', 42, 1, 6);


--
-- Add catid in points table
--
ALTER TABLE `#__taxibooking_points` ADD `catid` INT NOT NULL AFTER `id`;
ALTER TABLE `#__taxibooking_points` ADD `text` TEXT NOT NULL AFTER `long`;

--
-- alter routes table
--

ALTER TABLE `#__taxibooking_routes` CHANGE `from` `route_from` INT NOT NULL;
ALTER TABLE `#__taxibooking_routes` CHANGE `to` `route_to` INT NOT NULL;
ALTER TABLE `#__taxibooking_routes` ADD `text` TEXT NOT NULL AFTER `price`;