--
-- Alter Cars table
-- 
ALTER TABLE `#__taxibooking_cars` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_cars` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `#__taxibooking_cars` ADD `use_as_shuttle` TINYINT NOT NULL DEFAULT '0' COMMENT '0 = No, 1 = Yes, 2 = Only Shuttle' AFTER `hourly_rate`;

--
-- Alter Coupons table
-- 
ALTER TABLE `#__taxibooking_coupons` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_coupons` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';


--
-- Alter Fields table
-- 
ALTER TABLE `#__taxibooking_fields` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_fields` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';

--
-- Alter Orders table
-- 
ALTER TABLE `#__taxibooking_orders` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_orders` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `#__taxibooking_orders` ADD `shuttle_route_id` INT NOT NULL DEFAULT '0' AFTER `coupon_used`;

ALTER TABLE `#__taxibooking_orders`
  DROP `PickupAddr2`,
  DROP `PickupAddr3`,
  DROP `PickupAddr5`,
  DROP `PickupAddr6`;
    

--
-- Alter POI Cats table
-- 
ALTER TABLE `#__taxibooking_poicats` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_poicats` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';

--
-- Alter Points table
-- 
ALTER TABLE `#__taxibooking_points` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_points` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';

--
-- Alter Routes table
-- 
ALTER TABLE `#__taxibooking_routes` ADD `checked_out` INT UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `#__taxibooking_routes` ADD `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';


--
-- Table structure for table `#__taxibooking_shuttle_bookings`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_bookings`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `route_id` int(11) NOT NULL,
  `order_date` date NOT NULL,
  `booked_seats` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Table structure for table `#__taxibooking_shuttle_routes`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_routes`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `car_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `text` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `language` char(7) NOT NULL DEFAULT '*' COMMENT 'The language code for the Route',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `#__taxibooking_shuttle_route_stops`
--

DROP TABLE IF EXISTS `#__taxibooking_shuttle_route_stops`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_shuttle_route_stops` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `route_id` int(11) NOT NULL,
  `poi_id` int(11) NOT NULL,
  `price_per_passenger` decimal(10,2) NOT NULL,
  `arrival_time` time NOT NULL,
  `is_start` tinyint(4) NOT NULL DEFAULT '0',
  `is_end` tinyint(4) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
