--
-- Table structure for table `#__taxibooking_errorlog`
--

DROP TABLE IF EXISTS `#__taxibooking_errorlog`;
CREATE TABLE IF NOT EXISTS `#__taxibooking_errorlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `description` text,
  `sql_data` varchar(255) DEFAULT NULL,
  `err_object` varchar(252) DEFAULT NULL,
  `err_severity` varchar(25) DEFAULT NULL,
  `checked_out` smallint(5) DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` smallint(5) DEFAULT '0',
  `published` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Alter Cars table
-- 
ALTER TABLE `#__taxibooking_cars` ADD `modified` DATETIME NOT NULL AFTER `created_by` ,
ADD `modified_by` INT NOT NULL AFTER `modified`;

ALTER TABLE `#__taxibooking_cars` ADD `google_calendar_enabled` TINYINT NOT NULL DEFAULT '0' AFTER `text` ,
ADD `google_user` VARCHAR( 255 ) NOT NULL AFTER `google_calendar_enabled` ,
ADD `google_password` VARCHAR( 255 ) NOT NULL AFTER `google_user` ,
ADD `google_calendar_id` VARCHAR( 255 ) NOT NULL AFTER `google_password`, 
ADD `google_calendar_html_url` TEXT NOT NULL AFTER `google_calendar_id`;

--
-- Alter Order Car Relation table
-- 
ALTER TABLE `#__taxibooking_order_car_rel` ADD `google_event_id` VARCHAR( 255 ) NOT NULL AFTER `booking_time_end` ,
ADD `google_calendar_id` VARCHAR( 255 ) NOT NULL AFTER `google_event_id`;

ALTER TABLE `#__taxibooking_order_car_rel` ADD `journey_type` ENUM( 'outbound', 'return' ) NOT NULL DEFAULT 'outbound' AFTER `vehicle_id`,
 ADD `modified_date` DATETIME NOT NULL AFTER `created_date`;

--
-- Alter Settings table
-- 
ALTER TABLE `#__taxibooking_settings` ADD `booking_calendar_url` TEXT NOT NULL AFTER `params`;

--
-- Alter Orders table
-- 
ALTER TABLE `#__taxibooking_orders` ADD `ip_address` VARCHAR( 15 ) NOT NULL;
