<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Car table
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxibookingTableCar extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabaseDriver  &$_db  Database connector object
	 *
	 * @since   1.5
	 */
	public function __construct(&$_db)
	{
		parent::__construct('#__taxibooking_cars', 'id', $_db);
	}
	
	// overloaded check function
	function check()
	{
		// Not typed in a title?
		if (trim( $this->title ) == '') {
			$this->setError(JText::_('ADD TITLE'));
			return false;
		}

		$alias = JFilterOutput::stringURLSafe($this->title);

		if(empty($this->alias) || $this->alias === $alias ) {
			$this->alias = $alias;
		}
		
		if (trim( $this->passenger_no ) <  trim( $this->booster_seat_no )) {
			$this->setError(JText::_('Booster seat must not be greater than total passengers seat!'));
			return false;
		}
		if (trim( $this->passenger_no ) <  trim( $this->infant_seat_no )) {
			$this->setError(JText::_('Infant seat must not be greater than total passengers seat!'));
			return false;
		}
		if (trim( $this->passenger_no ) <  trim( $this->child_seat_no )) {
			$this->setError(JText::_('Child seat must not be greater than total passengers seat!'));
			return false;
		}
		
		return true;
	}
}
