<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Order table
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxibookingTableOrder extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabaseDriver  &$_db  Database connector object
	 *
	 * @since   1.5
	 */
	public function __construct(&$_db)
	{
		parent::__construct('#__taxibooking_orders', 'id', $_db);
	}
	
	function check()
	{
		if ($this->vehicletype==0 && $this->custom_car=="") {
			$this->setError(JText::_('ORDER_EDIT_CAR_NOT_ASSIGNED'));
			return false;
		}
		if($this->datetime1==""){
			$this->setError(JText::_('ORDER_EDIT_PICKUP_DATE_NOT_SPECIFIED'));
			return false;
		}
		if($this->selpassengers==""){
			$this->setError(JText::_('ORDER_EDIT_PASSENGERS_NOT_SPECIFIED'));
			return false;
		}
		/*if(($this->cprice==0||$this->cprice=="") && ($this->price_override==0||$this->price_override=="")){
			$this->setError(JText::_('ORDER_EDIT_PRICE_NOT_SPECIFIED'));
			return false;
		}*/
		
		return true;
	}
}