<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Paymentmethod table
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxibookingTablePaymentmethod extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabaseDriver  &$_db  Database connector object
	 *
	 * @since   1.5
	 */
	public function __construct(&$_db)
	{
		parent::__construct('#__taxibooking_paymentmethods', 'id', $_db);
	}
	
	function check()
	{
		if ($this->title=="") {
			$this->setError(JText::_('Add Title'));
			return false;
		}
		
		// Set name
		$this->title = htmlspecialchars_decode($this->title, ENT_QUOTES);

		// Set alias
		$this->alias = JApplication::stringURLSafe($this->alias);

		if (empty($this->alias))
		{
			$this->alias = JApplication::stringURLSafe($this->title);
		}
		
		if(isset($this->payment_plugin_id)){

			$tb = '#__extensions';
			$ext_id = 'extension_id';

			$q = 'SELECT `element` FROM `' . $tb . '` WHERE `' . $ext_id . '` = "'.$this->payment_plugin_id.'"';
			$this->_db->setQuery($q);
			$this->payment_element = $this->_db->loadResult();
		}
		
		return true;
	}
}