<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Special Route table
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxibookingTableRoute extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabaseDriver  &$_db  Database connector object
	 *
	 * @since   1.5
	 */
	public function __construct(&$_db)
	{
		parent::__construct('#__taxibooking_routes', 'id', $_db);
	}
	
	function check()
	{
		if ($this->title=="") {
			$this->setError(JText::_('Add Title'));
			return false;
		}
		
		// Set name
		$this->title = htmlspecialchars_decode($this->title, ENT_QUOTES);

		// Set alias
		$this->alias = JApplication::stringURLSafe($this->alias);

		if (empty($this->alias))
		{
			$this->alias = JApplication::stringURLSafe($this->title);
		}
		
		if ($this->route_from == 0) {
			$this->setError(JText::_('Add From Location'));
			return false;
		}
                
		if ($this->route_to == 0) {
			$this->setError(JText::_('Add To Location'));
			return false;
		}
		
		if ($this->route_from == $this->route_to) {
			$this->setError(JText::_( 'SELECT_DIFFERENT_FROM_TO_POI' ));
			return false;
		}
		
		return true;
	}
}