<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * TB Users table
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxibookingTableTbuser extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabaseDriver  &$_db  Database connector object
	 *
	 * @since   1.5
	 */
	public function __construct(&$_db)
	{
		parent::__construct('#__taxibooking_users', 'id', $_db);
	}
	
	function check()
	{
		if ($this->name=="") {
			$this->setError(JText::_('Add Title'));
			return false;
		}
		
		return true;
	}
}