<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

if(!defined('DS')){
	define('DS',DIRECTORY_SEPARATOR);
}

require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'liveupdate'.DS.'liveupdate.php';
if(JFactory::getApplication()->input->get('view') == 'liveupdate') {
    LiveUpdate::handleRequest();
    return;
}

require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'booking.helper.php');
require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'common.php');
require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'route.php');

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_taxibooking')) 
{
	return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
}

// restore old settings table data into new table
booking_helper::restoreSettings();

// Set the table directory
JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');

//Set filepath
$params = JComponentHelper::getParams('com_taxibooking');
define('COM_TAXIBOOKING_FILEPATH',    JPATH_ROOT.DS.$params->get($path, 'components/com_taxibooking/upload'));

if(!defined('APPREGULATOR_URL')){
	define('APPREGULATOR_URL',    'http://kabsky.co.uk/reviews'); // without trailing slash
}

// Require the base controller
require_once (JPATH_COMPONENT.DS.'controller.php');

// Require specific controller if requested
if( $controller = JRequest::getCmd('controller') ) {
	$path = JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';
	if (file_exists($path)) {
		require_once $path;
	} else {
		$controller = '';
	}
}

//Create the controller
$classname  = 'TaxiBookingController'.$controller;
$controller = new $classname( );

// Perform the Request task
$controller->execute( JRequest::getCmd('task'));

$controller->redirect();