<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
?>

<style type="text/css">
    /* Tooltips */
    .tip-wrap {max-width: 300px !important}  
</style>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/cars.css" />

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict( );
var BASE_URL = '<?php echo JURI::root();?>';
var assigned_tariffs = <?php echo count($this->tariffs) ?>;

tbjQuery(document).ready(function(){
    
})
</script>

<form action="<?php echo JRoute::_('index.php' ); ?>" method="post" name="adminForm" id="adminForm">

<div class="details_car_adminform">
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'CAR_TYPE' ).':'; ?>
		</label>
		<strong><?php echo $this->item->title; ?></strong>
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<?php echo JText::_( 'PUBLISHED' ).':'; ?>
		</label>
		<?php echo ($this->item->published==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_MINIMUM_PASSENGERS_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_MINIMUM_PASSENGERS' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->min_passenger_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_MAXIMUM_PASSENGERS_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_MAXIMUM_PASSENGERS' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->passenger_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="published">
			<?php echo JText::_( 'SUITCASE_NO' ).':'; ?>
		</label>
		<?php echo $this->item->suitcase_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'BOOSTER_SEAT' ).':'; ?>
		</label>
		<?php echo $this->item->booster_seat_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="published">
			<?php echo JText::_( 'INFANT_SEAT' ).':'; ?>
		</label>
		<?php echo $this->item->infant_seat_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'CHILD_SEAT' ).':'; ?>
		</label>
		<?php echo $this->item->child_seat_no; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'Description' ).':'; ?>
		</label>
		<?php echo $this->item->text; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'Image' ).':'; ?>
		</label>
		<div class="car_selectWrap"><?php echo JHtml::_('image', $this->item->image, $this->item->title, 'width="100"');?></div>
	</div>
</div>

<div class="details_car_adminform">
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_PRICE' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->price; ?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_ADD_PRICE_RETURN_TRIP_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_ADD_PRICE_RETURN_TRIP' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->add_price_return==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_USE_IN_ADDRESS_SEARCH_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_USE_IN_ADDRESS_SEARCH' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->use_in_address==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('UNIT_PRICE_OVERRIDE_EXPLAIN'); ?>">
			<?php echo JText::_( 'UNIT_PRICE_OVERRIDE' ).':'; ?>
			</span>
		</label>
		<?php echo ($this->item->unit_price_override==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap price_override_feature published clearfix">
		<label for="published">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_USE_TARIFF_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_USE_TARIFF' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->use_tariff==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap price_override_feature clearfix">
		<label for="published">
		    <span class="hasTip control-label" title="<?php echo JText::_('UNIT_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'UNIT_PRICE' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->unit_price; ?>
	</div>
	<div class="inputWrap price_override_feature clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_CHARGE_PER_MINUTE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_CHARGE_PER_MINUTE' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->charge_per_min; ?>
	</div>
	<div class="inputWrap price_override_feature clearfix" style="<?php echo ($this->item->unit_price_override==1) ? 'display:block':'display:none';?>">
		<label class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_EXPLAIN'); ?>">
			<?php echo JText::_( 'MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE' ).':'; ?>
		</label>
		<?php echo ($this->item->price_calculation_cumulative==1) ? JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_CUMULATIVE') : JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_NON_CUMULATIVE');?>
	</div>
	
	<?php
	if($this->item->unit_price_override==0){
	    $cum_style_display = 'display:none;';
	    $non_cum_style_display = 'display:none;';
	}
	else {
	    if($this->item->price_calculation_cumulative==0){
		$cum_style_display = 'display:none;';
		$non_cum_style_display = 'display:block;';
	    }
	    else {
		$cum_style_display = 'display:block;';
		$non_cum_style_display = 'display:none;';
	    }
	}
	?>
	
	<div class="inputWrap price_override_feature style clearfix" style="<?php echo $non_cum_style_display;?>">
	    <label class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
		<?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE'); ?>
	    </label>
	    <div id="surcharge_date_wrapper" class="non_cumulative_surcharge_date_wrapper">
		
		<?php
		$distance_price_arr = $this->item->distance_price_arr;
		for($i = 0; $i < count($distance_price_arr); $i++)
		{
			$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
			$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
			$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
			$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
			$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
			$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
		?>    
		<div class="date_price <?php echo 'row'.$i;?> clearfix">
		    <div class="fltlft">
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
				</span>
			    </label>
			    <?php echo $distance_min;?>
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
				</span>
			    </label>
			    <?php echo $distance_max;?>
			</div>
			
			<?php
			if($this->item->use_tariff==1 && count($this->tariffs)>0)
			{
			    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
				$tariff = $this->tariffs[$tariff_counter];
				$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
				<?php echo $tariff->title.':'; ?>
				</span>
			    </label>
			    <?php echo $tariff_price; ?>
			</div>
			<?php
			    }
			}
			else {
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
				<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
				</span>
			    </label>
			    <?php echo $price_value;?>
			</div>
			<?php } ?>
			
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <?php echo $outbound_discount_value;?>
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <?php echo $return_discount_value;?>
			</div>
		    </div>
		</div>
		<?php
		}
		?>
	    </div>
	</div>
	
	<div class="inputWrap price_override_feature style clearfix" style="<?php echo $cum_style_display;?>">
	    <label class="hasTip control-label" title="<?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
		<?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE'); ?>
	    </label>
	    <div id="surcharge_date_wrapper" class="cumulative_surcharge_date_wrapper">
		
		<?php
		$distance_price_arr = $this->item->cumulative_distance_price_arr;
		for($i = 0; $i < count($distance_price_arr); $i++)
		{
			$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
			$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
			$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
			$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
			$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
			$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
		?>    
		<div class="date_price <?php echo 'row'.$i;?> clearfix">
		    <div class="fltlft">
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
				</span>
			    </label>
			    <?php echo $distance_min;?>
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
				</span>
			    </label>
			    <?php echo $distance_max;?>
			</div>
			
			<?php
			if($this->item->use_tariff==1 && count($this->tariffs)>0)
			{
			    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
				$tariff = $this->tariffs[$tariff_counter];
				$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
				<?php echo $tariff->title.':'; ?>
				</span>
			    </label>
			    <?php echo $tariff_price; ?>
			</div>
			<?php
			    }
			}
			else {
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
				<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
				</span>
			    </label>
			    <?php echo $price_value;?>
			</div>
			<?php } ?>
			
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <?php echo $outbound_discount_value;?>
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <?php echo $return_discount_value;?>
			</div>
		    </div>
		</div>
		<?php
		}
		?>
	    </div>
	</div>
</div>

<div class="details_car_adminform">
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_USE_IN_SPECIAL_ROUTES_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_USE_IN_SPECIAL_ROUTES' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->use_in_offers==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->hourly_hire_enabled==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_MIN_HR_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_MIN_HR' ).':'; ?>
		    </span>
		</label>							
		<?php echo $this->item->hourly_hire_min_hr; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_MAX_HR_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_MAX_HR' ).':'; ?>
		    </span>
		</label>							
		<?php echo $this->item->hourly_hire_max_hr; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_PRICE' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->hourly_rate; ?>
	</div>
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_HIRE_FEE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_HIRE_FEE' ).':'; ?>
		    </span>
		</label>
		<?php echo $this->item->hourly_hire_fee; ?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTES_ENABLED_EXPLAIN'); ?>">
			<?php echo JText::_( 'SHUTTLE_ROUTES_ENABLED' ).':'; ?>
		    </span>
		</label>
		<?php
		if($this->item->use_as_shuttle==1){
		    echo JText::_('JYES');
		}
		elseif($this->item->use_as_shuttle==2){
		    echo JText::_('SHUTTLE_ROUTES_ENABLED_OPTION_ONLY_SHUTTLE');
		}
		else {
		    echo JText::_('JNO');
		}
		?>
	</div>
</div>

<div class="details_car_adminform scrollable">

	<legend><?php echo JText::_('CAR_AVAILABILITY');?></legend>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('TRACK_AVAILABITLITY_EXPLAIN'); ?>">
			<?php echo JText::_( 'TRACK_AVAILABITLITY' ).':'; ?>
		    </span>
		</label>
		<?php echo ($this->item->track_availability==1) ? JText::_('JYES') : JText::_('JNO');?>
	</div>
	
	<?php
	$weekdays = array(0 => JText::_('MONDAY'),
			  1 => JText::_('TUESDAY'),
			  2 => JText::_('WEDNESDAY'),
			  3 => JText::_('THURSDAY'),
			  4 => JText::_('FRIDAY'),
			  5 => JText::_('SATURDAY'),
			  6 => JText::_('SUNDAY')
			  );
	
	$days_availability = $this->item->days_availability;
	?>
	<table class="adminlist">
		<thead>
		    <tr>
			    <th class="one" width="150"><?php echo JText::_('CAR_AVAILABLE_WEEKDAYS');?></th>
			    <th class="two" width="150"><?php echo JText::_('CAR_AVAILABILITY');?></th>
		    </tr>
		</thead>
		<tbody>
		    
		    <?php
		    for($i=0;$i<count($weekdays);$i++)
		    {
			$checked = (isset($days_availability[$i]['is_available']) && ($days_availability[$i]['is_available']==1)) ? JText::_('JYES') : JText::_('JNO');
			
			$opening_hrs = $days_availability[$i]['opening_hrs'];
			$opening_mins = $days_availability[$i]['opening_mins'];
			$closing_hrs = $days_availability[$i]['closing_hrs'];
			$closing_mins = $days_availability[$i]['closing_mins'];
			
			if(isset($days_availability[$i]['is_available']) && ($days_availability[$i]['is_available']==1)){
			    if($opening_hrs==-1&&$opening_mins==-1&&$closing_hrs==-1&&$closing_mins==-1){
				$availability = JText::_('CAR_EDIT_AVAILABLE_ALLDAY');
			    }
			    else {
				$availability = $opening_hrs.':'.$opening_mins.' - '.$closing_hrs.':'.$closing_mins;
			    }
			}
			else {
			    $availability = JText::_('JNO');
			}
			
		    ?>
		    <tr>
		    <td class="center" width="150"><?php echo $weekdays[$i];?></td>
		    <td class="center" width="150"><?php echo $availability;?></td>
		    
		    </tr>
		    <?php } ?>
		</tbody>
	</table>
</div>
<div class="details_car_adminform" style="padding-top: 30px;">
	<div class="inputWrap clearfix">
	    <label><?php echo JText::_('CAR_BLOCKED_DATES'); ?></label>
	    <div id="blocked_dates_wrapper" style="width:350px; float: left;">
		    <?php
		    $blocked_dates_arr = (array)$this->item->blocked_dates_arr;
		    if(count($blocked_dates_arr)==0){
			echo JText::_('CAR_EDIT_NO_BLOCKED_DATES');
		    }
		    else {
			for($i = 0; $i < count($blocked_dates_arr); $i++)
			{
		    ?>    
		    <div class="blocked_date">
			    <div class="fltlft">
				    <?php echo $blocked_dates_arr[$i]; ?>
			    </div>
		    </div>
		    <?php 
			}
		    }
		    ?>
	    </div>							
	</div>
</div>


<?php
// only shuttle should not have calendar
if($this->item->google_calendar_enabled==1 && $this->item->google_calendar_html_url!="" && $this->item->use_as_shuttle!=2){ ?>
<div class="details_car_adminform" style="padding-top: 30px;">
    <legend><?php echo JText::_('CAR_DETAILS_BOOKING_CALENDAR');?></legend>
    <div class="inputWrap clearfix">
	<iframe width="100%" height="500" frameborder="0" scrolling="auto" src="<?php echo $this->escape($this->item->google_calendar_html_url);?>"></iframe>
    </div>
</div>
<?php } ?>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="cid[]" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="cars" />
<input type="hidden" name="view" value="car" />
<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>