<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>
<style type="text/css">
    div.current input, div.current textarea, div.current select{
        margin: 10px 0 0 2px;
    }
    .button2-left{
        /*margin: 0 0 0 5px;*/
    }
    .blocked_date {
        width: 420px;
        float: left;
	margin-top: 5px;
    }
    .date_price_label{
        width:116px;
        float: left;
        color:#146295;
    }
    
    #blocked_dates_wrapper .inputbox {
	float: left;
	margin: 0 5px 5px 0;
	width: auto;
    }
    /* Tooltips */
    .tip-wrap {max-width: 300px !important}  
</style>
<script language="javascript" type="text/javascript">
window.addEvent('domready', function() {
	
	$('add_blocked').addEvent('click', function(){
	    $('blocked_dates_wrapper').getChildren(".blocked_date_current").each(function(el, i) { 
		el.removeClass('blocked_date_current').getNext('.blocked_date').show().addClass('blocked_date_current');
	    });
	});
	$$('a.remove_blocked').addEvent('click', function(e){
		this.getParent().getParent().getParent().getElements('input').each(function (el, num){
			el.set('value', '');
		});
		this.getParent().getParent().getParent().hide();
	});
});
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<?php
$ynoptions = array(
	JHtml::_('select.option', 1, JText::_('JYES')),
	JHtml::_('select.option', 0, JText::_('JNO'))
);
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/cars.css" />

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>


<script type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict( );
var BASE_URL = '<?php echo JURI::root();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';
var assigned_tariffs = <?php echo count($this->tariffs) ?>;

tbjQuery(document).ready(function(){
    
    tbjQuery('input[name="use_in_address"]').click(function(){
	if(tbjQuery(this).val()==1){ // YES
	    tbjQuery('input[name="unit_price_override"]').closest('div.inputWrap').show();
	}
	else {
	    tbjQuery('input[name="unit_price_override"]').closest('div.inputWrap').hide();
	}
    })
    tbjQuery('input[name="unit_price_override"]').click(function(){
	if(tbjQuery(this).val()==1){ // YES
	    tbjQuery('div.price_override_feature').show();
	    tbjQuery('input:radio[name="price_calculation_cumulative"][value="0"]').prop('checked', true);
	    tbjQuery('input:radio[name="price_calculation_cumulative"][value="1"]').prop('checked', false);
	    tbjQuery('div.non_cumulative_surcharge_date_wrapper').parent().show();
	    tbjQuery('div.cumulative_surcharge_date_wrapper').parent().hide();
	}
	else {
	    tbjQuery('div.price_override_feature').hide();
	}
    })
    tbjQuery('input[name="use_tariff"]').click(function(){
	if(tbjQuery(this).val()==1){ // use tariff YES will hide unit price, remove all previous distance sector
	    tbjQuery('input[name="unit_price"]').parent().hide();
	    tbjQuery('input[name="charge_per_min"]').parent().hide();
	}
	else {
	    tbjQuery('input[name="unit_price"]').parent().show();
	    tbjQuery('input[name="charge_per_min"]').parent().show();
	}
	tbjQuery('div.cumulative_surcharge_date_wrapper, div.non_cumulative_surcharge_date_wrapper').find("div.date_price:not(:first-child)").remove();
    })
    tbjQuery('input[name="google_calendar_enabled"]').click(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('div.google_calendar_feature').show();
	}
	else {
	    tbjQuery('div.google_calendar_feature').hide();
	}
    })
    
    tbjQuery('input[name="price_calculation_cumulative"]').click(function(){
	if(tbjQuery(this).val()==1){ // cumulative
	    tbjQuery('div.non_cumulative_surcharge_date_wrapper').parent().hide();
	    tbjQuery('div.cumulative_surcharge_date_wrapper').parent().show();
	}
	else {
	    tbjQuery('div.non_cumulative_surcharge_date_wrapper').parent().show();
	    tbjQuery('div.cumulative_surcharge_date_wrapper').parent().hide();
	}
    })
    tbjQuery('input[name="hourly_hire_enabled"]').click(function(){
	if(tbjQuery(this).val()==1){ // YES
	    tbjQuery('div.hourly_feature').show();
	}
	else {
	    tbjQuery('div.hourly_feature').hide();
	}
    })
    
    tbjQuery('#add_price').click(function(){
	var count = tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price').length;
	var html = '';
	var i = count-1;
	
html += '<div class="date_price row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox distance_min" type="text" name="distance_min['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="distance_max['+i+']" size="10" value="" />'+
	    '</div>';
	    
// if use tariff YES, show separate price inputbox for each assigned tarrifs
// if NO, show one Price box
if(tbjQuery('input[name="use_tariff"]:checked').val()==1 && parseInt(assigned_tariffs) > 0){
<?php foreach($this->tariffs as $tariff){ ?>
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label">'+
		    '<?php echo $tariff->title.':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="tariff_prices['+i+']['+<?php echo $tariff->id; ?>+']" size="10" value="<?php echo $tariff->unit_price; ?>" />'+
	    '</div>';
<?php } ?>
}
else {
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="prices['+i+']" size="10" value="" />'+
	    '</div>';
}
	    
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="outbound_discount['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="return_discount['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			'<a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
	'</div>';
    
	tbjQuery('div.non_cumulative_surcharge_date_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
	tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price:last-child .distance_min').focus();
	
	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })
    
    tbjQuery('#cumulative_add_price').click(function(){
	var count = tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price').length;
	var html = '';
	var i = count-1;
	
html += '<div class="date_price row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox cumulative_distance_min" type="text" name="cumulative_distance_min['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="cumulative_distance_max['+i+']" size="10" value="" />'+
	    '</div>';
	    
// if use tariff YES, show separate price inputbox for each assigned tarrifs
// if NO, show one Price box
if(tbjQuery('input[name="use_tariff"]:checked').val()==1 && parseInt(assigned_tariffs) > 0){
<?php foreach($this->tariffs as $tariff){ ?>
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label">'+
		    '<?php echo $tariff->title.':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="tariff_cumulative_prices['+i+']['+<?php echo $tariff->id; ?>+']" size="10" value="<?php echo $tariff->unit_price; ?>" />'+
	    '</div>';
<?php } ?>
}
else {
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="cumulative_prices['+i+']" size="10" value="" />'+
	    '</div>';
}

html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="cumulative_outbound_discount['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="cumulative_return_discount['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			'<a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
	'</div>';
    
	tbjQuery('div.cumulative_surcharge_date_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
	tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price:last-child .cumulative_distance_min').focus();
	
	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })
    
    tbjQuery(document).on("click", '.remove_price', function (e) {
	    var r = confirm("Are you sure?");
	    if (r == true) {
		tbjQuery(this).closest('div.date_price').remove();
	    }
    })
})
</script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />

<!-- CSS to style the file input field as button and adjust the Bootstrap progress bars -->
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.fileupload.css">
<!-- The basic File Upload plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload.js"></script>
<!-- The File Upload processing plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-process.js"></script>
<!-- The File Upload validation plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-validate.js"></script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.Jcrop.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.Jcrop.css">

<script type="text/javascript">

/*jslint unparam: true */
/*global window, $ */
tbjQuery(function () {
    'use strict';
    // Change this to the location of your server-side upload handler:
    var url = BASE_URL+ 'components/com_taxibooking/upload.php';
    
    // Create variables (in this scope) to hold the API and image size
    var jcrop_api,
    boundx,
    boundy,

    // Grab some information about the preview pane
    $preview = tbjQuery('#preview-pane'),
    $pcnt = tbjQuery('#preview-pane .preview-container'),
    $pimg = tbjQuery('#preview-pane .preview-container img'),

    xsize = $pcnt.width(),
    ysize = $pcnt.height();
    
    tbjQuery('#fileupload').fileupload({
        url: url,
        dataType: 'json',
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        maxFileSize: 2000000 // 2 MB
        // Enable image resizing, except for Android and Opera,
        // which actually support image resizing, but fail to
        // send Blob objects via XHR requests:
        //disableImageResize: /Android(?!.*Chrome)|Opera/
            //.test(window.navigator.userAgent),
        //previewMaxWidth: 150,
        //previewMaxHeight: 150,
        //previewCrop: true,
    }).on('fileuploadadd', function (e, data) {
        tbjQuery('div#progress, div#photoPreviewWrap, div#preview-pane').show();
	if (typeof jcrop_api !== 'undefined') {
		jcrop_api.destroy();
	}
	data.context = tbjQuery('<div/>').appendTo('#files');
	tbjQuery.each(data.files, function (index, file) {
	    var node = tbjQuery('<p/>');
	    /*if (!index) {
		node
		    .append('<br>')
		    .append(uploadButton.clone(true).data(data));
	    }*/
	    node.appendTo(data.context);
	});
    }).on('fileuploadprocessalways', function (e, data) {
        var index = data.index,
	    file = data.files[index],
	    node = tbjQuery(data.context.children()[index]);
	/*if (file.preview) {
	    node
		.prepend('<br>')
		.prepend(file.preview);
	}*/
	if (file.error) {
	    tbjQuery('div#files').html(tbjQuery('<span class="text-danger"/>').text(file.error));
	}
	/*if (index + 1 === data.files.length) {
	    data.context.find('button')
		.text('Upload')
		.prop('disabled', !!data.files.error);
	}*/
    }).on('fileuploadprogressall', function (e, data) {
        var progress = parseInt(data.loaded / data.total * 100, 10);
        tbjQuery('#progress .progress-bar').css(
            'width',
            progress + '%'
        );
    }).on('fileuploaddone', function (e, data) {
	var file = data.result.files[0];
        //tbjQuery.each(data.result.files, function (index, file) {
            if (file.url) {
		tbjQuery('#new_photo').val(file.name);
		tbjQuery("#crop-target").attr("src",file.mediumUrl+"?d="+ (new Date()).getTime()  );
		$pimg.attr("src",file.mediumUrl+"?d="+ (new Date()).getTime());
		tbjQuery('.jcrop-holder img').attr('src', file.mediumUrl+"?d="+ (new Date()).getTime() );
		tbjQuery('#is_photo_changed').val(1);
		tbjQuery( "#preview-pane" ).draggable({
			cursor: "move"
		});
		
		setTimeout(function() {
		    initJcrop();
		    tbjQuery('span#reupload-button').show();
		    tbjQuery('span#upload-button').hide();
		    
		    function initJcrop()
		    {
			//var oImage = new Image();
			//oImage.src = tbjQuery("#crop-target").attr("src");
			//console.log('width: ' + oImage.naturalWidth + ' and height: ' + oImage.naturalHeight);

			tbjQuery('#crop-target').Jcrop({
				onChange: updatePreview,
				onSelect: updatePreview,
				aspectRatio: xsize / ysize,
				setSelect: [ 0, 0, 300, 300 ],
				minSize: [ 100, 100 ]
			},function(){
				// Use the API to get the real image size
				var bounds = this.getBounds();
				boundx = bounds[0];
				boundy = bounds[1];
				console.log('boundx: ' + boundx + ' and boundy: ' + boundy);
				
				// Store the API in the jcrop_api variable
				jcrop_api = this;
				
				// Sets a random selection
				jcrop_api.animateTo([0, 0, 300, 300]);
				jcrop_api.setImage(file.mediumUrl+"?d="+ (new Date()).getTime());
			  
				// Move the preview into the jcrop container for css positioning
				$preview.appendTo(jcrop_api.ui.holder);
				$pimg.removeAttr( 'style' );
			});
		    };
		    function updatePreview(c)
		    {
			if (parseInt(c.w) > 0)
			{
			    var rx = xsize / c.w;
			    var ry = ysize / c.h;
			    
			    tbjQuery('#x1').val(c.x);
			    tbjQuery('#y1').val(c.y);
			    tbjQuery('#x2').val(c.x2);
			    tbjQuery('#y2').val(c.y2);
			    tbjQuery('#w').val(c.w);
			    tbjQuery('#h').val(c.h);
		    
			    $pimg.css({
				    width: Math.round(rx * boundx) + 'px',
				    height: Math.round(ry * boundy) + 'px',
				    marginLeft: '-' + Math.round(rx * c.x) + 'px',
				    marginTop: '-' + Math.round(ry * c.y) + 'px'
			    });
			}
		    };
		}, 100);
		
                /*var link = $('<a>')
                    .attr('target', '_blank')
                    .prop('href', file.url);
                $(data.context.children()[index])
                    .wrap(link);*/
            } else if (file.error) {
                var error = tbjQuery('<span class="text-danger"/>').text(file.error);
                tbjQuery(data.context.children()[index])
                    .append('<br>')
                    .append(error);
            }
        //});
	
    }).on('fileuploadfail', function (e, data) {
        /*$.each(data.files, function (index) {
            var error = $('<span class="text-danger"/>').text('File upload failed.');
            $(data.context.children()[index])
                .append('<br>')
                .append(error);
        });*/
    }).prop('disabled', !tbjQuery.support.fileInput)
        .parent().addClass(tbjQuery.support.fileInput ? undefined : 'disabled');
	
});
</script>

<style type="text/css">

/* Apply these styles only when #preview-pane has
   been placed within the Jcrop widget */
.jcrop-holder #preview-pane {
  display: block;
  position: absolute;
  z-index: 2000;
  top: 10px;
  right: -280px;
  padding: 6px;
  border: 1px rgba(0,0,0,.4) solid;
  background-color: white;
cursor: all-scroll;
  -webkit-border-radius: 6px;
  -moz-border-radius: 6px;
  border-radius: 6px;

  -webkit-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
  -moz-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
  box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
}

/* The Javascript code will set the aspect ratio of the crop
   area based on the size of the thumbnail preview,
   specified here */
#preview-pane {
  width: 300px;
}
#preview-pane .preview-container {
  width: 300px;
  height: 300px;
  overflow: hidden;
}
.fileinput-button {
	margin-bottom: 10px;
}

.progress {
	margin-bottom: 10px;
}

.progress-bar-success {
    background-color: #5cb85c;
}

.progress-bar {
    box-shadow: 0 -1px 0 rgba(0, 0, 0, 0.15) inset;
    color: #fff;
    float: left;
    font-size: 12px;
    height: 100%;
    line-height: 20px;
    text-align: center;
    transition: width 0.6s ease 0s;
}
</style>

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

<div class="details_car_adminform">
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'CAR_TYPE' ).':'; ?>
		</label>
		<input type="text" name="title" value="<?php echo $this->item->title; ?>" size="50" class="inputbox required" />
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<?php echo JText::_( 'PUBLISHED' ).':'; ?>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );
		?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_MINIMUM_PASSENGERS_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_MINIMUM_PASSENGERS' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="min_passenger_no" value="<?php echo $this->item->min_passenger_no; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_MAXIMUM_PASSENGERS_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_MAXIMUM_PASSENGERS' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="passenger_no" value="<?php echo $this->item->passenger_no; ?>" size="50" maxlength="100" class="inputbox required" />
	</div>
	<div class="inputWrap clearfix">
		<label for="published">
			<?php echo JText::_( 'SUITCASE_NO' ).':'; ?>
		</label>
		<input type="text" name="suitcase_no" value="<?php echo $this->item->suitcase_no; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'BOOSTER_SEAT' ).':'; ?>
		</label>
		<input type="text" name="booster_seat_no" value="<?php echo $this->item->booster_seat_no; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">
		<label for="published">
			<?php echo JText::_( 'INFANT_SEAT' ).':'; ?>
		</label>
		<input type="text" name="infant_seat_no" value="<?php echo $this->item->infant_seat_no; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'CHILD_SEAT' ).':'; ?>
		</label>
		<input type="text" name="child_seat_no" value="<?php echo $this->item->child_seat_no; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'Image' ).':'; ?>
		</label>
		<div class="car_selectWrap">
		
		    <?php echo $this->imageselect;?>
		    
		    <?php if($this->item->image!=""){ ?>
		    <div style="margin-bottom:10px;">
		    <img src="<?php echo JURI::root().$this->item->image;?>?d=<?php echo time();?>" alt="<?php echo htmlspecialchars($this->item->title);?>" />
		    </div>
		    <?php } ?>

		    <!-- The global progress bar -->
		    <div id="progress" class="progress" style="display:none;">
			<div class="progress-bar progress-bar-success"></div>
		    </div>
		    
		    <!-- The container for the uploaded files -->
		    <div id="files" class="files"></div>
		    
		    <div id="photoPreviewWrap" style="display:none;">
			<img src="" id="crop-target" />
			<input type="hidden" name="is_photo_changed" id="is_photo_changed" value="0" />
			<input type="hidden" name="new_photo" id="new_photo" value="" />
			<input type="hidden" name="cropped_data[x1]" id="x1" value="0" />
			<input type="hidden" name="cropped_data[y1]" id="y1" value="0" />
			<input type="hidden" name="cropped_data[x2]" id="x2" value="300" />
			<input type="hidden" name="cropped_data[y2]" id="y2" value="300" />
			<input type="hidden" name="cropped_data[w]" id="w" value="300" />
			<input type="hidden" name="cropped_data[h]" id="h" value="300" />
		    </div>
		    
		    <div id="preview-pane" style="display:none;">
			<div class="preview-container">
			    <img src="" class="jcrop-preview" alt="Preview" />
			</div>
		    </div>
			
			<div class="clearfix"></div>
		    <!-- The fileinput-button span is used to style the file input field as button -->
		    <span class="btn btn-success fileinput-button" id="upload-button">
			<i class="glyphicon glyphicon-plus"></i>
			<span><?php echo JText::_('TBUSERS_SELECT_FILE');?></span>
			<!-- The file input field used as target for the file upload widget -->
			<input id="fileupload" type="file" name="files[]" accept="image/*" />
		    </span>
		    
		    <span class="btn btn-success fileinput-button" id="reupload-button" style="display:none;">
			<i class="glyphicon glyphicon-plus"></i>
			<span onclick="window.location.reload(true);"><?php echo JText::_('TBUSERS_IMAGE_REUPLOAD');?></span>
		    </span>			
			
		    
		</div>
</div>

<div class="details_car_adminform">
	<div class="inputWrap clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_PRICE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="price" value="<?php echo $this->item->price; ?>" size="50" maxlength="100" />
	</div>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_ADD_PRICE_RETURN_TRIP_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_ADD_PRICE_RETURN_TRIP' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'add_price_return', 'class="inputbox"', $this->item->add_price_return );
		?>
	</div>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_USE_IN_ADDRESS_SEARCH_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_USE_IN_ADDRESS_SEARCH' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'use_in_address', 'class="inputbox"', $this->item->use_in_address );
		?>
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_DISCOUNT_PRICE_DRIVER_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_DISCOUNT_PRICE_DRIVER' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="discount_price_driver" value="<?php echo $this->item->discount_price_driver; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap published clearfix" style="<?php echo ($this->item->use_in_address==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('UNIT_PRICE_OVERRIDE_EXPLAIN'); ?>">
			<?php echo JText::_( 'UNIT_PRICE_OVERRIDE' ).':'; ?>
			</span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'unit_price_override', 'class="inputbox"', $this->item->unit_price_override );
		?>
	</div>
	<div class="inputWrap price_override_feature published clearfix" style="<?php echo ($this->item->unit_price_override==1) ? 'display:block':'display:none';?>">
		<label for="published">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_USE_TARIFF_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_USE_TARIFF' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'use_tariff', 'class="inputbox"', $this->item->use_tariff );
		?>
	</div>
	<div class="inputWrap price_override_feature clearfix" style="<?php echo ($this->item->unit_price_override==1&&$this->item->use_tariff==0) ? 'display:block':'display:none';?>">
		<label for="published">
		    <span class="hasTip control-label" title="<?php echo JText::_('UNIT_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'UNIT_PRICE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="unit_price" value="<?php echo $this->item->unit_price; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap price_override_feature clearfix" style="<?php echo ($this->item->unit_price_override==1&&$this->item->use_tariff==0) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_CHARGE_PER_MINUTE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_CHARGE_PER_MINUTE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="charge_per_min" value="<?php echo $this->item->charge_per_min; ?>" size="50" maxlength="100" />
	</div>
	
	<div class="inputWrap price_override_feature clearfix" style="<?php echo ($this->item->unit_price_override==1) ? 'display:block':'display:none';?>">
		<label class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_EXPLAIN'); ?>">
			<?php echo JText::_( 'MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE' ).':'; ?>
		</label>
		<?php
		$options = array(
		    JHtml::_('select.option', 0, JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_NON_CUMULATIVE')),
		    JHtml::_('select.option', 1, JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_CUMULATIVE'))			
		);
		echo JHtml::_('select.radiolist', $options, 'price_calculation_cumulative', '', 'value', 'text', $this->item->price_calculation_cumulative) ;
		?>
	</div>
	
	<?php
	if($this->item->unit_price_override==0){
	    $cum_style_display = 'display:none;';
	    $non_cum_style_display = 'display:none;';
	}
	else {
	    if($this->item->price_calculation_cumulative==0){
		$cum_style_display = 'display:none;';
		$non_cum_style_display = 'display:block;';
	    }
	    else {
		$cum_style_display = 'display:block;';
		$non_cum_style_display = 'display:none;';
	    }
	}
	?>
	
	<div class="inputWrap price_override_feature style clearfix" style="<?php echo $non_cum_style_display;?>">
	    <label class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
		<?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE'); ?>
	    </label>
	    <div id="surcharge_date_wrapper" class="non_cumulative_surcharge_date_wrapper">
		<div class="date_price clearfix">
			<div class="button2-left">
				<div class="blank">
					<a class="btn btn-small" href="javascript:void(0);" id="add_price"><?php echo JText::_('ADD_NEW'); ?></a>
				</div>
			</div>
		</div>
		
		<?php
		$distance_price_arr = $this->item->distance_price_arr;
		for($i = 0; $i < count($distance_price_arr); $i++)
		{
			$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
			$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
			$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
			$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
			$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
			$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
		?>    
		<div class="date_price <?php echo 'row'.$i;?> clearfix">
		    <div class="fltlft">
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox distance_min" name="distance_min[<?php echo $i;?>]" size="20" value="<?php echo $distance_min;?>" />
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="distance_max[<?php echo $i;?>]" size="20" value="<?php echo $distance_max;?>" />
			</div>
			
			<?php
			if($this->item->use_tariff==1 && count($this->tariffs)>0)
			{
			    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
				$tariff = $this->tariffs[$tariff_counter];
				$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
				<?php echo $tariff->title.':'; ?>
				</span>
			    </label>
			    <input class="inputbox" type="text" name="tariff_prices[<?php echo $i;?>][<?php echo $tariff->id; ?>]" size="10" value="<?php echo $tariff_price; ?>" />
			</div>
			<?php
			    }
			}
			else {
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
				<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="prices[<?php echo $i;?>]" size="20" value="<?php echo $price_value;?>" />
			</div>
			<?php } ?>
			
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="outbound_discount[<?php echo $i;?>]" size="20" value="<?php echo $outbound_discount_value;?>" />
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="return_discount[<?php echo $i;?>]" size="20" value="<?php echo $return_discount_value;?>" />
			</div>
		    </div>
		    <div class="button2-left">
			<div class="blank">
			    <a href="javascript:void(0);" class="remove_price btn btn-small"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		    </div>
		</div>
		<?php
		}
		?>
	    </div>
	</div>
	
	<div class="inputWrap price_override_feature style clearfix" style="<?php echo $cum_style_display;?>">
	    <label class="hasTip control-label" title="<?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
		<?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE'); ?>
	    </label>
	    <div id="surcharge_date_wrapper" class="cumulative_surcharge_date_wrapper">
		<div class="date_price clearfix">
			<div class="button2-left">
				<div class="blank">
					<a class="btn btn-small" href="javascript:void(0);" id="cumulative_add_price"><?php echo JText::_('ADD_NEW'); ?></a>
				</div>
			</div>
		</div>
		
		<?php
		$distance_price_arr = $this->item->cumulative_distance_price_arr;
		for($i = 0; $i < count($distance_price_arr); $i++)
		{
			$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
			$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
			$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
			$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
			$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
			$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
		?>    
		<div class="date_price <?php echo 'row'.$i;?> clearfix">
		    <div class="fltlft">
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox cumulative_distance_min" name="cumulative_distance_min[<?php echo $i;?>]" size="20" value="<?php echo $distance_min;?>" />
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="cumulative_distance_max[<?php echo $i;?>]" size="20" value="<?php echo $distance_max;?>" />
			</div>
			
			<?php
			if($this->item->use_tariff==1 && count($this->tariffs)>0)
			{
			    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
				$tariff = $this->tariffs[$tariff_counter];
				$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
				<?php echo $tariff->title.':'; ?>
				</span>
			    </label>
			    <input class="inputbox" type="text" name="tariff_cumulative_prices[<?php echo $i;?>][<?php echo $tariff->id; ?>]" size="10" value="<?php echo $tariff_price; ?>" />
			</div>
			<?php
			    }
			}
			else {
			?>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
				<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="cumulative_prices[<?php echo $i;?>]" size="20" value="<?php echo $price_value;?>" />
			</div>
			<?php } ?>
			
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="cumulative_outbound_discount[<?php echo $i;?>]" size="20" value="<?php echo $outbound_discount_value;?>" />
			</div>
			<div class="inputwrap clearfix">
			    <label>
				<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
				<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
				</span>
			    </label>
			    <input type="text" class="inputbox" name="cumulative_return_discount[<?php echo $i;?>]" size="20" value="<?php echo $return_discount_value;?>" />
			</div>
		    </div>
		    <div class="button2-left">
			<div class="blank">
			    <a href="javascript:void(0);" class="remove_price btn btn-small"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		    </div>
		</div>
		<?php
		}
		?>
	    </div>
	</div>
</div>


<div class="details_car_adminform">
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_USE_IN_SPECIAL_ROUTES_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_USE_IN_SPECIAL_ROUTES' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'use_in_offers', 'class="inputbox"', $this->item->use_in_offers );
		?>
	</div>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'hourly_hire_enabled', 'class="inputbox"', $this->item->hourly_hire_enabled );
		?>
	</div>
	<div class="inputWrap hourly_feature clearfix" style="<?php echo ($this->item->hourly_hire_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_MIN_HR_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_MIN_HR' ).':'; ?>
		    </span>
		</label>							
		<input type="text" name="hourly_hire_min_hr" value="<?php echo $this->item->hourly_hire_min_hr; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap hourly_feature clearfix" style="<?php echo ($this->item->hourly_hire_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_MAX_HR_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_MAX_HR' ).':'; ?>
		    </span>
		</label>							
		<input type="text" name="hourly_hire_max_hr" value="<?php echo $this->item->hourly_hire_max_hr; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap hourly_feature clearfix" style="<?php echo ($this->item->hourly_hire_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_RATE_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_RATE_PRICE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="hourly_rate" value="<?php echo $this->item->hourly_rate; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap hourly_feature clearfix" style="<?php echo ($this->item->hourly_hire_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_HOURLY_HIRE_FEE_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_HOURLY_HIRE_FEE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="hourly_hire_fee" value="<?php echo $this->item->hourly_hire_fee; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTES_ENABLED_EXPLAIN'); ?>">
			<?php echo JText::_( 'SHUTTLE_ROUTES_ENABLED' ).':'; ?>
		    </span>
		</label>
		<?php
		$options = array();
		$options[] = JHTML::_('select.option', 0, JText::_('JNO'));
		$options[] = JHTML::_('select.option', 1, JText::_('JYES'));
		$options[] = JHTML::_('select.option', 2, JText::_('SHUTTLE_ROUTES_ENABLED_OPTION_ONLY_SHUTTLE'));
		echo JHTML::_('select.genericlist', $options, 'use_as_shuttle', 'size="1" class="inputbox"', 'value', 'text', $this->item->use_as_shuttle);
		?>
	</div>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_GOOGLE_CALENDAR_ENABLED_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_GOOGLE_CALENDAR_ENABLED' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'google_calendar_enabled', 'class="inputbox"', $this->item->google_calendar_enabled );
		?>
	</div>
	
	<div class="inputWrap google_calendar_feature clearfix" style="<?php echo ($this->item->google_calendar_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_GOOGLE_CALENDAR_ID_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_GOOGLE_CALENDAR_ID' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="google_calendar_id" value="<?php echo $this->item->google_calendar_id; ?>" size="50" maxlength="255" />
	</div>
	<div class="inputWrap google_calendar_feature clearfix" style="<?php echo ($this->item->google_calendar_enabled==1) ? 'display:block':'display:none';?>">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('CAR_EDIT_GOOGLE_CALENDAR_HTML_URL_EXPLAIN'); ?>">
			<?php echo JText::_( 'CAR_EDIT_GOOGLE_CALENDAR_HTML_URL' ).':'; ?>
		    </span>
		</label>
		<textarea name="google_calendar_html_url" style="height:80px;"><?php echo $this->item->google_calendar_html_url; ?></textarea>
	</div>
</div>


<div class="details_car_adminform scrollable">

	<legend><?php echo JText::_('CAR_AVAILABILITY');?></legend>
	
	<div class="inputWrap published clearfix">
		<label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('TRACK_AVAILABITLITY_EXPLAIN'); ?>">
			<?php echo JText::_( 'TRACK_AVAILABITLITY' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'track_availability', 'class="inputbox"', $this->item->track_availability );
		?>
	</div>
	
	<?php
	$weekdays = array(0 => JText::_('MONDAY'),
			  1 => JText::_('TUESDAY'),
			  2 => JText::_('WEDNESDAY'),
			  3 => JText::_('THURSDAY'),
			  4 => JText::_('FRIDAY'),
			  5 => JText::_('SATURDAY'),
			  6 => JText::_('SUNDAY')
			  );
	$hr_options = array();
	$hr_options[] = JHTML::_('select.option', -1, JText::_('HRS'));
	for($i = 0; $i < 24; $i++)
	{
	$i = ($i < 10) ? "0$i" : $i;
	$hr_options[] = JHTML::_('select.option', $i, $i);
	}
	
	$min_options = array();
	$min_options[] = JHTML::_('select.option', -1, JText::_('MINS'));
	for ($i = 0; $i <= 55; $i = $i + 5)
	{
	$i = ($i < 10) ? "0$i" : $i;
	$min_options[] = JHTML::_('select.option', $i, $i);
	}
	$days_availability = $this->item->days_availability;
	?>
	<table class="adminlist">
		<thead>
			<tr>
				<th class="one"><?php echo JText::_('CAR_AVAILABLE_WEEKDAYS');?></th>
				<th class="two"><?php echo JText::_('CAR_AVAILABLE_IS_AVAILABLE');?></th>
				<th class="three"><?php echo JText::_('CAR_AVAILABLE_FROM');?></th>
				<th class="four"><?php echo JText::_('CAR_AVAILABLE_TO');?></th>
			</tr>
		</thead>
		<tbody>
			
			<?php
			for($i=0;$i<count($weekdays);$i++)
			{
			$checked = (isset($days_availability[$i]['is_available']) && ($days_availability[$i]['is_available']==1)) ? ' checked="checked"' : '';
			?>
			<tr>
			<td class="center"><?php echo $weekdays[$i];?></td>
			<td class="center">
				<input type="checkbox" value="1" name="days_availability[<?php echo $i;?>][is_available]" <?php echo $checked;?> />
			</td>
			<td class="center">
				<?php echo JHTML::_('select.genericlist', $hr_options, "days_availability[$i][opening_hrs]", '', 'value', 'text',$days_availability[$i]['opening_hrs']);?><span class="dot">:</span>
				<?php echo JHTML::_('select.genericlist', $min_options, "days_availability[$i][opening_mins]", '', 'value', 'text',$days_availability[$i]['opening_mins'] );?>
			</td>
			<td class="center">
				<?php echo JHTML::_('select.genericlist', $hr_options, "days_availability[$i][closing_hrs]", '', 'value', 'text',$days_availability[$i]['closing_hrs']);?><span class="dot">:</span>
				<?php echo JHTML::_('select.genericlist', $min_options, "days_availability[$i][closing_mins]", '', 'value', 'text',$days_availability[$i]['closing_mins']);?>
			</td>
			</tr>
			<?php } ?>			    
		</tbody>
	</table>
</div>
	
<div class="details_car_adminform">
	<div class="inputWrap clearfix">
		<label style="padding-top: 30px;"><?php echo JText::_('CAR_BLOCKED_DATES'); ?></label>
		<div id="blocked_dates_wrapper" style="width:350px; float: left;">
			<div class="date_price_button">
				<div class="fltlft">
					
				</div>
				<div class="button2-left">
					<div class="blank">
						<a class="btn btn-small" href="javascript:void(0);" id="add_blocked"><?php echo JText::_('ADD_NEW'); ?></a>
					</div>
				</div>
			</div>

			<?php
			
			$blocked_dates_arr = (array)$this->item->blocked_dates_arr;
			for($i = 0; $i < 50; $i++)
			{
				$style = "display:none;";
				$current = '';
				if($i == 0 || isset($blocked_dates_arr[$i]))
				{
					$style = "display:block;";
					$current = ' blocked_date_current';
				}
				
				$sel_val = !empty($blocked_dates_arr[$i]) ? $blocked_dates_arr[$i] : "";
			?>    
			<div class="blocked_date<?php echo $current;?> <?php echo 'row'.$i;?>" style="<?php echo $style;?>">
				<div class="fltlft">
					<?php
					echo JHtml::_('calendar', $sel_val, 'blocked_dates[]', "blocked_dates$i", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
					?>
				</div>
				<div class="button2-left">
					<div class="blank">
						<a href="javascript:void(0);" class="remove_blocked btn btn-small"><?php echo JText::_('REMOVE'); ?></a>
					</div>
				</div>
			</div>
			<?php 
			}
			?>
		</div>							
	</div>
</div>
<div class="editor">		    
	<table class="adminform">
		<tr>
			<td>
				<label for="body">
					<?php echo JText::_( 'Description' ).':'; ?>
				</label>
			</td>
		</tr>
		<tr>
			<td>
				<?php
				// parameters : areaname, content, hidden field, width, height, rows, cols
				echo $this->editor->display( 'text',  $this->item->text, '100%;', '350', '75', '20', array('pagebreak') ) ;
				?>
			</td>
		</tr>
	</table>
</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="cars" />
<input type="hidden" name="view" value="car" />
<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>