<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View to edit an car.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxiBookingViewCar extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		
		$this->item	= $this->get('Item');
		$this->tariffs  = $this->get( 'Tariffs' );
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
	
			return false;
		}
		
		if($isNew){
			// parse distance prices
			$this->item->distance_price_arr = array();
			$this->item->cumulative_distance_price_arr = array();
			$this->item->blocked_dates_arr = array();
		}
		else {
			// parse distance prices
			$this->item->distance_price_arr = unserialize($this->item->distance_prices);
			$this->item->cumulative_distance_price_arr = unserialize($this->item->cumulative_distance_prices);
			
			// parse blocked dates
			$this->item->blocked_dates_arr = unserialize($this->item->blocked_dates);
			
			// Convert the params field to an array.
			$registry = new JRegistry;
			
			$registry->loadString($this->item->days_availability);
			$this->item->days_availability = $registry->toArray();
		}
		
		 // Load the modal behavior script for image select
                JHtml::_('behavior.modal');

                // Build the script.
                $script = array();
                $script[] = '	function jInsertFieldValue(value, id) {';
                $script[] = '		var old_id = document.id(id).value;';
                $script[] = '		if (old_id != id) {';
                $script[] = '			var elem = document.id(id)';
                $script[] = '			elem.value = value;';
                $script[] = '			elem.fireEvent("change");';
                $script[] = '		}';
                $script[] = '	}';

                // Add the script to the document head.
                JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		$html[] = '<div class="fltlft">';
		$html[] = '	<input type="text" name="image" id="car_image" value="'
			. htmlspecialchars($this->item->image, ENT_COMPAT, 'UTF-8') . '" size="40" readonly="readonly" />';
		$html[] = '</div>';

		$directory = 'taxibooking/cars';
		if (file_exists(JPATH_ROOT . '/' . JComponentHelper::getParams('com_media')->get('image_path', 'images') . '/' . $directory))
		{
			$folder = $directory;
		}
		else
		{
			$folder = '';
		}
		// The button.
		$html[] = '<div class="button2-left">';
		$html[] = '	<div class="blank">';
		$html[] = '		<a class="modal btn" title="' . JText::_('JLIB_FORM_BUTTON_SELECT') . '"' . ' href="'
			. 'index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;asset=com_taxibooking'
                        . '&amp;author='.$user->get('id').'&amp;fieldid=car_image&amp;folder=' . $folder . '"'
			. ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}">';
		$html[] = JText::_('JLIB_FORM_BUTTON_SELECT') . '</a>';
		$html[] = '	</div>';
		$html[] = '</div>';

		$html[] = '<div class="button2-left">';
		$html[] = '	<div class="blank">';
		$html[] = '		<a class="btn" title="' . JText::_('JLIB_FORM_BUTTON_CLEAR') . '"' . ' href="#" onclick="';
		$html[] = 'document.id(\'car_image\').value=\'\';';
		$html[] = 'document.id(\'car_image\').fireEvent(\'change\');';
		$html[] = 'return false;';
		$html[] = '">';
		$html[] = JText::_('JLIB_FORM_BUTTON_CLEAR') . '</a>';
		$html[] = '	</div>';
		$html[] = '</div>';
                
                $this->imageselect = implode("\n", $html);
	
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
		
		$layout = JFactory::getApplication()->input->get('layout', 'default', 'string');
        
		if($layout == 'edit')
		{
		    JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_CAR_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_CAR_EDIT'), 'generic');
		    
		    // If not checked out, can save the item.
		    if (!$checkedOut)
		    {
			JToolbarHelper::apply();
			JToolbarHelper::save();
		    }
		    
		    JToolbarHelper::cancel();
		}
		else {
		    JToolbarHelper::title(JText::_('COM_TAXIBOOKING_MANAGER_CAR_DETAILS'), 'generic');
		    
		    if (($canDo->get('core.edit')))
		    {
			JToolbarHelper::custom('edit', 'edit', '', 'JTOOLBAR_EDIT', false);
		    }
		    
		    JToolbarHelper::cancel('cancel', 'JTOOLBAR_BACK');
		    
		    if (($canDo->get('core.delete')))
		    {
			// Add a delete button.
			$bar->appendButton('Confirm', 'Are you sure?', 'delete', 'JTOOLBAR_DELETE', 'remove', false);
		    }
		}
	}
}