<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');
?>

<style type="text/css">
.map-canvas-wrapper {
    margin: 20px 10px 10px 0px;
    padding: 10px 10px 10px 0px;
    min-height: 350px;
    height: 350px;
    width: 100%;
}
#map-canvas {
    width: 100%;
    height: 100%;
}
.map-canvas-wrapper img {
    max-width: inherit !important;
}
#panel {
    position: absolute;
    top: 50px;
    left: 50%;
    margin-left: -50px;
    z-index: 5;
    background-color: #fff;
    padding: 5px;
    border: 1px solid #999;
}
</style>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp"></script>
<script src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/google.maps.Polygon.getBounds.js"></script>
<script src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/google.maps.Polygon.moveTo.js"></script>

<script type="text/javascript">
var map,areaOfOperation,geocoder;
var selectedAreaVerticesStr = '<?php echo $this->item->operation_area_vertices; ?>';
var triangleCoords = new Array();
var selectedAreaVerticesArr = JSON.parse(selectedAreaVerticesStr);

var defaultAreaVerticesStr = '<?php echo $this->default_operation_area_vertices; ?>';
var defaultAreaVerticesArr = JSON.parse(defaultAreaVerticesStr);

function initialize() {

    geocoder = new google.maps.Geocoder();

    var mapOptions = {
	zoom: 7,
	center: new google.maps.LatLng(0, 0),
	mapTypeId: google.maps.MapTypeId.ROADMAP
    };

    map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);

    var bounds = new google.maps.LatLngBounds();
    for (var i =0; i < selectedAreaVerticesArr.length; i++) {
	    var myLatLng = new google.maps.LatLng(selectedAreaVerticesArr[i][0],selectedAreaVerticesArr[i][1]);
	    triangleCoords.push(myLatLng);
	    bounds.extend(myLatLng);
    }
    map.fitBounds(bounds);

    // Construct the polygon.
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords,
	strokeColor: '#FF0000',
	strokeOpacity: 0.8,
	strokeWeight: 2,
	fillColor: '#FF0000',
	fillOpacity: 0.35,
	draggable: true,
	editable: true
    });

    areaOfOperation.setMap(map);

     // Add a listener for the click event.
    google.maps.event.addListener(areaOfOperation, 'click', showArrays);
    google.maps.event.addListener(areaOfOperation, 'dragend', showArrays);
    google.maps.event.addListener(areaOfOperation, 'mouseup', showArrays);
    google.maps.event.addListener(areaOfOperation, 'mouseout', showArrays);
}

function showArrays(event) {

    // Since this polygon has only one path, we can call getPath()
    // to return the MVCArray of LatLngs.
    var vertices = this.getPath();
    //var contentString = '<b>Bermuda Triangle polygon</b><br>Clicked location: <br>' + event.latLng.lat() + ',' + event.latLng.lng() +'<br>';

    // Iterate over the vertices.
    var newAreaVertices = new Array();
    for (var i =0; i < vertices.getLength(); i++) {
	var xy = vertices.getAt(i);
	newAreaVertices.push(new Array(xy.lat(),xy.lng()));
	//contentString += '<br>' + 'Coordinate ' + i + ':<br>' + xy.lat() + ',' + xy.lng();
    }

    window.parent.document.getElementById('operation_area_vertices').value = JSON.stringify(newAreaVertices);
}

function resetArea() {
    var triangleCoords = new Array();

    var mapOptions = {
	zoom: 7,
	center: new google.maps.LatLng(0, 0),
	mapTypeId: google.maps.MapTypeId.ROADMAP
    };

    map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);

    var bounds = new google.maps.LatLngBounds();
    for (var i =0; i < defaultAreaVerticesArr.length; i++) {
	    var myLatLng = new google.maps.LatLng(defaultAreaVerticesArr[i][0],defaultAreaVerticesArr[i][1]);
	    triangleCoords.push(myLatLng);
	    bounds.extend(myLatLng);
    }
    map.fitBounds(bounds);

    // Construct the polygon.
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords,
	strokeColor: '#FF0000',
	strokeOpacity: 0.8,
	strokeWeight: 2,
	fillColor: '#FF0000',
	fillOpacity: 0.35,
	draggable: true,
	editable: true
    });

    areaOfOperation.setMap(map);
    window.parent.document.getElementById('operation_area_vertices').value = JSON.stringify(defaultAreaVerticesArr);
}

google.maps.event.addDomListener(window, 'load', initialize);

tbjQuery(document).ready(function(){
    tbjQuery('#jformdefault_country,#jform_default_city').change(function(){

	    // if country is changed, clear out city
	    if(tbjQuery(this).attr('id')=='jformdefault_country'){
		tbjQuery('#jform_default_city').val("");
	    }
	    var address = tbjQuery('#jformdefault_country :selected').text();

	    if(tbjQuery('#jform_default_city').val()!=""){
		    address += ' '+tbjQuery('#jform_default_city').val();
	    }
	    geocoder.geocode( { 'address': address}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
		    map.setCenter(results[0].geometry.location);
		    // Move the 2nd polygon to a new location
		    // @note: when geodesic is set to false it's recommened to use setTimeout() in order to have the getProjection() function available on the map
		    areaOfOperation.moveTo(results[0].geometry.location);

		    var newAreaVertices = new Array();
		    areaOfOperation.getPath().forEach(function(elem, index){
			    newAreaVertices.push(new Array(elem.lat(),elem.lng()));
		    });
		    document.getElementById('operation_area_vertices').value = JSON.stringify(newAreaVertices);
		} else {
		      //alert("Geocode was not successful for the following reason: " + status);
		}
	    });
    });
    tbjQuery('#jformcalculate_base_pickup').change(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('.base_pickup_feature').show();
	}
	else {
	    tbjQuery('.base_pickup_feature').hide();
	}
    })
    tbjQuery('#jformcalculate_dropoff_base').change(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('.base_dropoff_feature').show();
	}
	else {
	    tbjQuery('.base_dropoff_feature').hide();
	}
    })
});
</script>

<?php
  // echo "<pre>";
  // // $tete = json_decode($this->item->text, true);
  // $tete = unserialize($this->item->text);
  // print_r($tete);
  // $tete['newshit'] = 'some new shit';
  // $te = serialize($tete);
  // $te2 = unserialize($te);
  // print_r($te2);
  // die();
   ?>

<div class="adminform tab7">
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('DEFAULT_COUNTRY_EXPLAIN'); ?>">
		<?php echo JText::_('DEFAULT_COUNTRY'); ?>
	    </span>
	</label>
	<?php echo $this->lists['country_list']; ?>
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('DEFAULT_CITY_EXPLAIN'); ?>">
		<?php echo JText::_('DEFAULT_CITY'); ?>
	    </span>
	</label>
	<input class="inputbox" type="text" name="jform[default_city]" id="jform_default_city" value="<?php echo $this->item->default_city; ?>" size="50" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('CONFIGS_BASE_MAIN_BOOKING_EMAIL_EXPLAIN'); ?>">
		<?php echo JText::_('CONFIGS_BASE_MAIN_BOOKING_EMAIL'); ?>
	    </span>
	</label>
	<input class="inputbox" type="text" name="jform[booking_notification_email]" id="jform_booking_notification_email" value="<?php echo $this->item->booking_notification_email; ?>" size="50" />
    </div>
    <div class="inputwrap clearfix" style="position:relative; width: 400px">
	<label>
		<span class="hasTip control-label" title="<?php echo JText::_('AREA_OF_OPERATION_EXPLAIN'); ?>">
			<?php echo JText::_('AREA_OF_OPERATION'); ?>
		</span>
	</label>
	<input type="hidden" name="jform[operation_area_vertices]" id="operation_area_vertices" value="<?php echo $this->item->operation_area_vertices; ?>" />
	<div id="panel">
	    <input onclick="resetArea();" type=button value="<?php echo JText::_('SETTINGS_RESET_AREA_OPERATION'); ?>" />
	</div>

	<div class="map-canvas-wrapper">
		<div id="map-canvas"></div>
	</div>
    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('PICKUP_ONLY_FROM_BASE_AREA_EXPLAIN'); ?>">
			    <?php echo JText::_('PICKUP_ONLY_FROM_BASE_AREA'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[pickup_in_area]', 'size="1" class="inputbox"', 'value', 'text', $this->item->pickup_in_area);
	    ?>
    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('DROPOFF_ONLY_FROM_BASE_AREA_EXPLAIN'); ?>">
			    <?php echo JText::_('DROPOFF_ONLY_FROM_BASE_AREA'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[dropoff_in_area]', 'size="1" class="inputbox"', 'value', 'text', $this->item->dropoff_in_area);
	    ?>
    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('PICKUP_DROPFF_FROM_BASE_AREA_EXPLAIN'); ?>">
			    <?php echo JText::_('PICKUP_DROPFF_FROM_BASE_AREA'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[pickup_dropoff_in_area]', 'size="1" class="inputbox"', 'value', 'text', $this->item->pickup_dropoff_in_area);
	    ?>
    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('BASE_LATITUDE_EXPLAIN'); ?>">
			    <?php echo JText::_('BASE_LATITUDE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[base_lat]" id="base_lat" value="<?php echo $this->item->base_lat ?>">
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('BASE_LONGITUDE_EXPLAIN'); ?>">
			    <?php echo JText::_('BASE_LONGITUDE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[base_long]" id="base_long" value="<?php echo $this->item->base_long ?>">
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CALCULATE_DISTANCE_BASE_PICKUP_EXPLAIN'); ?>">
			    <?php echo JText::_('CALCULATE_DISTANCE_BASE_PICKUP'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[calculate_base_pickup]', 'size="1" class="inputbox"', 'value', 'text', $this->item->calculate_base_pickup);
	    ?>
    </div>
    <div class="inputwrap base_pickup_feature clearfix" style="display:<?php echo ($this->item->calculate_base_pickup==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_EXPLAIN'); ?>">
			    <?php echo JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES'); ?>
		    </span>
	    </label>
	    <?php
	    $options = array();
	    $options[] = JHTML::_('select.option', 'price_time', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_PRICE_TIME'));
	    $options[] = JHTML::_('select.option', 'time', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_TIME'));
	    $options[] = JHTML::_('select.option', 'no', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_NO'));
	    echo JHTML::_('select.genericlist', $options, 'jform[base_pickup_special_routes]', 'size="1" class="inputbox"', 'value', 'text', $this->item->base_pickup_special_routes);
	    ?>
    </div>
    <div class="inputwrap base_pickup_feature clearfix" style="display:<?php echo ($this->item->calculate_base_pickup==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('BASE_PICKUP_PRICE_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_('BASE_PICKUP_PRICE_TYPE'); ?>
		    </span>
	    </label>
	    <?php
	    $options = array();
	    $options[] = JHTML::_('select.option', 'flat', JText::_('BASE_PICKUP_PRICE_TYPE_FLAT'));
	    $options[] = JHTML::_('select.option', 'distance', JText::_('BASE_PICKUP_PRICE_TYPE_DISTANCE'));
	    echo JHTML::_('select.genericlist', $options, 'jform[base_pickup_price_type]', 'size="1" class="inputbox"', 'value', 'text', $this->item->base_pickup_price_type);
	    ?>
    </div>
    <div class="inputwrap base_pickup_feature clearfix" style="display:<?php echo ($this->item->calculate_base_pickup==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('BASE_PICKUP_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('BASE_PICKUP_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[base_pickup_price]" id="base_pickup_price" value="<?php echo $this->item->base_pickup_price ?>" />
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CALCULATE_DISTANCE_DROPOFF_BASE_EXPLAIN'); ?>">
			    <?php echo JText::_('CALCULATE_DISTANCE_DROPOFF_BASE'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[calculate_dropoff_base]', 'size="1" class="inputbox"', 'value', 'text', $this->item->calculate_dropoff_base);
	    ?>
    </div>
    <div class="inputwrap base_dropoff_feature clearfix" style="display:<?php echo ($this->item->calculate_dropoff_base==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_EXPLAIN'); ?>">
			    <?php echo JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES'); ?>
		    </span>
	    </label>
	    <?php
	    $options = array();
	    $options[] = JHTML::_('select.option', 'price_time', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_PRICE_TIME'));
	    $options[] = JHTML::_('select.option', 'time', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_TIME'));
	    $options[] = JHTML::_('select.option', 'no', JText::_('CONFIG_BASE_FOR_SPECIAL_ROUTES_OPTION_NO'));
	    echo JHTML::_('select.genericlist', $options, 'jform[base_dropoff_special_routes]', 'size="1" class="inputbox"', 'value', 'text', $this->item->base_dropoff_special_routes);
	    ?>
    </div>
    <div class="inputwrap base_dropoff_feature clearfix" style="display:<?php echo ($this->item->calculate_dropoff_base==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('DROPOFF_BASE_PRICE_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_('DROPOFF_BASE_PRICE_TYPE'); ?>
		    </span>
	    </label>
	    <?php
	    $options = array();
	    $options[] = JHTML::_('select.option', 'flat', JText::_('BASE_PICKUP_PRICE_TYPE_FLAT'));
	    $options[] = JHTML::_('select.option', 'distance', JText::_('BASE_PICKUP_PRICE_TYPE_DISTANCE'));
	    echo JHTML::_('select.genericlist', $options, 'jform[dropoff_base_price_type]', 'size="1" class="inputbox"', 'value', 'text', $this->item->dropoff_base_price_type);
	    ?>
    </div>
    <div class="inputwrap base_dropoff_feature clearfix" style="display:<?php echo ($this->item->calculate_dropoff_base==0)? 'none':'block';?>">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('DROPOFF_BASE_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('DROPOFF_BASE_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[dropoff_base_price]" id="dropoff_base_price" value="<?php echo $this->item->dropoff_base_price ?>" />
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('TIME_AFTER_EACH_BOOKING_EXPLAIN'); ?>">
			    <?php echo JText::_('TIME_AFTER_EACH_BOOKING'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[time_after_each_booking]" id="time_after_each_booking" value="<?php echo $this->item->time_after_each_booking ?>">
    </div>
    <div class="inputWrap clearfix">
      <label for="title">
  		    <span class="hasTip control-label" title="<?php //echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>Price in Zone 1">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Zone 0 distance
  		    </span>
  		</label>
  		<input type="text" name="jform[zonedist_0]" value="<?php echo $this->item->zonedist_0; ?>" size="50" class="inputbox required" />
      <hr>
      <label for="title">
  		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price in Zone 0
  		    </span>
  		</label>
  		<input type="text" name="jform[zoneprice_0]" value="<?php echo $this->item->zoneprice_0; ?>" size="50" class="inputbox required" />
    </div>

    <div class="inputWrap clearfix">
      <label for="title">
  		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Zone 1 distance
  		    </span>
  		</label>
  		<input type="text" name="jform[zonedist_1]" value="<?php echo $this->item->zonedist_1; ?>" size="50" class="inputbox required" />
      <hr>
      <label for="title">
  		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price in Zone 1
  		    </span>
  		</label>
  		<input type="text" name="jform[zoneprice_1]" value="<?php echo $this->item->zoneprice_1; ?>" size="50" class="inputbox required" />
  	</div>



      <div class="inputWrap clearfix">
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Zone 2 distance
    		    </span>
    		</label>
    		<input type="text" name="jform[zonedist_2]" value="<?php echo $this->item->zonedist_2; ?>" size="50" class="inputbox required" />
        <hr>
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price in Zone 2
    		    </span>
    		</label>
    		<input type="text" name="jform[zoneprice_2]" value="<?php echo $this->item->zoneprice_2; ?>" size="50" class="inputbox required" />
    	</div>

      <div class="inputWrap clearfix">
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Zone 3 distance
    		    </span>
    		</label>
    		<input type="text" name="jform[zonedist_3]" value="<?php echo $this->item->zonedist_3; ?>" size="50" class="inputbox required" />
        <hr>
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price in Zone 3
    		    </span>
    		</label>
    		<input type="text" name="jform[zoneprice_3]" value="<?php echo $this->item->zoneprice_3; ?>" size="50" class="inputbox required" />
    	</div>

      <div class="inputWrap clearfix">
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Zone 4 distance
    		    </span>
    		</label>
    		<input type="text" name="jform[zonedist_4]" value="<?php echo $this->item->zonedist_4; ?>" size="50" class="inputbox required" />
        <hr>
        <label for="title">
    		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price in Zone 4
    		    </span>
    		</label>
    		<input type="text" name="jform[zoneprice_4]" value="<?php echo $this->item->zoneprice_4; ?>" size="50" class="inputbox required" />
    	</div>
    	
    	  	<div class="inputWrap clearfix">
      <label for="title">
  		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Goodwood House radius
  		    </span>
  		</label>
  		<input type="text" name="jform[zonedist_5]" value="<?php echo $this->item->zonedist_5; ?>" size="50" class="inputbox required" />
      <hr>
      <label for="title">
  		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
  			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price for Goodwood House
  		    </span>
  		</label>
  		<input type="text" name="jform[zoneprice_5]" value="<?php echo $this->item->zoneprice_5; ?>" size="50" class="inputbox required" />
  	</div>
  	
  	<div class="inputWrap clearfix">
        <label for="title">
        <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
        <?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>London CC radius
        </span>
    </label>
    <input type="text" name="jform[zonedist_6]" value="<?php echo $this->item->zonedist_6; ?>" size="50" class="inputbox required" />
    <hr>
    <label for="title">
        <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
    <?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Extra Price for London CC
        </span>
    </label>
    <input type="text" name="jform[zoneprice_6]" value="<?php echo $this->item->zoneprice_6; ?>" size="50" class="inputbox required" />
    </div>
  
</div>

        <div class="inputWrap clearfix">
          <label for="title">
      		    <span class="hasTip control-label" title="<?php echo JText::_('TARRIF_INITIAL_PRICE_EXPLAIN'); ?>">
      			<?php //echo JText::_( 'TARRIF_INITIAL_PRICE' ).':'; ?>Google API key for distance matrix
      		    </span>
      		</label>
      		<input type="text" name="jform[distance_api_key]" value="<?php echo $this->item->distance_api_key; ?>" size="50" class="inputbox required" />          
      	</div>
    </div>
