<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');
?>

<div class="adminform tab4">
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('EMAIL_SETTINGS_ADDITIONAL_EMAILS_EXPLAIN'); ?>">
		<?php echo JText::_('EMAIL_SETTINGS_ADDITIONAL_EMAILS'); ?>
	    </span>
	</label>
	<textarea name="jform[additional_emails]"><?php echo $this->item->additional_emails ?></textarea>
    </div>
    
    <div class="inputwrap clearfix">
	<label>
		<span class="hasTip control-label" title="<?php echo JText::_('EMAIL_SETTINGS_SEND_ORDER_COPY_EXPLAIN'); ?>">
			<?php echo JText::_('EMAIL_SETTINGS_SEND_ORDER_COPY'); ?>
		</span>
	</label>
	<?php 
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[send_order_copy]', 'size="1" class="inputbox"', 'value', 'text', $this->item->send_order_copy);
	?>
    </div>
    
    <div class="adminform clearfix">
	<legend><?php echo JText::_('EMAIL_HEADER_LOGO'); ?></legend>
	<?php
	if (!class_exists('TbMedia')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbmedia.php');
	$config = array('name' => 'jform[header_logo]',
			'id' => 'header_logo',
			'value' => $this->item->header_logo,
			'label' => '',
			'asset' => 'com_taxibooking',
			'directory' => 'stories/taxibooking',
			'link' => '',
			'field_class' => 'inputbox',
			'size' => '40',
			'readonly' => false,
			'preview' => true,
			'author' => $this->user->get('id')
			);
	$tbMedia = new TbMedia($config);
	echo $tbMedia->getInput();
	?>
    </div>
    
    <?php
    foreach($this->lang->getKnownLanguages() as $tag => $lang)
    {
	$header_value = isset($this->item->header_info[$tag]) ? $this->item->header_info[$tag] : '';
	$contact_value = isset($this->item->contact_info[$tag]) ? $this->item->contact_info[$tag] : '';
    ?>
    <div class="adminform scroll">
	<legend><?php echo JText::_('EMAIL_HEADER_INFO').' - '.$lang['name']; ?></legend>
	
	<table class="admintable" cellspacing="1">
	    <tbody>
		<tr>
		    <td valign="top" width="60%">
			<?php
			// parameters : areaname, content, hidden field, width, height, rows, cols
			echo $this->editor->display('header_info['.$tag.']', $header_value, '100%', '250', '75', '20');
			?>
		    </td>
		</tr>
	    </tbody>
	</table>
    
    </div>
    
    <div class="adminform scroll">
	<legend><?php echo JText::_('CONTACT_INFO').' - '.$lang['name']; ?></legend>
	
	<table class="admintable" cellspacing="1">
	    <tbody>
		<tr>
		    <td valign="top" width="60%">
			<?php
			// parameters : areaname, content, hidden field, width, height, rows, cols
			echo $this->editor->display('contact_info['.$tag.']', $contact_value, '100%', '250', '75', '20');
			?>
		    </td>
		</tr>
	    </tbody>
	</table>
    
    </div>
    <?php } ?>
</div>