<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

?>

<script type="text/javascript">
var tariffs_count = <?php echo count($this->tariffs) ?>;

tbjQuery(document).ready(function(){

    tbjQuery('[name="jform[price_calculation_cumulative]"]').click(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('.cumulative_surcharge_date_wrapper').parent().show();
	    tbjQuery('.non_cumulative_surcharge_date_wrapper').parent().hide();
	}
	else {
	    tbjQuery('.cumulative_surcharge_date_wrapper').parent().hide();
	    tbjQuery('.non_cumulative_surcharge_date_wrapper').parent().show();
	}
    })
    tbjQuery('#jformwait_time_return_discount').change(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('#return_discount_wrapper').parent().show();
	}
	else {
	    tbjQuery('#return_discount_wrapper').parent().hide();
	}
    })

    tbjQuery('#add_return_discount').click(function(){
	var i = tbjQuery('div#return_discount_wrapper div.return_discount').length;
	var html = '';

html += '<div class="return_discount row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_WAIT_TIME_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'CONFIG_WAIT_TIME' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox return_wait_time_hrs" type="text" name="jform[wait_time_hrs]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_RETURN_DISCOUNT_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'CONFIG_RETURN_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[return_discount_percentage]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			    '<a href="javascript:void(0);" class="btn btn-small remove_return_discount"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
    '</div>';

	tbjQuery('div#return_discount_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div#return_discount_wrapper div.return_discount:last-child').offset().top-80 }, 'fast');
	tbjQuery('div#return_discount_wrapper div.return_discount:last-child .return_wait_time_hrs').focus();

	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })

    tbjQuery(document).on("click", '.remove_return_discount', function (e) {
	    var r = confirm("Are you sure?");
	    if (r == true) {
		tbjQuery(this).closest('div.return_discount').remove();
	    }
    })

    tbjQuery('#add_price').click(function(){
	var i = tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price').length;
	var html = '';

html += '<div class="date_price row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox distance_min" type="text" name="jform[distance_min]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[distance_max]['+i+']" size="10" value="" />'+
	    '</div>';

html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[price]['+i+']" size="10" value="" />'+
	    '</div>';

// if published tariffs, show separate price inputbox for each assigned tarrifs
if(parseInt(tariffs_count) > 0){
<?php foreach($this->tariffs as $tariff){ ?>
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label">'+
		    '<?php echo $tariff->title.':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[tariff_prices]['+i+']['+<?php echo $tariff->id; ?>+']" size="10" value="<?php echo $tariff->unit_price; ?>" />'+
	    '</div>';
<?php } ?>
}

html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[outbound_discount]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[return_discount]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			'<a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
	'</div>';

	tbjQuery('div.non_cumulative_surcharge_date_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
	tbjQuery('div.non_cumulative_surcharge_date_wrapper div.date_price:last-child .distance_min').focus();

	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })

    tbjQuery('#cumulative_add_price').click(function(){
	var i = tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price').length;
	var html = '';

html += '<div class="date_price row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox cumulative_distance_min" type="text" name="jform[cumulative_distance_min]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[cumulative_distance_max]['+i+']" size="10" value="" />'+
	    '</div>';

html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[cumulative_price]['+i+']" size="10" value="" />'+
	    '</div>';

// if published tariffs, show separate price inputbox for each assigned tarrifs
if(parseInt(tariffs_count) > 0){
<?php foreach($this->tariffs as $tariff){ ?>
html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label">'+
		    '<?php echo $tariff->title.':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[tariff_cumulative_prices]['+i+']['+<?php echo $tariff->id; ?>+']" size="10" value="<?php echo $tariff->unit_price; ?>" />'+
	    '</div>';
<?php } ?>
}

html +=	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[cumulative_outbound_discount]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="'+"<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>"+'">'+
		    '<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox" type="text" name="jform[cumulative_return_discount]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			'<a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
	'</div>';

	tbjQuery('div.cumulative_surcharge_date_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
	tbjQuery('div.cumulative_surcharge_date_wrapper div.date_price:last-child .cumulative_distance_min').focus();

	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })

    tbjQuery(document).on("click", '.remove_price', function (e) {
	    var r = confirm("Are you sure?");
	    if (r == true) {
		tbjQuery(this).closest('div.date_price').remove();
	    }
    })

    tbjQuery('#jformenable_gratuity').change(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('.gratuity_feature').show();
	}
	else {
	    tbjQuery('.gratuity_feature').hide();
	}
    })

    tbjQuery('#add_gratuity').click(function(){
	var i = tbjQuery('div#gratuity_wrapper div.gratuity_block').length;
	var html = '';

html += '<div class="gratuity_block row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_GRATUITY_AMOUNT_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'CONFIG_GRATUITY_AMOUNT' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox gratuity_amount" type="text" name="jform[gratuity_amount]['+i+']" size="10" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'CONFIG_GRATUITY_AMOUNT_TYPE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<select name="jform[gratuity_type]['+i+']" classs="inputbox">'+
		'<option value="flat"><?php echo JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_OPTION_FLAT');?></option>'+
		'<option value="percent"><?php echo JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_OPTION_PERCENT');?></option>'+
		'</select>'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			    '<a href="javascript:void(0);" class="btn btn-small remove_gratuity"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
    '</div>';

	tbjQuery('div#gratuity_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div#gratuity_wrapper div.gratuity_block:last-child').offset().top-80 }, 'fast');
	tbjQuery('div#gratuity_wrapper div.gratuity_block:last-child .gratuity_amount').focus();

	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })

    tbjQuery(document).on("click", '.remove_gratuity', function (e) {
	    var r = confirm("Are you sure?");
	    if (r == true) {
		tbjQuery(this).closest('div.gratuity_block').remove();
	    }
    })
})
</script>

<div class="adminform tab2">
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('SHOW_PRICE'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_price]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_price);
	    ?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('SETTINGS_AUTO_APPROVE_FREE_ORDER_EXPLAIN'); ?>">
			    <?php echo JText::_('SETTINGS_AUTO_APPROVE_FREE_ORDER'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[auto_approve_free_order]', 'size="1" class="inputbox"', 'value', 'text', $this->item->auto_approve_free_order);
	    ?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('DEBUG_PRICE_CALCUALTION_EXPLAIN'); ?>">
			    <?php echo JText::_('DEBUG_PRICE_CALCUALTION'); ?>
		    </span>
	    </label>
	    <?php
	    echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[debug_price_calculation]', 'size="1" class="inputbox"', 'value', 'text', $this->item->debug_price_calculation);
	    ?>
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('ROUND_UP_PRICE_EXPLAIN'); ?>">
		<?php echo JText::_('ROUND_UP_PRICE'); ?>
	    </span>
	</label>
	<?php
	$options = array();
	$options[] = JHTML::_('select.option', 'no', JText::_('ROUND_UP_PRICE_OPTION_NO'));
	$options[] = JHTML::_('select.option', 'whole', JText::_('ROUND_UP_PRICE_OPTION_WHOLE'));
	$options[] = JHTML::_('select.option', 'nearest5', JText::_('ROUND_UP_PRICE_OPTION_NEAREST'));
	echo JHTML::_('select.genericlist', $options, 'jform[roundup_price]', 'size="1" class="inputbox"', 'value', 'text', $this->item->roundup_price);
	?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('COST_PER_CALL_EXPLAIN'); ?>">
			    <?php echo JText::_('COST_PER_CALL'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[cost_per_call]" value="<?php echo $this->item->cost_per_call; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('MIN_DISTANCE_EXPLAIN'); ?>">
			    <?php echo JText::_('MIN_DISTANCE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[minmil]" value="<?php echo $this->item->minmil; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('MIN_DIST_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('MIN_DIST_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[minprice]" value="<?php echo $this->item->minprice; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_INFANT_SELECT_EXPLAIN'); ?>">
		<?php echo JText::_('SHOW_INFANT_SELECT'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_infant_select]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_infant_select);
	?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('INFANT_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('INFANT_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[infant_seat_price]" value="<?php echo $this->item->infant_seat_price; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_CHILD_SELECT_EXPLAIN'); ?>">
		<?php echo JText::_('SHOW_CHILD_SELECT'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_child_select]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_child_select);
	?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CHILD_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('CHILD_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[child_seat_price]" value="<?php echo $this->item->child_seat_price; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_BOOSTER_SELECT_EXPLAIN'); ?>">
		<?php echo JText::_('SHOW_BOOSTER_SELECT'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_booster_select]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_booster_select);
	?>
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('BOOSTER_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_('BOOSTER_PRICE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[booster_seat_price]" value="<?php echo $this->item->booster_seat_price; ?>" size="15" maxlength="15" />
    </div>

    <div class="inputwrap clearfix">
	<label>
	    <span class="editlinktip">
		<?php echo JText::_('CURRENCY'); ?>
	    </span>
	</label>
	    <?php
	    echo $this->lists['currency'];
	    ?>
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="editlinktip">
		<?php echo JText::_('CURRENCY_SYMBOL'); ?>
	    </span>
	</label>
	    <input class="inputbox" type="text" name="jform[currency_symbol]" value="<?php echo $this->item->currency_symbol; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('PRICE_PER_UNIT_DISTANCE_EXPLAIN'); ?>">
			    <?php echo JText::_('PRICE_PER_UNIT_DISTANCE'); ?>
		    </span>
	    </label>
	    <input class="inputbox" type="text" name="jform[price_per_unit_distance]" value="<?php echo $this->item->price_per_unit_distance; ?>" size="15" maxlength="15" />
    </div>

    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SETTINGS_ENABLE_CHARGE_PER_MINUTE_EXPLAIN'); ?>">
		<?php echo JText::_('SETTINGS_ENABLE_CHARGE_PER_MINUTE'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[enable_charge_per_min]', 'size="1" class="inputbox"', 'value', 'text', $this->item->enable_charge_per_min);
	?>
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SETTINGS_CHARGE_PER_MINUTE_EXPLAIN'); ?>">
		<?php echo JText::_('SETTINGS_CHARGE_PER_MINUTE'); ?>
	    </span>
	</label>
	<input class="inputbox" type="text" name="jform[charge_per_min]" value="<?php echo $this->item->charge_per_min; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_RETURN_OPTION_EXPLAIN'); ?>">
		<?php echo JText::_('SHOW_RETURN_OPTION'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_return_option]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_return_option);
	?>
    </div>

    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('RETURN_DISCOUNT_EXPLAIN'); ?>">
		<?php echo JText::_('RETURN_DISCOUNT'); ?>
	    </span>
	</label>
	<input class="inputbox" type="text" name="jform[discount]" value="<?php echo $this->item->discount; ?>" size="15" maxlength="15" />
    </div>
    <div class="inputwrap clearfix">
	<label>
	    <span class="hasTip control-label" title="<?php echo JText::_('SHOW_RETURN_EXTRAS_EXPLAIN'); ?>">
		<?php echo JText::_('SHOW_RETURN_EXTRAS'); ?>
	    </span>
	</label>
	<?php
	echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[show_return_extras]', 'size="1" class="inputbox"', 'value', 'text', $this->item->show_return_extras);
	?>
    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('CONFIG_WAIT_TIME_RETURN_DISCOUNT_EXPLAIN'); ?>">
		    <?php echo JText::_( 'CONFIG_WAIT_TIME_RETURN_DISCOUNT' ).':'; ?>
		    </span>
	    </label>
	    <?php echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[wait_time_return_discount]', 'size="1" class="inputbox"', 'value', 'text', $this->item->wait_time_return_discount);?>
    </div>

    <div style="margin-bottom:15px;min-height:100px;<?php echo ($this->item->wait_time_return_discount==0)? 'display:none':'display:block';?>">
	<div class="button2-left">
		<div class="blank">
			<a href="javascript:void(0);" class="btn btn-small" id="add_return_discount"><?php echo JText::_('ADD_NEW'); ?></a>
		</div>
	</div>
	<div id="return_discount_wrapper" class="clearfix">
	    <?php
	    $return_discounts_arr = $this->item->return_discounts;
	    for($i = 0; $i < count($return_discounts_arr); $i++)
	    {
		    $wait_time_hrs = !empty($return_discounts_arr[$i][0]) ? $return_discounts_arr[$i][0] : '';
		    $return_discount_percentage = !empty($return_discounts_arr[$i][1]) ? $return_discounts_arr[$i][1] : '';
	    ?>

	    <div class="return_discount <?php echo 'row'.$i;?> clearfix">
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_WAIT_TIME_EXPLAIN'); ?>">
			    <?php echo JText::_( 'CONFIG_WAIT_TIME' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[wait_time_hrs][<?php echo $i;?>]" size="10" value="<?php echo $wait_time_hrs;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_RETURN_DISCOUNT_EXPLAIN'); ?>">
			    <?php echo JText::_( 'CONFIG_RETURN_DISCOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[return_discount_percentage][<?php echo $i;?>]" size="10" value="<?php echo $return_discount_percentage;?>" />
		</div>
		<div class="button2-left" style="margin:0;">
			<div class="blank">
				<a href="javascript:void(0);" class="btn btn-small remove_return_discount"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		</div>
	    </div>
	    <?php
	    }
	    ?>
	</div>
    </div>

    <div style="margin-bottom:0px;">

	<div id="return_discount_wrapper2" class="clearfix">

	    <div class="return_discount_hours clearfix">
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="Waiting time min. if the waiting time is more than this setting, the price per hour for waiting time will be added to the booking.">
			    <strong>Waiting time starts - hours</strong>
			</span>
		    </label>
		    <input class="inputbox" type="number" name="jform[wait_time_min]" size="10" value="<?php echo $this->item->wait_time_min; ?>" />
		</div>
        <div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="Waiting time max. if the waiting time is more than this setting, no waiting time will be charged.">
			    <strong>Waiting time ends - hours</strong>
			</span>
		    </label>
		    <input class="inputbox" type="number" name="jform[wait_time_max]" size="10" value="<?php echo $this->item->wait_time_max; ?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="Price per hour for waiting time">
			    <strong>Price per hour</strong>
			</span>
		    </label>
		    <input class="inputbox" type="number" name="jform[return_time_price_hour]" size="10" value="<?php echo $this->item->return_time_price_hour; ?>" />
		</div>

	    </div>

	</div>
    </div>

    <div style="margin-bottom:15px; margin-top:-15px;">



	<div id="return_discount_wrapper2" class="clearfix">



	    <div class="return_discount_hours clearfix">

		<div class="inputwrap clearfix">

		    <label>

			<span class="hasTip control-label" title="This is the maximum distance in miles from zone zero where normal tariffs apply. Anything over this distance will have the extra price per mile applied to it.">

			    <strong>___max dist Z-0__ </strong>

			</span>

		    </label>

		    <input class="inputbox" type="number" name="jform[zone_zero_max]" size="10" value="<?php echo $this->item->zone_zero_max; ?>" />

		</div>

		<div class="inputwrap clearfix">

		    <label>

			<span class="hasTip control-label" title="Extra price per mile distances longer than zone zero max.">

			    <strong>Extra price per mile</strong>

			</span>

		    </label>

		    <input class="inputbox" type="number" name="jform[zone_zero_price_mile]" size="10" value="<?php echo $this->item->zone_zero_price_mile; ?>" />

		</div>



	    </div>



	</div>

    </div>

    <div class="inputwrap clearfix">
	    <label>
		    <span class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE' ).':'; ?>
		    </span>
	    </label>
	    <?php
	    $options = array(
		JHtml::_('select.option', 0, JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_NON_CUMULATIVE')),
		JHtml::_('select.option', 1, JText::_('MULTIPLE_DISTANCE_PRICE_CALCULATION_TYPE_CUMULATIVE'))
	    );
	    echo JHtml::_('select.radiolist', $options, 'jform[price_calculation_cumulative]', '', 'value', 'text', $this->item->price_calculation_cumulative) ;
	    ?>
    </div>

    <div class="inputwrap clearfix" style="min-height:100px;<?php echo ($this->item->price_calculation_cumulative==0)? 'display:block':'display:none';?>">
	<label style="font-weight:bold;font-size: 13px;" class="hasTip control-label" title="<?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
	    <?php echo JText::_('MULTIPLE_PRICE_PER_DISTANCE'); ?>
	</label>
	<div class="button2-left">
		<div class="blank">
			<a href="javascript:void(0);" class="btn btn-small" id="add_price"><?php echo JText::_('ADD_NEW'); ?></a>
		</div>
	</div>
	<br />
	<div id="surcharge_date_wrapper" class="non_cumulative_surcharge_date_wrapper clearfix">
	    <?php
	    $distance_price_arr = $this->item->distance_prices;
	    for($i = 0; $i < count($distance_price_arr); $i++)
	    {
		$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
		$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
		$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
		$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
		$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
		$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
	    ?>
	    <div class="date_price <?php echo 'row'.$i;?> clearfix">
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[distance_min][<?php echo $i;?>]" size="10" value="<?php echo $distance_min;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[distance_max][<?php echo $i;?>]" size="10" value="<?php echo $distance_max;?>" />
		</div>

		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[price][<?php echo $i;?>]" size="10" value="<?php echo $price_value;?>" />
		</div>

		<?php
		if(count($this->tariffs)>0)
		{
		    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
			$tariff = $this->tariffs[$tariff_counter];
			$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
		?>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
			<?php echo $tariff->title.':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[tariff_prices][<?php echo $i;?>][<?php echo $tariff->id; ?>]" size="10" value="<?php echo $tariff_price; ?>" />
		</div>
		<?php
		    }
		}
		?>

		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[outbound_discount][<?php echo $i;?>]" size="10" value="<?php echo $outbound_discount_value;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[return_discount][<?php echo $i;?>]" size="10" value="<?php echo $return_discount_value;?>" />
		</div>
		<div class="button2-left" style="margin:0;">
			<div class="blank">
			    <a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		</div>
	    </div>
	    <?php
	    }
	    ?>
	</div>
    </div>

    <div class="inputwrap clearfix" style="min-height:100px;<?php echo ($this->item->price_calculation_cumulative==1)? 'display:block':'display:none';?>">
	<label style="font-weight:bold;font-size: 13px;" class="hasTip control-label" title="<?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE_EXPLAIN'); ?>">
	    <?php echo JText::_('CUMULATIVE_PRICE_PER_DISTANCE'); ?>
	</label>
	<div class="button2-left">
		<div class="blank">
			<a href="javascript:void(0);" class="btn btn-small" id="cumulative_add_price"><?php echo JText::_('ADD_NEW'); ?></a>
		</div>
	</div>
	<br />
	<div id="surcharge_date_wrapper" class="cumulative_surcharge_date_wrapper clearfix">
	    <?php
	    $distance_price_arr = $this->item->cumulative_distance_prices;
	    for($i = 0; $i < count($distance_price_arr); $i++)
	    {
		$distance_min = !empty($distance_price_arr[$i][0]) ? $distance_price_arr[$i][0] : 0;
		$distance_max = !empty($distance_price_arr[$i][1]) ? $distance_price_arr[$i][1] : 0;
		$price_value = !empty($distance_price_arr[$i][2]) ? $distance_price_arr[$i][2] : 0;
		$outbound_discount_value = !empty($distance_price_arr[$i][3]) ? $distance_price_arr[$i][3] : 0;
		$return_discount_value = !empty($distance_price_arr[$i][4]) ? $distance_price_arr[$i][4] : 0;
		$tariff_prices = !empty($distance_price_arr[$i][5]) ? $distance_price_arr[$i][5] : array();
	    ?>

	    <div class="date_price <?php echo 'row'.$i;?> clearfix">
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_FROM_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_FROM' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[cumulative_distance_min][<?php echo $i;?>]" size="10" value="<?php echo $distance_min;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_DISTANCE_TO_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_TO' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[cumulative_distance_max][<?php echo $i;?>]" size="10" value="<?php echo $distance_max;?>" />
		</div>

		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_MULTI_PRICE_EXPLAIN'); ?>">
			<?php echo JText::_( 'MULTI_PRICE' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[cumulative_price][<?php echo $i;?>]" size="10" value="<?php echo $price_value;?>" />
		</div>

		<?php
		if(count($this->tariffs)>0)
		{
		    for($tariff_counter=0; $tariff_counter<count($this->tariffs); $tariff_counter++){
			$tariff = $this->tariffs[$tariff_counter];
			$tariff_price = !empty($tariff_prices[$tariff->id]) ? $tariff_prices[$tariff->id] : 0;
		?>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo strip_tags($tariff->text); ?>">
			<?php echo $tariff->title.':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[tariff_cumulative_prices][<?php echo $i;?>][<?php echo $tariff->id; ?>]" size="10" value="<?php echo $tariff_price; ?>" />
		</div>
		<?php
		    }
		}
		?>

		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_OUTBOUND_DISCOUNT_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_SECTOR_OUTBOUND_DISCOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[cumulative_outbound_discount][<?php echo $i;?>]" size="10" value="<?php echo $outbound_discount_value;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('DISTANCE_SECTOR_RETURN_DISCOUNT_EXPLAIN'); ?>">
			<?php echo JText::_( 'DISTANCE_SECTOR_RETURN_DISCOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[cumulative_return_discount][<?php echo $i;?>]" size="10" value="<?php echo $return_discount_value;?>" />
		</div>
		<div class="button2-left" style="margin:0;">
			<div class="blank">
			    <a href="javascript:void(0);" class="btn btn-small remove_price"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		</div>
	    </div>
	    <?php
	    }
	    ?>
	</div>
    </div>

    <div class="inputwrap clearfix">
	<label>
		<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_ENABLE_GRATUITY_EXPLAIN'); ?>">
		<?php echo JText::_( 'CONFIG_ENABLE_GRATUITY' ).':'; ?>
		</span>
	</label>
	<?php echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[enable_gratuity]', 'size="1" class="inputbox"', 'value', 'text', $this->item->enable_gratuity);?>
    </div>

    <div class="inputwrap gratuity_feature clearfix" style="<?php echo ($this->item->enable_gratuity==0)? 'display:none':'display:block';?>">
	<label>
		<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_ENABLE_GRATUITY_FLAT_FIELD_EXPLAIN'); ?>">
		<?php echo JText::_( 'CONFIG_ENABLE_GRATUITY_FLAT_FIELD' ).':'; ?>
		</span>
	</label>
	<?php echo JHTML::_('select.genericlist', $this->ynoptions, 'jform[enable_gratuity_flat]', 'size="1" class="inputbox"', 'value', 'text', $this->item->enable_gratuity_flat);?>
    </div>

    <div class="inputwrap gratuity_feature clearfix" style="margin-bottom:15px;min-height:100px;<?php echo ($this->item->enable_gratuity==0)? 'display:none':'display:block';?>">
	<label style="font-weight:bold;font-size: 13px;" class="control-label">&nbsp;</label>
	<div class="button2-left">
		<div class="blank">
			<a href="javascript:void(0);" class="btn btn-small" id="add_gratuity"><?php echo JText::_('ADD_NEW'); ?></a>
		</div>
	</div>
	<br />
	<div id="gratuity_wrapper" class="clearfix">
	    <?php
	    $gratuities_arr = $this->item->gratuities;
	    for($i = 0; $i < count($gratuities_arr); $i++)
	    {
		    $gratuity_amount = !empty($gratuities_arr[$i][0]) ? $gratuities_arr[$i][0] : '';
		    $gratuity_type = !empty($gratuities_arr[$i][1]) ? $gratuities_arr[$i][1] : 'flat';
	    ?>

	    <div class="gratuity_block <?php echo 'row'.$i;?> clearfix">
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_GRATUITY_AMOUNT_EXPLAIN'); ?>">
			    <?php echo JText::_( 'CONFIG_GRATUITY_AMOUNT' ).':'; ?>
			</span>
		    </label>
		    <input class="inputbox" type="text" name="jform[gratuity_amount][<?php echo $i;?>]" size="10" value="<?php echo $gratuity_amount;?>" />
		</div>
		<div class="inputwrap clearfix">
		    <label>
			<span class="hasTip control-label" title="<?php echo JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'CONFIG_GRATUITY_AMOUNT_TYPE' ).':'; ?>
			</span>
		    </label>
		    <?php
		    $options = array();
		    $options[] = JHTML::_('select.option', 'flat', JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_OPTION_FLAT'));
		    $options[] = JHTML::_('select.option', 'percent', JText::_('CONFIG_GRATUITY_AMOUNT_TYPE_OPTION_PERCENT'));
		    echo JHTML::_('select.genericlist', $options, 'jform[gratuity_type]['.$i.']', 'size="1" class="inputbox"', 'value', 'text', $gratuity_type);
		    ?>
		</div>
		<div class="button2-left" style="margin:0;">
			<div class="blank">
				<a href="javascript:void(0);" class="btn btn-small remove_gratuity"><?php echo JText::_('REMOVE'); ?></a>
			</div>
		</div>
	    </div>
	    <?php
	    }
	    ?>
	</div>
    </div>

</div>
