<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class
 */
class TaxibookingViewConfig extends JViewLegacy
{
	protected $item;

	protected $state;

	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$this->user =  JFactory::getUser();
		$this->config = JFactory::getConfig();
		$this->lang 	= JFactory::getLanguage();
		$this->editor =  JFactory::getEditor();

		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$this->tariffs  = $this->get('Tariffs');
		$isNew		= ($this->item->id == 0);

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$config_params = unserialize($this->item->text);
		// echo "<pre>";
		// print_r($config_params);
		foreach($config_params as $key => $val)
		{
			$this->item->$key = $val;
			// die('here');
		}

		// show warning if google php client library is not uploaded
		if($this->item->alias=='gcal-settings')
		{
			if(!file_exists(JPATH_COMPONENT_SITE.DS.'google-api-php-client-master')){
				$app->enqueueMessage(JText::_('COM_TAXIBOOKING_GOOGLE_CALENDAR_PHP_LIBRARY_MISSING'), 'warning');
			}
		}

		if($this->item->alias=='base-settings'){
			$app->enqueueMessage(JText::_('COM_TAXIBOOKING_BASE_SETTINGS_SYSTEM_MSG'), 'notice');

			$super_user_email = $app->getCfg('mailfrom');
			$this->item->booking_notification_email = isset($this->item->booking_notification_email) ? $this->item->booking_notification_email : $super_user_email;

			$this->item->base_pickup_special_routes = isset($this->item->base_pickup_special_routes) ? $this->item->base_pickup_special_routes : 'price_time';
			$this->item->base_dropoff_special_routes = isset($this->item->base_dropoff_special_routes) ? $this->item->base_dropoff_special_routes : 'price_time';
		}
		if($this->item->alias=='general-settings'){
			$this->item->booking_cancellation_allowed = isset($this->item->booking_cancellation_allowed) ? $this->item->booking_cancellation_allowed : 0;
			$this->item->booking_cancellation_prior_hrs = isset($this->item->booking_cancellation_prior_hrs) ? $this->item->booking_cancellation_prior_hrs : 0;
		}
		if($this->item->alias=='price-settings'){
			$this->item->enable_gratuity = isset($this->item->enable_gratuity) ? $this->item->enable_gratuity : 0;
			$this->item->enable_gratuity_flat = isset($this->item->enable_gratuity_flat) ? $this->item->enable_gratuity_flat : 1;
			$this->item->gratuities = isset($this->item->gratuities) ? $this->item->gratuities : array();
		}
		if($this->item->alias=='map-settings'){
			$this->item->optimize_stops = isset($this->item->optimize_stops) ? $this->item->optimize_stops : 1;
		}
		if($this->item->alias=='orderemail-settings'){
			$this->item->send_order_copy = isset($this->item->send_order_copy) ? $this->item->send_order_copy : 1;
		}
		if($this->item->alias=='sms-settings'){
			$this->item->clickatell_sender_id = isset($this->item->clickatell_sender_id) ? $this->item->clickatell_sender_id : '';
		}

		$this->default_operation_area_vertices = '[[51.629949539313905,-0.5104715976563057],[51.36834810929568,-0.3786356601563057],[51.447157400846535,0.2695576992186943],[51.83916879427223,0.3189961757811943]]';
		$this->lists = $this->_buildEditLists($this->item);

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);

		JToolbarHelper::title(JText::sprintf('COM_TAXIBOOKING_MANAGER_CONFIG_EDIT', $this->item->title), 'generic');

		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}

		JToolbarHelper::cancel();
	}

	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		$lists = array();

		// get country list
		if($item->alias=='base-settings')
		{
			$query = 'SELECT `country_id`, `country_name` '
				. ' FROM #__taxibooking_countries'
				. ' ORDER BY `country_name` ASC'
				;
			$db->setQuery($query);
			$db->query();
			$rows = $db->loadObjectList();

			$country_options = array();
			$country_options[] = JHTML::_('select.option',  '', JText::_( 'JSELECT' ) );
			if(!empty($rows)){
			    foreach ($rows as $row){
				$country_options[] = JHTML::_('select.option',  $row->country_id, $row->country_name );
			    }
			}
			$lists['country_list'] = JHTML::_('select.genericlist', $country_options, 'jform[default_country]', '', 'value', 'text', $item->default_country );
		}

		// get currency list
		if($item->alias=='price-settings')
		{
			$query = 'SELECT `currency_id`, `currency_code`, `currency_name`'
				. ' FROM #__taxibooking_currency'
				. ' ORDER BY `currency_name` ASC'
				;
			$db->setQuery($query);
			$db->query();
			$rows = $db->loadObjectList();

			$currency_options = array();
			$currency_options[] = JHTML::_('select.option',  '', JText::_( 'JSELECT' ) );
			if(!empty($rows)){
			    foreach ($rows as $row){
				$currency_options[] = JHTML::_('select.option',  $row->currency_code, $row->currency_name );
			    }
			}
			$lists['currency'] = JHTML::_('select.genericlist', $currency_options, 'jform[currency]', '', 'value', 'text', $item->currency );
		}

		return $lists;
	}
}
