<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$saveOrder	= $listOrder=='ordering';
$params		= (isset($this->state->params)) ? $this->state->params : new JObject();

?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/settings.css" />

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=configs'); ?>" method="post" name="adminForm" id="adminForm">

	<div class="poi_int_adminform clearfix">
		<div class="poi_int_adminform_left clearfix">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip inputbox" />
			<button type="submit" class="btn hasTooltip"><i class="icon-search"></i></button>
			<button type="button" class="btn hasTooltip" onclick="document.id('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			<?php } else { ?>
			<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" class="inputbox" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			<?php } ?>
		</div>
	</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<table class="no-more-tables table table-striped" id="articleList">
	<?php } else { ?>
	<table class="adminlist">
	<?php } ?>
	
	<thead>
		<tr>
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="5">
				<?php echo JHtml::_('grid.checkall'); ?>
			</th>
			<?php } else { ?>
			<th width="1%">
				<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>
			<?php } ?>
			
			<th class="title numeric"><?php echo JHTML::_('grid.sort', 'TITLE', 'a.title', $listDirn, $listOrder ); ?></th>
		</tr>
	</thead>

	<tbody>
		<?php
		$k = 0;
		$img1 = 'icon-16-allow.png';
		$img0 = 'publish_r.png';
		for ($i=0, $n=count($this->items); $i < $n; $i++) {
			$row = $this->items[$i];
			$ordering	= ($listOrder == 'ordering');

			$link 		= 'index.php?option=com_taxibooking&amp;controller=configs&amp;task=edit&amp;cid[]='. $row->id;
			$checked 	= JHTML::_('grid.id', $i, $row->id);
			
			$config_title = JText::_('COM_TAXIBOOKING_'.str_replace(' ', '_', strtoupper($row->title)));
			$tip_expln = JText::_('COM_TAXIBOOKING_'.str_replace(' ', '_', strtoupper($row->title).'_EXPLAIN'));
   		?>
		<tr class="<?php echo "row$k"; ?>">
			
			<td data-title="&nbsp;" class=""><?php echo $checked; ?></td>
			<td data-title="<?php echo JText::_('TITLE');?>" class="numeric" align="left">
				<?php if ($row->checked_out) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $row->checked_out, $row->checked_out_time, '', true); ?>
				<?php endif; ?>
                            <span class="hasTip control-label" data-title="<?php echo $tip_expln; ?>" title="<?php echo $tip_expln; ?>">
                            <a href="<?php echo $link; ?>">
                            <?php echo $config_title; ?>
                            </a>
			    </span>
				
			</td>
		</tr>
		<?php $k = 1 - $k; } ?>
	</tbody>
	<tfoot>
		<tr>
			<td colspan="11">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>	

	</table>
	

	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="controller" value="configs" />
	<input type="hidden" name="view" value="configs" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
