<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of configs.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxibookingViewConfigs extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Method to display the view.
	 *
	 * @param   string  $tpl  A template file to load. [optional]
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @since   1.6
	 */
	public function display($tpl = null)
	{
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		
		// generate new config if its not already done
		$this->_generateNewConfigs();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('configs');

		$this->addToolbar();
		
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_TAXIBOOKING_MANAGER_COFIGS'), 'generic');

		if ($canDo->get('core.create'))
		{
			//JToolbarHelper::addNew();
		}
		if (($canDo->get('core.edit')))
		{
			//JToolbarHelper::editList();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::checkin();
			//JToolbarHelper::publish('publish', 'JTOOLBAR_PUBLISH', true);
			//JToolbarHelper::unpublish('unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
		if ($canDo->get('core.delete'))
		{
			//JToolbarHelper::deleteList('Are you sure?', 'remove', 'JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.create'))
		{
			//JToolBarHelper::custom('duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
		}
		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
	
	private function _generateNewConfigs()
	{
		$app	= JFactory::getApplication();
		$db = JFactory::getDBO();
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		$lang 	= JFactory::getLanguage();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_configs');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		if(count($rows) <= 0)
		{
			$config_sections = array();
			$config_sections['general-settings'] = array(
				'title' => 'General Settings',
				'params' => array(
					'distance_unit' => 'mile',
					'restrict_time' => 3,
					'date_format' => 'dd-mm-yy',
					'datepicker_type' => 'jquery',
					'time_format' => '24hr',
					'load_current_date' => 1,
					'show_address_tab' => 1,
					'show_from_poi' => 1,
					'show_from_address' => 1,
					'show_to_poi' => 1,
					'show_to_address' => 1,
					'show_offers_tab' => 1,
					'enable_route_swap' => 1,
					'show_poi_categories' => 0,
					'show_hourly_tab' => 1,
					'show_shuttles_tab' => 1,
					'default_tab' => 'address',
					'default_adult_seat' => 0,
					'show_suitcase_select' => 1,
					'invoice_title' => 'taxi_booking',
					'enable_captcha' => 1,
					'combine_car_type' => 0,
					'display_car_types' => 0,
					'usergroups_allowed_import_orders' => array(),
					//'timestamp_collect_disabled_dates' => 0,
					//'timestamp_archive_orders' => 0,
				)
			);
			
			$config_sections['price-settings'] = array(
				'title' => 'General Price Settings',
				'params' => array(
					'show_price' => 1,
					'auto_approve_free_order' => 1,
					'debug_price_calculation' => 0,
					'roundup_price' => 'no',
					'cost_per_call' => 0,
					'minmil' => 0,
					'minprice' => 0,
					'show_infant_select' => 1,
					'infant_seat_price' => 0,
					'show_child_select' => 1,
					'child_seat_price' => 0,
					'show_booster_select' => 1,
					'booster_seat_price' => 0,
					'currency' => '',
					'currency_symbol' => '',
					'price_per_unit_distance' => 0,
					'enable_charge_per_min' => 0,
					'charge_per_min' => 0,
					'show_return_option' => 1,
					'discount' => 0,
					'show_return_extras' => 0,
					'wait_time_return_discount' => 0,
					'return_discounts' => array(),
					'price_calculation_cumulative' => 0,
					'cumulative_distance_prices' => array(),
					'distance_prices' => array(),
				)
			);
			
			$config_sections['map-settings'] = array(
				'title' => 'Map Settings',
				'params' => array(
					'show_map_address' => 1,
					'show_map_offers' => 1,
					'show_map_shuttles' => 1,
					'map_height' => '300',
					'map_zoom' => '10',
					'dir_height' => '200',
					'ssl_enabled' => 0,
					'api_key' => '',
					'api_client_id' => '',
					'api_client_signature' => '',
					'enable_stops' => 0,
					'show_stop_poi' => 0,
					'show_stop_address' => 0,
					'max_stop_time' => 0,
					'stop_duration_interval' => '15',
					'stops_charge_per_min' => 0,
				)
			);
			
			$super_user_email = $app->getCfg('mailfrom');
			$default_operation_area_vertices = '[[51.629949539313905,-0.5104715976563057],[51.36834810929568,-0.3786356601563057],[51.447157400846535,0.2695576992186943],[51.83916879427223,0.3189961757811943]]';
			$config_sections['base-settings'] = array(
				'title' => 'Base Settings',
				'params' => array(
					'default_country' => '222',
					'default_city' => 'London',
					'booking_notification_email' => $super_user_email, 
					'operation_area_vertices' => $default_operation_area_vertices,
					'pickup_in_area' => 0,
					'dropoff_in_area' => 0,
					'pickup_dropoff_in_area' => 0,
					'base_lat' => '',
					'base_long' => '',
					'calculate_base_pickup' => 0,
					'base_pickup_price_type' => 'flat',
					'base_pickup_price' => 0,
					'calculate_dropoff_base' => 0,
					'dropoff_base_price_type' => 'flat',
					'dropoff_base_price' => 0,
					'time_after_each_booking' => 0,
				)
			);
			
			$config_sections['gcal-settings'] = array(
				'title' => 'Google Calendar Settings',
				'params' => array(
					'google_client_id' => '',
					'google_app_name' => '',
					'google_app_email_address' => '',
					'google_p12_key_filename' => '',
				)
			);
			
			$config_sections['orderemail-settings'] = array(
				'title' => 'Order Email Settings',
				'params' => array(
					'additional_emails' => '',
					'header_logo' => ''
				)
			);
			
			$config_sections['terms-settings'] = array(
				'title' => 'Terms Settings',
				'params' => array(
					'use_terms' => 1,
				)
			);
			
			foreach($lang->getKnownLanguages() as $tag => $lang)
			{
				$header_info = 'header_info['.$tag.']';
				$contact_info = 'contact_info['.$tag.']';
				$terms_conditions = 'terms_conditions['.$tag.']';
				
				$config_sections['orderemail-settings']['params']['header_info'][$tag] = '';
				$config_sections['orderemail-settings']['params']['contact_info'][$tag] = '';
				$config_sections['terms-settings']['params']['terms_conditions'][$tag] = '';
			}
			
			$config_sections['design-settings'] = array(
				'title' => 'Design Settings',
				'params' => array(
					'booking_form_bgcolor' => '#006599',
					'booking_form_active_tab_color' => '#006599',
					'booking_form_inactive_tab_color' => '#1aa1bf',
					'booking_form_boxcolor' => '#2D2D2D',
					'booking_form_fontcolor' => '#FFFFFF',
					'booking_form_boxes_fontcolor' => '#FFFFFF',
					'booking_form_header_tabs_fontcolor' => '#FFFFFF',
					'other_steps_fontcolor' => '#999999',
					'booking_form_btncolor' => '#1aa1bf',
					'highlights_color' => '#1aa1bf',
				)
			);
			
			$config_sections['sms-settings'] = array(
				'title' => 'SMS Settings',
				'params' => array(
					'send_user_sms' => 0,
					'clickatell_api_id' => '',
					'clickatell_api_username' => '',
					'clickatell_api_password' => '',
					'country_calling_code' => '',
				)
			);
			//echo '<pre>';
			//print_r($config_sections);
			
			// fetch old settings object first
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__taxibooking_settings');
			$query->where('id = 1');
			$db->setQuery((string)$query);
			$oldSettings = $db->loadObject();
			$oldParams = unserialize($oldSettings->params);
			//print_r($oldParams);
			
			// now move to creating config for each section
			foreach($config_sections as $section_key => $section_arr)
			{
				foreach($section_arr['params'] as $field_name => $value)
				{
					if(isset($oldParams[$field_name])){
						$section_arr['params'][$field_name] = $oldParams[$field_name];
					}
				}
				$config_sections[$section_key]['params'] = $section_arr['params'];
			}
			//die(print_r($config_sections));
			
			foreach($config_sections as $section_key => $section_arr)
			{
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_configs');
				$query->where('alias = '.$db->Quote($section_key));
				$db->setQuery((string)$query);
				$row = $db->loadObject();
				
				if($row){ // update this config
					$temp = new stdClass();
					$temp->id = $row->id;
					$temp->title = $section_arr['title'];
					$temp->alias = $section_key;
					$temp->text = serialize($section_arr['params']);
					$temp->created = $date->toSql();
					$temp->created_by = $user->get('id');
			       
					$db->updateObject('#__taxibooking_configs', $temp, 'id');
				}
				else { // create this new config
					$temp = new stdClass();
					$temp->title = $section_arr['title'];
					$temp->alias = $section_key;
					$temp->text = serialize($section_arr['params']);
					$temp->created = $date->toSql();
					$temp->created_by = $user->get('id');
			       
					$db->insertObject('#__taxibooking_configs', $temp);
				}
			}
			
			$app->redirect(JRoute::_('index.php?option=com_taxibooking&view=configs', false));
		}
		
		return true;
	}
}