<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<script language="javascript" type="text/javascript">
var xhr = null;
var BASE_URL = '<?php echo JURI::root();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';

Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/coupons.css" />

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script type="text/javascript">
var tbjQuery = jQuery.noConflict( );
tbjQuery(document).ready(function(){
    if(page_mode=='edit'){
	tbjQuery('input[name="code"]').attr('readonly', true);
    }
    
    // coupon code exists check
    tbjQuery('input[name="code"]').change(function(){
	tbjQuery('input[name="task"]').val('checkCodeAjax');
	var passingData = tbjQuery('#adminForm').serialize();
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&task=checkCodeAjax'
	    , data: passingData
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		if(response.error==0){
		}
		else {
		    tbjQuery('input[name="code"]').val('');
		    alert(response.msg);
		    return false;
		}
	    }
	})
    })
})
</script>

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">
	
	<div id="elconfig-document">
        <div id="page-basic">
            
	    <?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	    <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'panel_1')); ?>
	    
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_1', JText::_('COUPON_CODE_TAB_BASIC_SETTINGS')); ?>
	    <?php } else { ?>
	    <?php echo JHtml::_('tabs.start', 'tab_group_id', array('useCookie'=>0)); ?>
	    
		<?php echo JHtml::_('tabs.panel', JText::_('COUPON_CODE_TAB_BASIC_SETTINGS'), 'panel_1'); ?>
	    <?php } ?>
	    
	    
<div class="adminform tab1">
	
	<div class="poicat_adminform">
		<?php if($this->has_app_coupon){ ?>
		<input type="hidden" name="for_company_share" value="0" />
		<?php } else { ?>
		<div class="coupon_inputwrap published clearfix" style="display: none;">
			<label for="published">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_FOR_COMPANY_SHARE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_FOR_COMPANY_SHARE'); ?>
				</span>
			</label>
			<?php
			echo JHTML::_('select.booleanlist', 'for_company_share', 'class="inputbox"', $this->item->for_company_share );
			?>
		</div>
		<?php } ?>
		<div class="coupon_inputwrap clearfix">
			<label>
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_TITLE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_TITLE'); ?>
				</span>
			</label>
			<input type="text" name="title" value="<?php echo $this->item->title; ?>" class="inputbox required" maxlength="100" />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="title">
				<?php echo JText::_( 'ALIAS' ).':'; ?>
			</label>
			<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" placeholder="<?php echo JText::_('JFIELD_ALIAS_PLACEHOLDER');?>" />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label>
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE'); ?>
				</span>
			</label>
			<input type="text" name="code" value="<?php echo $this->item->code; ?>" class="inputbox required"  />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label>
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_DISCOUNT_TYPE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_DISCOUNT_TYPE'); ?>
				</span>
			</label>
			<?php
			$options = array();
			$options[] = JHTML::_('select.option', 'fixed', JText::_('COUPON_CODE_DISCOUNT_TYPE_OPTION_FIXED'));
			$options[] = JHTML::_('select.option', 'percent', JText::_('COUPON_CODE_DISCOUNT_TYPE_OPTION_PERCENT'));
			echo JHTML::_('select.genericlist', $options, 'discount_type', 'size="1" class="inputbox"', 'value', 'text', $this->item->discount_type);
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label>
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_DISCOUNT_VALUE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_DISCOUNT_VALUE'); ?>
				</span>
			</label>
			<input type="text" name="discount_value" value="<?php echo $this->item->discount_value; ?>" class="inputbox required" />
		</div>
		<div class="coupon_inputwrap published clearfix">
			<label for="published"><?php echo JText::_('PUBLISHED'); ?></label>
			<?php
			echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label>
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_COUPON_HITS_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_COUPON_HITS'); ?>
				</span>
			</label>
			<input type="text" name="hits" value="<?php echo $this->item->hits; ?>" class="inputbox" />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="published">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_LANGUAGE_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_LANGUAGE'); ?>
				</span>
			</label>
			<?php 
			echo $this->lists['languages'];
			?>
		</div>
	</div>
</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
	    
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_2', JText::_('COUPON_CODE_TAB_FINE_TUNING')); ?>
	    <?php } else { ?>
		    
		    <?php echo JHtml::_('tabs.panel', JText::_('COUPON_CODE_TAB_FINE_TUNING'), 'panel_2'); ?>
	    <?php } ?>
	    
<div class="adminform tab2">
	
	<div class="poicat_adminform">
		
		<div class="coupon_inputwrap clearfix">
			<label for="valid_from">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_VALID_FROM_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_VALID_FROM'); ?>
				</span>
			</label>
			<?php
			echo JHtml::_('calendar', $this->item->valid_from, 'valid_from', "valid_from", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="valid_to">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_VALID_TO_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_VALID_TO'); ?>
				</span>
			</label>
			<?php
			echo JHtml::_('calendar', $this->item->valid_to, 'valid_to', "valid_to", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="coupon_user">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_USER_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_USER'); ?>
				</span>
			</label>
			<?php
			if (!class_exists('TbUser')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbuser.php');
			$config = array('name' => 'coupon_user',
					'id' => 'coupon_user',
					'value' => $this->item->coupon_user,
					'class' => 'inputbox',
					'readonly' => false,
					'disabled' => false,
					'onchange' => ''
					);
			$tbUser = new TbUser($config);
			echo $tbUser->getInput();
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="coupon_email">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_USER_EMAIL_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_USER_EMAIL'); ?>
				</span>
			</label>
			<input type="text" name="coupon_email" value="<?php echo $this->item->coupon_email; ?>" class="inputbox" />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="coupon_user_group">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_USER_GROUP_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_USER_GROUP'); ?>
				</span>
			</label>
			<?php 
			echo JHtml::_('access.usergroup', 'coupon_user_group[]', $this->item->coupon_user_group, ' size="8" multiple="multiple" class="inputbox"', '', 'coupon_user_group');
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="special_routes">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_BOOKING_TYPES_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_BOOKING_TYPES'); ?>
				</span>
			</label>
			<?php 
			echo $this->lists['booking_types'];
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="special_routes">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_SPECIAL_ROUTES_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_SPECIAL_ROUTES'); ?>
				</span>
			</label>
			<?php 
			echo $this->lists['special_routes'];
			?>
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="hits_limit">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_HITS_LIMIT_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_HITS_LIMIT'); ?>
				</span>
			</label>
			<input type="text" name="hits_limit" value="<?php echo $this->item->hits_limit; ?>" class="inputbox" />
		</div>
		<div class="coupon_inputwrap clearfix">
			<label for="valid_to">
				<span class="hasTip control-label" title="<?php echo JText::_('COUPON_CODE_MAX_HITS_USER_EXPLAIN'); ?>">
					<?php echo JText::_('COUPON_CODE_MAX_HITS_USER'); ?>
				</span>
			</label>
			<input type="text" name="max_hits_user" value="<?php echo $this->item->max_hits_user; ?>" class="inputbox" />
		</div>
	</div>
</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	    <?php } else { ?>
		    
		    <?php echo JHtml::_('tabs.end'); ?>
	    <?php } ?>
            
         </div>
    </div>
    <div class="clr"></div>

	
<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="coupons" />
<input type="hidden" name="view" value="coupon" />
<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>